/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.symbols;

import com.android.SdkConstants;
import com.android.ide.common.symbols.IdProvider;
import com.android.ide.common.symbols.ResourceValuesXmlParseException;
import com.android.ide.common.symbols.Symbol;
import com.android.ide.common.symbols.SymbolTable;
import com.android.resources.ResourceType;
import com.android.utils.XmlUtils;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0001H\u0002\u001aH\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0011H\u0002\u001aB\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\t2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\b\u0002\u0010\u0012\u001a\u00020\u0011H\u0002\u001aJ\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\b\u0002\u0010\u0012\u001a\u00020\u0011H\u0002\u001a*\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\b\u001a\u00020\t2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\b\u0002\u0010\u0012\u001a\u00020\u0011\u00a8\u0006\u001e"}, d2={"getMandatoryAttr", "", "element", "Lorg/w3c/dom/Element;", "attrName", "parseAttr", "", "attr", "idProvider", "Lcom/android/ide/common/symbols/IdProvider;", "name", "builder", "Lcom/android/ide/common/symbols/SymbolTable$Builder;", "enumSymbols", "", "Lcom/android/ide/common/symbols/Symbol;", "isMaybeDefinition", "", "validation", "parseChild", "", "child", "platformAttrSymbols", "Lcom/android/ide/common/symbols/SymbolTable;", "parseDeclareStyleable", "declareStyleable", "styleableName", "parseValuesResource", "xmlDocument", "Lorg/w3c/dom/Document;", "android.sdktools.sdk-common"})
@JvmName(name="ResourceValuesXmlParser")
public final class ResourceValuesXmlParser {
    @NotNull
    public static final SymbolTable parseValuesResource(@NotNull Document xmlDocument, @NotNull IdProvider idProvider, @Nullable SymbolTable platformAttrSymbols, boolean validation) {
        Intrinsics.checkNotNullParameter((Object)xmlDocument, (String)"xmlDocument");
        Intrinsics.checkNotNullParameter((Object)idProvider, (String)"idProvider");
        Element element = xmlDocument.getDocumentElement();
        if (element == null) {
            throw new ResourceValuesXmlParseException("XML document does not have a root element.");
        }
        Element root = element;
        if (!Intrinsics.areEqual((Object)root.getTagName(), (Object)"resources")) {
            throw new ResourceValuesXmlParseException("XML document root is not 'resources'");
        }
        if (root.getNamespaceURI() != null) {
            throw new ResourceValuesXmlParseException("XML document root has a namespace");
        }
        SymbolTable.Builder builder = SymbolTable.Companion.builder();
        ArrayList enumSymbols = new ArrayList();
        for (Node current = root.getFirstChild(); current != null; current = current.getNextSibling()) {
            if (current.getNodeType() != 1) continue;
            ResourceValuesXmlParser.parseChild((Element)current, builder, idProvider, enumSymbols, platformAttrSymbols, validation);
        }
        for (Symbol enumSymbol : enumSymbols) {
            Intrinsics.checkNotNullExpressionValue((Object)enumSymbol, (String)"enumSymbol");
            if (builder.contains(enumSymbol)) continue;
            builder.add(enumSymbol);
        }
        return builder.build();
    }

    public static /* synthetic */ SymbolTable parseValuesResource$default(Document document, IdProvider idProvider, SymbolTable symbolTable, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = true;
        }
        return ResourceValuesXmlParser.parseValuesResource(document, idProvider, symbolTable, bl);
    }

    private static final void parseChild(Element child, SymbolTable.Builder builder, IdProvider idProvider, List<Symbol> enumSymbols, SymbolTable platformAttrSymbols, boolean validation) {
        if (Intrinsics.areEqual((Object)child.getTagName(), (Object)"eat-comment")) {
            return;
        }
        ResourceType resourceType = ResourceType.fromXmlTag((Node)child);
        if (resourceType == null) {
            throw new ResourceValuesXmlParseException("Unknown resource value XML element '" + XmlUtils.toXml((Node)child) + '\'');
        }
        ResourceType resourceType2 = resourceType;
        if (resourceType2.isSynthetic() && resourceType2 != ResourceType.STYLE_ITEM) {
            return;
        }
        String name = ResourceValuesXmlParser.getMandatoryAttr(child, "name");
        switch (WhenMappings.$EnumSwitchMapping$0[resourceType2.ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                builder.add(Symbol.Companion.createSymbol$default(Symbol.Companion, resourceType2, name, idProvider, validation, false, 16, null));
                break;
            }
            case 22: {
                ResourceValuesXmlParser.parseDeclareStyleable(child, idProvider, name, builder, enumSymbols, platformAttrSymbols, validation);
                break;
            }
            case 23: {
                ResourceValuesXmlParser.parseAttr$default(child, idProvider, name, builder, enumSymbols, false, false, 64, null);
                break;
            }
            default: {
                throw new ResourceValuesXmlParseException("Unknown resource value XML element '" + XmlUtils.toXml((Node)child) + '\'');
            }
        }
    }

    static /* synthetic */ void parseChild$default(Element element, SymbolTable.Builder builder, IdProvider idProvider, List list, SymbolTable symbolTable, boolean bl, int n, Object object) {
        if ((n & 0x20) != 0) {
            bl = true;
        }
        ResourceValuesXmlParser.parseChild(element, builder, idProvider, list, symbolTable, bl);
    }

    private static final void parseDeclareStyleable(Element declareStyleable, IdProvider idProvider, String styleableName, SymbolTable.Builder builder, List<Symbol> enumSymbols, SymbolTable platformAttrSymbols, boolean validation) {
        ImmutableList.Builder attrNames = new ImmutableList.Builder();
        ImmutableList.Builder attrValues = ImmutableList.builder();
        Node attrNode = declareStyleable.getFirstChild();
        while (attrNode != null) {
            int n;
            if (attrNode.getNodeType() != 1) {
                attrNode = attrNode.getNextSibling();
                continue;
            }
            Element attrElement = (Element)attrNode;
            String tagName = attrElement.getTagName();
            if (Intrinsics.areEqual((Object)tagName, (Object)"item")) {
                tagName = attrElement.getAttribute("type");
            }
            if (!Intrinsics.areEqual((Object)tagName, (Object)ResourceType.ATTR.getName()) || attrElement.getNamespaceURI() != null) {
                if (Intrinsics.areEqual((Object)tagName, (Object)"eat-comment")) {
                    attrNode = ((Element)attrNode).getNextSibling();
                    continue;
                }
                throw new ResourceValuesXmlParseException("Illegal type under declare-styleable: was <" + tagName + ">, only accepted is <attr>");
            }
            String attrName = ResourceValuesXmlParser.getMandatoryAttr(attrElement, "name");
            if (StringsKt.startsWith$default((String)attrName, (String)"android:", (boolean)false, (int)2, null)) {
                if (platformAttrSymbols == null) {
                    n = -1;
                } else {
                    Symbol attrSymbol;
                    String realAttrName;
                    Intrinsics.checkNotNullExpressionValue((Object)attrName.substring(SdkConstants.ANDROID_NS_NAME_PREFIX_LEN), (String)"this as java.lang.String).substring(startIndex)");
                    if ((Symbol)platformAttrSymbols.getSymbols().get((Object)ResourceType.ATTR, (Object)realAttrName) == null) {
                        throw new ResourceValuesXmlParseException("Unknown android attribute '" + attrName + "' under '" + styleableName);
                    }
                    n = attrSymbol.getIntValue();
                }
            } else {
                n = ResourceValuesXmlParser.parseAttr(attrElement, idProvider, attrName, builder, enumSymbols, true, validation);
            }
            int attrValue = n;
            attrNames.add((Object)attrName);
            attrValues.add((Object)attrValue);
            attrNode = ((Element)attrNode).getNextSibling();
        }
        ImmutableList immutableList = attrValues.build();
        Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"attrValues.build()");
        ImmutableList immutableList2 = attrNames.build();
        Intrinsics.checkNotNullExpressionValue((Object)immutableList2, (String)"attrNames.build()");
        builder.add(Symbol.Companion.createStyleableSymbol(styleableName, (ImmutableList<Integer>)immutableList, (List)immutableList2, validation));
    }

    static /* synthetic */ void parseDeclareStyleable$default(Element element, IdProvider idProvider, String string, SymbolTable.Builder builder, List list, SymbolTable symbolTable, boolean bl, int n, Object object) {
        if ((n & 0x40) != 0) {
            bl = true;
        }
        ResourceValuesXmlParser.parseDeclareStyleable(element, idProvider, string, builder, list, symbolTable, bl);
    }

    private static final int parseAttr(Element attr, IdProvider idProvider, String name, SymbolTable.Builder builder, List<Symbol> enumSymbols, boolean isMaybeDefinition, boolean validation) {
        Node enumNode = attr.getFirstChild();
        while (enumNode != null) {
            if (enumNode.getNodeType() != 1) {
                enumNode = enumNode.getNextSibling();
                continue;
            }
            Element enumElement = (Element)enumNode;
            String tagName = enumElement.getTagName();
            if (Intrinsics.areEqual((Object)tagName, (Object)"item")) {
                tagName = enumElement.getAttribute("type");
            }
            if (!Intrinsics.areEqual((Object)tagName, (Object)"enum") || enumElement.getNamespaceURI() != null) {
                enumNode = ((Element)enumNode).getNextSibling();
                continue;
            }
            Symbol newEnum = Symbol.Companion.createSymbol$default(Symbol.Companion, ResourceType.ID, ResourceValuesXmlParser.getMandatoryAttr(enumElement, "name"), idProvider, false, validation, 8, null);
            enumSymbols.add(newEnum);
            enumNode = ((Element)enumNode).getNextSibling();
        }
        Symbol newAttr = Symbol.Companion.createSymbol(ResourceType.ATTR, name, idProvider, isMaybeDefinition, validation);
        if (!builder.contains(newAttr)) {
            builder.add(newAttr);
            return newAttr.getIntValue();
        }
        if (!isMaybeDefinition) {
            Symbol symbol = builder.get(newAttr);
            Intrinsics.checkNotNull((Object)symbol, (String)"null cannot be cast to non-null type com.android.ide.common.symbols.Symbol.AttributeSymbol");
            if (((Symbol.AttributeSymbol)symbol).isMaybeDefinition()) {
                Symbol symbol2 = builder.remove(newAttr.getResourceType(), newAttr.getCanonicalName());
                Intrinsics.checkNotNull((Object)symbol2);
                Symbol old = symbol2;
                builder.add(Symbol.Companion.attributeSymbol$default(Symbol.Companion, newAttr.getCanonicalName(), old.getIntValue(), false, null, null, 24, null));
            }
        }
        Symbol symbol = builder.get(newAttr);
        Intrinsics.checkNotNull((Object)symbol);
        return symbol.getIntValue();
    }

    static /* synthetic */ int parseAttr$default(Element element, IdProvider idProvider, String string, SymbolTable.Builder builder, List list, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 0x40) != 0) {
            bl2 = true;
        }
        return ResourceValuesXmlParser.parseAttr(element, idProvider, string, builder, list, bl, bl2);
    }

    private static final String getMandatoryAttr(Element element, String attrName) {
        Attr attr = element.getAttributeNodeNS(null, attrName);
        if (attr == null) {
            throw new ResourceValuesXmlParseException("Element '" + element.getTagName() + "' should have attribute '" + attrName + '\'');
        }
        Attr attr2 = attr;
        String string = attr2.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"attr.value");
        return string;
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ResourceType.values().length];
            nArray[ResourceType.ANIM.ordinal()] = 1;
            nArray[ResourceType.ANIMATOR.ordinal()] = 2;
            nArray[ResourceType.ARRAY.ordinal()] = 3;
            nArray[ResourceType.BOOL.ordinal()] = 4;
            nArray[ResourceType.COLOR.ordinal()] = 5;
            nArray[ResourceType.DIMEN.ordinal()] = 6;
            nArray[ResourceType.DRAWABLE.ordinal()] = 7;
            nArray[ResourceType.FONT.ordinal()] = 8;
            nArray[ResourceType.FRACTION.ordinal()] = 9;
            nArray[ResourceType.ID.ordinal()] = 10;
            nArray[ResourceType.INTEGER.ordinal()] = 11;
            nArray[ResourceType.INTERPOLATOR.ordinal()] = 12;
            nArray[ResourceType.LAYOUT.ordinal()] = 13;
            nArray[ResourceType.MENU.ordinal()] = 14;
            nArray[ResourceType.MIPMAP.ordinal()] = 15;
            nArray[ResourceType.PLURALS.ordinal()] = 16;
            nArray[ResourceType.RAW.ordinal()] = 17;
            nArray[ResourceType.STRING.ordinal()] = 18;
            nArray[ResourceType.STYLE.ordinal()] = 19;
            nArray[ResourceType.TRANSITION.ordinal()] = 20;
            nArray[ResourceType.XML.ordinal()] = 21;
            nArray[ResourceType.STYLEABLE.ordinal()] = 22;
            nArray[ResourceType.ATTR.ordinal()] = 23;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

