/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.tools.projectWizard.wizard.service;

import com.intellij.jarRepository.RemoteRepositoriesConfiguration;
import com.intellij.jarRepository.RemoteRepositoryDescription;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.framework.KotlinSdkType;
import org.jetbrains.kotlin.tools.projectWizard.core.Context;
import org.jetbrains.kotlin.tools.projectWizard.core.TaskResult;
import org.jetbrains.kotlin.tools.projectWizard.core.TaskResultKt;
import org.jetbrains.kotlin.tools.projectWizard.core.service.KotlinVersionKindKt;
import org.jetbrains.kotlin.tools.projectWizard.core.service.ProjectImportingWizardService;
import org.jetbrains.kotlin.tools.projectWizard.core.service.WizardKotlinVersion;
import org.jetbrains.kotlin.tools.projectWizard.ir.buildsystem.ModuleIR;
import org.jetbrains.kotlin.tools.projectWizard.plugins.buildSystem.BuildSystemType;
import org.jetbrains.kotlin.tools.projectWizard.plugins.kotlin.ProjectKind;
import org.jetbrains.kotlin.tools.projectWizard.settings.buildsystem.Repository;
import org.jetbrains.kotlin.tools.projectWizard.wizard.IdeWizard;
import org.jetbrains.kotlin.tools.projectWizard.wizard.NewProjectWizardModuleBuilder;
import org.jetbrains.kotlin.tools.projectWizard.wizard.service.IdeaKotlinVersionProviderService;
import org.jetbrains.kotlin.tools.projectWizard.wizard.service.IdeaWizardService;
import org.jetbrains.kotlin.tools.projectWizard.wizard.service.JpsModuleConfigurationUpdater;
import org.jetbrains.kotlin.tools.projectWizard.wizard.service.ProjectImporter;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\f\u001a\u00020\rH\u0002J<\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u000f2\u000e\u0010\u0010\u001a\n0\u0011R\u00020\u0012j\u0002`\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001aH\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/tools/projectWizard/wizard/service/IdeaJpsWizardService;", "Lorg/jetbrains/kotlin/tools/projectWizard/core/service/ProjectImportingWizardService;", "Lorg/jetbrains/kotlin/tools/projectWizard/wizard/service/IdeaWizardService;", "project", "Lcom/intellij/openapi/project/Project;", "modulesModel", "Lcom/intellij/openapi/module/ModifiableModuleModel;", "modulesBuilder", "Lorg/jetbrains/kotlin/tools/projectWizard/wizard/NewProjectWizardModuleBuilder;", "ideWizard", "Lorg/jetbrains/kotlin/tools/projectWizard/wizard/IdeWizard;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/module/ModifiableModuleModel;Lorg/jetbrains/kotlin/tools/projectWizard/wizard/NewProjectWizardModuleBuilder;Lorg/jetbrains/kotlin/tools/projectWizard/wizard/IdeWizard;)V", "addRepositoryForNonReleasedVersion", "", "importProject", "Lorg/jetbrains/kotlin/tools/projectWizard/core/TaskResult;", "reader", "Lorg/jetbrains/kotlin/tools/projectWizard/core/Context$Reader;", "Lorg/jetbrains/kotlin/tools/projectWizard/core/Context;", "Lorg/jetbrains/kotlin/tools/projectWizard/core/Reader;", "path", "Ljava/nio/file/Path;", "modulesIrs", "", "Lorg/jetbrains/kotlin/tools/projectWizard/ir/buildsystem/ModuleIR;", "buildSystem", "Lorg/jetbrains/kotlin/tools/projectWizard/plugins/buildSystem/BuildSystemType;", "isSuitableFor", "", "buildSystemType", "kotlin.project-wizard.idea"})
public final class IdeaJpsWizardService
implements ProjectImportingWizardService,
IdeaWizardService {
    private final Project project;
    private final ModifiableModuleModel modulesModel;
    private final NewProjectWizardModuleBuilder modulesBuilder;
    private final IdeWizard ideWizard;

    @Override
    public boolean isSuitableFor(@NotNull BuildSystemType buildSystemType2) {
        Intrinsics.checkNotNullParameter((Object)buildSystemType2, (String)"buildSystemType");
        return buildSystemType2 == BuildSystemType.Jps;
    }

    @Override
    @NotNull
    public TaskResult<Unit> importProject(@NotNull Context.Reader reader, @NotNull Path path2, @NotNull List<? extends ModuleIR> modulesIrs, @NotNull BuildSystemType buildSystem2) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Intrinsics.checkNotNullParameter(modulesIrs, (String)"modulesIrs");
        Intrinsics.checkNotNullParameter((Object)buildSystem2, (String)"buildSystem");
        KotlinSdkType.Companion.setUpIfNeeded$default(KotlinSdkType.Companion, null, null, 3, null);
        ProjectImporter projectImporter = new ProjectImporter(this.project, this.modulesModel, path2, modulesIrs);
        this.addRepositoryForNonReleasedVersion();
        this.modulesBuilder.addModuleConfigurationUpdater(new JpsModuleConfigurationUpdater(this.ideWizard.getJpsData(), projectImporter, this.project, reader));
        projectImporter.import();
        Disposer.dispose((Disposable)((Disposable)this.ideWizard.getJpsData().getLibraryOptionsPanel()));
        return TaskResultKt.getUNIT_SUCCESS();
    }

    /*
     * WARNING - void declaration
     */
    private final void addRepositoryForNonReleasedVersion() {
        Collection<RemoteRepositoryDescription> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Repository repositoryToAdd;
        void $this$filterTo$iv$iv;
        WizardKotlinVersion kotlinVersion2 = new IdeaKotlinVersionProviderService().getKotlinVersion(ProjectKind.Singleplatform);
        if (KotlinVersionKindKt.isStable(kotlinVersion2.getKind())) {
            return;
        }
        RemoteRepositoriesConfiguration remoteRepositoriesConfiguration = RemoteRepositoriesConfiguration.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)remoteRepositoriesConfiguration, (String)"RemoteRepositoriesConfig\u2026tion.getInstance(project)");
        List list2 = remoteRepositoriesConfiguration.getRepositories();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"RemoteRepositoriesConfig\u2026nce(project).repositories");
        List currentRepositories = list2;
        Iterable $this$filter$iv = kotlinVersion2.getRepositories();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            block7: {
                repositoryToAdd = (Repository)element$iv$iv;
                boolean bl2 = false;
                Iterable $this$none$iv = currentRepositories;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        RemoteRepositoryDescription it = (RemoteRepositoryDescription)element$iv;
                        boolean bl3 = false;
                        RemoteRepositoryDescription remoteRepositoryDescription = it;
                        Intrinsics.checkNotNullExpressionValue((Object)remoteRepositoryDescription, (String)"it");
                        if (!Intrinsics.areEqual((Object)remoteRepositoryDescription.getUrl(), (Object)repositoryToAdd.getUrl())) continue;
                        bl = false;
                        break block7;
                    }
                    bl = true;
                }
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List repositoriesToAdd = (List)destination$iv$iv;
        if (repositoriesToAdd.isEmpty()) {
            return;
        }
        RemoteRepositoriesConfiguration remoteRepositoriesConfiguration2 = RemoteRepositoriesConfiguration.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)remoteRepositoriesConfiguration2, (String)"RemoteRepositoriesConfig\u2026tion.getInstance(project)");
        $this$filter$iv = repositoriesToAdd;
        Collection collection2 = currentRepositories;
        RemoteRepositoriesConfiguration remoteRepositoriesConfiguration3 = remoteRepositoriesConfiguration2;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            repositoryToAdd = (Repository)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            RemoteRepositoryDescription remoteRepositoryDescription = new RemoteRepositoryDescription(it.getIdForMaven(), it.getIdForMaven(), it.getUrl());
            collection.add(remoteRepositoryDescription);
        }
        collection = (List)destination$iv$iv;
        remoteRepositoriesConfiguration3.setRepositories(CollectionsKt.plus((Collection)collection2, (Iterable)collection));
    }

    public IdeaJpsWizardService(@NotNull Project project2, @NotNull ModifiableModuleModel modulesModel, @NotNull NewProjectWizardModuleBuilder modulesBuilder, @NotNull IdeWizard ideWizard) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)modulesModel, (String)"modulesModel");
        Intrinsics.checkNotNullParameter((Object)((Object)modulesBuilder), (String)"modulesBuilder");
        Intrinsics.checkNotNullParameter((Object)ideWizard, (String)"ideWizard");
        this.project = project2;
        this.modulesModel = modulesModel;
        this.modulesBuilder = modulesBuilder;
        this.ideWizard = ideWizard;
    }
}

