/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.nj2k.printing;

import com.intellij.openapi.util.text.StringUtil;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.nj2k.printing.JKPrinter;
import org.jetbrains.kotlin.nj2k.tree.JKComment;
import org.jetbrains.kotlin.nj2k.tree.JKDeclaration;
import org.jetbrains.kotlin.nj2k.tree.JKFormattingOwner;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0012\u0010\u000f\u001a\u00020\u0010*\b\u0012\u0004\u0012\u00020\u00070\u0011H\u0002J\u000e\u0010\u000f\u001a\u0004\u0018\u00010\u0010*\u00020\u0007H\u0002J\f\u0010\u0012\u001a\u00020\u0013*\u00020\u0010H\u0002J\f\u0010\u0014\u001a\u00020\u0013*\u00020\u0007H\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/nj2k/printing/JKCommentPrinter;", "", "printer", "Lorg/jetbrains/kotlin/nj2k/printing/JKPrinter;", "(Lorg/jetbrains/kotlin/nj2k/printing/JKPrinter;)V", "printedTokens", "", "Lorg/jetbrains/kotlin/nj2k/tree/JKComment;", "getPrinter", "()Lorg/jetbrains/kotlin/nj2k/printing/JKPrinter;", "printLeadingComments", "", "element", "Lorg/jetbrains/kotlin/nj2k/tree/JKFormattingOwner;", "printTrailingComments", "createText", "", "", "hasNoLineBreakAfterSingleLineComment", "", "shouldBeDropped", "kotlin.j2k.new"})
public final class JKCommentPrinter {
    private final Set<JKComment> printedTokens;
    @NotNull
    private final JKPrinter printer;

    private final boolean shouldBeDropped(JKComment $this$shouldBeDropped) {
        return StringsKt.startsWith$default((String)$this$shouldBeDropped.getText(), (String)"//noinspection", (boolean)false, (int)2, null);
    }

    private final String createText(JKComment $this$createText) {
        String string;
        if (!this.printedTokens.contains($this$createText)) {
            Collection collection = this.printedTokens;
            collection.add($this$createText);
            string = !$this$createText.isSingleline() && StringsKt.lastIndexOf$default((CharSequence)$this$createText.getText(), (String)"/*", (int)0, (boolean)false, (int)6, null) != StringsKt.indexOf$default((CharSequence)$this$createText.getText(), (String)"/*", (int)0, (boolean)false, (int)6, null) ? StringsKt.replaceFirst$default((String)StringsKt.replace$default((String)$this$createText.getText(), (String)"/*", (String)"/ *", (boolean)false, (int)4, null), (String)"/ *", (String)"/*", (boolean)false, (int)4, null) : $this$createText.getText();
        } else {
            string = null;
        }
        return string;
    }

    private final String createText(List<JKComment> $this$createText) {
        StringBuilder stringBuilder;
        StringBuilder $this$buildString = stringBuilder = new StringBuilder();
        boolean bl = false;
        boolean needNewLine = false;
        for (JKComment comment2 : $this$createText) {
            String text2;
            Object object;
            block5: {
                CharSequence charSequence;
                block6: {
                    if (this.shouldBeDropped(comment2) || this.createText(comment2) == null) continue;
                    if (!needNewLine) break block5;
                    if (comment2.getIndent() == null) break block6;
                    String it = charSequence;
                    boolean bl2 = false;
                    if (StringUtil.containsLineBreak((CharSequence)it)) break block5;
                }
                charSequence = $this$buildString;
                Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)charSequence).append('\n'), (String)"append('\\n')");
            }
            if ((object = comment2.getIndent()) == null) {
                object = Character.valueOf(' ');
            }
            $this$buildString.append(object);
            $this$buildString.append(text2);
            needNewLine = StringsKt.startsWith$default((String)text2, (String)"//", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)text2, (char)'\n', (boolean)false, (int)2, null);
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    private final boolean hasNoLineBreakAfterSingleLineComment(String $this$hasNoLineBreakAfterSingleLineComment) {
        return StringsKt.lastIndexOf$default((CharSequence)$this$hasNoLineBreakAfterSingleLineComment, (char)'\n', (int)0, (boolean)false, (int)6, null) < StringsKt.lastIndexOf$default((CharSequence)$this$hasNoLineBreakAfterSingleLineComment, (String)"//", (int)0, (boolean)false, (int)6, null);
    }

    public final void printLeadingComments(@NotNull JKFormattingOwner element3) {
        boolean addNewLine;
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        String text2 = this.createText(element3.getLeadingComments());
        this.printer.print(text2);
        boolean bl = addNewLine = element3.getHasLeadingLineBreak() || this.hasNoLineBreakAfterSingleLineComment(text2);
        if (addNewLine) {
            this.printer.println();
        }
    }

    public final void printTrailingComments(@NotNull JKFormattingOwner element3) {
        boolean addNewLine;
        Collection collection;
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        String text2 = this.createText(element3.getTrailingComments());
        this.printer.print(text2);
        boolean bl = element3.getHasTrailingLineBreak() || element3 instanceof JKDeclaration && !(collection = (Collection)element3.getTrailingComments()).isEmpty() || this.hasNoLineBreakAfterSingleLineComment(text2) ? true : (addNewLine = false);
        if (addNewLine) {
            this.printer.println();
        }
    }

    @NotNull
    public final JKPrinter getPrinter() {
        return this.printer;
    }

    public JKCommentPrinter(@NotNull JKPrinter printer) {
        Intrinsics.checkNotNullParameter((Object)printer, (String)"printer");
        this.printer = printer;
        this.printedTokens = new LinkedHashSet();
    }
}

