/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.nj2k.inference.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.nj2k.inference.common.Constraint;
import org.jetbrains.kotlin.nj2k.inference.common.ConstraintBound;
import org.jetbrains.kotlin.nj2k.inference.common.ConstraintKt;
import org.jetbrains.kotlin.nj2k.inference.common.ConstraintPriority;
import org.jetbrains.kotlin.nj2k.inference.common.DebugPrinter;
import org.jetbrains.kotlin.nj2k.inference.common.DefaultStateProvider;
import org.jetbrains.kotlin.nj2k.inference.common.EqualsConstraint;
import org.jetbrains.kotlin.nj2k.inference.common.InferenceContext;
import org.jetbrains.kotlin.nj2k.inference.common.LiteralBound;
import org.jetbrains.kotlin.nj2k.inference.common.Solver;
import org.jetbrains.kotlin.nj2k.inference.common.State;
import org.jetbrains.kotlin.nj2k.inference.common.SubtypeConstraint;
import org.jetbrains.kotlin.nj2k.inference.common.TypeVariable;
import org.jetbrains.kotlin.nj2k.inference.common.TypeVariableBound;
import org.jetbrains.kotlin.nj2k.inference.common.TypeVariablesKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0014\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eJ\u0012\u0010\u0010\u001a\u00020\f*\b\u0012\u0004\u0012\u00020\u000f0\u0011H\u0002J\u0012\u0010\u0012\u001a\u00020\f*\b\u0012\u0004\u0012\u00020\u000f0\u0011H\u0002J\u000e\u0010\u0013\u001a\u0004\u0018\u00010\u0014*\u00020\u0015H\u0002J%\u0010\u0016\u001a\r\u0012\t\u0012\u00070\u0017\u00a2\u0006\u0002\b\u00180\u000e*\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J%\u0010\u001b\u001a\r\u0012\t\u0012\u00070\u0017\u00a2\u0006\u0002\b\u00180\u000e*\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0014\u0010\u001c\u001a\u0004\u0018\u00010\u001d*\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\u001a\u0010\u001e\u001a\u00020\u0005*\b\u0012\u0004\u0012\u00020\u000f0\u00112\u0006\u0010\u001f\u001a\u00020\u001aH\u0002J\u001a\u0010 \u001a\u00020\u0005*\b\u0012\u0004\u0012\u00020\u000f0\u00112\u0006\u0010\u001f\u001a\u00020\u001aH\u0002J\u001a\u0010!\u001a\u00020\u0005*\b\u0012\u0004\u0012\u00020\u000f0\u00112\u0006\u0010\u001f\u001a\u00020\u001aH\u0002J\u001a\u0010\"\u001a\u00020\f*\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u001f\u001a\u00020#H\u0002J\u0012\u0010$\u001a\u00020\u0005*\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/nj2k/inference/common/Solver;", "", "inferenceContext", "Lorg/jetbrains/kotlin/nj2k/inference/common/InferenceContext;", "printConstraints", "", "defaultStateProvider", "Lorg/jetbrains/kotlin/nj2k/inference/common/DefaultStateProvider;", "(Lorg/jetbrains/kotlin/nj2k/inference/common/InferenceContext;ZLorg/jetbrains/kotlin/nj2k/inference/common/DefaultStateProvider;)V", "printer", "Lorg/jetbrains/kotlin/nj2k/inference/common/DebugPrinter;", "solveConstraints", "", "constraints", "", "Lorg/jetbrains/kotlin/nj2k/inference/common/Constraint;", "cleanConstraints", "", "filterOutConstraintsWithUnusedState", "fixedState", "Lorg/jetbrains/kotlin/nj2k/inference/common/State;", "Lorg/jetbrains/kotlin/nj2k/inference/common/ConstraintBound;", "getConstraintsWithNotNullUpperBound", "Lorg/jetbrains/kotlin/nj2k/inference/common/SubtypeConstraint;", "Lkotlin/internal/NoInfer;", "priority", "Lorg/jetbrains/kotlin/nj2k/inference/common/ConstraintPriority;", "getConstraintsWithNullableLowerBound", "getTypeVariableAsEqualsOrUpperBound", "Lorg/jetbrains/kotlin/nj2k/inference/common/TypeVariable;", "handleConstraintsWithNotNullUpperBound", "step", "handleConstraintsWithNullableLowerBound", "handleEqualsConstraints", "printDebugInfo", "", "substituteConstraints", "kotlin.j2k.services"})
public final class Solver {
    private final DebugPrinter printer;
    private final InferenceContext inferenceContext;
    private final boolean printConstraints;
    private final DefaultStateProvider defaultStateProvider;

    private final void printDebugInfo(List<? extends Constraint> $this$printDebugInfo, int step2) {
        DebugPrinter debugPrinter;
        DebugPrinter $this$with = debugPrinter = this.printer;
        boolean bl = false;
        if (this.printConstraints) {
            Object object;
            String object2 = "Step " + step2 + ":";
            System.out.println((Object)object2);
            for (Constraint constraint : $this$printDebugInfo) {
                object = $this$with.asString(constraint);
                System.out.println(object);
            }
            System.out.println();
            String string = "type variables:";
            System.out.println((Object)string);
            for (TypeVariable typeVariable : this.inferenceContext.getTypeVariables()) {
                if (typeVariable.getState() == State.UNUSED) continue;
                object = $this$with.getName(typeVariable) + " := " + typeVariable.getState();
                System.out.println(object);
            }
            String string2 = "---------------\n";
            System.out.println((Object)string2);
        }
    }

    public final void solveConstraints(@NotNull List<? extends Constraint> constraints2) {
        boolean somethingChanged;
        Intrinsics.checkNotNullParameter(constraints2, (String)"constraints");
        List mutableConstraints = CollectionsKt.toMutableList((Collection)constraints2);
        this.filterOutConstraintsWithUnusedState(mutableConstraints);
        ConstraintPriority currentStep = (ConstraintPriority)((Object)ArraysKt.first((Object[])ConstraintPriority.values()));
        int i = 0;
        do {
            somethingChanged = false;
            List $this$with = mutableConstraints;
            boolean bl = false;
            this.printDebugInfo($this$with, i);
            somethingChanged = this.handleConstraintsWithNullableLowerBound($this$with, currentStep);
            somethingChanged = this.handleConstraintsWithNotNullUpperBound($this$with, currentStep) || somethingChanged;
            somethingChanged = this.handleEqualsConstraints($this$with, currentStep) || somethingChanged;
            somethingChanged = this.substituteConstraints($this$with) || somethingChanged;
            this.cleanConstraints($this$with);
            if (!somethingChanged && currentStep.ordinal() < ArraysKt.getLastIndex((Object[])ConstraintPriority.values())) {
                currentStep = ConstraintPriority.values()[currentStep.ordinal() + 1];
                somethingChanged = true;
            }
            if (!somethingChanged) {
                TypeVariable typeVariable;
                TypeVariable typeVariable2 = this.getTypeVariableAsEqualsOrUpperBound(mutableConstraints);
                if (typeVariable2 == null) {
                    Object v1;
                    block6: {
                        Iterable $this$firstOrNull$iv = this.inferenceContext.getTypeVariables();
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            TypeVariable it = (TypeVariable)element$iv;
                            boolean bl2 = false;
                            if (!(!TypeVariablesKt.isFixed(it))) continue;
                            v1 = element$iv;
                            break block6;
                        }
                        v1 = null;
                    }
                    typeVariable2 = v1;
                }
                if ((typeVariable = typeVariable2) != null) {
                    TypeVariablesKt.setStateIfNotFixed(typeVariable, this.defaultStateProvider.defaultStateFor(typeVariable));
                    somethingChanged = true;
                }
            }
            int n = i;
            i = n + 1;
        } while (somethingChanged);
    }

    private final void cleanConstraints(List<Constraint> $this$cleanConstraints) {
        $this$cleanConstraints.removeIf(cleanConstraints.1.INSTANCE);
    }

    private final boolean handleConstraintsWithNullableLowerBound(List<Constraint> $this$handleConstraintsWithNullableLowerBound, ConstraintPriority step2) {
        boolean somethingChanged = false;
        List<SubtypeConstraint> nullableConstraints = this.getConstraintsWithNullableLowerBound($this$handleConstraintsWithNullableLowerBound, step2);
        Collection object2 = nullableConstraints;
        if (!object2.isEmpty()) {
            Collection collection = $this$handleConstraintsWithNullableLowerBound;
            CollectionsKt.removeAll((Collection)collection, (Iterable)nullableConstraints);
            for (SubtypeConstraint subtypeConstraint : nullableConstraints) {
                ConstraintBound upperBound = subtypeConstraint.component2();
                if (!(upperBound instanceof TypeVariableBound)) continue;
                somethingChanged = true;
                TypeVariablesKt.setStateIfNotFixed(((TypeVariableBound)upperBound).getTypeVariable(), State.UPPER);
            }
        }
        return somethingChanged;
    }

    private final boolean handleConstraintsWithNotNullUpperBound(List<Constraint> $this$handleConstraintsWithNotNullUpperBound, ConstraintPriority step2) {
        boolean somethingChanged = false;
        List<SubtypeConstraint> nullableConstraints = this.getConstraintsWithNotNullUpperBound($this$handleConstraintsWithNotNullUpperBound, step2);
        Collection object2 = nullableConstraints;
        if (!object2.isEmpty()) {
            Collection collection = $this$handleConstraintsWithNotNullUpperBound;
            CollectionsKt.removeAll((Collection)collection, (Iterable)nullableConstraints);
            for (SubtypeConstraint subtypeConstraint : nullableConstraints) {
                ConstraintBound lowerBound = subtypeConstraint.component1();
                if (!(lowerBound instanceof TypeVariableBound)) continue;
                somethingChanged = true;
                TypeVariablesKt.setStateIfNotFixed(((TypeVariableBound)lowerBound).getTypeVariable(), State.LOWER);
            }
        }
        return somethingChanged;
    }

    private final State fixedState(ConstraintBound $this$fixedState) {
        return $this$fixedState instanceof LiteralBound ? ((LiteralBound)$this$fixedState).getState() : ($this$fixedState instanceof TypeVariableBound && TypeVariablesKt.isFixed(((TypeVariableBound)$this$fixedState).getTypeVariable()) ? ((TypeVariableBound)$this$fixedState).getTypeVariable().getState() : null);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean handleEqualsConstraints(List<Constraint> $this$handleEqualsConstraints, ConstraintPriority step2) {
        ConstraintBound $this$filterTo$iv$iv;
        Collection $this$filter$iv;
        void $this$filterIsInstanceTo$iv$iv;
        boolean somethingChanged = false;
        Iterable $this$filterIsInstance$iv = $this$handleEqualsConstraints;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof EqualsConstraint)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv;
            element$iv$iv = iterator.next();
            EqualsConstraint it = (EqualsConstraint)element$iv$iv;
            boolean bl = false;
            if (!(it.getPriority().compareTo((Enum)step2) <= 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List equalsConstraints = (List)destination$iv$iv;
        $this$filter$iv = equalsConstraints;
        if (!$this$filter$iv.isEmpty()) {
            for (EqualsConstraint constraint : equalsConstraints) {
                void leftBound;
                Object object = constraint;
                $this$filterTo$iv$iv = ((EqualsConstraint)object).component1();
                ConstraintBound rightBound = ((EqualsConstraint)object).component2();
                if (leftBound instanceof TypeVariableBound && this.fixedState(rightBound) != null) {
                    object = $this$handleEqualsConstraints;
                    object.remove(constraint);
                    somethingChanged = true;
                    TypeVariable typeVariable = ((TypeVariableBound)leftBound).getTypeVariable();
                    State state = this.fixedState(rightBound);
                    Intrinsics.checkNotNull((Object)((Object)state));
                    TypeVariablesKt.setStateIfNotFixed(typeVariable, state);
                    continue;
                }
                if (!(rightBound instanceof TypeVariableBound) || this.fixedState((ConstraintBound)leftBound) == null) continue;
                object = $this$handleEqualsConstraints;
                object.remove(constraint);
                somethingChanged = true;
                TypeVariable typeVariable = ((TypeVariableBound)rightBound).getTypeVariable();
                State state = this.fixedState((ConstraintBound)leftBound);
                Intrinsics.checkNotNull((Object)((Object)state));
                TypeVariablesKt.setStateIfNotFixed(typeVariable, state);
            }
        }
        return somethingChanged;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean substituteConstraints(List<? extends Constraint> $this$substituteConstraints) {
        boolean somethingChanged = false;
        for (Constraint constraint : $this$substituteConstraints) {
            void lower;
            if (!(constraint instanceof SubtypeConstraint)) continue;
            SubtypeConstraint subtypeConstraint = (SubtypeConstraint)constraint;
            ConstraintBound constraintBound = subtypeConstraint.component1();
            ConstraintBound upper = subtypeConstraint.component2();
            if (lower instanceof TypeVariableBound && TypeVariablesKt.isFixed(((TypeVariableBound)lower).getTypeVariable())) {
                somethingChanged = true;
                LiteralBound literalBound = ConstraintKt.constraintBound(((TypeVariableBound)lower).getTypeVariable().getState());
                if (literalBound == null) {
                    continue;
                }
                ((SubtypeConstraint)constraint).setSubtype(literalBound);
            }
            if (!(upper instanceof TypeVariableBound) || !TypeVariablesKt.isFixed(((TypeVariableBound)upper).getTypeVariable())) continue;
            somethingChanged = true;
            LiteralBound literalBound = ConstraintKt.constraintBound(((TypeVariableBound)upper).getTypeVariable().getState());
            if (literalBound == null) {
                continue;
            }
            ((SubtypeConstraint)constraint).setSupertype(literalBound);
        }
        return somethingChanged;
    }

    /*
     * Unable to fully structure code
     */
    private final List<SubtypeConstraint> getConstraintsWithNullableLowerBound(List<? extends Constraint> $this$getConstraintsWithNullableLowerBound, ConstraintPriority priority) {
        $this$filterIsInstance$iv = $this$getConstraintsWithNullableLowerBound;
        $i$f$filterIsInstance = false;
        var5_5 = $this$filterIsInstance$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterIsInstanceTo = false;
        for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof SubtypeConstraint)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            constraint = (SubtypeConstraint)element$iv$iv;
            $i$a$-filter-Solver$getConstraintsWithNullableLowerBound$1 = false;
            if (constraint.getPriority().compareTo((Enum)priority) > 0) ** GOTO lbl-1000
            $this$safeAs$iv = constraint.getSubtype();
            $i$f$safeAs = false;
            v0 = $this$safeAs$iv;
            if (!(v0 instanceof LiteralBound)) {
                v0 = null;
            }
            v1 = (LiteralBound)v0;
            if ((v1 != null ? v1.getState() : null) == State.UPPER) {
                v2 = true;
            } else lbl-1000:
            // 2 sources

            {
                v2 = false;
            }
            if (!v2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * Unable to fully structure code
     */
    private final List<SubtypeConstraint> getConstraintsWithNotNullUpperBound(List<? extends Constraint> $this$getConstraintsWithNotNullUpperBound, ConstraintPriority priority) {
        $this$filterIsInstance$iv = $this$getConstraintsWithNotNullUpperBound;
        $i$f$filterIsInstance = false;
        var5_5 = $this$filterIsInstance$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterIsInstanceTo = false;
        for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof SubtypeConstraint)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            constraint = (SubtypeConstraint)element$iv$iv;
            $i$a$-filter-Solver$getConstraintsWithNotNullUpperBound$1 = false;
            if (constraint.getPriority().compareTo((Enum)priority) > 0) ** GOTO lbl-1000
            $this$safeAs$iv = constraint.getSupertype();
            $i$f$safeAs = false;
            v0 = $this$safeAs$iv;
            if (!(v0 instanceof LiteralBound)) {
                v0 = null;
            }
            v1 = (LiteralBound)v0;
            if ((v1 != null ? v1.getState() : null) == State.LOWER) {
                v2 = true;
            } else lbl-1000:
            // 2 sources

            {
                v2 = false;
            }
            if (!v2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final TypeVariable getTypeVariableAsEqualsOrUpperBound(List<? extends Constraint> $this$getTypeVariableAsEqualsOrUpperBound) {
        for (Constraint constraint : $this$getTypeVariableAsEqualsOrUpperBound) {
            TypeVariableBound typeVariableBound;
            TypeVariableBound typeVariableBound2;
            boolean bl;
            Object $this$safeAs$iv;
            Constraint constraint2 = constraint;
            if (constraint2 instanceof SubtypeConstraint) {
                Object object;
                Object object2;
                $this$safeAs$iv = ((SubtypeConstraint)constraint).getSupertype();
                boolean $i$f$safeAs = false;
                Object object3 = $this$safeAs$iv;
                if (!(object3 instanceof TypeVariableBound)) {
                    object3 = null;
                }
                if ((object2 = (TypeVariableBound)object3) != null && (object2 = ((TypeVariableBound)object2).getTypeVariable()) != null) {
                    Object it = $this$safeAs$iv = object2;
                    bl = false;
                    object2 = this.defaultStateProvider.defaultStateFor((TypeVariable)it) == State.LOWER ? $this$safeAs$iv : null;
                    if (object2 != null) {
                        it = $this$safeAs$iv = object2;
                        boolean bl2 = false;
                        return it;
                    }
                }
                $this$safeAs$iv = ((SubtypeConstraint)constraint).getSubtype();
                $i$f$safeAs = false;
                Object object4 = $this$safeAs$iv;
                if (!(object4 instanceof TypeVariableBound)) {
                    object4 = null;
                }
                if ((object = (TypeVariableBound)object4) == null || (object = ((TypeVariableBound)object).getTypeVariable()) == null) continue;
                Object it = $this$safeAs$iv = object;
                bl = false;
                object = this.defaultStateProvider.defaultStateFor((TypeVariable)it) == State.UPPER ? $this$safeAs$iv : null;
                if (object == null) continue;
                it = $this$safeAs$iv = object;
                boolean bl3 = false;
                return it;
            }
            if (!(constraint2 instanceof EqualsConstraint)) continue;
            $this$safeAs$iv = ((EqualsConstraint)constraint).getLeft();
            boolean $i$f$safeAs = false;
            Object object = $this$safeAs$iv;
            if (!(object instanceof TypeVariableBound)) {
                object = null;
            }
            if ((typeVariableBound2 = (TypeVariableBound)object) == null) {
                $this$safeAs$iv = ((EqualsConstraint)constraint).getRight();
                $i$f$safeAs = false;
                Object object5 = $this$safeAs$iv;
                if (!(object5 instanceof TypeVariableBound)) {
                    object5 = null;
                }
                typeVariableBound2 = (TypeVariableBound)object5;
            }
            if (typeVariableBound2 == null) continue;
            TypeVariableBound it = typeVariableBound = typeVariableBound2;
            bl = false;
            return it.getTypeVariable();
        }
        return null;
    }

    private final void filterOutConstraintsWithUnusedState(List<Constraint> $this$filterOutConstraintsWithUnusedState) {
        $this$filterOutConstraintsWithUnusedState.removeIf(filterOutConstraintsWithUnusedState.1.INSTANCE);
    }

    public Solver(@NotNull InferenceContext inferenceContext2, boolean printConstraints, @NotNull DefaultStateProvider defaultStateProvider) {
        Intrinsics.checkNotNullParameter((Object)inferenceContext2, (String)"inferenceContext");
        Intrinsics.checkNotNullParameter((Object)defaultStateProvider, (String)"defaultStateProvider");
        this.inferenceContext = inferenceContext2;
        this.printConstraints = printConstraints;
        this.defaultStateProvider = defaultStateProvider;
        this.printer = new DebugPrinter(this.inferenceContext);
    }
}

