/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.nj2k.inference.common;

import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.nj2k.inference.common.BoundType;
import org.jetbrains.kotlin.nj2k.inference.common.BoundTypeLabel;
import org.jetbrains.kotlin.nj2k.inference.common.ClassReference;
import org.jetbrains.kotlin.nj2k.inference.common.Constraint;
import org.jetbrains.kotlin.nj2k.inference.common.ConstraintBound;
import org.jetbrains.kotlin.nj2k.inference.common.DebugPrinter$WhenMappings;
import org.jetbrains.kotlin.nj2k.inference.common.DebugPrinter$addTypeVariablesNames$;
import org.jetbrains.kotlin.nj2k.inference.common.DescriptorClassReference;
import org.jetbrains.kotlin.nj2k.inference.common.EqualsConstraint;
import org.jetbrains.kotlin.nj2k.inference.common.GenericLabel;
import org.jetbrains.kotlin.nj2k.inference.common.InferenceContext;
import org.jetbrains.kotlin.nj2k.inference.common.LiteralBound;
import org.jetbrains.kotlin.nj2k.inference.common.LiteralLabel;
import org.jetbrains.kotlin.nj2k.inference.common.Namer;
import org.jetbrains.kotlin.nj2k.inference.common.NoClassReference;
import org.jetbrains.kotlin.nj2k.inference.common.NullLiteralLabel;
import org.jetbrains.kotlin.nj2k.inference.common.StarProjectionLabel;
import org.jetbrains.kotlin.nj2k.inference.common.State;
import org.jetbrains.kotlin.nj2k.inference.common.SubtypeConstraint;
import org.jetbrains.kotlin.nj2k.inference.common.TypeParameter;
import org.jetbrains.kotlin.nj2k.inference.common.TypeParameterLabel;
import org.jetbrains.kotlin.nj2k.inference.common.TypeParameterReference;
import org.jetbrains.kotlin.nj2k.inference.common.TypeVariable;
import org.jetbrains.kotlin.nj2k.inference.common.TypeVariableBound;
import org.jetbrains.kotlin.nj2k.inference.common.TypeVariableLabel;
import org.jetbrains.kotlin.nj2k.inference.common.WithForcedStateBoundType;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtTypeElement;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\n\u0010\f\u001a\u00020\r*\u00020\u000eJ\n\u0010\u000f\u001a\u00020\b*\u00020\u0010J\n\u0010\u000f\u001a\u00020\b*\u00020\u0011J\f\u0010\u000f\u001a\u00020\b*\u00020\u0012H\u0002J\n\u0010\u000f\u001a\u00020\b*\u00020\u0013J\f\u0010\u000f\u001a\u00020\b*\u00020\u0014H\u0002J\n\u0010\u000f\u001a\u00020\b*\u00020\u0015R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0007\u001a\u00020\b*\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/nj2k/inference/common/DebugPrinter;", "", "inferenceContext", "Lorg/jetbrains/kotlin/nj2k/inference/common/InferenceContext;", "(Lorg/jetbrains/kotlin/nj2k/inference/common/InferenceContext;)V", "namer", "Lorg/jetbrains/kotlin/nj2k/inference/common/Namer;", "name", "", "Lorg/jetbrains/kotlin/nj2k/inference/common/TypeVariable;", "getName", "(Lorg/jetbrains/kotlin/nj2k/inference/common/TypeVariable;)Ljava/lang/String;", "addTypeVariablesNames", "", "Lcom/intellij/psi/PsiElement;", "asString", "Lorg/jetbrains/kotlin/nj2k/inference/common/BoundType;", "Lorg/jetbrains/kotlin/nj2k/inference/common/BoundTypeLabel;", "Lorg/jetbrains/kotlin/nj2k/inference/common/ClassReference;", "Lorg/jetbrains/kotlin/nj2k/inference/common/Constraint;", "Lorg/jetbrains/kotlin/nj2k/inference/common/ConstraintBound;", "Lorg/jetbrains/kotlin/nj2k/inference/common/State;", "kotlin.j2k.services"})
public final class DebugPrinter {
    private final Namer namer;
    private final InferenceContext inferenceContext;

    @NotNull
    public final String getName(@NotNull TypeVariable $this$name) {
        Intrinsics.checkNotNullParameter((Object)$this$name, (String)"$this$name");
        return this.namer.name($this$name);
    }

    private final String asString(ClassReference $this$asString) {
        String string;
        ClassReference classReference2 = $this$asString;
        if (classReference2 instanceof DescriptorClassReference) {
            string = ((DescriptorClassReference)$this$asString).getDescriptor().getName().toString();
        } else if (classReference2 instanceof TypeParameterReference) {
            string = ((TypeParameterReference)$this$asString).getDescriptor().getName().toString();
        } else if (classReference2 instanceof NoClassReference) {
            string = "NoClassRef";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"when (this) {\n        is\u2026nce -> \"NoClassRef\"\n    }");
        return string;
    }

    @NotNull
    public final String asString(@NotNull BoundTypeLabel $this$asString) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$asString, (String)"$this$asString");
        BoundTypeLabel boundTypeLabel = $this$asString;
        if (boundTypeLabel instanceof TypeVariableLabel) {
            object = this.getName(((TypeVariableLabel)$this$asString).getTypeVariable()) + "@" + this.asString(((TypeVariableLabel)$this$asString).getTypeVariable().getClassReference());
        } else if (boundTypeLabel instanceof TypeParameterLabel) {
            String string = ((TypeParameterLabel)$this$asString).getTypeParameter().getName().asString();
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"typeParameter.name.asString()");
        } else if (boundTypeLabel instanceof GenericLabel) {
            object = this.asString(((GenericLabel)$this$asString).getClassReference());
        } else if (Intrinsics.areEqual((Object)boundTypeLabel, (Object)StarProjectionLabel.INSTANCE)) {
            object = "*";
        } else if (Intrinsics.areEqual((Object)boundTypeLabel, (Object)NullLiteralLabel.INSTANCE)) {
            object = "NULL";
        } else if (Intrinsics.areEqual((Object)boundTypeLabel, (Object)LiteralLabel.INSTANCE)) {
            object = "LIT";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return object;
    }

    @NotNull
    public final String asString(@NotNull State $this$asString) {
        String string;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$asString), (String)"$this$asString");
        switch (DebugPrinter$WhenMappings.$EnumSwitchMapping$0[$this$asString.ordinal()]) {
            case 1: {
                string = "L";
                break;
            }
            case 2: {
                string = "U";
                break;
            }
            case 3: {
                string = "?";
                break;
            }
            case 4: {
                string = "$";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    @NotNull
    public final String asString(@NotNull BoundType $this$asString) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$asString, (String)"$this$asString");
        StringBuilder $this$buildString = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$buildString.append(this.asString($this$asString.getLabel()));
        Collection collection = $this$asString.getTypeParameters();
        if (!collection.isEmpty()) {
            CollectionsKt.joinTo$default((Iterable)$this$asString.getTypeParameters(), (Appendable)$this$buildString, (CharSequence)", ", (CharSequence)"<", (CharSequence)">", (int)0, null, (Function1)((Function1)new Function1<TypeParameter, CharSequence>(this, $this$asString){
                final /* synthetic */ DebugPrinter this$0;
                final /* synthetic */ BoundType $this_asString$inlined;
                {
                    this.this$0 = debugPrinter;
                    this.$this_asString$inlined = boundType;
                    super(1);
                }

                @NotNull
                public final CharSequence invoke(@NotNull TypeParameter it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return this.this$0.asString(it.getBoundType());
                }
            }), (int)48, null);
        }
        if ($this$asString instanceof WithForcedStateBoundType) {
            $this$buildString.append("!!");
            $this$buildString.append(this.asString(((WithForcedStateBoundType)$this$asString).getForcedState()));
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @NotNull
    public final String asString(@NotNull Constraint $this$asString) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$asString, (String)"$this$asString");
        Constraint constraint = $this$asString;
        if (constraint instanceof EqualsConstraint) {
            string = this.asString(((EqualsConstraint)$this$asString).getLeft()) + " := " + this.asString(((EqualsConstraint)$this$asString).getRight());
        } else if (constraint instanceof SubtypeConstraint) {
            string = this.asString(((SubtypeConstraint)$this$asString).getSubtype()) + " <: " + this.asString(((SubtypeConstraint)$this$asString).getSupertype());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string + " due to '" + $this$asString.getPriority() + "'";
    }

    private final String asString(ConstraintBound $this$asString) {
        String string;
        ConstraintBound constraintBound = $this$asString;
        if (constraintBound instanceof LiteralBound) {
            string = ((LiteralBound)$this$asString).getState().toString();
        } else if (constraintBound instanceof TypeVariableBound) {
            string = this.getName(((TypeVariableBound)$this$asString).getTypeVariable());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public final void addTypeVariablesNames(@NotNull PsiElement $this$addTypeVariablesNames) {
        void $this$forEachDescendantOfType$iv$iv$iv$iv;
        void $this$collectDescendantsOfTypeTo$iv$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$addTypeVariablesNames, (String)"$this$addTypeVariablesNames");
        KtPsiFactory factory2 = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)$this$addTypeVariablesNames, (boolean)false, (int)2, null);
        PsiElement $this$collectDescendantsOfType_u24default$iv = $this$addTypeVariablesNames;
        Function1 predicate$iv = addTypeVariablesNames$$inlined$collectDescendantsOfType$1.INSTANCE;
        boolean $i$f$collectDescendantsOfType = false;
        PsiElement $this$collectDescendantsOfType$iv$iv = $this$collectDescendantsOfType_u24default$iv;
        boolean $i$f$collectDescendantsOfType2 = false;
        PsiElement psiElement2 = $this$collectDescendantsOfType$iv$iv;
        Collection to$iv$iv$iv = new ArrayList();
        boolean $i$f$collectDescendantsOfTypeTo = false;
        void var13_11 = $this$collectDescendantsOfTypeTo$iv$iv$iv;
        Function1 action$iv$iv$iv$iv = (Function1)new Function1<KtTypeElement, Unit>(predicate$iv, to$iv$iv$iv){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Collection $to;
            {
                this.$predicate = $predicate;
                this.$to = $to;
                super(1);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final void invoke(@NotNull PsiElement it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (((Boolean)this.$predicate.invoke((Object)it)).booleanValue()) {
                    this.$to.add(it);
                }
            }
        };
        boolean $i$f$forEachDescendantOfType = false;
        $this$forEachDescendantOfType$iv$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(action$iv$iv$iv$iv){
            final /* synthetic */ Function1 $action;
            {
                this.$action = $action;
            }

            public void visitElement(@NotNull PsiElement element3) {
                Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
                PsiElement it = element3;
                boolean bl = false;
                super.visitElement(element3);
                if (element3 instanceof KtTypeElement) {
                    this.$action.invoke((Object)element3);
                }
            }
        });
        for (KtTypeElement typeElement : (List)to$iv$iv$iv) {
            Object object = this.inferenceContext.getTypeElementToTypeVariable().get(typeElement);
            if (object == null || (object = this.getName((TypeVariable)object)) == null) continue;
            Object typeVariableName = object;
            PsiComment comment2 = factory2.createComment("/*" + (String)typeVariableName + "@*/");
            typeElement.getParent().addBefore((PsiElement)comment2, (PsiElement)typeElement);
        }
    }

    public DebugPrinter(@NotNull InferenceContext inferenceContext2) {
        Intrinsics.checkNotNullParameter((Object)inferenceContext2, (String)"inferenceContext");
        this.inferenceContext = inferenceContext2;
        this.namer = new Namer(this.inferenceContext);
    }
}

