/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.util;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptorWithTypeParameters;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilityUtils;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.idea.base.utils.fqname.FqNameUtilKt;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.UtilsKt;
import org.jetbrains.kotlin.idea.core.formatter.KotlinCodeStyleSettings;
import org.jetbrains.kotlin.idea.core.formatter.KotlinPackageEntryTable;
import org.jetbrains.kotlin.idea.formatter.CodeStyleUtilsKt;
import org.jetbrains.kotlin.idea.imports.ImportsUtils;
import org.jetbrains.kotlin.idea.project.AnalyzerServicesKt;
import org.jetbrains.kotlin.idea.project.TargetPlatformDetector;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacadeKt;
import org.jetbrains.kotlin.idea.util.ImportDescriptorResult;
import org.jetbrains.kotlin.idea.util.ImportInsertHelper;
import org.jetbrains.kotlin.idea.util.ImportInsertHelperImpl;
import org.jetbrains.kotlin.idea.util.ImportInsertHelperImpl$Importer$addImport$;
import org.jetbrains.kotlin.idea.util.ImportInsertHelperImpl$Importer$addStarImport$;
import org.jetbrains.kotlin.idea.util.ImportInsertHelperImpl$Importer$dropRedundantExplicitImports$;
import org.jetbrains.kotlin.idea.util.ImportPathComparator;
import org.jetbrains.kotlin.idea.util.ScopeUtils;
import org.jetbrains.kotlin.incremental.components.LookupLocation;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtImportList;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.ImportPath;
import org.jetbrains.kotlin.resolve.PlatformDependentAnalyzerServices;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.resolve.scopes.DescriptorKindFilter;
import org.jetbrains.kotlin.resolve.scopes.HierarchicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.resolve.scopes.MemberScopeKt;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;
import org.jetbrains.kotlin.scripting.definitions.ScriptDependenciesProvider;
import org.jetbrains.kotlin.scripting.resolve.ScriptCompilationConfigurationWrapper;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 %2\u00020\u0001:\u0002%&B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J \u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u000b0\nj\b\u0012\u0004\u0012\u00020\u000b`\f2\u0006\u0010\u0007\u001a\u00020\bH\u0016J2\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J \u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\bH\u0016J\f\u0010\u001f\u001a\u00020\u0014*\u00020\u0012H\u0002J\"\u0010 \u001a\u00020\u0014*\u00020\u00122\u0006\u0010!\u001a\u00020\u00172\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/idea/util/ImportInsertHelperImpl;", "Lorg/jetbrains/kotlin/idea/util/ImportInsertHelper;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getCodeStyleSettings", "Lorg/jetbrains/kotlin/idea/core/formatter/KotlinCodeStyleSettings;", "contextFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "getImportSortComparator", "Ljava/util/Comparator;", "Lorg/jetbrains/kotlin/resolve/ImportPath;", "Lkotlin/Comparator;", "importDescriptor", "Lorg/jetbrains/kotlin/idea/util/ImportDescriptorResult;", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "runImmediately", "", "forceAllUnderImport", "aliasName", "Lorg/jetbrains/kotlin/name/Name;", "importPsiClass", "psiClass", "Lcom/intellij/psi/PsiClass;", "isImportedWithDefault", "importPath", "isImportedWithLowPriorityDefaultImport", "mayImportOnShortenReferences", "comesFromLocalScopes", "explicitlyImported", "name", "imports", "", "Lorg/jetbrains/kotlin/psi/KtImportDirective;", "Companion", "Importer", "kotlin.idea"})
public final class ImportInsertHelperImpl
extends ImportInsertHelper {
    private final Project project;
    @NotNull
    public static final Companion Companion = new Companion(null);

    private final KotlinCodeStyleSettings getCodeStyleSettings(KtFile contextFile) {
        return CodeStyleUtilsKt.getKotlinCustomSettings((PsiFile)contextFile);
    }

    @NotNull
    public Comparator<ImportPath> getImportSortComparator(@NotNull KtFile contextFile) {
        Intrinsics.checkNotNullParameter((Object)contextFile, (String)"contextFile");
        KotlinPackageEntryTable kotlinPackageEntryTable = this.getCodeStyleSettings((KtFile)contextFile).PACKAGES_IMPORT_LAYOUT;
        Intrinsics.checkNotNullExpressionValue((Object)kotlinPackageEntryTable, (String)"getCodeStyleSettings(con\u2026e).PACKAGES_IMPORT_LAYOUT");
        return new ImportPathComparator(kotlinPackageEntryTable);
    }

    public boolean isImportedWithDefault(@NotNull ImportPath importPath, @NotNull KtFile contextFile) {
        Intrinsics.checkNotNullParameter((Object)importPath, (String)"importPath");
        Intrinsics.checkNotNullParameter((Object)contextFile, (String)"contextFile");
        return Companion.isInDefaultImports(importPath, contextFile);
    }

    public boolean isImportedWithLowPriorityDefaultImport(@NotNull ImportPath importPath, @NotNull KtFile contextFile) {
        Intrinsics.checkNotNullParameter((Object)importPath, (String)"importPath");
        Intrinsics.checkNotNullParameter((Object)contextFile, (String)"contextFile");
        TargetPlatform targetPlatform = TargetPlatformDetector.getPlatform(contextFile);
        Intrinsics.checkNotNullExpressionValue((Object)targetPlatform, (String)"TargetPlatformDetector.getPlatform(contextFile)");
        TargetPlatform platform2 = targetPlatform;
        Project project2 = contextFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"contextFile.project");
        PlatformDependentAnalyzerServices analyzerServices = AnalyzerServicesKt.findAnalyzerServices(platform2, project2);
        return FqNameUtilKt.isImported(importPath, analyzerServices.getDefaultLowPriorityImports(), analyzerServices.getExcludedImports());
    }

    public boolean mayImportOnShortenReferences(@NotNull DeclarationDescriptor descriptor2, @NotNull KtFile contextFile) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)contextFile, (String)"contextFile");
        DeclarationDescriptor declarationDescriptor = DescriptorUtilsKt.getImportableDescriptor((DeclarationDescriptor)descriptor2);
        return declarationDescriptor instanceof PackageViewDescriptor ? false : (declarationDescriptor instanceof ClassDescriptor ? DescriptorUtilsKt.getImportableDescriptor((DeclarationDescriptor)descriptor2).getContainingDeclaration() instanceof PackageFragmentDescriptor || this.getCodeStyleSettings((KtFile)contextFile).IMPORT_NESTED_CLASSES : DescriptorUtilsKt.getImportableDescriptor((DeclarationDescriptor)descriptor2).getContainingDeclaration() instanceof PackageFragmentDescriptor);
    }

    @NotNull
    public ImportDescriptorResult importDescriptor(@NotNull KtElement element3, @NotNull DeclarationDescriptor descriptor2, boolean runImmediately, boolean forceAllUnderImport, @Nullable Name aliasName) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Importer importer = new Importer(element3, runImmediately);
        return forceAllUnderImport ? importer.importDescriptorWithStarImport(descriptor2) : importer.importDescriptor(descriptor2, aliasName);
    }

    @NotNull
    public ImportDescriptorResult importPsiClass(@NotNull KtElement element3, @NotNull PsiClass psiClass2, boolean runImmediately) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter((Object)psiClass2, (String)"psiClass");
        return new Importer(element3, runImmediately).importPsiClass(psiClass2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean explicitlyImported(DeclarationDescriptor $this$explicitlyImported, Name name2, List<? extends KtImportDirective> imports2) {
        boolean bl;
        Iterable $this$any$iv = imports2;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            KtImportDirective it = (KtImportDirective)element$iv;
            boolean bl2 = false;
            if (!it.isAllUnder()) {
                ImportPath importPath = it.getImportPath();
                if (Intrinsics.areEqual((Object)(importPath != null ? importPath.getFqName() : null), (Object)ImportsUtils.getImportableFqName($this$explicitlyImported))) {
                    ImportPath importPath2 = it.getImportPath();
                    if (Intrinsics.areEqual((Object)(importPath2 != null ? importPath2.getImportedName() : null), (Object)name2)) {
                        return true;
                    }
                }
            }
            bl = false;
        } while (!bl);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean comesFromLocalScopes(DeclarationDescriptor $this$comesFromLocalScopes) {
        if (DescriptorUtils.isLocal((DeclarationDescriptor)$this$comesFromLocalScopes)) return true;
        DeclarationDescriptor $this$safeAs$iv = $this$comesFromLocalScopes;
        boolean $i$f$safeAs = false;
        DeclarationDescriptor declarationDescriptor = $this$safeAs$iv;
        if (!(declarationDescriptor instanceof ClassifierDescriptor)) {
            declarationDescriptor = null;
        }
        ClassifierDescriptor classifierDescriptor = (ClassifierDescriptor)declarationDescriptor;
        ClassifierDescriptor classifierDescriptor2 = classifierDescriptor;
        if (classifierDescriptor == null) return false;
        ClassId classId = DescriptorUtilsKt.getClassId((ClassifierDescriptor)classifierDescriptor2);
        classifierDescriptor2 = classId;
        if (classId == null) return false;
        if (!classifierDescriptor2.isNestedClass()) return false;
        return true;
    }

    public ImportInsertHelperImpl(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
    }

    public static final /* synthetic */ boolean access$explicitlyImported(ImportInsertHelperImpl $this, DeclarationDescriptor $this$access_u24explicitlyImported, Name name2, List imports2) {
        return $this.explicitlyImported($this$access_u24explicitlyImported, name2, imports2);
    }

    public static final /* synthetic */ boolean access$comesFromLocalScopes(ImportInsertHelperImpl $this, DeclarationDescriptor $this$access_u24comesFromLocalScopes) {
        return $this.comesFromLocalScopes($this$access_u24comesFromLocalScopes);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J$\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00052\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u0010\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u0010H\u0002J,\u0010\u001a\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00162\b\b\u0002\u0010\u001e\u001a\u00020\u0012H\u0002J\u0018\u0010\u001f\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001c\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020#0%H\u0002J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0016H\u0002J\u001a\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010+\u001a\u00020,H\u0002J\u0018\u0010-\u001a\u00020\u000e2\u0006\u0010.\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012J\u000e\u0010/\u001a\u00020\u000e2\u0006\u0010.\u001a\u00020\u0010J\u000e\u00100\u001a\u00020\u000e2\u0006\u00101\u001a\u000202J&\u00103\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u00102\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u00140%H\u0002J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u00162\u0006\u00105\u001a\u000206H\u0002J\"\u00107\u001a\b\u0012\u0004\u0012\u00020#0\"*\u0002082\u0006\u00109\u001a\u00020\u00122\u0006\u0010:\u001a\u00020;H\u0002J\u0012\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00100%*\u000206H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lorg/jetbrains/kotlin/idea/util/ImportInsertHelperImpl$Importer;", "", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "runImmediately", "", "(Lorg/jetbrains/kotlin/idea/util/ImportInsertHelperImpl;Lorg/jetbrains/kotlin/psi/KtElement;Z)V", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "resolutionFacade", "Lorg/jetbrains/kotlin/idea/resolve/ResolutionFacade;", "addExplicitImport", "Lorg/jetbrains/kotlin/idea/util/ImportDescriptorResult;", "target", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "aliasName", "Lorg/jetbrains/kotlin/name/Name;", "addImport", "Lorg/jetbrains/kotlin/psi/KtImportDirective;", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "allUnder", "addStarImport", "targetDescriptor", "alreadyImported", "scope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "targetFqName", "targetName", "canImportWithStar", "containerFqName", "detectNeededImports", "", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "importedClasses", "", "dropRedundantExplicitImports", "", "packageFqName", "getMemberScope", "Lorg/jetbrains/kotlin/resolve/scopes/MemberScope;", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "importDescriptor", "descriptor", "importDescriptorWithStarImport", "importPsiClass", "psiClass", "Lcom/intellij/psi/PsiClass;", "shouldTryStarImport", "imports", "ref", "Lorg/jetbrains/kotlin/psi/KtReferenceExpression;", "findClassifiers", "Lorg/jetbrains/kotlin/resolve/scopes/HierarchicalScope;", "name", "location", "Lorg/jetbrains/kotlin/incremental/components/LookupLocation;", "resolveTargets", "kotlin.idea"})
    private final class Importer {
        private final KtFile file;
        private final ResolutionFacade resolutionFacade;
        private final LanguageVersionSettings languageVersionSettings;
        private final KtElement element;
        private final boolean runImmediately;

        private final ImportDescriptorResult alreadyImported(DeclarationDescriptor target2, LexicalScope scope2, FqName targetFqName, Name targetName2) {
            Object object;
            DeclarationDescriptor declarationDescriptor = target2;
            if (declarationDescriptor instanceof ClassifierDescriptorWithTypeParameters) {
                ImportDescriptorResult importDescriptorResult;
                Iterator $this$filterTo$iv$iv;
                ClassifierDescriptor it;
                Object element$iv2;
                boolean bl;
                boolean $i$f$all;
                Iterable $this$all$iv;
                Set<ClassifierDescriptor> classifiers2;
                block21: {
                    Set<ClassifierDescriptor> set2;
                    Set<ClassifierDescriptor> it2 = set2 = this.findClassifiers((HierarchicalScope)scope2, targetName2, (LookupLocation)NoLookupLocation.FROM_IDE);
                    boolean bl2 = false;
                    Collection collection = it2;
                    Set<Object> set3 = !collection.isEmpty() ? set2 : null;
                    if (set3 == null) {
                        return null;
                    }
                    classifiers2 = set3;
                    $this$all$iv = classifiers2;
                    $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv2 : $this$all$iv) {
                            it = (ClassifierDescriptor)element$iv2;
                            boolean bl3 = false;
                            if (it instanceof TypeAliasDescriptor) continue;
                            bl = false;
                            break block21;
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    boolean bl4;
                    block22: {
                        $this$all$iv = classifiers2;
                        $i$f$all = false;
                        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                            bl4 = true;
                        } else {
                            for (Object element$iv2 : $this$all$iv) {
                                it = (ClassifierDescriptor)element$iv2;
                                boolean bl5 = false;
                                if (Intrinsics.areEqual((Object)ImportsUtils.getImportableFqName((DeclarationDescriptor)it), (Object)targetFqName)) continue;
                                bl4 = false;
                                break block22;
                            }
                            bl4 = true;
                        }
                    }
                    return bl4 ? ImportDescriptorResult.ALREADY_IMPORTED : (classifiers2.size() == 1 ? null : ImportDescriptorResult.FAIL);
                }
                Iterable $this$filter$iv = classifiers2;
                boolean $i$f$filter = false;
                element$iv2 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                Iterator iterator = $this$filterTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    Object element$iv$iv = iterator.next();
                    ClassifierDescriptor it3 = (ClassifierDescriptor)element$iv$iv;
                    boolean bl6 = false;
                    if (!(!(it3 instanceof TypeAliasDescriptor) || Intrinsics.areEqual((Object)ImportsUtils.getImportableFqName((DeclarationDescriptor)it3), (Object)targetFqName))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List nonAliasClassifiers = (List)destination$iv$iv;
                if (nonAliasClassifiers.size() > 1) {
                    boolean bl7;
                    block23: {
                        Iterable $this$all$iv2 = nonAliasClassifiers;
                        boolean $i$f$all2 = false;
                        if ($this$all$iv2 instanceof Collection && ((Collection)$this$all$iv2).isEmpty()) {
                            bl7 = true;
                        } else {
                            for (Object element$iv3 : $this$all$iv2) {
                                ClassifierDescriptor it4 = (ClassifierDescriptor)element$iv3;
                                boolean bl8 = false;
                                if (it4.getContainingDeclaration() instanceof PackageFragmentDescriptor) continue;
                                bl7 = false;
                                break block23;
                            }
                            bl7 = true;
                        }
                    }
                    if (bl7) {
                        return null;
                    }
                }
                ClassifierDescriptor classifierDescriptor = (ClassifierDescriptor)CollectionsKt.singleOrNull((List)nonAliasClassifiers);
                if (classifierDescriptor == null) {
                    return ImportDescriptorResult.FAIL;
                }
                ClassifierDescriptor classifier2 = classifierDescriptor;
                ImportDescriptorResult it5 = importDescriptorResult = ImportDescriptorResult.ALREADY_IMPORTED;
                boolean bl9 = false;
                object = Intrinsics.areEqual((Object)ImportsUtils.getImportableFqName((DeclarationDescriptor)classifier2), (Object)targetFqName) ? importDescriptorResult : null;
            } else if (declarationDescriptor instanceof FunctionDescriptor) {
                ImportDescriptorResult importDescriptorResult;
                ImportDescriptorResult it = importDescriptorResult = ImportDescriptorResult.ALREADY_IMPORTED;
                boolean bl = false;
                object = ScopeUtilsKt.findFunction((HierarchicalScope)((HierarchicalScope)scope2), (Name)targetName2, (LookupLocation)((LookupLocation)NoLookupLocation.FROM_IDE), (Function1)((Function1)new Function1<FunctionDescriptor, Boolean>(scope2, targetName2, targetFqName){
                    final /* synthetic */ LexicalScope $scope$inlined;
                    final /* synthetic */ Name $targetName$inlined;
                    final /* synthetic */ FqName $targetFqName$inlined;
                    {
                        this.$scope$inlined = lexicalScope;
                        this.$targetName$inlined = name2;
                        this.$targetFqName$inlined = fqName2;
                        super(1);
                    }

                    public final boolean invoke(@NotNull FunctionDescriptor it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return Intrinsics.areEqual((Object)ImportsUtils.getImportableFqName((DeclarationDescriptor)it), (Object)this.$targetFqName$inlined);
                    }
                })) != null ? importDescriptorResult : null;
            } else if (declarationDescriptor instanceof PropertyDescriptor) {
                ImportDescriptorResult importDescriptorResult;
                ImportDescriptorResult it = importDescriptorResult = ImportDescriptorResult.ALREADY_IMPORTED;
                boolean bl = false;
                object = ScopeUtilsKt.findVariable((HierarchicalScope)((HierarchicalScope)scope2), (Name)targetName2, (LookupLocation)((LookupLocation)NoLookupLocation.FROM_IDE), (Function1)((Function1)new Function1<VariableDescriptor, Boolean>(scope2, targetName2, targetFqName){
                    final /* synthetic */ LexicalScope $scope$inlined;
                    final /* synthetic */ Name $targetName$inlined;
                    final /* synthetic */ FqName $targetFqName$inlined;
                    {
                        this.$scope$inlined = lexicalScope;
                        this.$targetName$inlined = name2;
                        this.$targetFqName$inlined = fqName2;
                        super(1);
                    }

                    public final boolean invoke(@NotNull VariableDescriptor it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return Intrinsics.areEqual((Object)ImportsUtils.getImportableFqName((DeclarationDescriptor)it), (Object)this.$targetFqName$inlined);
                    }
                })) != null ? importDescriptorResult : null;
            } else {
                object = null;
            }
            return object;
        }

        static /* synthetic */ ImportDescriptorResult alreadyImported$default(Importer importer, DeclarationDescriptor declarationDescriptor, LexicalScope lexicalScope, FqName fqName2, Name name2, int n, Object object) {
            if ((n & 8) != 0) {
                Name name3 = declarationDescriptor.getName();
                Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"target.name");
                name2 = name3;
            }
            return importer.alreadyImported(declarationDescriptor, lexicalScope, fqName2, name2);
        }

        private final Set<ClassifierDescriptor> findClassifiers(HierarchicalScope $this$findClassifiers, Name name2, LookupLocation location2) {
            Set result2 = new LinkedHashSet();
            HierarchicalScope $this$processForMeAndParent$iv = $this$findClassifiers;
            boolean $i$f$processForMeAndParent = false;
            HierarchicalScope currentScope$iv = $this$processForMeAndParent$iv;
            while (true) {
                HierarchicalScope it = currentScope$iv;
                boolean bl = false;
                if (it.getContributedClassifier(name2, location2) != null) {
                    ClassifierDescriptor classifierDescriptor;
                    Set set2 = result2;
                    ClassifierDescriptor p1 = classifierDescriptor;
                    boolean bl2 = false;
                    set2.add(p1);
                }
                if (currentScope$iv.getParent() == null) break;
            }
            return result2;
        }

        /*
         * Unable to fully structure code
         */
        @NotNull
        public final ImportDescriptorResult importPsiClass(@NotNull PsiClass psiClass) {
            block5: {
                block6: {
                    Intrinsics.checkNotNullParameter((Object)psiClass, (String)"psiClass");
                    v0 = psiClass.getQualifiedName();
                    Intrinsics.checkNotNull((Object)v0);
                    Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"psiClass.qualifiedName!!");
                    qualifiedName = v0;
                    targetFqName = new FqName(qualifiedName);
                    v1 = psiClass.getName();
                    Intrinsics.checkNotNull((Object)v1);
                    v2 = Name.identifier((String)v1);
                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"Name.identifier(psiClass.name!!)");
                    name = v2;
                    scope = Intrinsics.areEqual((Object)this.element, (Object)this.file) != false ? ScopeUtils.getFileResolutionScope(this.resolutionFacade, this.file) : ScopeUtils.getResolutionScope(this.element);
                    v3 = ScopeUtilsKt.findClassifier((HierarchicalScope)((HierarchicalScope)scope), (Name)name, (LookupLocation)((LookupLocation)NoLookupLocation.FROM_IDE));
                    if (v3 != null) {
                        it = var6_6 = v3;
                        $i$a$-let-ImportInsertHelperImpl$Importer$importPsiClass$1 = false;
                        return Intrinsics.areEqual((Object)DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)((DeclarationDescriptor)it)), (Object)targetFqName) != false ? ImportDescriptorResult.ALREADY_IMPORTED : ImportDescriptorResult.FAIL;
                    }
                    imports = this.file.getImportDirectives();
                    $this$any$iv = imports;
                    $i$f$any = false;
                    if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) break block6;
                    v4 = false;
                    break block5;
                }
                for (T element$iv : $this$any$iv) {
                    it = (KtImportDirective)element$iv;
                    $i$a$-any-ImportInsertHelperImpl$Importer$importPsiClass$2 = false;
                    if (it.isAllUnder()) ** GOTO lbl-1000
                    v5 = it.getImportPath();
                    if (Intrinsics.areEqual((Object)(v5 != null ? v5.getAlias() : null), (Object)name)) ** GOTO lbl-1000
                    v6 = it.getImportPath();
                    if (Intrinsics.areEqual((Object)(v6 != null ? v6.getFqName() : null), (Object)targetFqName)) lbl-1000:
                    // 2 sources

                    {
                        v7 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v7 = false;
                    }
                    if (!v7) continue;
                    v4 = true;
                    break block5;
                }
                v4 = false;
            }
            if (v4) {
                return ImportDescriptorResult.FAIL;
            }
            Importer.addImport$default(this, targetFqName, false, null, 4, null);
            return ImportDescriptorResult.IMPORT_ADDED;
        }

        /*
         * Unable to fully structure code
         */
        @NotNull
        public final ImportDescriptorResult importDescriptor(@NotNull DeclarationDescriptor descriptor, @Nullable Name aliasName) {
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            target = DescriptorUtilsKt.getImportableDescriptor((DeclarationDescriptor)descriptor);
            v0 = aliasName;
            if (v0 == null) {
                v1 = target.getName();
                v0 = v1;
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"target.name");
            }
            name = v0;
            topLevelScope = ScopeUtils.getFileResolutionScope(this.resolutionFacade, this.file);
            v2 = ImportsUtils.getImportableFqName(target);
            if (v2 == null) {
                return ImportDescriptorResult.FAIL;
            }
            targetFqName = v2;
            scope = Intrinsics.areEqual((Object)this.element, (Object)this.file) != false ? topLevelScope : ScopeUtils.getResolutionScope(this.element);
            v3 = this.alreadyImported(target, scope, targetFqName, name);
            if (v3 != null) {
                it = var8_8 = v3;
                $i$a$-let-ImportInsertHelperImpl$Importer$importDescriptor$1 = false;
                return it;
            }
            imports = this.file.getImportDirectives();
            for (DeclarationDescriptor import : imports) {
                if (import.getImportPath() == null) continue;
                Intrinsics.checkNotNullExpressionValue((Object)importPath, (String)"import.importPath ?: continue");
                if (importPath.isAllUnder() || !Intrinsics.areEqual((Object)importPath.getAlias(), (Object)aliasName) || !Intrinsics.areEqual((Object)importPath.getFqName(), (Object)targetFqName)) continue;
                return ImportDescriptorResult.FAIL;
            }
            import = target;
            v4 = import instanceof ClassDescriptor != false ? (DeclarationDescriptor)ScopeUtilsKt.findClassifier((HierarchicalScope)((HierarchicalScope)scope), (Name)name, (LookupLocation)((LookupLocation)NoLookupLocation.FROM_IDE)) : (import instanceof PackageViewDescriptor != false ? (DeclarationDescriptor)ScopeUtilsKt.findPackage((HierarchicalScope)((HierarchicalScope)scope), (Name)name) : null);
            if (v4 != null) {
                conflict = import = v4;
                $i$a$-let-ImportInsertHelperImpl$Importer$importDescriptor$2 = false;
                if (ImportInsertHelperImpl.access$explicitlyImported(ImportInsertHelperImpl.this, conflict, name, imports) || ImportInsertHelperImpl.access$comesFromLocalScopes(ImportInsertHelperImpl.this, conflict)) {
                    return ImportDescriptorResult.FAIL;
                }
            }
            v5 = targetFqName.parent();
            Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"targetFqName.parent()");
            containerFqName = v5;
            if (aliasName != null || !this.shouldTryStarImport(containerFqName, target, imports)) ** GOTO lbl-1000
            $i$a$-let-ImportInsertHelperImpl$Importer$importDescriptor$2 = target;
            if ($i$a$-let-ImportInsertHelperImpl$Importer$importDescriptor$2 instanceof ClassifierDescriptorWithTypeParameters) {
                v6 = ScopeUtilsKt.findClassifier((HierarchicalScope)((HierarchicalScope)topLevelScope), (Name)name, (LookupLocation)((LookupLocation)NoLookupLocation.FROM_IDE)) == null;
            } else if ($i$a$-let-ImportInsertHelperImpl$Importer$importDescriptor$2 instanceof FunctionDescriptor || $i$a$-let-ImportInsertHelperImpl$Importer$importDescriptor$2 instanceof PropertyDescriptor) {
                v6 = true;
            } else {
                var12_19 = "Unknown kind of descriptor to import:" + target;
                throw new IllegalStateException(var12_19.toString());
            }
            if (v6) {
                v7 = true;
            } else lbl-1000:
            // 2 sources

            {
                v7 = tryStarImport = false;
            }
            if (tryStarImport && (result = this.addStarImport(target)) != ImportDescriptorResult.FAIL) {
                return result;
            }
            return this.addExplicitImport(target, aliasName);
        }

        @NotNull
        public final ImportDescriptorResult importDescriptorWithStarImport(@NotNull DeclarationDescriptor descriptor2) {
            boolean bl;
            FqName containerFqName2;
            FqName fqName2;
            DeclarationDescriptor target2;
            block7: {
                Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
                target2 = DescriptorUtilsKt.getImportableDescriptor((DeclarationDescriptor)descriptor2);
                FqName fqName3 = ImportsUtils.getImportableFqName(target2);
                if (fqName3 == null) {
                    return ImportDescriptorResult.FAIL;
                }
                fqName2 = fqName3;
                FqName fqName4 = fqName2.parent();
                Intrinsics.checkNotNullExpressionValue((Object)fqName4, (String)"fqName.parent()");
                containerFqName2 = fqName4;
                List imports2 = this.file.getImportDirectives();
                ImportPath starImportPath = new ImportPath(containerFqName2, true, null, 4, null);
                Iterable $this$any$iv = imports2;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        KtImportDirective it = (KtImportDirective)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getImportPath(), (Object)starImportPath)) continue;
                        bl = true;
                        break block7;
                    }
                    bl = false;
                }
            }
            if (bl) {
                ImportDescriptorResult importDescriptorResult = Importer.alreadyImported$default(this, target2, ScopeUtils.getFileResolutionScope(this.resolutionFacade, this.file), fqName2, null, 8, null);
                if (importDescriptorResult == null) {
                    importDescriptorResult = ImportDescriptorResult.FAIL;
                }
                return importDescriptorResult;
            }
            if (!this.canImportWithStar(containerFqName2, target2)) {
                return ImportDescriptorResult.FAIL;
            }
            return this.addStarImport(target2);
        }

        private final boolean shouldTryStarImport(FqName containerFqName2, DeclarationDescriptor target2, Collection<? extends KtImportDirective> imports2) {
            int n;
            boolean bl;
            block9: {
                if (!this.canImportWithStar(containerFqName2, target2)) {
                    return false;
                }
                ImportPath starImportPath = new ImportPath(containerFqName2, true, null, 4, null);
                Iterable $this$any$iv = imports2;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        KtImportDirective it = (KtImportDirective)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getImportPath(), (Object)starImportPath)) continue;
                        bl = true;
                        break block9;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return false;
            }
            KotlinCodeStyleSettings codeStyle = ImportInsertHelperImpl.this.getCodeStyleSettings(this.file);
            KotlinPackageEntryTable kotlinPackageEntryTable = codeStyle.PACKAGES_TO_USE_STAR_IMPORTS;
            String string = containerFqName2.asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"containerFqName.asString()");
            if (kotlinPackageEntryTable.contains(string)) {
                return true;
            }
            Iterable $this$count$iv = imports2;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    int n2;
                    KtImportDirective it = (KtImportDirective)element$iv;
                    boolean bl3 = false;
                    ImportPath path2 = it.getImportPath();
                    if (!(path2 != null && !path2.isAllUnder() && !path2.hasAlias() && Intrinsics.areEqual((Object)path2.getFqName().parent(), (Object)containerFqName2)) || (n2 = ++count$iv) >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
            int importsFromPackage = n;
            int nameCountToUseStar = target2.getContainingDeclaration() instanceof ClassDescriptor ? codeStyle.NAME_COUNT_TO_USE_STAR_IMPORT_FOR_MEMBERS : codeStyle.NAME_COUNT_TO_USE_STAR_IMPORT;
            return importsFromPackage + 1 >= nameCountToUseStar;
        }

        private final boolean canImportWithStar(FqName containerFqName2, DeclarationDescriptor target2) {
            if (containerFqName2.isRoot()) {
                return false;
            }
            DeclarationDescriptor container = target2.getContainingDeclaration();
            return !(container instanceof ClassDescriptor) || ((ClassDescriptor)container).getKind() != ClassKind.OBJECT;
        }

        /*
         * WARNING - void declaration
         */
        private final ImportDescriptorResult addStarImport(DeclarationDescriptor targetDescriptor) {
            void $this$filterTo$iv$iv;
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            void result$iv;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            DeclarationDescriptor p1;
            void $this$filterTo$iv$iv2;
            FqName fqName2 = ImportsUtils.getImportableFqName(targetDescriptor);
            Intrinsics.checkNotNull((Object)fqName2);
            FqName targetFqName = fqName2;
            FqName fqName3 = targetFqName.parent();
            Intrinsics.checkNotNullExpressionValue((Object)fqName3, (String)"targetFqName.parent()");
            FqName parentFqName = fqName3;
            ModuleDescriptor moduleDescriptor = this.resolutionFacade.getModuleDescriptor();
            MemberScope memberScope2 = this.getMemberScope(parentFqName, moduleDescriptor);
            if (memberScope2 == null) {
                return ImportDescriptorResult.FAIL;
            }
            MemberScope scopeToImport = memberScope2;
            PackageViewDescriptor filePackage = moduleDescriptor.getPackage(this.file.getPackageFqName());
            var $fun$isVisible$1 = new Function1<DeclarationDescriptor, Boolean>(this, filePackage){
                final /* synthetic */ Importer this$0;
                final /* synthetic */ PackageViewDescriptor $filePackage;

                public final boolean invoke(@NotNull DeclarationDescriptor descriptor2) {
                    Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
                    if (!(descriptor2 instanceof DeclarationDescriptorWithVisibility)) {
                        return true;
                    }
                    DescriptorVisibility descriptorVisibility = ((DeclarationDescriptorWithVisibility)descriptor2).getVisibility();
                    Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"descriptor.visibility");
                    DescriptorVisibility visibility2 = descriptorVisibility;
                    return !visibility2.mustCheckInImports() || DescriptorVisibilityUtils.isVisibleIgnoringReceiver((DeclarationDescriptorWithVisibility)((DeclarationDescriptorWithVisibility)descriptor2), (DeclarationDescriptor)((DeclarationDescriptor)this.$filePackage), (LanguageVersionSettings)Importer.access$getLanguageVersionSettings$p(this.this$0));
                }
                {
                    this.this$0 = importer;
                    this.$filePackage = packageViewDescriptor;
                    super(1);
                }
            };
            DescriptorKindFilter kindFilter = DescriptorKindFilter.ALL.withoutKinds(DescriptorKindFilter.Companion.getPACKAGES_MASK());
            Iterable $this$filter$iv = MemberScopeKt.getDescriptorsFiltered$default((MemberScope)scopeToImport, (DescriptorKindFilter)kindFilter, null, (int)2, null);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                p1 = (DeclarationDescriptor)element$iv$iv;
                boolean bl = false;
                if (!$fun$isVisible$1.invoke(p1)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv2 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                p1 = (DeclarationDescriptor)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Name name2 = it.getName();
                collection.add(name2);
            }
            Set allNamesToImport = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            var $fun$targetFqNameAndType$2 = new Function1<KtReferenceExpression, Pair<? extends FqName, ? extends Class<? extends Object>>>(this, $fun$isVisible$1){
                final /* synthetic */ Importer this$0;
                final /* synthetic */ addStarImport.1 $isVisible$1;

                /*
                 * WARNING - void declaration
                 */
                @Nullable
                public final Pair<FqName, Class<? extends Object>> invoke(@NotNull KtReferenceExpression ref2) {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    DeclarationDescriptor p1;
                    void $this$filterTo$iv$iv;
                    Intrinsics.checkNotNullParameter((Object)ref2, (String)"ref");
                    Collection descriptors2 = Importer.access$resolveTargets(this.this$0, ref2);
                    Iterable $this$filter$iv = descriptors2;
                    boolean $i$f$filter = false;
                    Iterable iterable = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        p1 = (DeclarationDescriptor)element$iv$iv;
                        boolean bl = false;
                        if (!this.$isVisible$1.invoke(p1)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$filter$iv = (List)destination$iv$iv;
                    boolean $i$f$map = false;
                    $this$filterTo$iv$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        p1 = (DeclarationDescriptor)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        FqName fqName2 = ImportsUtils.getImportableFqName((DeclarationDescriptor)it);
                        collection.add(fqName2);
                    }
                    FqName fqName3 = (FqName)CollectionsKt.singleOrNull((Iterable)CollectionsKt.toSet((Iterable)((List)destination$iv$iv)));
                    return fqName3 != null ? new Pair((Object)fqName3, ((DeclarationDescriptor)CollectionsKt.elementAt((Iterable)descriptors2, (int)0)).getClass()) : null;
                }
                {
                    this.this$0 = importer;
                    this.$isVisible$1 = var2_2;
                    super(1);
                }
            };
            HashMap futureCheckMap = new HashMap();
            this.file.accept((PsiElementVisitor)new KtVisitorVoid(allNamesToImport, $fun$targetFqNameAndType$2, futureCheckMap){
                final /* synthetic */ Set $allNamesToImport;
                final /* synthetic */ addStarImport.2 $targetFqNameAndType$2;
                final /* synthetic */ HashMap $futureCheckMap;

                public void visitElement(@NotNull PsiElement element3) {
                    Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
                    element3.acceptChildren((PsiElementVisitor)this);
                }

                public void visitImportList(@NotNull KtImportList importList) {
                    Intrinsics.checkNotNullParameter((Object)importList, (String)"importList");
                }

                public void visitPackageDirective(@NotNull KtPackageDirective directive) {
                    Intrinsics.checkNotNullParameter((Object)directive, (String)"directive");
                }

                public void visitSimpleNameExpression(@NotNull KtSimpleNameExpression expression2) {
                    Pair<FqName, Class<? extends Object>> target2;
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    Name refName = expression2.getReferencedNameAsName();
                    if (this.$allNamesToImport.contains(refName) && (target2 = this.$targetFqNameAndType$2.invoke((KtReferenceExpression)expression2)) != null) {
                        Map map2 = this.$futureCheckMap;
                        Pair pair = new Pair((Object)expression2, target2);
                        map2.put(pair.getFirst(), pair.getSecond());
                    }
                }
                {
                    this.$allNamesToImport = $captured_local_variable$0;
                    this.$targetFqNameAndType$2 = $captured_local_variable$1;
                    this.$futureCheckMap = $captured_local_variable$2;
                }
            });
            KtImportDirective addedImport = Importer.addImport$default(this, parentFqName, true, null, 4, null);
            if (Importer.alreadyImported$default(this, targetDescriptor, ScopeUtils.getFileResolutionScope(this.resolutionFacade, this.file), targetFqName, null, 8, null) == null) {
                Object object;
                boolean runImmediately$iv = this.runImmediately;
                boolean $i$f$runAction = false;
                if (runImmediately$iv) {
                    boolean bl = false;
                    addedImport.delete();
                    object = Unit.INSTANCE;
                } else {
                    Object item$iv$iv;
                    item$iv$iv = new Ref.ObjectRef();
                    ((Ref.ObjectRef)item$iv$iv).element = null;
                    ApplicationManager.getApplication().invokeAndWait(new Runnable((Ref.ObjectRef)result$iv, addedImport){
                        final /* synthetic */ Ref.ObjectRef $result;
                        final /* synthetic */ KtImportDirective $addedImport$inlined;
                        {
                            this.$result = objectRef;
                            this.$addedImport$inlined = ktImportDirective;
                        }

                        public final void run() {
                            CommandProcessor.getInstance().runUndoTransparentAction(new Runnable(this){
                                final /* synthetic */ Importer$addStarImport$$inlined$runAction$1 this$0;
                                {
                                    this.this$0 = var1_1;
                                }

                                public final void run() {
                                    this.this$0.$result.element = ApplicationManager.getApplication().runWriteAction(new Computable(this){
                                        final /* synthetic */ Importer$addStarImport$$inlined$runAction$1$1 this$0;
                                        {
                                            this.this$0 = var1_1;
                                        }

                                        public final T compute() {
                                            boolean bl = false;
                                            this.this$0.this$0.$addedImport$inlined.delete();
                                            return (T)Unit.INSTANCE;
                                        }
                                    });
                                }
                            });
                        }
                    });
                    Object object2 = result$iv.element;
                    object = object2;
                    Intrinsics.checkNotNull((Object)object2);
                }
                return ImportDescriptorResult.FAIL;
            }
            this.dropRedundantExplicitImports(parentFqName);
            Map $i$f$runAction = futureCheckMap;
            boolean $i$f$mapNotNull = false;
            result$iv = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            Iterable $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                FqName fqName4;
                void expr;
                Map.Entry element$iv$iv$iv;
                Map.Entry element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                Map.Entry $dstr$expr$fqNameAndType = element$iv$iv;
                boolean bl2 = false;
                Map.Entry entry = $dstr$expr$fqNameAndType;
                KtSimpleNameExpression ktSimpleNameExpression = (KtSimpleNameExpression)entry.getKey();
                entry = $dstr$expr$fqNameAndType;
                Pair fqNameAndType = (Pair)entry.getValue();
                FqName fqName5 = Intrinsics.areEqual($fun$targetFqNameAndType$2.invoke((KtReferenceExpression)expr), (Object)fqNameAndType) ^ true ? (FqName)fqNameAndType.getFirst() : null;
                if (fqName5 == null) continue;
                FqName it$iv$iv = fqName4 = fqName5;
                boolean bl3 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            Set conflicts2 = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
            var $fun$isNotImported$5 = new Function1<FqName, Boolean>(this){
                final /* synthetic */ Importer this$0;

                public final boolean invoke(@NotNull FqName fqName2) {
                    boolean bl;
                    block3: {
                        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
                        Iterable $this$none$iv = Importer.access$getFile$p(this.this$0).getImportDirectives();
                        boolean $i$f$none = false;
                        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                            bl = true;
                        } else {
                            for (T element$iv : $this$none$iv) {
                                KtImportDirective directive = (KtImportDirective)element$iv;
                                boolean bl2 = false;
                                if (!(!directive.isAllUnder() && directive.getAlias() == null && Intrinsics.areEqual((Object)directive.getImportedFqName(), (Object)fqName2))) continue;
                                bl = false;
                                break block3;
                            }
                            bl = true;
                        }
                    }
                    return bl;
                }
                {
                    this.this$0 = importer;
                    super(1);
                }
            };
            Iterable $this$filter$iv2 = conflicts2;
            boolean $i$f$filter2 = false;
            $this$forEach$iv$iv$iv = $this$filter$iv2;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Map.Entry element$iv$iv : $this$filterTo$iv$iv) {
                FqName p12 = (FqName)element$iv$iv;
                boolean bl = false;
                if (!$fun$isNotImported$5.invoke(p12)) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            for (FqName conflict : (List)destination$iv$iv3) {
                Importer.addImport$default(this, conflict, false, null, 4, null);
            }
            return ImportDescriptorResult.IMPORT_ADDED;
        }

        private final MemberScope getMemberScope(FqName fqName2, ModuleDescriptor moduleDescriptor) {
            PackageViewDescriptor packageView = moduleDescriptor.getPackage(fqName2);
            if (!packageView.isEmpty()) {
                return packageView.getMemberScope();
            }
            FqName fqName3 = fqName2.parent();
            Intrinsics.checkNotNullExpressionValue((Object)fqName3, (String)"fqName.parent()");
            MemberScope memberScope2 = this.getMemberScope(fqName3, moduleDescriptor);
            if (memberScope2 == null) {
                return null;
            }
            MemberScope parentScope = memberScope2;
            Name name2 = fqName2.shortName();
            Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"fqName.shortName()");
            ClassifierDescriptor classifier2 = parentScope.getContributedClassifier(name2, (LookupLocation)NoLookupLocation.FROM_IDE);
            ClassifierDescriptor classifierDescriptor = classifier2;
            if (!(classifierDescriptor instanceof ClassDescriptor)) {
                classifierDescriptor = null;
            }
            ClassDescriptor classDescriptor = (ClassDescriptor)classifierDescriptor;
            if (classDescriptor == null) {
                return null;
            }
            ClassDescriptor classDescriptor2 = classDescriptor;
            return classDescriptor2.getDefaultType().getMemberScope();
        }

        private final ImportDescriptorResult addExplicitImport(DeclarationDescriptor target2, Name aliasName) {
            if (target2 instanceof ClassDescriptor || target2 instanceof PackageViewDescriptor) {
                Collection collection;
                Name name2;
                ClassifierDescriptor classifier2;
                LexicalScope topLevelScope = ScopeUtils.getFileResolutionScope(this.resolutionFacade, this.file);
                Name name3 = aliasName;
                if (name3 == null) {
                    Name name4 = target2.getName();
                    name3 = name4;
                    Intrinsics.checkNotNullExpressionValue((Object)name4, (String)"target.name");
                }
                if ((classifier2 = ScopeUtilsKt.findClassifier((HierarchicalScope)((HierarchicalScope)topLevelScope), (Name)(name2 = name3), (LookupLocation)((LookupLocation)NoLookupLocation.FROM_IDE))) != null && !(collection = (Collection)this.detectNeededImports(CollectionsKt.listOf((Object)classifier2))).isEmpty()) {
                    return ImportDescriptorResult.FAIL;
                }
            }
            FqName fqName2 = ImportsUtils.getImportableFqName(target2);
            Intrinsics.checkNotNull((Object)fqName2);
            this.addImport(fqName2, false, aliasName);
            return ImportDescriptorResult.IMPORT_ADDED;
        }

        /*
         * WARNING - void declaration
         */
        private final void dropRedundantExplicitImports(FqName packageFqName) {
            Iterator $this$filterTo$iv$iv;
            Iterable $this$filter$iv = this.file.getImportDirectives();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator iterator = $this$filterTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                ImportPath importPath;
                Object element$iv$iv = iterator.next();
                KtImportDirective it = (KtImportDirective)element$iv$iv;
                boolean bl = false;
                if (!(!it.isAllUnder() && it.getAliasName() == null && Intrinsics.areEqual((Object)((importPath = it.getImportPath()) != null && (importPath = importPath.getFqName()) != null ? importPath.parent() : null), (Object)packageFqName))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List dropCandidates = (List)destination$iv$iv;
            ArrayList importsToCheck = new ArrayList();
            for (KtImportDirective ktImportDirective : dropCandidates) {
                void result$iv;
                Object object;
                void $this$filterIsInstanceTo$iv$iv;
                boolean bl;
                Collection targets;
                block9: {
                    if (ktImportDirective.getImportedReference() == null) continue;
                    targets = UtilsKt.targetDescriptors$default(ktImportDirective, null, 1, null);
                    Iterable $this$any$iv = targets;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            DeclarationDescriptor it = (DeclarationDescriptor)element$iv;
                            boolean bl2 = false;
                            if (!(it instanceof PackageViewDescriptor)) continue;
                            bl = true;
                            break block9;
                        }
                        bl = false;
                    }
                }
                if (bl) continue;
                Iterable $this$filterIsInstance$iv = targets;
                boolean $i$f$filterIsInstance = false;
                Iterable element$iv = $this$filterIsInstance$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof ClassDescriptor)) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                ClassDescriptor classDescriptor = (ClassDescriptor)CollectionsKt.firstOrNull((List)((List)destination$iv$iv2));
                ClassDescriptor classDescriptor2 = classDescriptor;
                org.jetbrains.kotlin.utils.CollectionsKt.addIfNotNull((Collection)importsToCheck, (Object)(classDescriptor2 != null ? ImportsUtils.getImportableFqName((DeclarationDescriptor)classDescriptor2) : null));
                boolean runImmediately$iv = this.runImmediately;
                boolean $i$f$runAction = false;
                if (runImmediately$iv) {
                    boolean bl3 = false;
                    ktImportDirective.delete();
                    object = Unit.INSTANCE;
                    continue;
                }
                destination$iv$iv2 = new Ref.ObjectRef();
                ((Ref.ObjectRef)destination$iv$iv2).element = null;
                ApplicationManager.getApplication().invokeAndWait(new Runnable((Ref.ObjectRef)result$iv, ktImportDirective){
                    final /* synthetic */ Ref.ObjectRef $result;
                    final /* synthetic */ KtImportDirective $import$inlined;
                    {
                        this.$result = objectRef;
                        this.$import$inlined = ktImportDirective;
                    }

                    public final void run() {
                        CommandProcessor.getInstance().runUndoTransparentAction(new Runnable(this){
                            final /* synthetic */ Importer$dropRedundantExplicitImports$$inlined$runAction$1 this$0;
                            {
                                this.this$0 = var1_1;
                            }

                            public final void run() {
                                this.this$0.$result.element = ApplicationManager.getApplication().runWriteAction(new Computable(this){
                                    final /* synthetic */ Importer$dropRedundantExplicitImports$$inlined$runAction$1$1 this$0;
                                    {
                                        this.this$0 = var1_1;
                                    }

                                    public final T compute() {
                                        boolean bl = false;
                                        this.this$0.this$0.$import$inlined.delete();
                                        return (T)Unit.INSTANCE;
                                    }
                                });
                            }
                        });
                    }
                });
                Object object2 = result$iv.element;
                object = object2;
                Intrinsics.checkNotNull((Object)object2);
            }
            Collection ktImportDirective = importsToCheck;
            if (!ktImportDirective.isEmpty()) {
                LexicalScope topLevelScope = ScopeUtils.getFileResolutionScope(this.resolutionFacade, this.file);
                for (FqName classFqName : importsToCheck) {
                    ClassifierDescriptor classifier2;
                    HierarchicalScope hierarchicalScope = (HierarchicalScope)topLevelScope;
                    Name name2 = classFqName.shortName();
                    Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"classFqName.shortName()");
                    ClassifierDescriptor classifierDescriptor = classifier2 = ScopeUtilsKt.findClassifier((HierarchicalScope)hierarchicalScope, (Name)name2, (LookupLocation)((LookupLocation)NoLookupLocation.FROM_IDE));
                    if (!(Intrinsics.areEqual((Object)(classifierDescriptor != null ? ImportsUtils.getImportableFqName((DeclarationDescriptor)classifierDescriptor) : null), (Object)classFqName) ^ true)) continue;
                    FqName fqName2 = classFqName;
                    Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"classFqName");
                    Importer.addImport$default(this, fqName2, false, null, 4, null);
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private final Set<ClassifierDescriptor> detectNeededImports(Collection<? extends ClassifierDescriptor> importedClasses) {
            void destination$iv;
            void $this$associateByTo$iv;
            if (importedClasses.isEmpty()) {
                return SetsKt.emptySet();
            }
            Iterable iterable = importedClasses;
            Map map2 = new LinkedHashMap();
            boolean $i$f$associateByTo = false;
            for (Object element$iv : $this$associateByTo$iv) {
                void it;
                ClassifierDescriptor classifierDescriptor = (ClassifierDescriptor)element$iv;
                void var10_9 = destination$iv;
                boolean bl = false;
                Name name2 = it.getName();
                var10_9.put(name2, element$iv);
            }
            void classesToCheck = destination$iv;
            LinkedHashSet result2 = new LinkedHashSet();
            this.file.accept((PsiElementVisitor)new KtVisitorVoid(this, (Map)classesToCheck, result2){
                final /* synthetic */ Importer this$0;
                final /* synthetic */ Map $classesToCheck;
                final /* synthetic */ LinkedHashSet $result;

                public void visitElement(@NotNull PsiElement element3) {
                    Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
                    if (this.$classesToCheck.isEmpty()) {
                        return;
                    }
                    element3.acceptChildren((PsiElementVisitor)this);
                }

                public void visitImportList(@NotNull KtImportList importList) {
                    Intrinsics.checkNotNullParameter((Object)importList, (String)"importList");
                }

                public void visitPackageDirective(@NotNull KtPackageDirective directive) {
                    Intrinsics.checkNotNullParameter((Object)directive, (String)"directive");
                }

                public void visitSimpleNameExpression(@NotNull KtSimpleNameExpression expression2) {
                    FqName targetFqName;
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    if (KtPsiUtil.isSelectorInQualified((KtSimpleNameExpression)expression2)) {
                        return;
                    }
                    Name refName = expression2.getReferencedNameAsName();
                    ClassifierDescriptor descriptor2 = (ClassifierDescriptor)this.$classesToCheck.get(refName);
                    if (descriptor2 != null && (targetFqName = Importer.access$targetFqName(this.this$0, (KtReferenceExpression)expression2)) != null && Intrinsics.areEqual((Object)targetFqName, (Object)DescriptorUtils.getFqNameSafe((DeclarationDescriptor)((DeclarationDescriptor)descriptor2)))) {
                        this.$classesToCheck.remove(refName);
                        this.$result.add(descriptor2);
                    }
                }
                {
                    this.this$0 = this$0;
                    this.$classesToCheck = $captured_local_variable$1;
                    this.$result = $captured_local_variable$2;
                }
            });
            return result2;
        }

        /*
         * WARNING - void declaration
         */
        private final FqName targetFqName(KtReferenceExpression ref2) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.resolveTargets(ref2);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                FqName fqName2 = ImportsUtils.getImportableFqName((DeclarationDescriptor)it);
                collection.add(fqName2);
            }
            return (FqName)CollectionsKt.singleOrNull((Iterable)CollectionsKt.toSet((Iterable)((List)destination$iv$iv)));
        }

        private final Collection<DeclarationDescriptor> resolveTargets(KtReferenceExpression $this$resolveTargets) {
            return ImportsUtils.getImportableTargets($this$resolveTargets, this.resolutionFacade.analyze((KtElement)$this$resolveTargets, BodyResolveMode.PARTIAL));
        }

        /*
         * WARNING - void declaration
         */
        private final KtImportDirective addImport(FqName fqName2, boolean allUnder, Name aliasName) {
            Object object;
            boolean runImmediately$iv = this.runImmediately;
            boolean $i$f$runAction = false;
            if (runImmediately$iv) {
                boolean bl = false;
                object = Companion.addImport(ImportInsertHelperImpl.this.project, this.file, fqName2, allUnder, aliasName);
            } else {
                void result$iv;
                Ref.ObjectRef objectRef = new Ref.ObjectRef();
                objectRef.element = null;
                ApplicationManager.getApplication().invokeAndWait(new Runnable((Ref.ObjectRef)result$iv, this, fqName2, allUnder, aliasName){
                    final /* synthetic */ Ref.ObjectRef $result;
                    final /* synthetic */ Importer this$0;
                    final /* synthetic */ FqName $fqName$inlined;
                    final /* synthetic */ boolean $allUnder$inlined;
                    final /* synthetic */ Name $aliasName$inlined;
                    {
                        this.$result = objectRef;
                        this.this$0 = importer;
                        this.$fqName$inlined = fqName2;
                        this.$allUnder$inlined = bl;
                        this.$aliasName$inlined = name2;
                    }

                    public final void run() {
                        CommandProcessor.getInstance().runUndoTransparentAction(new Runnable(this){
                            final /* synthetic */ Importer$addImport$$inlined$runAction$1 this$0;
                            {
                                this.this$0 = var1_1;
                            }

                            public final void run() {
                                this.this$0.$result.element = ApplicationManager.getApplication().runWriteAction(new Computable(this){
                                    final /* synthetic */ Importer$addImport$$inlined$runAction$1$1 this$0;
                                    {
                                        this.this$0 = var1_1;
                                    }

                                    public final T compute() {
                                        boolean bl = false;
                                        return (T)ImportInsertHelperImpl.Companion.addImport(ImportInsertHelperImpl.access$getProject$p(this.this$0.this$0.this$0.ImportInsertHelperImpl.this), Importer.access$getFile$p(this.this$0.this$0.this$0), this.this$0.this$0.$fqName$inlined, this.this$0.this$0.$allUnder$inlined, this.this$0.this$0.$aliasName$inlined);
                                    }
                                });
                            }
                        });
                    }
                });
                Object object2 = result$iv.element;
                object = object2;
                Intrinsics.checkNotNull((Object)object2);
            }
            return object;
        }

        static /* synthetic */ KtImportDirective addImport$default(Importer importer, FqName fqName2, boolean bl, Name name2, int n, Object object) {
            if ((n & 4) != 0) {
                name2 = null;
            }
            return importer.addImport(fqName2, bl, name2);
        }

        public Importer(KtElement element3, boolean runImmediately) {
            Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
            this.element = element3;
            this.runImmediately = runImmediately;
            KtFile ktFile = this.element.getContainingKtFile();
            Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"element.containingKtFile");
            this.file = ktFile;
            this.resolutionFacade = ResolutionUtils.getResolutionFacade((KtElement)this.file);
            this.languageVersionSettings = ResolutionFacadeKt.getLanguageVersionSettings(this.resolutionFacade);
        }

        public static final /* synthetic */ LanguageVersionSettings access$getLanguageVersionSettings$p(Importer $this) {
            return $this.languageVersionSettings;
        }

        public static final /* synthetic */ Collection access$resolveTargets(Importer $this, KtReferenceExpression $this$access_u24resolveTargets) {
            return $this.resolveTargets($this$access_u24resolveTargets);
        }

        public static final /* synthetic */ FqName access$targetFqName(Importer $this, KtReferenceExpression ref2) {
            return $this.targetFqName(ref2);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000eJ&\u0010\u000f\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00110\u00102\u0006\u0010\u0013\u001a\u00020\bJ\u0016\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\b\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/util/ImportInsertHelperImpl$Companion;", "", "()V", "addImport", "Lorg/jetbrains/kotlin/psi/KtImportDirective;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "allUnder", "", "alias", "Lorg/jetbrains/kotlin/name/Name;", "computeDefaultAndExcludedImports", "Lkotlin/Pair;", "", "Lorg/jetbrains/kotlin/resolve/ImportPath;", "contextFile", "isInDefaultImports", "importPath", "kotlin.idea"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        public final boolean isInDefaultImports(@NotNull ImportPath importPath, @NotNull KtFile contextFile) {
            void defaultImports;
            Intrinsics.checkNotNullParameter((Object)importPath, (String)"importPath");
            Intrinsics.checkNotNullParameter((Object)contextFile, (String)"contextFile");
            Pair<List<ImportPath>, List<FqName>> pair = this.computeDefaultAndExcludedImports(contextFile);
            List list2 = (List)pair.component1();
            List excludedImports = (List)pair.component2();
            return FqNameUtilKt.isImported(importPath, (Iterable)defaultImports, excludedImports);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Pair<List<ImportPath>, List<FqName>> computeDefaultAndExcludedImports(@NotNull KtFile contextFile) {
            Object object;
            List list2;
            KtFile ktFile;
            Intrinsics.checkNotNullParameter((Object)contextFile, (String)"contextFile");
            LanguageVersionSettings languageVersionSettings2 = ResolutionFacadeKt.getLanguageVersionSettings(ResolutionUtils.getResolutionFacade((KtElement)contextFile));
            TargetPlatform targetPlatform = TargetPlatformDetector.getPlatform(contextFile);
            Intrinsics.checkNotNullExpressionValue((Object)targetPlatform, (String)"TargetPlatformDetector.getPlatform(contextFile)");
            TargetPlatform platform2 = targetPlatform;
            Project project2 = contextFile.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"contextFile.project");
            PlatformDependentAnalyzerServices analyzerServices = AnalyzerServicesKt.findAnalyzerServices(platform2, project2);
            List allDefaultImports = analyzerServices.getDefaultImports(languageVersionSettings2, true);
            KtFile it = ktFile = contextFile;
            boolean bl = false;
            Object object2 = it.isScript() ? ktFile : null;
            if (object2 != null) {
                ScriptCompilationConfigurationWrapper scriptDependencies;
                Object object3;
                ScriptCompilationConfigurationWrapper scriptCompilationConfigurationWrapper;
                KtFile ktFile2 = ktFile = object2;
                boolean bl2 = false;
                Project project3 = ktFile2.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"ktFile.project");
                ScriptDependenciesProvider scriptDependenciesProvider = ScriptDependenciesProvider.Companion.getInstance(project3);
                if (scriptDependenciesProvider != null) {
                    PsiFile psiFile2 = ktFile2.getOriginalFile();
                    if (psiFile2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
                    }
                    scriptCompilationConfigurationWrapper = scriptDependenciesProvider.getScriptConfiguration((KtFile)psiFile2);
                } else {
                    scriptCompilationConfigurationWrapper = null;
                }
                if ((object3 = (scriptDependencies = scriptCompilationConfigurationWrapper)) != null && (object3 = ((ScriptCompilationConfigurationWrapper)object3).getDefaultImports()) != null) {
                    void $this$mapTo$iv$iv;
                    Iterable $this$map$iv = (Iterable)object3;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it2;
                        String string = (String)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl3 = false;
                        ImportPath importPath = ImportPath.Companion.fromString((String)it2);
                        collection.add(importPath);
                    }
                    list2 = (List)destination$iv$iv;
                } else {
                    list2 = null;
                }
            } else {
                list2 = null;
            }
            if ((object = (ktFile = list2)) == null) {
                object = CollectionsKt.emptyList();
            }
            KtFile scriptExtraImports = object;
            return TuplesKt.to((Object)CollectionsKt.plus((Collection)allDefaultImports, (Iterable)((Iterable)scriptExtraImports)), (Object)analyzerServices.getExcludedImports());
        }

        @NotNull
        public final KtImportDirective addImport(@NotNull Project project2, @NotNull KtFile file2, @NotNull FqName fqName2, boolean allUnder, @Nullable Name alias) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
            ImportPath importPath = new ImportPath(fqName2, allUnder, alias);
            KtPsiFactory psiFactory = new KtPsiFactory(project2, false, 2, null);
            if (file2 instanceof KtCodeFragment) {
                KtImportDirective newDirective = psiFactory.createImportDirective(importPath);
                ((KtCodeFragment)file2).addImportsFromString(newDirective.getText());
                return newDirective;
            }
            KtImportList importList = file2.getImportList();
            if (importList != null) {
                KtImportDirective ktImportDirective;
                boolean isInjectedScript = file2.getVirtualFile() instanceof VirtualFileWindow && file2.isScript();
                KtImportDirective newDirective = psiFactory.createImportDirective(importPath);
                List list2 = importList.getImports();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"importList.imports");
                List imports2 = list2;
                if (imports2.isEmpty()) {
                    KtImportDirective ktImportDirective2;
                    importList.add(psiFactory.createNewLine());
                    PsiElement psiElement2 = importList.add((PsiElement)newDirective);
                    if (psiElement2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtImportDirective");
                    }
                    KtImportDirective it = ktImportDirective2 = (KtImportDirective)psiElement2;
                    boolean bl = false;
                    if (isInjectedScript) {
                        importList.add(psiFactory.createNewLine());
                    }
                    ktImportDirective = ktImportDirective2;
                } else {
                    KtImportDirective ktImportDirective3;
                    Object v4;
                    block9: {
                        Comparator<ImportPath> importPathComparator = new ImportInsertHelperImpl(project2).getImportSortComparator(file2);
                        List $this$lastOrNull$iv = imports2;
                        boolean $i$f$lastOrNull = false;
                        ListIterator iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
                        while (iterator$iv.hasPrevious()) {
                            Object element$iv = iterator$iv.previous();
                            KtImportDirective it = (KtImportDirective)element$iv;
                            boolean bl = false;
                            KtImportDirective ktImportDirective4 = it;
                            Intrinsics.checkNotNullExpressionValue((Object)ktImportDirective4, (String)"it");
                            ImportPath directivePath = ktImportDirective4.getImportPath();
                            if (!(directivePath != null && importPathComparator.compare(directivePath, importPath) <= 0)) continue;
                            v4 = element$iv;
                            break block9;
                        }
                        v4 = null;
                    }
                    KtImportDirective insertAfter = v4;
                    PsiElement psiElement3 = importList.addAfter((PsiElement)newDirective, (PsiElement)insertAfter);
                    if (psiElement3 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtImportDirective");
                    }
                    KtImportDirective insertedDirective = ktImportDirective3 = (KtImportDirective)psiElement3;
                    boolean bl = false;
                    if (isInjectedScript) {
                        importList.addBefore(psiFactory.createNewLine(1), (PsiElement)insertedDirective);
                    }
                    ktImportDirective = ktImportDirective3;
                }
                return ktImportDirective;
            }
            String string = "Trying to insert import " + fqName2 + " into a file " + file2.getName() + " of type " + file2.getClass() + " with no import list.";
            throw new IllegalStateException(string.toString());
        }

        public static /* synthetic */ KtImportDirective addImport$default(Companion companion, Project project2, KtFile ktFile, FqName fqName2, boolean bl, Name name2, int n, Object object) {
            if ((n & 8) != 0) {
                bl = false;
            }
            if ((n & 0x10) != 0) {
                name2 = null;
            }
            return companion.addImport(project2, ktFile, fqName2, bl, name2);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

