/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.search.ideaExtensions;

import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.RequestResultProcessor;
import com.intellij.psi.search.SearchRequestCollector;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.SearchSession;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.Processor;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.idea.search.ideaExtensions.KotlinAwareReferencesSearchParameters;
import org.jetbrains.kotlin.idea.search.ideaExtensions.KotlinReferencesSearchOptions;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00032\u0010\u0010\b\u001a\f\u0012\b\b\u0000\u0012\u0004\u0018\u00010\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/search/ideaExtensions/KotlinAliasedImportedElementSearcher;", "Lcom/intellij/openapi/application/QueryExecutorBase;", "Lcom/intellij/psi/PsiReference;", "Lcom/intellij/psi/search/searches/ReferencesSearch$SearchParameters;", "()V", "processQuery", "", "parameters", "consumer", "Lcom/intellij/util/Processor;", "AliasProcessor", "kotlin.fir.frontend-independent"})
public final class KotlinAliasedImportedElementSearcher
extends QueryExecutorBase<PsiReference, ReferencesSearch.SearchParameters> {
    public void processQuery(@NotNull ReferencesSearch.SearchParameters parameters2, @NotNull Processor<? super PsiReference> consumer2) {
        block3: {
            Function0 queryFunction2;
            Object kotlinOptions;
            Object object;
            Intrinsics.checkNotNullParameter((Object)parameters2, (String)"parameters");
            Intrinsics.checkNotNullParameter(consumer2, (String)"consumer");
            ReferencesSearch.SearchParameters searchParameters2 = parameters2;
            if (!(searchParameters2 instanceof KotlinAwareReferencesSearchParameters)) {
                searchParameters2 = null;
            }
            if ((object = (KotlinAwareReferencesSearchParameters)searchParameters2) == null || (object = object.getKotlinOptions()) == null) {
                object = KotlinReferencesSearchOptions.Companion.getEmpty();
            }
            if (!((KotlinReferencesSearchOptions)(kotlinOptions = object)).getAcceptImportAlias()) {
                return;
            }
            Function0 function0 = queryFunction2 = (Function0)ReadAction.nonBlocking((Callable)new Callable(parameters2){
                final /* synthetic */ ReferencesSearch.SearchParameters $parameters;

                @Nullable
                public final Function0<Unit> call() {
                    PsiElement psiElement2 = this.$parameters.getElementToSearch();
                    Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"parameters.elementToSearch");
                    PsiElement element3 = psiElement2;
                    if (!element3.isValid()) {
                        return null;
                    }
                    PsiNamedElement psiNamedElement = LightClassUtilsKt.getNamedUnwrappedElement((PsiElement)element3);
                    if (psiNamedElement == null) {
                        return null;
                    }
                    PsiNamedElement unwrappedElement = psiNamedElement;
                    String name2 = unwrappedElement.getName();
                    if (name2 == null || StringUtil.isEmptyOrSpaces((String)name2)) {
                        return null;
                    }
                    SearchScope effectiveSearchScope = KotlinReferencesSearchOptions.Companion.calculateEffectiveScope$kotlin_fir_frontend_independent(unwrappedElement, this.$parameters);
                    SearchRequestCollector searchRequestCollector = this.$parameters.getOptimizer();
                    Intrinsics.checkNotNullExpressionValue((Object)searchRequestCollector, (String)"parameters.optimizer");
                    SearchRequestCollector collector2 = searchRequestCollector;
                    SearchSession searchSession = collector2.getSearchSession();
                    Intrinsics.checkNotNullExpressionValue((Object)searchSession, (String)"collector.searchSession");
                    SearchSession session = searchSession;
                    Function0 function2 = (Function0)new Function0<Unit>(collector2, name2, effectiveSearchScope, element3, session){
                        final /* synthetic */ SearchRequestCollector $collector;
                        final /* synthetic */ String $name;
                        final /* synthetic */ SearchScope $effectiveSearchScope;
                        final /* synthetic */ PsiElement $element;
                        final /* synthetic */ SearchSession $session;

                        public final void invoke() {
                            this.$collector.searchWord(this.$name, this.$effectiveSearchScope, (short)1, true, this.$element, (RequestResultProcessor)new AliasProcessor(this.$element, this.$session));
                        }
                        {
                            this.$collector = searchRequestCollector;
                            this.$name = string;
                            this.$effectiveSearchScope = searchScope2;
                            this.$element = psiElement2;
                            this.$session = searchSession;
                            super(0);
                        }
                    };
                    return function2;
                }
                {
                    this.$parameters = searchParameters2;
                }
            }).inSmartMode(parameters2.getProject()).executeSynchronously();
            if (function0 == null) break block3;
            Unit cfr_ignored_0 = (Unit)function0.invoke();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J(\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\u000e\u0010\f\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u000e0\rH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/search/ideaExtensions/KotlinAliasedImportedElementSearcher$AliasProcessor;", "Lcom/intellij/psi/search/RequestResultProcessor;", "myTarget", "Lcom/intellij/psi/PsiElement;", "mySession", "Lcom/intellij/psi/search/SearchSession;", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/search/SearchSession;)V", "processTextOccurrence", "", "element", "offsetInElement", "", "consumer", "Lcom/intellij/util/Processor;", "Lcom/intellij/psi/PsiReference;", "kotlin.fir.frontend-independent"})
    private static final class AliasProcessor
    extends RequestResultProcessor {
        private final PsiElement myTarget;
        private final SearchSession mySession;

        public boolean processTextOccurrence(@NotNull PsiElement element3, int offsetInElement, @NotNull Processor<? super PsiReference> consumer2) {
            Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
            Intrinsics.checkNotNullParameter(consumer2, (String)"consumer");
            PsiElement psiElement2 = element3.getParent();
            if (!(psiElement2 instanceof KtImportDirective)) {
                psiElement2 = null;
            }
            KtImportDirective ktImportDirective = (KtImportDirective)psiElement2;
            if (ktImportDirective == null) {
                return true;
            }
            KtImportDirective importStatement = ktImportDirective;
            Object object = importStatement.getAlias();
            if (object == null || (object = object.getName()) == null) {
                return true;
            }
            Object importAlias = object;
            KtExpression ktExpression = importStatement.getImportedReference();
            if (ktExpression == null || (ktExpression = KtPsiUtilKt.getQualifiedElementSelector((KtElement)((KtElement)ktExpression))) == null || (ktExpression = ReferenceUtilsKt.getMainReference((KtElement)ktExpression)) == null) {
                return true;
            }
            KtExpression reference2 = ktExpression;
            if (!reference2.isReferenceTo(this.myTarget)) {
                return true;
            }
            SearchRequestCollector collector2 = new SearchRequestCollector(this.mySession);
            SearchScope fileScope = (SearchScope)new LocalSearchScope((PsiElement)element3.getContainingFile());
            collector2.searchWord((String)importAlias, fileScope, (short)1, true, this.myTarget);
            return PsiSearchHelper.getInstance((Project)element3.getProject()).processRequests(collector2, consumer2);
        }

        public AliasProcessor(@NotNull PsiElement myTarget, @NotNull SearchSession mySession) {
            Intrinsics.checkNotNullParameter((Object)myTarget, (String)"myTarget");
            Intrinsics.checkNotNullParameter((Object)mySession, (String)"mySession");
            super(new Object[]{myTarget});
            this.myTarget = myTarget;
            this.mySession = mySession;
        }
    }
}

