/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.references;

import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.psi.ContributedReferenceHost;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.Function;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.references.KotlinPsiReferenceProvider;
import org.jetbrains.kotlin.idea.references.KotlinPsiReferenceRegistrar;
import org.jetbrains.kotlin.idea.references.KotlinReferenceProviderContributor;
import org.jetbrains.kotlin.psi.KotlinReferenceProvidersService;
import org.jetbrains.kotlin.utils.SmartList;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001b\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\bH\u0002\u00a2\u0006\u0002\u0010\u0011J\u001b\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0013\u001a\u00020\bH\u0016\u00a2\u0006\u0002\u0010\u0011R\"\u0010\u0005\u001a\u0016\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\u0012\u0004\u0012\u00020\t0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\n\u001a\u001c\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/references/KtIdeReferenceProviderService;", "Lorg/jetbrains/kotlin/psi/KotlinReferenceProvidersService;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "originalProvidersBinding", "Lcom/intellij/util/containers/MultiMap;", "Ljava/lang/Class;", "Lcom/intellij/psi/PsiElement;", "Lorg/jetbrains/kotlin/idea/references/KotlinPsiReferenceProvider;", "providersBindingCache", "", "", "doGetKotlinReferencesFromProviders", "", "Lcom/intellij/psi/PsiReference;", "context", "(Lcom/intellij/psi/PsiElement;)[Lcom/intellij/psi/PsiReference;", "getReferences", "psiElement", "kotlin.fir.frontend-independent"})
public final class KtIdeReferenceProviderService
extends KotlinReferenceProvidersService {
    private final MultiMap<Class<? extends PsiElement>, KotlinPsiReferenceProvider> originalProvidersBinding;
    private final Map<Class<? extends PsiElement>, List<KotlinPsiReferenceProvider>> providersBindingCache;

    private final PsiReference[] doGetKotlinReferencesFromProviders(PsiElement context2) {
        List<KotlinPsiReferenceProvider> providers = this.providersBindingCache.get(context2.getClass());
        Collection collection = providers;
        if (collection == null || collection.isEmpty()) {
            Intrinsics.checkNotNullExpressionValue((Object)PsiReference.EMPTY_ARRAY, (String)"PsiReference.EMPTY_ARRAY");
            return PsiReference.EMPTY_ARRAY;
        }
        SmartList result2 = new SmartList();
        for (KotlinPsiReferenceProvider provider2 : providers) {
            try {
                CollectionsKt.addAll((Collection)((Collection)result2), (Object[])provider2.getReferencesByElement(context2));
            }
            catch (IndexNotReadyException indexNotReadyException) {}
        }
        if (result2.isEmpty()) {
            Intrinsics.checkNotNullExpressionValue((Object)PsiReference.EMPTY_ARRAY, (String)"PsiReference.EMPTY_ARRAY");
            return PsiReference.EMPTY_ARRAY;
        }
        Collection $this$toTypedArray$iv = (Collection)result2;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new PsiReference[0]);
    }

    @NotNull
    public PsiReference[] getReferences(@NotNull PsiElement psiElement2) {
        Intrinsics.checkNotNullParameter((Object)psiElement2, (String)"psiElement");
        if (psiElement2 instanceof ContributedReferenceHost) {
            PsiReference[] psiReferenceArray = ReferenceProvidersRegistry.getReferencesFromProviders((PsiElement)psiElement2, (PsiReferenceService.Hints)PsiReferenceService.Hints.NO_HINTS);
            Intrinsics.checkNotNullExpressionValue((Object)psiReferenceArray, (String)"ReferenceProvidersRegist\u2026ceService.Hints.NO_HINTS)");
            return psiReferenceArray;
        }
        Object object = CachedValuesManager.getCachedValue((PsiElement)psiElement2, (CachedValueProvider)new CachedValueProvider(this, psiElement2){
            final /* synthetic */ KtIdeReferenceProviderService this$0;
            final /* synthetic */ PsiElement $psiElement;

            @Nullable
            public final CachedValueProvider.Result<PsiReference[]> compute() {
                return CachedValueProvider.Result.create((Object)KtIdeReferenceProviderService.access$doGetKotlinReferencesFromProviders(this.this$0, this.$psiElement), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            }
            {
                this.this$0 = ktIdeReferenceProviderService;
                this.$psiElement = psiElement2;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"CachedValuesManager.getC\u2026T\n            )\n        }");
        return (PsiReference[])object;
    }

    public KtIdeReferenceProviderService(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        KotlinPsiReferenceRegistrar registrar = new KotlinPsiReferenceRegistrar();
        KotlinReferenceProviderContributor.Companion.getInstance(project2).registerReferenceProviders(registrar);
        this.originalProvidersBinding = registrar.getProviders();
        ConcurrentMap concurrentMap = ConcurrentFactoryMap.createMap((Function)new Function(){

            public final List<KotlinPsiReferenceProvider> fun(Class<? extends PsiElement> klass2) {
                SmartList result2 = new SmartList();
                for (Class bindingClass : originalProvidersBinding.keySet()) {
                    if (!bindingClass.isAssignableFrom(klass2)) continue;
                    result2.addAll(originalProvidersBinding.get((Object)bindingClass));
                }
                return (List)result2;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"ConcurrentFactoryMap.cre\u2026         result\n        }");
        this.providersBindingCache = concurrentMap;
    }

    public static final /* synthetic */ PsiReference[] access$doGetKotlinReferencesFromProviders(KtIdeReferenceProviderService $this, PsiElement context2) {
        return $this.doGetKotlinReferencesFromProviders(context2);
    }
}

