/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.rename;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.search.SearchScope;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.rename.naming.AutomaticRenamer;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.idea.search.declarationsSearch.HierarchySearchRequest;
import org.jetbrains.kotlin.idea.search.declarationsSearch.OverridersSearchKt;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\u0005H\u0016J\u0012\u0010\b\u001a\f0\u0005\u00a2\u0006\u0002\b\t\u00a2\u0006\u0002\b\nH\u0016J\b\u0010\u000b\u001a\u00020\u0005H\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/rename/AutomaticParameterRenamer;", "Lcom/intellij/refactoring/rename/naming/AutomaticRenamer;", "element", "Lorg/jetbrains/kotlin/psi/KtParameter;", "newName", "", "(Lorg/jetbrains/kotlin/psi/KtParameter;Ljava/lang/String;)V", "entityName", "getDialogDescription", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "getDialogTitle", "isSelectedByDefault", "", "processHierarchy", "", "kotlin.idea"})
public final class AutomaticParameterRenamer
extends AutomaticRenamer {
    private final void processHierarchy(KtParameter element3, String newName2) {
        KtDeclarationWithBody ktDeclarationWithBody = element3.getOwnerFunction();
        if (ktDeclarationWithBody == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)ktDeclarationWithBody, (String)"element.ownerFunction ?: return");
        KtDeclarationWithBody function2 = ktDeclarationWithBody;
        PsiElement psiElement2 = (PsiElement)function2;
        SearchScope searchScope2 = function2.getUseScope();
        Intrinsics.checkNotNullExpressionValue((Object)searchScope2, (String)"function.useScope");
        Iterator iterator = OverridersSearchKt.searchOverriders(new HierarchySearchRequest(psiElement2, searchScope2, false, 4, null)).iterator();
        while (iterator.hasNext()) {
            PsiNamedElement parameter;
            PsiNamedElement psiNamedElement;
            boolean $i$f$firstOrNull;
            PsiParameter[] $this$firstOrNull$iv;
            PsiNamedElement callable2;
            PsiMethod overrider;
            PsiMethod psiMethod = overrider = (PsiMethod)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)psiMethod, (String)"overrider");
            if (LightClassUtilsKt.getNamedUnwrappedElement((PsiElement)((PsiElement)psiMethod)) == null || !KotlinRefactoringUtilKt.canRefactor((PsiElement)callable2)) continue;
            Object object = callable2;
            if (object instanceof KtCallableDeclaration) {
                Object v6;
                block8: {
                    List list2 = ((KtCallableDeclaration)callable2).getValueParameters();
                    Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"callable.valueParameters");
                    $this$firstOrNull$iv = (PsiParameter[])list2;
                    $i$f$firstOrNull = false;
                    for (Object t : $this$firstOrNull$iv) {
                        KtParameter it = (KtParameter)t;
                        boolean bl = false;
                        KtParameter ktParameter = it;
                        Intrinsics.checkNotNullExpressionValue((Object)ktParameter, (String)"it");
                        if (!Intrinsics.areEqual((Object)ktParameter.getName(), (Object)element3.getName())) continue;
                        v6 = t;
                        break block8;
                    }
                    v6 = null;
                }
                psiNamedElement = v6;
            } else if (object instanceof PsiMethod) {
                PsiParameter psiParameter;
                block9: {
                    PsiParameterList psiParameterList = ((PsiMethod)callable2).getParameterList();
                    Intrinsics.checkNotNullExpressionValue((Object)psiParameterList, (String)"callable.parameterList");
                    Intrinsics.checkNotNullExpressionValue((Object)psiParameterList.getParameters(), (String)"callable.parameterList.parameters");
                    $i$f$firstOrNull = false;
                    int n = $this$firstOrNull$iv.length;
                    for (int i = 0; i < n; ++i) {
                        PsiParameter element$iv;
                        PsiParameter it = element$iv = $this$firstOrNull$iv[i];
                        boolean bl = false;
                        PsiParameter psiParameter2 = it;
                        Intrinsics.checkNotNullExpressionValue((Object)psiParameter2, (String)"it");
                        if (!Intrinsics.areEqual((Object)psiParameter2.getName(), (Object)element3.getName())) continue;
                        psiParameter = element$iv;
                        break block9;
                    }
                    psiParameter = null;
                }
                psiNamedElement = (PsiNamedElement)psiParameter;
            } else {
                psiNamedElement = null;
            }
            if ((parameter = psiNamedElement) == null) continue;
            object = this.myElements;
            object.add(parameter);
        }
        this.suggestAllNames(element3.getName(), KtPsiUtilKt.quoteIfNeeded((String)newName2));
    }

    @NotNull
    public String getDialogTitle() {
        return KotlinBundle.message("text.rename.parameters.title", new Object[0]);
    }

    @NotNull
    public String getDialogDescription() {
        String string = RefactoringBundle.message((String)"title.rename.parameters.hierarchy");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"RefactoringBundle.messag\u2026me.parameters.hierarchy\")");
        return string;
    }

    @NotNull
    public String entityName() {
        return KotlinBundle.message("text.parameter", new Object[0]);
    }

    public boolean isSelectedByDefault() {
        return true;
    }

    public AutomaticParameterRenamer(@NotNull KtParameter element3, @NotNull String newName2) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter((Object)newName2, (String)"newName");
        this.processHierarchy(element3, newName2);
    }
}

