/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.google.common.collect.ImmutableSet;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.quickfix.KotlinPsiOnlyQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.ReplaceCallFixKt;
import org.jetbrains.kotlin.idea.quickfix.ReplaceInfixOrOperatorCallFix;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.BuilderByPattern;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\u0007H\u0016J\b\u0010\n\u001a\u00020\u0007H\u0016J#\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0094\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ReplaceInfixOrOperatorCallFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinPsiOnlyQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "element", "notNullNeeded", "", "binaryOperatorName", "", "(Lorg/jetbrains/kotlin/psi/KtExpression;ZLjava/lang/String;)V", "getFamilyName", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "kotlin.fir.frontend-independent"})
public final class ReplaceInfixOrOperatorCallFix
extends KotlinPsiOnlyQuickFixAction<KtExpression> {
    private final boolean notNullNeeded;
    private final String binaryOperatorName;

    @NotNull
    public String getText() {
        return KotlinBundle.message("replace.with.safe.call", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @Override
    protected void invoke(@NotNull Project project2, @Nullable Editor editor2, @NotNull KtFile file2) {
        block18: {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            KtExpression ktExpression = (KtExpression)this.getElement();
            if (ktExpression == null) {
                return;
            }
            KtExpression element3 = ktExpression;
            KtPsiFactory psiFactory = new KtPsiFactory((KtElement)file2, false, 2, null);
            String elvis2 = ReplaceCallFixKt.elvisOrEmpty(element3, this.notNullNeeded);
            PsiElement replacement2 = null;
            Object object = element3;
            if (object instanceof KtArrayAccessExpression) {
                KtBinaryExpression assignment2;
                KtBinaryExpression ktBinaryExpression = assignment2 = KtPsiUtilKt.getAssignmentByLHS((KtExpression)element3);
                KtExpression right2 = ktBinaryExpression != null ? ktBinaryExpression.getRight() : null;
                KtExpression ktExpression2 = ((KtArrayAccessExpression)element3).getArrayExpression();
                if (ktExpression2 == null) {
                    return;
                }
                Intrinsics.checkNotNullExpressionValue((Object)ktExpression2, (String)"element.arrayExpression ?: return");
                KtExpression arrayExpression = ktExpression2;
                if (assignment2 != null) {
                    if (right2 == null) {
                        return;
                    }
                    Object[] objectArray = new Object[3];
                    objectArray[0] = arrayExpression;
                    List list2 = ((KtArrayAccessExpression)element3).getIndexExpressions();
                    Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"element.indexExpressions");
                    objectArray[1] = CollectionsKt.joinToString$default((Iterable)list2, (CharSequence)", ", null, null, (int)0, null, (Function1)invoke.newExpression.1.INSTANCE, (int)30, null);
                    objectArray[2] = right2;
                    KtExpression newExpression2 = CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)psiFactory, (String)"$0?.set($1, $2)", (Object[])objectArray, (boolean)false, (int)4, null);
                    assignment2.replace((PsiElement)newExpression2);
                } else {
                    String string = "$0?.get($1)" + elvis2;
                    Object[] objectArray = new Object[2];
                    objectArray[0] = arrayExpression;
                    List list3 = ((KtArrayAccessExpression)element3).getIndexExpressions();
                    Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"element.indexExpressions");
                    objectArray[1] = CollectionsKt.joinToString$default((Iterable)list3, (CharSequence)", ", null, null, (int)0, null, (Function1)invoke.newExpression.2.INSTANCE, (int)30, null);
                    KtExpression newExpression3 = CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)psiFactory, (String)string, (Object[])objectArray, (boolean)false, (int)4, null);
                    replacement2 = ((KtArrayAccessExpression)element3).replace((PsiElement)newExpression3);
                }
            } else if (object instanceof KtCallExpression) {
                KtExpression ktExpression3 = ((KtCallExpression)element3).getCalleeExpression();
                if (ktExpression3 == null) {
                    return;
                }
                Intrinsics.checkNotNullExpressionValue((Object)ktExpression3, (String)"element.calleeExpression ?: return");
                KtExpression calleeExpression2 = ktExpression3;
                Object object2 = ((KtCallExpression)element3).getValueArgumentList();
                if (object2 == null || (object2 = object2.getText()) == null) {
                    return;
                }
                Object valueArgumentList2 = object2;
                PsiElement psiElement2 = ((KtCallExpression)element3).getParent();
                if (!(psiElement2 instanceof KtQualifiedExpression)) {
                    psiElement2 = null;
                }
                KtQualifiedExpression parentQualified = (KtQualifiedExpression)psiElement2;
                KtExpression newExpression4 = CreateByPatternKt.buildExpression$default((KtPsiFactory)psiFactory, (boolean)false, (Function1)((Function1)new Function1<BuilderByPattern<KtExpression>, Unit>(parentQualified, calleeExpression2, (String)valueArgumentList2, elvis2){
                    final /* synthetic */ KtQualifiedExpression $parentQualified;
                    final /* synthetic */ KtExpression $calleeExpression;
                    final /* synthetic */ String $valueArgumentList;
                    final /* synthetic */ String $elvis;

                    public final void invoke(@NotNull BuilderByPattern<KtExpression> $this$buildExpression) {
                        Intrinsics.checkNotNullParameter($this$buildExpression, (String)"$receiver");
                        if (this.$parentQualified != null) {
                            KtExpression receiver2 = this.$parentQualified.getReceiverExpression();
                            ASTNode operationNode = this.$parentQualified.getOperationTokenNode();
                            ASTNode aSTNode = receiver2.getNode();
                            Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"receiver.node");
                            String beforeOperationNode2 = SequencesKt.joinToString$default((Sequence)SequencesKt.takeWhile((Sequence)PsiUtilsKt.siblings((ASTNode)aSTNode, (boolean)true), (Function1)invoke.newExpression.beforeOperationNode.1.INSTANCE), (CharSequence)"", null, null, (int)0, null, (Function1)invoke.newExpression.beforeOperationNode.2.INSTANCE, (int)30, null);
                            String afterOperationNode2 = SequencesKt.joinToString$default((Sequence)SequencesKt.takeWhile((Sequence)PsiUtilsKt.siblings((ASTNode)operationNode, (boolean)true), (Function1)invoke.newExpression.afterOperationNode.1.INSTANCE), (CharSequence)"", null, null, (int)0, null, (Function1)invoke.newExpression.afterOperationNode.2.INSTANCE, (int)30, null);
                            $this$buildExpression.appendExpression(receiver2);
                            $this$buildExpression.appendFixedText(beforeOperationNode2);
                            KtSingleValueToken ktSingleValueToken = KtTokens.SAFE_ACCESS;
                            Intrinsics.checkNotNullExpressionValue((Object)ktSingleValueToken, (String)"KtTokens.SAFE_ACCESS");
                            String string = ktSingleValueToken.getValue();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"KtTokens.SAFE_ACCESS.value");
                            $this$buildExpression.appendFixedText(string);
                            $this$buildExpression.appendFixedText(afterOperationNode2);
                        }
                        $this$buildExpression.appendExpression(this.$calleeExpression);
                        KtSingleValueToken ktSingleValueToken = KtTokens.SAFE_ACCESS;
                        Intrinsics.checkNotNullExpressionValue((Object)ktSingleValueToken, (String)"KtTokens.SAFE_ACCESS");
                        String string = ktSingleValueToken.getValue();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"KtTokens.SAFE_ACCESS.value");
                        $this$buildExpression.appendFixedText(string);
                        $this$buildExpression.appendFixedText("invoke");
                        $this$buildExpression.appendFixedText(this.$valueArgumentList);
                        $this$buildExpression.appendFixedText(this.$elvis);
                    }
                    {
                        this.$parentQualified = ktQualifiedExpression;
                        this.$calleeExpression = ktExpression;
                        this.$valueArgumentList = string;
                        this.$elvis = string2;
                        super(1);
                    }
                }), (int)1, null);
                KtQualifiedExpression ktQualifiedExpression = parentQualified;
                replacement2 = (ktQualifiedExpression != null ? (KtExpression)ktQualifiedExpression : element3).replace((PsiElement)newExpression4);
            } else if (object instanceof KtBinaryExpression) {
                KtExpression ktExpression4;
                KtExpression ktExpression5 = ((KtBinaryExpression)element3).getLeft();
                if (ktExpression5 == null) {
                    return;
                }
                Intrinsics.checkNotNullExpressionValue((Object)ktExpression5, (String)"element.left ?: return");
                KtExpression left = ktExpression5;
                KtExpression ktExpression6 = ((KtBinaryExpression)element3).getRight();
                if (ktExpression6 == null) {
                    return;
                }
                Intrinsics.checkNotNullExpressionValue((Object)ktExpression6, (String)"element.right ?: return");
                KtExpression right3 = ktExpression6;
                boolean isNormalAssignment = KtTokens.AUGMENTED_ASSIGNMENTS.contains(((KtBinaryExpression)element3).getOperationToken()) && !((ImmutableSet)OperatorConventions.ASSIGNMENT_OPERATIONS.values()).contains((Object)Name.identifier((String)this.binaryOperatorName));
                boolean isContainsOperator = Intrinsics.areEqual((Object)((KtBinaryExpression)element3).getOperationToken(), (Object)KtTokens.IN_KEYWORD);
                boolean isNotContainsOperator = Intrinsics.areEqual((Object)((KtBinaryExpression)element3).getOperationToken(), (Object)KtTokens.NOT_IN);
                if (isContainsOperator || isNotContainsOperator) {
                    String booleanSuffix = isNotContainsOperator ? " != true" : " == true";
                    ktExpression4 = CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)psiFactory, (String)("$2?.$1($0)" + booleanSuffix), (Object[])new Object[]{left, this.binaryOperatorName, right3}, (boolean)false, (int)4, null);
                } else {
                    ktExpression4 = isNormalAssignment ? CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)psiFactory, (String)"$0 = $0?.$1($2)", (Object[])new Object[]{left, this.binaryOperatorName, right3}, (boolean)false, (int)4, null) : CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)psiFactory, (String)("$0?.$1($2)" + elvis2), (Object[])new Object[]{left, this.binaryOperatorName, right3}, (boolean)false, (int)4, null);
                }
                KtExpression newExpression5 = ktExpression4;
                replacement2 = ((KtBinaryExpression)element3).replace((PsiElement)newExpression5);
            }
            object = elvis2;
            if (!(object.length() > 0)) break block18;
            PsiElement psiElement3 = replacement2;
            if (psiElement3 != null) {
                ReplaceCallFixKt.moveCaretToEnd(psiElement3, editor2, project2);
            }
        }
    }

    public ReplaceInfixOrOperatorCallFix(@NotNull KtExpression element3, boolean notNullNeeded, @NotNull String binaryOperatorName) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter((Object)binaryOperatorName, (String)"binaryOperatorName");
        super((PsiElement)element3);
        this.notNullNeeded = notNullNeeded;
        this.binaryOperatorName = binaryOperatorName;
    }

    public /* synthetic */ ReplaceInfixOrOperatorCallFix(KtExpression ktExpression, boolean bl, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string = "";
        }
        this(ktExpression, bl, string);
    }
}

