/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.refactoring.PackageWrapper;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.MoveHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.actions.internal.refactoringTesting.cases.FailedToRunCaseException;
import org.jetbrains.kotlin.idea.actions.internal.refactoringTesting.cases.RandomUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.move.MoveUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.MoveKotlinDeclarationsHandlerActions;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.ui.KotlinAwareMoveFilesOrDirectoriesModel;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.ui.MoveKotlinNestedClassesToUpperLevelModel;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.ui.MoveKotlinTopLevelDeclarationsModel;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtPureElement;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002J\u001c\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J2\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\n2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\u001a\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J8\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\n2\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u00062\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016JT\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001e2\u0006\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\u00132\b\u0010\"\u001a\u0004\u0018\u00010\u000b2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020$2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J4\u0010&\u001a\u00020\u001a2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020 2\u0006\u0010*\u001a\u00020 2\b\u0010+\u001a\u0004\u0018\u00010 H\u0016\u00a8\u0006,"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/MoveKotlinDeclarationsHandlerTestActions;", "Lorg/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/MoveKotlinDeclarationsHandlerActions;", "()V", "doWithMoveKotlinNestedClassesToUpperLevelModel", "", "nestedClass", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "targetContainer", "Lcom/intellij/psi/PsiElement;", "getSourceFiles", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "elementsToMove", "", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "invokeKotlinAwareMoveFilesOrDirectoriesRefactoring", "project", "Lcom/intellij/openapi/project/Project;", "initialDirectory", "Lcom/intellij/psi/PsiDirectory;", "elements", "Lcom/intellij/psi/PsiFileSystemItem;", "moveCallback", "Lcom/intellij/refactoring/move/MoveCallback;", "invokeKotlinSelectNestedClassChooser", "invokeMoveKotlinNestedClassesRefactoring", "", "originalClass", "targetClass", "invokeMoveKotlinTopLevelDeclarationsRefactoring", "", "targetPackageName", "", "targetDirectory", "targetFile", "freezeTargets", "", "moveToPackage", "showErrorHint", "editor", "Lcom/intellij/openapi/editor/Editor;", "message", "title", "helpId", "kotlin.idea"})
final class MoveKotlinDeclarationsHandlerTestActions
implements MoveKotlinDeclarationsHandlerActions {
    @Override
    public void invokeMoveKotlinTopLevelDeclarationsRefactoring(@NotNull Project project2, @NotNull Set<? extends KtNamedDeclaration> elementsToMove, @NotNull String targetPackageName, @Nullable PsiDirectory targetDirectory2, @Nullable KtFile targetFile2, boolean freezeTargets, boolean moveToPackage, @Nullable MoveCallback moveCallback) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter(elementsToMove, (String)"elementsToMove");
        Intrinsics.checkNotNullParameter((Object)targetPackageName, (String)"targetPackageName");
        List<KtFile> sourceFiles2 = this.getSourceFiles((Collection<? extends KtNamedDeclaration>)elementsToMove);
        Object object = targetFile2;
        if (object == null || (object = object.getVirtualFile()) == null || (object = object.getPath()) == null) {
            VirtualFile virtualFile2 = sourceFiles2.get(0).getVirtualFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"sourceFiles[0].virtualFile");
            VirtualFile virtualFile3 = virtualFile2.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile3, (String)"sourceFiles[0].virtualFile.parent");
            object = virtualFile3.getPath() + "/" + MoveUtilsKt.guessNewFileName((Collection<? extends KtNamedDeclaration>)elementsToMove);
        }
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"targetFile?.virtualFile?\u2026FileName(elementsToMove))");
        Object targetFilePath = object;
        MoveKotlinTopLevelDeclarationsModel model2 = new MoveKotlinTopLevelDeclarationsModel(project2, CollectionsKt.toList((Iterable)elementsToMove), targetPackageName, targetDirectory2, "Derived.kt", (String)targetFilePath, true, false, false, false, false, false, null);
        model2.computeModelResult(true).getProcessor().run();
    }

    /*
     * WARNING - void declaration
     */
    private final List<KtFile> getSourceFiles(Collection<? extends KtNamedDeclaration> elementsToMove) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = elementsToMove;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void obj;
            KtPureElement ktPureElement = (KtPureElement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            KtFile ktFile = obj.getContainingKtFile();
            collection.add(ktFile);
        }
        return CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
    }

    @Override
    public void invokeKotlinSelectNestedClassChooser(@NotNull KtClassOrObject nestedClass, @Nullable PsiElement targetContainer) {
        Intrinsics.checkNotNullParameter((Object)nestedClass, (String)"nestedClass");
        this.doWithMoveKotlinNestedClassesToUpperLevelModel(nestedClass, targetContainer);
    }

    private final void doWithMoveKotlinNestedClassesToUpperLevelModel(KtClassOrObject nestedClass, PsiElement targetContainer) {
        PsiElement newTarget;
        Object object;
        PsiElement psiElement2;
        KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)nestedClass));
        if (ktClassOrObject == null) {
            throw (Throwable)new FailedToRunCaseException();
        }
        KtClassOrObject outerClass = ktClassOrObject;
        PsiElement psiElement3 = targetContainer;
        if (psiElement3 == null) {
            psiElement3 = psiElement2 = (PsiElement)KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)outerClass));
        }
        if (psiElement3 == null) {
            PsiFile psiFile2;
            PsiFile it = psiFile2 = outerClass.getContainingFile();
            boolean bl = false;
            PsiFile psiFile3 = it;
            Intrinsics.checkNotNullExpressionValue((Object)psiFile3, (String)"it");
            PsiDirectory psiDirectory = psiFile3.getContainingDirectory();
            psiElement2 = (PsiElement)(psiDirectory != null ? (PsiFileSystemItem)psiDirectory : (PsiFileSystemItem)it);
        }
        if ((object = MoveUtilsKt.getTargetPackageFqName(newTarget = psiElement2)) == null || (object = object.asString()) == null) {
            object = "";
        }
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getTargetPackageFqName(n\u2026Target)?.asString() ?: \"\"");
        Object packageName2 = object;
        Project project2 = nestedClass.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"nestedClass.project");
        String string = nestedClass.getName();
        if (string == null) {
            string = "";
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"nestedClass.name ?: \"\"");
        MoveKotlinNestedClassesToUpperLevelModel model2 = new MoveKotlinNestedClassesToUpperLevelModel(nestedClass, newTarget, (String)packageName2, project2, nestedClass, newTarget, "", string, false, false, false, (String)packageName2, false){
            final /* synthetic */ KtClassOrObject $nestedClass;
            final /* synthetic */ PsiElement $newTarget;
            final /* synthetic */ String $packageName;

            @Nullable
            protected VirtualFile chooseSourceRoot(@NotNull PackageWrapper newPackage, @NotNull List<? extends VirtualFile> contentSourceRoots, @Nullable PsiDirectory initialDir) {
                Intrinsics.checkNotNullParameter((Object)newPackage, (String)"newPackage");
                Intrinsics.checkNotNullParameter(contentSourceRoots, (String)"contentSourceRoots");
                return (VirtualFile)CollectionsKt.firstOrNull(contentSourceRoots);
            }
            {
                this.$nestedClass = $captured_local_variable$0;
                this.$newTarget = $captured_local_variable$1;
                this.$packageName = $captured_local_variable$2;
                super($super_call_param$3, $super_call_param$4, $super_call_param$5, $super_call_param$6, $super_call_param$7, $super_call_param$8, $super_call_param$9, $super_call_param$10, $super_call_param$11, $super_call_param$12);
            }
        };
        model2.computeModelResult(true).getProcessor().run();
    }

    @Override
    public void invokeKotlinAwareMoveFilesOrDirectoriesRefactoring(@NotNull Project project2, @Nullable PsiDirectory initialDirectory, @NotNull List<? extends PsiFileSystemItem> elements2, @Nullable MoveCallback moveCallback) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter(elements2, (String)"elements");
        Object object = initialDirectory;
        if (object == null || (object = object.getVirtualFile()) == null || (object = object.getPath()) == null) {
            PsiFileSystemItem psiFileSystemItem = (PsiFileSystemItem)CollectionsKt.firstOrNull(elements2);
            object = psiFileSystemItem != null && (psiFileSystemItem = psiFileSystemItem.getContainingFile()) != null && (psiFileSystemItem = psiFileSystemItem.getVirtualFile()) != null ? psiFileSystemItem.getPath() : null;
        }
        if (object == null) {
            throw (Throwable)new NotImplementedError(null, 1, null);
        }
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"initialDirectory?.virtua\u2026row NotImplementedError()");
        Object targetPath = object;
        KotlinAwareMoveFilesOrDirectoriesModel model2 = new KotlinAwareMoveFilesOrDirectoriesModel(project2, elements2, RandomUtilsKt.randomDirectoryPathMutator((String)targetPath), RandomUtilsKt.randomBoolean(), RandomUtilsKt.randomBoolean(), null);
        String string = MoveHandler.getRefactoringName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"MoveHandler.getRefactoringName()");
        ApplicationUtilsKt.executeCommand$default(project2, string, null, (Function0)new Function0<Unit>(model2){
            final /* synthetic */ KotlinAwareMoveFilesOrDirectoriesModel $model;

            public final void invoke() {
                this.$model.computeModelResult().getProcessor().run();
            }
            {
                this.$model = kotlinAwareMoveFilesOrDirectoriesModel;
                super(0);
            }
        }, 2, null);
    }

    @NotNull
    public Void showErrorHint(@NotNull Project project2, @Nullable Editor editor2, @NotNull String message2, @NotNull String title, @Nullable String helpId) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        throw (Throwable)new NotImplementedError(null, 1, null);
    }

    @NotNull
    public Void invokeMoveKotlinNestedClassesRefactoring(@NotNull Project project2, @NotNull List<? extends KtClassOrObject> elementsToMove, @NotNull KtClassOrObject originalClass, @NotNull KtClassOrObject targetClass, @Nullable MoveCallback moveCallback) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter(elementsToMove, (String)"elementsToMove");
        Intrinsics.checkNotNullParameter((Object)originalClass, (String)"originalClass");
        Intrinsics.checkNotNullParameter((Object)targetClass, (String)"targetClass");
        throw (Throwable)new NotImplementedError(null, 1, null);
    }
}

