/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.idea.KotlinIdeaAnalysisBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.quickfix.AnnotationHostKind;
import org.jetbrains.kotlin.idea.quickfix.CaretBox;
import org.jetbrains.kotlin.idea.quickfix.KotlinSuppressIntentionActionKt;
import org.jetbrains.kotlin.idea.util.ModifierListModifactorKt;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtAnnotatedExpression;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFileAnnotationList;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\t\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\nB\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u000b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\fJ\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0005H\u0002J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J \u0010\u001b\u001a\u0004\u0018\u00010\u00192\u0006\u0010 \u001a\u00020!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00190#H\u0002J\b\u0010$\u001a\u00020\u0005H\u0016J\b\u0010%\u001a\u00020\u0005H\u0016J#\u0010&\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020\u000bH\u0096\u0002J\"\u0010*\u001a\u00020+2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020\u000bH\u0016J\u001a\u0010,\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u00052\b\b\u0002\u0010-\u001a\u00020+H\u0002J\u001e\u0010.\u001a\u00020\u00172\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u0002000/2\u0006\u0010\u001a\u001a\u00020\u0005H\u0002J\u001e\u00101\u001a\u00020\u00172\f\u00102\u001a\b\u0012\u0004\u0012\u00020\u00030/2\u0006\u0010\u001a\u001a\u00020\u0005H\u0002J\u0018\u00103\u001a\u00020\u00172\u0006\u00104\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u0005H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0011\u001a\u00070\u0012\u00a2\u0006\u0002\b\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/KotlinSuppressIntentionAction;", "Lcom/intellij/codeInspection/SuppressIntentionAction;", "suppressAt", "Lorg/jetbrains/kotlin/psi/KtExpression;", "suppressKey", "", "kind", "Lorg/jetbrains/kotlin/idea/quickfix/AnnotationHostKind;", "(Lorg/jetbrains/kotlin/psi/KtExpression;Ljava/lang/String;Lorg/jetbrains/kotlin/idea/quickfix/AnnotationHostKind;)V", "Lorg/jetbrains/kotlin/psi/KtFile;", "(Lorg/jetbrains/kotlin/psi/KtFile;Ljava/lang/String;Lorg/jetbrains/kotlin/idea/quickfix/AnnotationHostKind;)V", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/psi/PsiElement;Ljava/lang/String;Lorg/jetbrains/kotlin/idea/quickfix/AnnotationHostKind;)V", "pointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "getPointer", "()Lcom/intellij/psi/SmartPsiElementPointer;", "project", "Lcom/intellij/openapi/project/Project;", "Lorg/jetbrains/annotations/NotNull;", "getProject", "()Lcom/intellij/openapi/project/Project;", "addArgumentToSuppressAnnotation", "", "entry", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "id", "findSuppressAnnotation", "annotated", "Lorg/jetbrains/kotlin/psi/KtAnnotated;", "annotationList", "Lorg/jetbrains/kotlin/psi/KtFileAnnotationList;", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "annotationEntries", "", "getFamilyName", "getText", "invoke", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "isAvailable", "", "suppressAnnotationText", "withAt", "suppressAtAnnotatedExpression", "Lorg/jetbrains/kotlin/idea/quickfix/CaretBox;", "Lorg/jetbrains/kotlin/psi/KtAnnotatedExpression;", "suppressAtExpression", "caretBox", "suppressAtFile", "ktFile", "kotlin.core"})
public final class KotlinSuppressIntentionAction
extends SuppressIntentionAction {
    @NotNull
    private final SmartPsiElementPointer<PsiElement> pointer;
    @NotNull
    private final Project project;
    private final String suppressKey;
    private final AnnotationHostKind kind;

    @NotNull
    public final SmartPsiElementPointer<PsiElement> getPointer() {
        return this.pointer;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public String getFamilyName() {
        return KotlinIdeaAnalysisBundle.message("intention.suppress.family", new Object[0]);
    }

    @NotNull
    public String getText() {
        return KotlinIdeaAnalysisBundle.message("intention.suppress.text", this.suppressKey, this.kind.getKind(), this.kind.getName());
    }

    public boolean isAvailable(@NotNull Project project2, @Nullable Editor editor2, @NotNull PsiElement element3) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        return element3.isValid();
    }

    public void invoke(@NotNull Project project2, @Nullable Editor editor2, @NotNull PsiElement element3) {
        block4: {
            PsiElement psiElement2;
            String id;
            PsiElement suppressAt;
            block6: {
                block5: {
                    block3: {
                        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
                        if (!element3.isValid()) {
                            return;
                        }
                        PsiElement psiElement3 = this.pointer.getElement();
                        if (psiElement3 == null) {
                            return;
                        }
                        Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"pointer.element ?: return");
                        suppressAt = psiElement3;
                        if (!FileModificationService.getInstance().preparePsiElementForWrite(element3)) {
                            return;
                        }
                        id = "\"" + this.suppressKey + "\"";
                        psiElement2 = suppressAt;
                        if (!(psiElement2 instanceof KtModifierListOwner)) break block3;
                        ModifierListModifactorKt.addAnnotation((KtModifierListOwner)suppressAt, StandardNames.FqNames.suppress, id, this.kind.getNewLineNeeded() ? "\n" : " ", (Function1<? super KtAnnotationEntry, Boolean>)((Function1)new Function1<KtAnnotationEntry, Boolean>(this, id){
                            final /* synthetic */ KotlinSuppressIntentionAction this$0;
                            final /* synthetic */ String $id;

                            public final boolean invoke(@NotNull KtAnnotationEntry entry) {
                                Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
                                KotlinSuppressIntentionAction.access$addArgumentToSuppressAnnotation(this.this$0, entry, this.$id);
                                return true;
                            }
                            {
                                this.this$0 = kotlinSuppressIntentionAction;
                                this.$id = string;
                                super(1);
                            }
                        }));
                        break block4;
                    }
                    if (!(psiElement2 instanceof KtAnnotatedExpression)) break block5;
                    this.suppressAtAnnotatedExpression(new CaretBox<KtExpression>((KtExpression)suppressAt, editor2), id);
                    break block4;
                }
                if (!(psiElement2 instanceof KtExpression)) break block6;
                this.suppressAtExpression(new CaretBox<KtExpression>((KtExpression)suppressAt, editor2), id);
                break block4;
            }
            if (!(psiElement2 instanceof KtFile)) break block4;
            this.suppressAtFile((KtFile)suppressAt, id);
        }
    }

    private final void suppressAtFile(KtFile ktFile, String id) {
        KtPsiFactory psiFactory = new KtPsiFactory(this.project, false, 2, null);
        KtFileAnnotationList fileAnnotationList = ktFile.getFileAnnotationList();
        if (fileAnnotationList == null) {
            KtFileAnnotationList ktFileAnnotationList;
            KtFileAnnotationList newAnnotationList = psiFactory.createFileAnnotationListWithAnnotation(this.suppressAnnotationText(id, false));
            KtPackageDirective packageDirective = ktFile.getPackageDirective();
            if (packageDirective != null && Intrinsics.areEqual((Object)PsiTreeUtil.skipWhitespacesForward((PsiElement)((PsiElement)packageDirective)), (Object)ktFile.getImportList())) {
                PsiElement psiElement2 = ktFile.addBefore((PsiElement)newAnnotationList, (PsiElement)packageDirective);
                if (psiElement2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFileAnnotationList");
                }
                ktFileAnnotationList = (KtFileAnnotationList)psiElement2;
            } else {
                ktFileAnnotationList = PsiUtilsKt.replaceFileAnnotationList((KtFile)ktFile, (KtFileAnnotationList)newAnnotationList);
            }
            KtFileAnnotationList createAnnotationList = ktFileAnnotationList;
            ktFile.addAfter(KotlinSuppressIntentionActionKt.access$createWhiteSpace(psiFactory, this.kind), (PsiElement)createAnnotationList);
            return;
        }
        KtAnnotationEntry suppressAnnotation = this.findSuppressAnnotation(fileAnnotationList);
        if (suppressAnnotation == null) {
            KtAnnotationEntry newSuppressAnnotation = psiFactory.createFileAnnotation(this.suppressAnnotationText(id, false));
            fileAnnotationList.add(KotlinSuppressIntentionActionKt.access$createWhiteSpace(psiFactory, this.kind));
            PsiElement psiElement3 = fileAnnotationList.add((PsiElement)newSuppressAnnotation);
            if (psiElement3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtAnnotationEntry");
            }
            KtAnnotationEntry cfr_ignored_0 = (KtAnnotationEntry)psiElement3;
            return;
        }
        this.addArgumentToSuppressAnnotation(suppressAnnotation, id);
    }

    private final void suppressAtAnnotatedExpression(CaretBox<? extends KtAnnotatedExpression> suppressAt, String id) {
        KtAnnotationEntry entry = this.findSuppressAnnotation((KtAnnotated)suppressAt.getExpression());
        if (entry != null) {
            this.addArgumentToSuppressAnnotation(entry, id);
        } else {
            this.suppressAtExpression(suppressAt, id);
        }
    }

    private final void suppressAtExpression(CaretBox<? extends KtExpression> caretBox, String id) {
        boolean bl;
        KtExpression suppressAt = caretBox.getExpression();
        boolean bl2 = bl = !(suppressAt instanceof KtDeclaration);
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-KotlinSuppressIntentionAction$suppressAtExpression$22 = false;
            String $i$a$-assert-KotlinSuppressIntentionAction$suppressAtExpression$22 = "Declarations should have been checked for above";
            throw new AssertionError((Object)$i$a$-assert-KotlinSuppressIntentionAction$suppressAtExpression$22);
        }
        String placeholderText = "PLACEHOLDER_ID";
        KtExpression annotatedExpression = new KtPsiFactory((KtElement)suppressAt, false, 2, null).createExpression(KotlinSuppressIntentionAction.suppressAnnotationText$default(this, id, false, 2, null) + "\n" + placeholderText);
        PsiElement psiElement2 = suppressAt.copy();
        Intrinsics.checkNotNull((Object)psiElement2);
        PsiElement copy = psiElement2;
        PsiElement psiElement3 = suppressAt.replace((PsiElement)annotatedExpression);
        if (psiElement3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtAnnotatedExpression");
        }
        KtAnnotatedExpression afterReplace = (KtAnnotatedExpression)psiElement3;
        PsiElement psiElement4 = afterReplace.findElementAt(afterReplace.getTextLength() - 2);
        Intrinsics.checkNotNull((Object)psiElement4);
        Intrinsics.checkNotNullExpressionValue((Object)psiElement4, (String)"afterReplace.findElement\u2026Replace.textLength - 2)!!");
        PsiElement toReplace = psiElement4;
        boolean bl3 = Intrinsics.areEqual((Object)toReplace.getText(), (Object)placeholderText);
        if (_Assertions.ENABLED && !bl3) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        PsiElement psiElement5 = toReplace.replace(copy);
        Intrinsics.checkNotNull((Object)psiElement5);
        PsiElement result2 = psiElement5;
        caretBox.positionCaretInCopy(result2);
    }

    private final void addArgumentToSuppressAnnotation(KtAnnotationEntry entry, String id) {
        KtValueArgumentList args = entry.getValueArgumentList();
        KtPsiFactory psiFactory = new KtPsiFactory((KtElement)entry, false, 2, null);
        KtValueArgumentList newArgList = psiFactory.createCallArguments("(" + id + ")");
        if (args == null) {
            entry.addAfter((PsiElement)newArgList, entry.getLastChild());
        } else if (args.getArguments().isEmpty()) {
            args.replace((PsiElement)newArgList);
        } else {
            args.addArgument((KtValueArgument)newArgList.getArguments().get(0));
        }
    }

    private final String suppressAnnotationText(String id, boolean withAt) {
        return (withAt ? "@" : "") + StandardNames.FqNames.suppress.shortName() + "(" + id + ")";
    }

    static /* synthetic */ String suppressAnnotationText$default(KotlinSuppressIntentionAction kotlinSuppressIntentionAction, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return kotlinSuppressIntentionAction.suppressAnnotationText(string, bl);
    }

    private final KtAnnotationEntry findSuppressAnnotation(KtAnnotated annotated) {
        BindingContext context2 = ResolutionUtils.analyze$default((KtElement)annotated, null, 1, null);
        List list2 = annotated.getAnnotationEntries();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"annotated.annotationEntries");
        return this.findSuppressAnnotation(context2, list2);
    }

    private final KtAnnotationEntry findSuppressAnnotation(KtFileAnnotationList annotationList) {
        BindingContext context2 = ResolutionUtils.analyze$default((KtElement)annotationList, null, 1, null);
        List list2 = annotationList.getAnnotationEntries();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"annotationList.annotationEntries");
        return this.findSuppressAnnotation(context2, list2);
    }

    private final KtAnnotationEntry findSuppressAnnotation(BindingContext context2, List<? extends KtAnnotationEntry> annotationEntries) {
        Object v1;
        block1: {
            Iterable $this$firstOrNull$iv = annotationEntries;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                KtAnnotationEntry entry = (KtAnnotationEntry)element$iv;
                boolean bl = false;
                AnnotationDescriptor annotationDescriptor = (AnnotationDescriptor)context2.get((ReadOnlySlice)BindingContext.ANNOTATION, (Object)entry);
                if (!Intrinsics.areEqual((Object)(annotationDescriptor != null ? annotationDescriptor.getFqName() : null), (Object)StandardNames.FqNames.suppress)) continue;
                v1 = element$iv;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }

    private KotlinSuppressIntentionAction(PsiElement suppressAt, String suppressKey, AnnotationHostKind kind2) {
        this.suppressKey = suppressKey;
        this.kind = kind2;
        this.pointer = PsiUtilsKt.createSmartPointer((PsiElement)suppressAt);
        Project project2 = suppressAt.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"suppressAt.project");
        this.project = project2;
    }

    public KotlinSuppressIntentionAction(@NotNull KtExpression suppressAt, @NotNull String suppressKey, @NotNull AnnotationHostKind kind2) {
        Intrinsics.checkNotNullParameter((Object)suppressAt, (String)"suppressAt");
        Intrinsics.checkNotNullParameter((Object)suppressKey, (String)"suppressKey");
        Intrinsics.checkNotNullParameter((Object)kind2, (String)"kind");
        this((PsiElement)suppressAt, suppressKey, kind2);
    }

    public KotlinSuppressIntentionAction(@NotNull KtFile suppressAt, @NotNull String suppressKey, @NotNull AnnotationHostKind kind2) {
        Intrinsics.checkNotNullParameter((Object)suppressAt, (String)"suppressAt");
        Intrinsics.checkNotNullParameter((Object)suppressKey, (String)"suppressKey");
        Intrinsics.checkNotNullParameter((Object)kind2, (String)"kind");
        this((PsiElement)suppressAt, suppressKey, kind2);
    }

    public static final /* synthetic */ void access$addArgumentToSuppressAnnotation(KotlinSuppressIntentionAction $this, KtAnnotationEntry entry, String id) {
        $this.addArgumentToSuppressAnnotation(entry, id);
    }
}

