/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtIsExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtWhenConditionIsPattern;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0007\bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/IsEnumEntryFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "RemoveIsFix", "ReplaceWithComparisonFix", "kotlin.idea"})
public final class IsEnumEntryFactory
extends KotlinSingleIntentionActionFactory {
    @NotNull
    public static final IsEnumEntryFactory INSTANCE;

    @Override
    @Nullable
    protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
        KtTypeReference ktTypeReference;
        Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
        PsiElement $this$safeAs$iv = diagnostic.getPsiElement();
        boolean $i$f$safeAs = false;
        PsiElement psiElement2 = $this$safeAs$iv;
        if (!(psiElement2 instanceof KtTypeReference)) {
            psiElement2 = null;
        }
        if ((ktTypeReference = (KtTypeReference)psiElement2) == null || (ktTypeReference = ktTypeReference.getParent()) == null) {
            return null;
        }
        KtTypeReference element3 = ktTypeReference;
        KtTypeReference ktTypeReference2 = element3;
        return ktTypeReference2 instanceof KtIsExpression ? (IntentionAction)(((KtIsExpression)element3).getTypeReference() == null ? null : new ReplaceWithComparisonFix((KtIsExpression)element3)) : (ktTypeReference2 instanceof KtWhenConditionIsPattern ? (IntentionAction)(((KtWhenConditionIsPattern)element3).getTypeReference() == null || ((KtWhenConditionIsPattern)element3).isNegated() ? null : new RemoveIsFix((KtWhenConditionIsPattern)element3)) : null);
    }

    private IsEnumEntryFactory() {
    }

    static {
        IsEnumEntryFactory isEnumEntryFactory;
        INSTANCE = isEnumEntryFactory = new IsEnumEntryFactory();
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\u0006H\u0016J\b\u0010\b\u001a\u00020\u0006H\u0016J#\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0094\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/IsEnumEntryFactory$ReplaceWithComparisonFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtIsExpression;", "isExpression", "(Lorg/jetbrains/kotlin/psi/KtIsExpression;)V", "comparison", "", "getFamilyName", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "kotlin.idea"})
    private static final class ReplaceWithComparisonFix
    extends KotlinQuickFixAction<KtIsExpression> {
        private final String comparison;

        @NotNull
        public String getText() {
            return KotlinBundle.message("replace.with.0", this.comparison);
        }

        @NotNull
        public String getFamilyName() {
            return this.getText();
        }

        @Override
        protected void invoke(@NotNull Project project2, @Nullable Editor editor2, @NotNull KtFile file2) {
            block2: {
                Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                KtIsExpression ktIsExpression = (KtIsExpression)this.getElement();
                if (ktIsExpression == null || (ktIsExpression = ktIsExpression.getLeftHandSide()) == null) {
                    return;
                }
                Intrinsics.checkNotNullExpressionValue((Object)ktIsExpression, (String)"element?.leftHandSide ?: return");
                KtIsExpression leftHandSide = ktIsExpression;
                Object object = (KtIsExpression)this.getElement();
                if (object == null || (object = object.getTypeReference()) == null || (object = object.getText()) == null) {
                    return;
                }
                Object typeReference2 = object;
                KtExpression binaryExpression = CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)new KtPsiFactory(project2, false, 2, null), (String)("$0 " + this.comparison + " $1"), (Object[])new Object[]{leftHandSide, typeReference2}, (boolean)false, (int)4, null);
                KtIsExpression ktIsExpression2 = (KtIsExpression)this.getElement();
                if (ktIsExpression2 == null) break block2;
                ktIsExpression2.replace((PsiElement)binaryExpression);
            }
        }

        public ReplaceWithComparisonFix(@NotNull KtIsExpression isExpression) {
            Intrinsics.checkNotNullParameter((Object)isExpression, (String)"isExpression");
            super((PsiElement)isExpression);
            this.comparison = isExpression.isNegated() ? "!=" : "==";
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J#\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0094\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/IsEnumEntryFactory$RemoveIsFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtWhenConditionIsPattern;", "isPattern", "(Lorg/jetbrains/kotlin/psi/KtWhenConditionIsPattern;)V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "kotlin.idea"})
    private static final class RemoveIsFix
    extends KotlinQuickFixAction<KtWhenConditionIsPattern> {
        @NotNull
        public String getText() {
            return KotlinBundle.message("remove.expression", "is");
        }

        @NotNull
        public String getFamilyName() {
            return this.getText();
        }

        @Override
        protected void invoke(@NotNull Project project2, @Nullable Editor editor2, @NotNull KtFile file2) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                Object object = (KtWhenConditionIsPattern)this.getElement();
                if (object == null || (object = object.getTypeReference()) == null || (object = object.getText()) == null) {
                    return;
                }
                Object typeReference2 = object;
                KtWhenConditionIsPattern ktWhenConditionIsPattern = (KtWhenConditionIsPattern)this.getElement();
                if (ktWhenConditionIsPattern == null) break block1;
                ktWhenConditionIsPattern.replace((PsiElement)new KtPsiFactory(project2, false, 2, null).createWhenCondition((String)typeReference2));
            }
        }

        public RemoveIsFix(@NotNull KtWhenConditionIsPattern isPattern) {
            Intrinsics.checkNotNullParameter((Object)isPattern, (String)"isPattern");
            super((PsiElement)isPattern);
        }
    }
}

