/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.quickfix.ConvertClassToKClassFixKt;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeFactory;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeAttributes;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\u0011B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0016J#\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0094\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ConvertKClassToClassFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "Lcom/intellij/codeInsight/intention/HighPriorityAction;", "element", "(Lorg/jetbrains/kotlin/psi/KtExpression;)V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "Companion", "kotlin.idea"})
public final class ConvertKClassToClassFix
extends KotlinQuickFixAction<KtExpression>
implements HighPriorityAction {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getText() {
        return this.getFamilyName();
    }

    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message("convert.from.class.to.kclass", new Object[0]);
    }

    @Override
    protected void invoke(@NotNull Project project2, @Nullable Editor editor2, @NotNull KtFile file2) {
        PsiElement psiElement2;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        KtExpression ktExpression = (KtExpression)this.getElement();
        if (ktExpression == null) {
            return;
        }
        KtExpression element3 = ktExpression;
        KtExpression expressionToInsert = CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)new KtPsiFactory((KtElement)file2, false, 2, null), (String)"$0.java", (Object[])new Object[]{element3}, (boolean)false, (int)4, null);
        PsiElement $this$replaced$iv = (PsiElement)element3;
        boolean $i$f$replaced = false;
        if (Intrinsics.areEqual((Object)$this$replaced$iv, (Object)((PsiElement)expressionToInsert))) {
            psiElement2 = (PsiElement)expressionToInsert;
        } else {
            PsiElement result$iv = $this$replaced$iv.replace((PsiElement)expressionToInsert);
            PsiElement psiElement3 = result$iv;
            if (!(psiElement3 instanceof KtExpression)) {
                psiElement3 = null;
            }
            if ((psiElement2 = (PsiElement)((KtExpression)psiElement3)) == null) {
                PsiElement psiElement4 = result$iv;
                if (psiElement4 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                }
                KtExpression ktExpression2 = ((KtParenthesizedExpression)psiElement4).getExpression();
                if (ktExpression2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                }
                psiElement2 = (PsiElement)ktExpression2;
            }
        }
    }

    public ConvertKClassToClassFix(@NotNull KtExpression element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        super((PsiElement)element3);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ConvertKClassToClassFix$Companion;", "", "()V", "create", "Lorg/jetbrains/kotlin/idea/quickfix/ConvertKClassToClassFix;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "expectedType", "Lorg/jetbrains/kotlin/types/KotlinType;", "expressionType", "diagnosticElement", "Lorg/jetbrains/kotlin/psi/KtExpression;", "kotlin.idea"})
    public static final class Companion {
        @Nullable
        public final ConvertKClassToClassFix create(@NotNull KtFile file2, @NotNull KotlinType expectedType, @NotNull KotlinType expressionType, @NotNull KtExpression diagnosticElement) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Intrinsics.checkNotNullParameter((Object)expectedType, (String)"expectedType");
            Intrinsics.checkNotNullParameter((Object)expressionType, (String)"expressionType");
            Intrinsics.checkNotNullParameter((Object)diagnosticElement, (String)"diagnosticElement");
            ClassifierDescriptor classifierDescriptor = expressionType.getConstructor().getDeclarationDescriptor();
            if (!(classifierDescriptor instanceof ClassDescriptor)) {
                classifierDescriptor = null;
            }
            ClassDescriptor classDescriptor = (ClassDescriptor)classifierDescriptor;
            if (classDescriptor == null) {
                return null;
            }
            ClassDescriptor expressionClassDescriptor = classDescriptor;
            if (!KotlinBuiltIns.isKClass((ClassDescriptor)expressionClassDescriptor) || !ConvertClassToKClassFixKt.isJClass(expectedType)) {
                return null;
            }
            TypeProjection typeProjection = (TypeProjection)CollectionsKt.firstOrNull((List)expressionType.getArguments());
            if (typeProjection == null || (typeProjection = typeProjection.getType()) == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)typeProjection, (String)"expressionType.arguments\u2026ll()?.type ?: return null");
            TypeProjection expressionTypeArgument = typeProjection;
            Object object = CollectionsKt.singleOrNull((Iterable)ResolutionUtils.resolveImportReference(file2, ConvertClassToKClassFixKt.getJAVA_LANG_CLASS_FQ_NAME()));
            if (!(object instanceof ClassDescriptor)) {
                object = null;
            }
            ClassDescriptor classDescriptor2 = (ClassDescriptor)object;
            if (classDescriptor2 == null) {
                return null;
            }
            ClassDescriptor javaLangClassDescriptor = classDescriptor2;
            SimpleType javaLangClassType = KotlinTypeFactory.simpleNotNullType((TypeAttributes)TypeAttributes.Companion.getEmpty(), (ClassDescriptor)javaLangClassDescriptor, (List)CollectionsKt.listOf((Object)new TypeProjectionImpl((KotlinType)expressionTypeArgument)));
            if (TypeUtilsKt.isSubtypeOf((KotlinType)((KotlinType)javaLangClassType), (KotlinType)expectedType)) {
                return new ConvertKClassToClassFix(diagnosticElement);
            }
            return null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

