/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters1;
import org.jetbrains.kotlin.diagnostics.UnboundDiagnostic;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.resolve.konan.diagnostics.ErrorsNative;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00122\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0012B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016J#\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0094\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddExceptionToThrowsFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "element", "argumentClassFqName", "Lorg/jetbrains/kotlin/name/FqName;", "(Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;Lorg/jetbrains/kotlin/name/FqName;)V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "Companion", "kotlin.idea"})
public final class AddExceptionToThrowsFix
extends KotlinQuickFixAction<KtAnnotationEntry> {
    private final FqName argumentClassFqName;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getText() {
        return KotlinBundle.message("fix.add.exception.to.throws", this.argumentClassFqName.shortName().asString() + "::class");
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @Override
    protected void invoke(@NotNull Project project2, @Nullable Editor editor2, @NotNull KtFile file2) {
        KtValueArgument added;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        KtAnnotationEntry ktAnnotationEntry = (KtAnnotationEntry)this.getElement();
        if (ktAnnotationEntry == null) {
            return;
        }
        KtAnnotationEntry annotationEntry2 = ktAnnotationEntry;
        KtPsiFactory psiFactory = new KtPsiFactory((KtElement)annotationEntry2, false, 2, null);
        String argumentText2 = this.argumentClassFqName.asString() + "::class";
        KtValueArgumentList ktValueArgumentList = annotationEntry2.getValueArgumentList();
        KtValueArgument ktValueArgument = added = ktValueArgumentList != null ? ktValueArgumentList.addArgument(psiFactory.createArgument(argumentText2)) : null;
        if (added != null) {
            ShortenReferences.process$default(ShortenReferences.DEFAULT, (KtElement)added, null, 2, null);
        }
    }

    public AddExceptionToThrowsFix(@NotNull KtAnnotationEntry element3, @NotNull FqName argumentClassFqName) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter((Object)argumentClassFqName, (String)"argumentClassFqName");
        super((PsiElement)element3);
        this.argumentClassFqName = argumentClassFqName;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddExceptionToThrowsFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "kotlin.idea"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactory {
        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
            PsiElement psiElement2 = diagnostic.getPsiElement();
            if (!(psiElement2 instanceof KtAnnotationEntry)) {
                psiElement2 = null;
            }
            KtAnnotationEntry ktAnnotationEntry = (KtAnnotationEntry)psiElement2;
            if (ktAnnotationEntry == null) {
                return null;
            }
            KtAnnotationEntry annotationEntry2 = ktAnnotationEntry;
            KtValueArgumentList ktValueArgumentList = annotationEntry2.getValueArgumentList();
            if (ktValueArgumentList == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)ktValueArgumentList, (String)"annotationEntry.valueArg\u2026           ?: return null");
            KtValueArgumentList valueArgumentsList = ktValueArgumentList;
            List list2 = valueArgumentsList.getArguments();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"valueArgumentsList.arguments");
            KtValueArgument ktValueArgument = (KtValueArgument)CollectionsKt.firstOrNull((List)list2);
            if ((ktValueArgument != null ? ktValueArgument.getArgumentName() : null) != null) {
                return null;
            }
            DiagnosticFactory diagnosticFactory = diagnostic.getFactory();
            if (!Intrinsics.areEqual((Object)diagnosticFactory, (Object)ErrorsNative.MISSING_EXCEPTION_IN_THROWS_ON_SUSPEND)) {
                return null;
            }
            FqName fqName2 = (FqName)((DiagnosticWithParameters1)ErrorsNative.MISSING_EXCEPTION_IN_THROWS_ON_SUSPEND.cast((UnboundDiagnostic)diagnostic)).getA();
            Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"when (diagnostic.factory\u2026return null\n            }");
            FqName missingExceptionFqName = fqName2;
            return new AddExceptionToThrowsFix(annotationEntry2, missingExceptionFqName);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

