/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.quickfix.AddAnnotationTargetFixKt;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.util.ExpectActualUtilKt;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0010B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J#\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0094\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddAnnotationTargetFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "annotationEntry", "(Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;)V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "Companion", "kotlin.idea"})
public final class AddAnnotationTargetFix
extends KotlinQuickFixAction<KtAnnotationEntry> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getText() {
        return KotlinBundle.message("fix.add.annotation.target", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @Override
    protected void invoke(@NotNull Project project2, @Nullable Editor editor2, @NotNull KtFile file2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        KtAnnotationEntry ktAnnotationEntry = (KtAnnotationEntry)this.getElement();
        if (ktAnnotationEntry == null) {
            return;
        }
        KtAnnotationEntry annotationEntry2 = ktAnnotationEntry;
        KtClass ktClass2 = AddAnnotationTargetFix.Companion.toAnnotationClass(annotationEntry2);
        if (ktClass2 == null) {
            return;
        }
        KtClass annotationClass = ktClass2;
        List requiredAnnotationTargets = AddAnnotationTargetFixKt.access$getRequiredAnnotationTargets(annotationEntry2, annotationClass, project2);
        if (requiredAnnotationTargets.isEmpty()) {
            return;
        }
        KtPsiFactory psiFactory = new KtPsiFactory((KtElement)annotationEntry2, false, 2, null);
        ExpectActualUtilKt.runOnExpectAndAllActuals$default((KtDeclaration)annotationClass, false, true, (Function1)new Function1<KtDeclaration, Unit>(requiredAnnotationTargets, psiFactory){
            final /* synthetic */ List $requiredAnnotationTargets;
            final /* synthetic */ KtPsiFactory $psiFactory;

            public final void invoke(@NotNull KtDeclaration it) {
                block1: {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    KtDeclaration $this$safeAs$iv = it;
                    boolean $i$f$safeAs = false;
                    KtDeclaration ktDeclaration = $this$safeAs$iv;
                    if (!(ktDeclaration instanceof KtClass)) {
                        ktDeclaration = null;
                    }
                    KtClass ktClass2 = (KtClass)ktDeclaration;
                    if (ktClass2 == null) break block1;
                    AddAnnotationTargetFixKt.access$addAnnotationTargets(ktClass2, this.$requiredAnnotationTargets, this.$psiFactory);
                }
            }
            {
                this.$requiredAnnotationTargets = list2;
                this.$psiFactory = ktPsiFactory;
                super(1);
            }
        }, 1, null);
    }

    public AddAnnotationTargetFix(@NotNull KtAnnotationEntry annotationEntry2) {
        Intrinsics.checkNotNullParameter((Object)annotationEntry2, (String)"annotationEntry");
        super((PsiElement)annotationEntry2);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u000e\u0010\b\u001a\u0004\u0018\u00010\t*\u00020\u0005H\u0002\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddAnnotationTargetFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "toAnnotationClass", "Lorg/jetbrains/kotlin/psi/KtClass;", "kotlin.idea"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactory {
        private final KtClass toAnnotationClass(KtAnnotationEntry $this$toAnnotationClass) {
            Object object;
            BindingContext context2 = ResolutionUtils.analyze((KtElement)$this$toAnnotationClass, BodyResolveMode.PARTIAL);
            AnnotationDescriptor annotationDescriptor = (AnnotationDescriptor)context2.get((ReadOnlySlice)BindingContext.ANNOTATION, (Object)$this$toAnnotationClass);
            if (annotationDescriptor == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)annotationDescriptor, (String)"context[BindingContext.A\u2026ION, this] ?: return null");
            AnnotationDescriptor annotationDescriptor2 = annotationDescriptor;
            ClassifierDescriptor classifierDescriptor = annotationDescriptor2.getType().getConstructor().getDeclarationDescriptor();
            if (classifierDescriptor == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)classifierDescriptor, (String)"annotationDescriptor.typ\u2026Descriptor ?: return null");
            ClassifierDescriptor annotationTypeDescriptor = classifierDescriptor;
            PsiElement psiElement2 = DescriptorToSourceUtils.descriptorToDeclaration((DeclarationDescriptor)((DeclarationDescriptor)annotationTypeDescriptor));
            if (!(psiElement2 instanceof KtClass)) {
                psiElement2 = null;
            }
            KtClass ktClass2 = (KtClass)psiElement2;
            if (ktClass2 != null) {
                KtClass ktClass3;
                KtClass it = ktClass3 = ktClass2;
                boolean bl = false;
                object = it.isAnnotation() && it.isWritable() ? ktClass3 : null;
            } else {
                object = null;
            }
            return object;
        }

        @Override
        @Nullable
        protected KotlinQuickFixAction<KtAnnotationEntry> createAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
            if (Intrinsics.areEqual((Object)diagnostic.getFactory(), (Object)Errors.WRONG_ANNOTATION_TARGET) ^ true && Intrinsics.areEqual((Object)diagnostic.getFactory(), (Object)Errors.WRONG_ANNOTATION_TARGET_WITH_USE_SITE_TARGET) ^ true) {
                return null;
            }
            PsiElement psiElement2 = diagnostic.getPsiElement();
            if (!(psiElement2 instanceof KtAnnotationEntry)) {
                psiElement2 = null;
            }
            KtAnnotationEntry ktAnnotationEntry = (KtAnnotationEntry)psiElement2;
            if (ktAnnotationEntry == null) {
                return null;
            }
            KtAnnotationEntry entry = ktAnnotationEntry;
            KtClass ktClass2 = this.toAnnotationClass(entry);
            if (ktClass2 == null) {
                return null;
            }
            KtClass annotationClass = ktClass2;
            if (entry.getUseSiteTarget() != null) {
                Project project2 = entry.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"entry.project");
                if (AddAnnotationTargetFixKt.access$getRequiredAnnotationTargets(entry, annotationClass, project2).isEmpty()) {
                    return null;
                }
            }
            return new AddAnnotationTargetFix(entry);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

