/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.model.SideEffectGuard;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.core.formatter.KotlinCodeStyleSettings;
import org.jetbrains.kotlin.idea.formatter.CodeStyleUtilsKt;
import org.jetbrains.kotlin.idea.formatter.trailingComma.UtilKt;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingIntention;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000bH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/TrailingCommaIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingIntention;", "Lorg/jetbrains/kotlin/psi/KtElement;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "()V", "applyTo", "", "element", "editor", "Lcom/intellij/openapi/editor/Editor;", "isApplicableTo", "", "caretOffset", "", "startInWriteAction", "kotlin.idea"})
public final class TrailingCommaIntention
extends SelfTargetingIntention<KtElement>
implements LowPriorityAction {
    @Override
    public void applyTo(@NotNull KtElement element3, @Nullable Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        SideEffectGuard.checkSideEffectAllowed((SideEffectGuard.EffectType)SideEffectGuard.EffectType.SETTINGS);
        KtFile ktFile = element3.getContainingKtFile();
        Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"element.containingKtFile");
        KotlinCodeStyleSettings kotlinCustomSettings = CodeStyleUtilsKt.getKotlinCustomSettings((PsiFile)ktFile);
        kotlinCustomSettings.ALLOW_TRAILING_COMMA = !kotlinCustomSettings.ALLOW_TRAILING_COMMA;
        CodeStyleSettingsManager.getInstance((Project)element3.getProject()).notifyCodeStyleSettingsChanged();
    }

    @Override
    public boolean isApplicableTo(@NotNull KtElement element3, int caretOffset) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        boolean it = bl = UtilKt.canAddTrailingCommaWithRegistryCheck((PsiElement)element3);
        boolean bl2 = false;
        Integer n = 1;
        int it2 = ((Number)n).intValue();
        boolean bl3 = false;
        KtFile ktFile = element3.getContainingKtFile();
        Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"element.containingKtFile");
        Integer n2 = CodeStyleUtilsKt.getKotlinCustomSettings((PsiFile)((PsiFile)ktFile)).ALLOW_TRAILING_COMMA ? n : null;
        int actionNumber = n2 != null ? n2 : 0;
        this.setTextGetter(KotlinBundle.lazyMessage("intention.trailing.comma.custom.text", actionNumber));
        return bl;
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    public TrailingCommaIntention() {
        super(KtElement.class, KotlinBundle.lazyMessage("intention.trailing.comma.text", new Object[0]), null, 4, null);
    }
}

