/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ExtendedResolutionApiKt;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingRangeIntention;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtContainerNode;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.error.ErrorUtils;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u001a\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u0018\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/RemoveExplicitSuperQualifierIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingRangeIntention;", "Lorg/jetbrains/kotlin/psi/KtSuperExpression;", "()V", "applicabilityRange", "Lcom/intellij/openapi/util/TextRange;", "element", "applyTo", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "toNonQualified", "superExpression", "reformat", "", "kotlin.idea"})
public final class RemoveExplicitSuperQualifierIntention
extends SelfTargetingRangeIntention<KtSuperExpression> {
    @Override
    @Nullable
    public TextRange applicabilityRange(@NotNull KtSuperExpression element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        if (element3.getSuperTypeQualifier() == null) {
            return null;
        }
        KtQualifiedExpression ktQualifiedExpression = KtPsiUtilKt.getQualifiedExpressionForReceiver((KtExpression)((KtExpression)element3));
        if (ktQualifiedExpression == null) {
            return null;
        }
        KtQualifiedExpression qualifiedExpression = ktQualifiedExpression;
        KtExpression ktExpression = qualifiedExpression.getSelectorExpression();
        if (ktExpression == null) {
            return null;
        }
        KtExpression selector2 = ktExpression;
        BindingContext bindingContext2 = ResolutionUtils.analyze((KtElement)selector2, BodyResolveMode.PARTIAL_WITH_CFA);
        if (CallUtilKt.getResolvedCall((KtElement)((KtElement)selector2), (BindingContext)bindingContext2) == null) {
            return null;
        }
        KtExpression ktExpression2 = CreateByPatternKt.createExpressionByPattern((KtPsiFactory)new KtPsiFactory((KtElement)element3, false, 2, null), (String)"$0.$1", (Object[])new Object[]{this.toNonQualified(element3, false), selector2}, (boolean)false);
        if (ktExpression2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtQualifiedExpression");
        }
        KtQualifiedExpression newQualifiedExpression = (KtQualifiedExpression)ktExpression2;
        BindingContext newBindingContext = ExtendedResolutionApiKt.analyzeAsReplacement$default((KtExpression)newQualifiedExpression, (KtExpression)qualifiedExpression, bindingContext2, null, null, null, 28, null);
        ResolvedCall resolvedCall2 = CallUtilKt.getResolvedCall((KtElement)((KtElement)newQualifiedExpression.getSelectorExpression()), (BindingContext)newBindingContext);
        if (resolvedCall2 == null) {
            return null;
        }
        ResolvedCall newResolvedCall = resolvedCall2;
        if (ErrorUtils.isError((DeclarationDescriptor)((DeclarationDescriptor)newResolvedCall.getResultingDescriptor()))) {
            return null;
        }
        KtReferenceExpression ktReferenceExpression = element3.getInstanceReference();
        Intrinsics.checkNotNullExpressionValue((Object)ktReferenceExpression, (String)"element.instanceReference");
        KtContainerNode ktContainerNode = element3.getLabelQualifier();
        return new TextRange(PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)ktReferenceExpression)), ktContainerNode != null ? PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)ktContainerNode)) : PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)element3)));
    }

    @Override
    public void applyTo(@NotNull KtSuperExpression element3, @Nullable Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        element3.replace((PsiElement)this.toNonQualified(element3, true));
    }

    private final KtSuperExpression toNonQualified(KtSuperExpression superExpression, boolean reformat) {
        KtPsiFactory factory2 = new KtPsiFactory((KtElement)superExpression, false, 2, null);
        Name labelName2 = superExpression.getLabelNameAsName();
        KtExpression ktExpression = labelName2 != null ? CreateByPatternKt.createExpressionByPattern((KtPsiFactory)factory2, (String)"super@$0", (Object[])new Object[]{labelName2}, (boolean)reformat) : factory2.createExpression("super");
        if (ktExpression == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtSuperExpression");
        }
        return (KtSuperExpression)ktExpression;
    }

    public RemoveExplicitSuperQualifierIntention() {
        super(KtSuperExpression.class, KotlinBundle.lazyMessage("remove.explicit.supertype.qualification", new Object[0]), null, 4, null);
    }
}

