/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.idea.KotlinIdeaAnalysisBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.FrontendIndependentPsiUtilsKt;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingIntention;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.idea.references.ReadWriteAccessCheckerKt;
import org.jetbrains.kotlin.idea.util.CommentSaver;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.BuilderByPattern;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtLoopExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi2ir.KotlinUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.util.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.resolve.references.ReferenceAccess;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \r2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/OperatorToFunctionIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingIntention;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "()V", "applyTo", "", "element", "editor", "Lcom/intellij/openapi/editor/Editor;", "isApplicableTo", "", "caretOffset", "", "Companion", "kotlin.core"})
public final class OperatorToFunctionIntention
extends SelfTargetingIntention<KtExpression> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    public boolean isApplicableTo(@NotNull KtExpression element3, int caretOffset) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        KtExpression ktExpression = element3;
        return ktExpression instanceof KtUnaryExpression ? OperatorToFunctionIntention.Companion.isApplicableUnary((KtUnaryExpression)element3, caretOffset) : (ktExpression instanceof KtBinaryExpression ? OperatorToFunctionIntention.Companion.isApplicableBinary((KtBinaryExpression)element3, caretOffset) : (ktExpression instanceof KtArrayAccessExpression ? OperatorToFunctionIntention.Companion.isApplicableArrayAccess((KtArrayAccessExpression)element3, caretOffset) : (ktExpression instanceof KtCallExpression ? OperatorToFunctionIntention.Companion.isApplicableCall((KtCallExpression)element3, caretOffset) : false)));
    }

    @Override
    public void applyTo(@NotNull KtExpression element3, @Nullable Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Companion.convert(element3);
    }

    public OperatorToFunctionIntention() {
        super(KtExpression.class, KotlinIdeaAnalysisBundle.lazyMessage("replace.overloaded.operator.with.function.call", new Object[0]), null, 4, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0007\u001a\u00020\u0005J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u000fH\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0012\u001a\u00020\u0005H\u0002J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\tH\u0002J\u0010\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\u0005H\u0002J\u0010\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001f\u001a\u00020 \u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/OperatorToFunctionIntention$Companion;", "", "()V", "convert", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "element", "convertArrayAccess", "Lorg/jetbrains/kotlin/psi/KtArrayAccessExpression;", "convertBinary", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "convertCall", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "convertUnary", "Lorg/jetbrains/kotlin/psi/KtUnaryExpression;", "convertUnaryWithAssignFix", "findCallName", "result", "isApplicableArrayAccess", "", "caretOffset", "", "isApplicableBinary", "isApplicableCall", "isApplicableUnary", "isAssignmentLeftSide", "isUsedAsExpression", "parentIsUsedAsExpression", "Lcom/intellij/psi/PsiElement;", "replaceExplicitInvokeCallWithImplicit", "qualifiedExpression", "Lorg/jetbrains/kotlin/psi/KtDotQualifiedExpression;", "kotlin.core"})
    public static final class Companion {
        @Nullable
        public final KtExpression replaceExplicitInvokeCallWithImplicit(@NotNull KtDotQualifiedExpression qualifiedExpression) {
            KtExpression ktExpression;
            boolean $i$f$replaced;
            PsiElement $this$replaced$iv;
            KtExpression selectorInReceiver;
            KtExpression receiverExpression;
            KtCallExpression ktCallExpression;
            Intrinsics.checkNotNullParameter((Object)qualifiedExpression, (String)"qualifiedExpression");
            KtExpression $this$safeAs$iv = qualifiedExpression.getSelectorExpression();
            boolean $i$f$safeAs = false;
            KtExpression ktExpression2 = $this$safeAs$iv;
            if (!(ktExpression2 instanceof KtCallExpression)) {
                ktExpression2 = null;
            }
            if ((ktCallExpression = (KtCallExpression)ktExpression2) == null || (ktCallExpression = (KtCallExpression)FrontendIndependentPsiUtilsKt.copied((PsiElement)ktCallExpression)) == null) {
                return null;
            }
            KtCallExpression callExpression2 = ktCallExpression;
            KtExpression ktExpression3 = callExpression2.getCalleeExpression();
            if (ktExpression3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtNameReferenceExpression");
            }
            KtNameReferenceExpression calleExpression = (KtNameReferenceExpression)ktExpression3;
            KtExpression $this$safeAs$iv2 = receiverExpression = qualifiedExpression.getReceiverExpression();
            boolean $i$f$safeAs2 = false;
            KtExpression ktExpression4 = $this$safeAs$iv2;
            if (!(ktExpression4 instanceof KtDotQualifiedExpression)) {
                ktExpression4 = null;
            }
            KtDotQualifiedExpression ktDotQualifiedExpression = (KtDotQualifiedExpression)ktExpression4;
            Object object = selectorInReceiver = ktDotQualifiedExpression != null ? ktDotQualifiedExpression.getSelectorExpression() : null;
            if (selectorInReceiver instanceof KtNameReferenceExpression) {
                PsiElement psiElement2;
                calleExpression.rawReplace(FrontendIndependentPsiUtilsKt.copied((PsiElement)selectorInReceiver));
                ((KtNameReferenceExpression)selectorInReceiver).rawReplace((PsiElement)callExpression2);
                $this$replaced$iv = (PsiElement)qualifiedExpression;
                $i$f$replaced = false;
                if (Intrinsics.areEqual((Object)$this$replaced$iv, (Object)((PsiElement)receiverExpression))) {
                    psiElement2 = (PsiElement)receiverExpression;
                } else {
                    PsiElement result$iv = $this$replaced$iv.replace((PsiElement)receiverExpression);
                    PsiElement psiElement3 = result$iv;
                    if (!(psiElement3 instanceof KtExpression)) {
                        psiElement3 = null;
                    }
                    if ((psiElement2 = (PsiElement)((KtExpression)psiElement3)) == null) {
                        PsiElement psiElement4 = result$iv;
                        if (psiElement4 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                        }
                        KtExpression ktExpression5 = ((KtParenthesizedExpression)psiElement4).getExpression();
                        if (ktExpression5 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                        }
                        psiElement2 = (PsiElement)ktExpression5;
                    }
                }
                ktExpression = (KtExpression)psiElement2;
            } else {
                PsiElement psiElement5;
                if ((receiverExpression instanceof KtCallExpression || receiverExpression instanceof KtDotQualifiedExpression) && callExpression2.getValueArgumentList() == null && callExpression2.getTypeArgumentList() == null) {
                    calleExpression.replace((PsiElement)receiverExpression);
                } else {
                    calleExpression.rawReplace((PsiElement)receiverExpression);
                }
                $this$replaced$iv = (PsiElement)qualifiedExpression;
                $i$f$replaced = false;
                if (Intrinsics.areEqual((Object)$this$replaced$iv, (Object)((PsiElement)callExpression2))) {
                    psiElement5 = (PsiElement)callExpression2;
                } else {
                    PsiElement result$iv = $this$replaced$iv.replace((PsiElement)callExpression2);
                    PsiElement psiElement6 = result$iv;
                    if (!(psiElement6 instanceof KtCallExpression)) {
                        psiElement6 = null;
                    }
                    if ((psiElement5 = (PsiElement)((KtCallExpression)psiElement6)) == null) {
                        PsiElement psiElement7 = result$iv;
                        if (psiElement7 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                        }
                        KtExpression ktExpression6 = ((KtParenthesizedExpression)psiElement7).getExpression();
                        if (ktExpression6 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtCallExpression");
                        }
                        psiElement5 = (PsiElement)((KtCallExpression)ktExpression6);
                    }
                }
                ktExpression = (KtExpression)psiElement5;
            }
            return ktExpression;
        }

        private final boolean isApplicableUnary(KtUnaryExpression element3, int caretOffset) {
            if (element3.getBaseExpression() == null) {
                return false;
            }
            KtSimpleNameExpression ktSimpleNameExpression = element3.getOperationReference();
            Intrinsics.checkNotNullExpressionValue((Object)ktSimpleNameExpression, (String)"element.operationReference");
            KtSimpleNameExpression opRef = ktSimpleNameExpression;
            if (!opRef.getTextRange().containsOffset(caretOffset)) {
                return false;
            }
            IElementType iElementType = opRef.getReferencedNameElementType();
            return Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.PLUS) || Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.MINUS) || Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EXCL) ? true : (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.PLUSPLUS) || Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.MINUSMINUS) ? !this.isUsedAsExpression((KtExpression)element3) : false);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isUsedAsExpression(KtExpression element3) {
            PsiElement parent2 = element3.getParent();
            if (parent2 instanceof KtBlockExpression) {
                if (!Intrinsics.areEqual((Object)KtPsiUtilKt.lastBlockStatementOrThis((KtExpression)((KtExpression)parent2)), (Object)element3)) return false;
                PsiElement psiElement2 = ((KtBlockExpression)parent2).getParent();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"parent.parent");
                if (!this.parentIsUsedAsExpression(psiElement2)) return false;
                return true;
            }
            PsiElement psiElement3 = parent2;
            Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"parent");
            boolean bl = this.parentIsUsedAsExpression(psiElement3);
            return bl;
        }

        private final boolean parentIsUsedAsExpression(PsiElement element3) {
            PsiElement parent2 = element3.getParent();
            return parent2 instanceof KtLoopExpression || parent2 instanceof KtFile ? false : (parent2 instanceof KtIfExpression || parent2 instanceof KtWhenExpression ? BindingContextUtilsKt.isUsedAsExpression((KtElement)((KtElement)((KtExpression)parent2)), (BindingContext)ResolutionUtils.analyze((KtElement)parent2, BodyResolveMode.PARTIAL_WITH_CFA)) : true);
        }

        private final boolean isApplicableBinary(KtBinaryExpression element3, int caretOffset) {
            boolean bl;
            block9: {
                if (element3.getLeft() == null || element3.getRight() == null) {
                    return false;
                }
                KtOperationReferenceExpression ktOperationReferenceExpression = element3.getOperationReference();
                Intrinsics.checkNotNullExpressionValue((Object)ktOperationReferenceExpression, (String)"element.operationReference");
                KtOperationReferenceExpression opRef = ktOperationReferenceExpression;
                if (!opRef.getTextRange().containsOffset(caretOffset)) {
                    return false;
                }
                IElementType iElementType = opRef.getReferencedNameElementType();
                if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.PLUS) || Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.MINUS) || Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.MUL) || Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.DIV) || Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.PERC) || Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.RANGE) || Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.IN_KEYWORD) || Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.NOT_IN) || Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.PLUSEQ) || Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.MINUSEQ) || Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.MULTEQ) || Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.DIVEQ) || Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.PERCEQ) || Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.GT) || Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.LT) || Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.GTEQ) || Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.LTEQ)) {
                    bl = true;
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EQEQ) || Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EXCLEQ)) {
                    Iterable $this$none$iv = CollectionsKt.listOf((Object[])new KtExpression[]{element3.getLeft(), element3.getRight()});
                    boolean $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$none$iv) {
                            KtExpression it = (KtExpression)element$iv;
                            boolean bl2 = false;
                            KtExpression ktExpression = it;
                            if (!Intrinsics.areEqual((Object)(ktExpression != null && (ktExpression = ktExpression.getNode()) != null ? ktExpression.getElementType() : null), (Object)KtNodeTypes.NULL)) continue;
                            bl = false;
                            break block9;
                        }
                        bl = true;
                    }
                } else {
                    bl = Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EQ) ? element3.getLeft() instanceof KtArrayAccessExpression : false;
                }
            }
            return bl;
        }

        private final boolean isApplicableArrayAccess(KtArrayAccessExpression element3, int caretOffset) {
            PsiElement psiElement2 = element3.getLeftBracket();
            if (psiElement2 == null) {
                return false;
            }
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"element.leftBracket ?: return false");
            PsiElement lbracket = psiElement2;
            PsiElement psiElement3 = element3.getRightBracket();
            if (psiElement3 == null) {
                return false;
            }
            Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"element.rightBracket ?: return false");
            PsiElement rbracket = psiElement3;
            ReferenceAccess access = ReadWriteAccessCheckerKt.readWriteAccess((KtExpression)((KtExpression)element3), (boolean)true);
            if (access == ReferenceAccess.READ_WRITE) {
                return false;
            }
            return lbracket.getTextRange().containsOffset(caretOffset) || rbracket.getTextRange().containsOffset(caretOffset);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isApplicableCall(KtCallExpression element3, int caretOffset) {
            ResolvedCall<? extends CallableDescriptor> resolvedCall2;
            UserDataHolder userDataHolder;
            KtValueArgumentList ktValueArgumentList = element3.getValueArgumentList();
            if (ktValueArgumentList != null && (ktValueArgumentList = ktValueArgumentList.getLeftParenthesis()) != null) {
                userDataHolder = (UserDataHolder)ktValueArgumentList;
            } else {
                List list2 = element3.getLambdaArguments();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"element.lambdaArguments");
                KtLambdaArgument ktLambdaArgument = (KtLambdaArgument)CollectionsKt.firstOrNull((List)list2);
                userDataHolder = (UserDataHolder)(ktLambdaArgument != null && (ktLambdaArgument = ktLambdaArgument.getLambdaExpression()) != null ? ktLambdaArgument.getLeftCurlyBrace() : null);
            }
            if (userDataHolder == null) {
                return false;
            }
            if (userDataHolder == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.psi.PsiElement");
            }
            PsiElement lbrace = (PsiElement)userDataHolder;
            if (!lbrace.getTextRange().containsOffset(caretOffset)) {
                return false;
            }
            ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2 = ResolutionUtils.resolveToCall((KtElement)element3, BodyResolveMode.FULL);
            CallableDescriptor descriptor2 = resolvedCall3 != null ? resolvedCall3.getResultingDescriptor() : null;
            if (!(descriptor2 instanceof FunctionDescriptor)) return false;
            if (!Intrinsics.areEqual((Object)descriptor2.getName(), (Object)OperatorNameConventions.INVOKE)) return false;
            if (element3.getParent() instanceof KtDotQualifiedExpression) {
                KtExpression ktExpression = element3.getCalleeExpression();
                if (Intrinsics.areEqual((Object)(ktExpression != null ? ktExpression.getText() : null), (Object)OperatorNameConventions.INVOKE.asString())) {
                    return false;
                }
            }
            if (element3.getValueArgumentList() != null) return true;
            List list3 = element3.getLambdaArguments();
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"element.lambdaArguments");
            Collection collection = list3;
            if (collection.isEmpty()) return false;
            return true;
        }

        private final KtExpression convertUnary(KtUnaryExpression element3) {
            Name name2;
            IElementType iElementType = element3.getOperationReference().getReferencedNameElementType();
            if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.PLUSPLUS) || Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.MINUSMINUS)) {
                return this.convertUnaryWithAssignFix(element3);
            }
            if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.PLUS)) {
                name2 = OperatorNameConventions.UNARY_PLUS;
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.MINUS)) {
                name2 = OperatorNameConventions.UNARY_MINUS;
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EXCL)) {
                name2 = OperatorNameConventions.NOT;
            } else {
                return (KtExpression)element3;
            }
            Name operatorName = name2;
            KtPsiFactory ktPsiFactory = new KtPsiFactory((KtElement)element3, false, 2, null);
            Object[] objectArray = new Object[2];
            KtExpression ktExpression = element3.getBaseExpression();
            Intrinsics.checkNotNull((Object)ktExpression);
            Intrinsics.checkNotNullExpressionValue((Object)ktExpression, (String)"element.baseExpression!!");
            objectArray[0] = ktExpression;
            objectArray[1] = operatorName;
            KtExpression transformed2 = CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)ktPsiFactory, (String)"$0.$1()", (Object[])objectArray, (boolean)false, (int)4, null);
            PsiElement psiElement2 = element3.replace((PsiElement)transformed2);
            if (psiElement2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
            }
            return (KtExpression)psiElement2;
        }

        private final KtExpression convertUnaryWithAssignFix(KtUnaryExpression element3) {
            Name name2;
            IElementType iElementType = element3.getOperationReference().getReferencedNameElementType();
            if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.PLUSPLUS)) {
                name2 = OperatorNameConventions.INC;
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.MINUSMINUS)) {
                name2 = OperatorNameConventions.DEC;
            } else {
                return (KtExpression)element3;
            }
            Name operatorName = name2;
            KtPsiFactory ktPsiFactory = new KtPsiFactory((KtElement)element3, false, 2, null);
            Object[] objectArray = new Object[2];
            KtExpression ktExpression = element3.getBaseExpression();
            Intrinsics.checkNotNull((Object)ktExpression);
            Intrinsics.checkNotNullExpressionValue((Object)ktExpression, (String)"element.baseExpression!!");
            objectArray[0] = ktExpression;
            objectArray[1] = operatorName;
            KtExpression transformed2 = CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)ktPsiFactory, (String)"$0 = $0.$1()", (Object[])objectArray, (boolean)false, (int)4, null);
            PsiElement psiElement2 = element3.replace((PsiElement)transformed2);
            if (psiElement2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
            }
            return (KtExpression)psiElement2;
        }

        private final KtExpression convertBinary(KtBinaryExpression element3) {
            String string;
            IElementType op = element3.getOperationReference().getReferencedNameElementType();
            KtExpression ktExpression = element3.getLeft();
            Intrinsics.checkNotNull((Object)ktExpression);
            Intrinsics.checkNotNullExpressionValue((Object)ktExpression, (String)"element.left!!");
            KtExpression left = ktExpression;
            KtExpression ktExpression2 = element3.getRight();
            Intrinsics.checkNotNull((Object)ktExpression2);
            Intrinsics.checkNotNullExpressionValue((Object)ktExpression2, (String)"element.right!!");
            KtExpression right2 = ktExpression2;
            if (Intrinsics.areEqual((Object)op, (Object)KtTokens.EQ)) {
                if (left instanceof KtArrayAccessExpression) {
                    this.convertArrayAccess((KtArrayAccessExpression)left);
                }
                return (KtExpression)element3;
            }
            BindingContext context2 = ResolutionUtils.analyze((KtElement)element3, BodyResolveMode.PARTIAL);
            ResolvedCall functionCandidate = CallUtilKt.getResolvedCall((KtElement)((KtElement)element3), (BindingContext)context2);
            ResolvedCall resolvedCall2 = functionCandidate;
            String functionName = String.valueOf(resolvedCall2 != null && (resolvedCall2 = resolvedCall2.getCandidateDescriptor()) != null ? resolvedCall2.getName() : null);
            KotlinType elemType = context2.getType(left);
            IElementType iElementType = op;
            if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.PLUS)) {
                string = "$0.plus($1)";
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.MINUS)) {
                string = "$0.minus($1)";
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.MUL)) {
                string = "$0.times($1)";
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.DIV)) {
                string = "$0.div($1)";
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.PERC)) {
                string = "$0.rem($1)";
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.RANGE)) {
                string = "$0.rangeTo($1)";
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.IN_KEYWORD)) {
                string = "$1.contains($0)";
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.NOT_IN)) {
                string = "!$1.contains($0)";
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.PLUSEQ)) {
                string = Intrinsics.areEqual((Object)functionName, (Object)"plusAssign") ? "$0.plusAssign($1)" : "$0 = $0.plus($1)";
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.MINUSEQ)) {
                string = Intrinsics.areEqual((Object)functionName, (Object)"minusAssign") ? "$0.minusAssign($1)" : "$0 = $0.minus($1)";
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.MULTEQ)) {
                string = Intrinsics.areEqual((Object)functionName, (Object)"timesAssign") ? "$0.timesAssign($1)" : "$0 = $0.times($1)";
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.DIVEQ)) {
                string = Intrinsics.areEqual((Object)functionName, (Object)"divAssign") ? "$0.divAssign($1)" : "$0 = $0.div($1)";
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.PERCEQ)) {
                boolean remSupported = PlatformKt.getLanguageVersionSettings((PsiElement)element3).supportsFeature(LanguageFeature.OperatorRem);
                string = remSupported && Intrinsics.areEqual((Object)functionName, (Object)"remAssign") ? "$0.remAssign($1)" : (Intrinsics.areEqual((Object)functionName, (Object)"modAssign") ? "$0.modAssign($1)" : (remSupported ? "$0 = $0.rem($1)" : "$0 = $0.mod($1)"));
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EQEQ)) {
                KotlinType kotlinType = elemType;
                string = kotlinType == null || kotlinType.isMarkedNullable() ? "$0?.equals($1) ?: ($1 == null)" : "$0.equals($1)";
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EXCLEQ)) {
                KotlinType kotlinType = elemType;
                string = kotlinType == null || kotlinType.isMarkedNullable() ? "!($0?.equals($1) ?: ($1 == null))" : "!$0.equals($1)";
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.GT)) {
                string = "$0.compareTo($1) > 0";
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.LT)) {
                string = "$0.compareTo($1) < 0";
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.GTEQ)) {
                string = "$0.compareTo($1) >= 0";
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.LTEQ)) {
                string = "$0.compareTo($1) <= 0";
            } else {
                return (KtExpression)element3;
            }
            String pattern2 = string;
            KtExpression transformed2 = CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)new KtPsiFactory((KtElement)element3, false, 2, null), (String)pattern2, (Object[])new Object[]{left, right2}, (boolean)false, (int)4, null);
            PsiElement psiElement2 = element3.replace((PsiElement)transformed2);
            if (psiElement2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
            }
            return (KtExpression)psiElement2;
        }

        /*
         * WARNING - void declaration
         */
        private final KtExpression convertArrayAccess(KtArrayAccessExpression element3) {
            void expressionToReplace;
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            objectRef.element = (KtExpression)element3;
            KtExpression transformed2 = CreateByPatternKt.buildExpression$default((KtPsiFactory)new KtPsiFactory((KtElement)element3, false, 2, null), (boolean)false, (Function1)((Function1)new Function1<BuilderByPattern<KtExpression>, Unit>(element3, (Ref.ObjectRef)expressionToReplace){
                final /* synthetic */ KtArrayAccessExpression $element;
                final /* synthetic */ Ref.ObjectRef $expressionToReplace;

                public final void invoke(@NotNull BuilderByPattern<KtExpression> $this$buildExpression) {
                    Intrinsics.checkNotNullParameter($this$buildExpression, (String)"$receiver");
                    $this$buildExpression.appendExpression(this.$element.getArrayExpression());
                    $this$buildExpression.appendFixedText(".");
                    if (org.jetbrains.kotlin.idea.intentions.OperatorToFunctionIntention$Companion.access$isAssignmentLeftSide(OperatorToFunctionIntention.Companion, this.$element)) {
                        PsiElement parent2;
                        PsiElement psiElement2 = parent2 = this.$element.getParent();
                        if (psiElement2 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBinaryExpression");
                        }
                        this.$expressionToReplace.element = (KtExpression)((KtBinaryExpression)psiElement2);
                        $this$buildExpression.appendFixedText("set(");
                        List list2 = this.$element.getIndexExpressions();
                        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"element.indexExpressions");
                        BuilderByPattern.appendExpressions$default($this$buildExpression, (Iterable)list2, null, (int)2, null);
                        $this$buildExpression.appendFixedText(",");
                        $this$buildExpression.appendExpression(((KtBinaryExpression)parent2).getRight());
                    } else {
                        $this$buildExpression.appendFixedText("get(");
                        List list3 = this.$element.getIndexExpressions();
                        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"element.indexExpressions");
                        BuilderByPattern.appendExpressions$default($this$buildExpression, (Iterable)list3, null, (int)2, null);
                    }
                    $this$buildExpression.appendFixedText(")");
                }
                {
                    this.$element = ktArrayAccessExpression;
                    this.$expressionToReplace = objectRef;
                    super(1);
                }
            }), (int)1, null);
            PsiElement psiElement2 = ((KtExpression)expressionToReplace.element).replace((PsiElement)transformed2);
            if (psiElement2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
            }
            return (KtExpression)psiElement2;
        }

        private final boolean isAssignmentLeftSide(KtArrayAccessExpression element3) {
            PsiElement parent2 = element3.getParent();
            return parent2 instanceof KtBinaryExpression && Intrinsics.areEqual((Object)((KtBinaryExpression)parent2).getOperationReference().getReferencedNameElementType(), (Object)KtTokens.EQ) && Intrinsics.areEqual((Object)element3, (Object)((KtBinaryExpression)parent2).getLeft());
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        private final KtExpression convertCall(KtCallExpression element) {
            v0 = element.getCalleeExpression();
            Intrinsics.checkNotNull((Object)v0);
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"element.calleeExpression!!");
            callee = v0;
            v1 = element.getParent();
            if (v1 == null) ** GOTO lbl-1000
            $this$safeAs$iv = v1;
            $i$f$safeAs = false;
            v2 = $this$safeAs$iv;
            if (!(v2 instanceof KtQualifiedExpression)) {
                v2 = null;
            }
            if ((v1 = (KtQualifiedExpression)v2) != null) {
                v3 = v1.getReceiverExpression();
            } else lbl-1000:
            // 2 sources

            {
                v3 = null;
            }
            receiver = v3;
            isAnonymousFunctionWithReceiver = receiver != null && KotlinUtilsKt.deparenthesize((KtElement)((KtElement)callee)) instanceof KtNamedFunction != false;
            argumentsList = element.getValueArgumentList();
            v4 /* !! */  = argumentsList;
            if (v4 /* !! */  == null || (v4 /* !! */  = v4 /* !! */ .getText()) == null || (v4 /* !! */  = StringsKt.removeSurrounding((String)v4 /* !! */ , (CharSequence)"(", (CharSequence)")")) == null) {
                v4 /* !! */  = argumentString /* !! */  = "";
            }
            if (isAnonymousFunctionWithReceiver) {
                v5 /* !! */  = receiver;
                if (v5 /* !! */  == null || (v5 /* !! */  = v5 /* !! */ .getText()) == null) {
                    v5 /* !! */  = "";
                }
                delimiter = (var10_10 = (CharSequence)(receiverText /* !! */  = v5 /* !! */ )).length() > 0 != false && (var10_10 = (CharSequence)argumentString /* !! */ ).length() > 0 != false ? ", " : "";
                v6 /* !! */  = (String)receiverText /* !! */  + delimiter + (String)argumentString /* !! */ ;
            } else {
                v6 /* !! */  = argumentString /* !! */ ;
            }
            argumentsWithReceiverIfNeeded /* !! */  = v6 /* !! */ ;
            v7 = element.getLambdaArguments();
            Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"element.lambdaArguments");
            funcLitArgs = v7;
            calleeText = callee.getText();
            transformation = calleeText + "." + OperatorNameConventions.INVOKE.asString() + "(" + (String)argumentsWithReceiverIfNeeded /* !! */  + ")";
            transformed = new KtPsiFactory((KtElement)element, false, 2, null).createExpression(transformation);
            v8 = PsiUtilsKt.getCalleeExpressionIfAny((KtElement)((KtElement)transformed));
            v9 /* !! */  = v8 != null ? v8.getParent() : null;
            if (!(v9 /* !! */  instanceof KtCallExpression)) {
                v9 /* !! */  = null;
            }
            if ((callExpression = (KtCallExpression)v9 /* !! */ ) != null && (var13_15 = (Collection)funcLitArgs).isEmpty() == false) {
                $this$forEach$iv = funcLitArgs;
                $i$f$forEach = false;
                var15_17 = $this$forEach$iv.iterator();
                while (var15_17.hasNext()) {
                    element$iv = var15_17.next();
                    it = (KtLambdaArgument)element$iv;
                    $i$a$-forEach-OperatorToFunctionIntention$Companion$convertCall$1 = false;
                    callExpression.add((PsiElement)it);
                }
                $this$forEach$iv = (CharSequence)argumentsWithReceiverIfNeeded /* !! */ ;
                if ($this$forEach$iv.length() == 0) {
                    v10 = callExpression.getValueArgumentList();
                    if (v10 != null) {
                        v10.delete();
                    }
                }
            }
            elementToReplace = isAnonymousFunctionWithReceiver != false ? element.getParent() : callee.getParent();
            v11 = elementToReplace.replace((PsiElement)transformed);
            if (v11 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
            }
            return (KtExpression)v11;
        }

        @NotNull
        public final Pair<KtExpression, KtSimpleNameExpression> convert(@NotNull KtExpression element3) {
            KtExpression ktExpression;
            Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
            KtExpression elementToBeReplaced = element3;
            if (element3 instanceof KtArrayAccessExpression && this.isAssignmentLeftSide((KtArrayAccessExpression)element3)) {
                PsiElement psiElement2 = ((KtArrayAccessExpression)element3).getParent();
                if (psiElement2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                }
                elementToBeReplaced = (KtExpression)psiElement2;
            }
            CommentSaver commentSaver = new CommentSaver((PsiElement)elementToBeReplaced, true);
            KtExpression ktExpression2 = element3;
            if (ktExpression2 instanceof KtUnaryExpression) {
                ktExpression = this.convertUnary((KtUnaryExpression)element3);
            } else if (ktExpression2 instanceof KtBinaryExpression) {
                ktExpression = this.convertBinary((KtBinaryExpression)element3);
            } else if (ktExpression2 instanceof KtArrayAccessExpression) {
                ktExpression = this.convertArrayAccess((KtArrayAccessExpression)element3);
            } else if (ktExpression2 instanceof KtCallExpression) {
                ktExpression = this.convertCall((KtCallExpression)element3);
            } else {
                throw (Throwable)new IllegalArgumentException(element3.toString());
            }
            KtExpression result2 = ktExpression;
            CommentSaver.restore$default(commentSaver, (PsiElement)result2, false, 2, null);
            KtSimpleNameExpression ktSimpleNameExpression = this.findCallName(result2);
            if (ktSimpleNameExpression == null) {
                String string = "No call name found in " + result2.getText();
                throw new IllegalStateException(string.toString());
            }
            KtSimpleNameExpression callName = ktSimpleNameExpression;
            return TuplesKt.to((Object)result2, (Object)callName);
        }

        private final KtSimpleNameExpression findCallName(KtExpression result2) {
            KtSimpleNameExpression ktSimpleNameExpression;
            KtExpression ktExpression = result2;
            if (ktExpression instanceof KtBinaryExpression) {
                if (KtPsiUtil.isAssignment((PsiElement)((PsiElement)result2))) {
                    KtExpression ktExpression2 = ((KtBinaryExpression)result2).getRight();
                    Intrinsics.checkNotNull((Object)ktExpression2);
                    Intrinsics.checkNotNullExpressionValue((Object)ktExpression2, (String)"result.right!!");
                    ktSimpleNameExpression = this.findCallName(ktExpression2);
                } else {
                    KtExpression ktExpression3 = ((KtBinaryExpression)result2).getLeft();
                    Intrinsics.checkNotNull((Object)ktExpression3);
                    Intrinsics.checkNotNullExpressionValue((Object)ktExpression3, (String)"result.left!!");
                    ktSimpleNameExpression = this.findCallName(ktExpression3);
                }
            } else if (ktExpression instanceof KtUnaryExpression) {
                KtExpression ktExpression4 = ((KtUnaryExpression)result2).getBaseExpression();
                if (ktExpression4 != null) {
                    KtExpression ktExpression5;
                    KtExpression it = ktExpression5 = ktExpression4;
                    boolean bl = false;
                    KtExpression ktExpression6 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)ktExpression6, (String)"it");
                    ktSimpleNameExpression = Companion.findCallName(ktExpression6);
                } else {
                    ktSimpleNameExpression = null;
                }
            } else if (ktExpression instanceof KtParenthesizedExpression) {
                KtExpression ktExpression7 = ((KtParenthesizedExpression)result2).getExpression();
                if (ktExpression7 != null) {
                    KtExpression ktExpression8;
                    KtExpression it = ktExpression8 = ktExpression7;
                    boolean bl = false;
                    KtExpression ktExpression9 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)ktExpression9, (String)"it");
                    ktSimpleNameExpression = Companion.findCallName(ktExpression9);
                } else {
                    ktSimpleNameExpression = null;
                }
            } else {
                ktSimpleNameExpression = (KtSimpleNameExpression)KtPsiUtilKt.getQualifiedElementSelector((KtElement)((KtElement)result2));
            }
            return ktSimpleNameExpression;
        }

        private Companion() {
        }

        public static final /* synthetic */ boolean access$isAssignmentLeftSide(Companion $this, KtArrayAccessExpression element3) {
            return $this.isAssignmentLeftSide(element3);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

