/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ExtendedResolutionApiKt;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.intentions.ConvertConcatenationToBuildStringIntention;
import org.jetbrains.kotlin.idea.intentions.ConvertConcatenationToBuildStringIntentionKt;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingIntention;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.BuilderByPattern;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateEntryWithExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0012\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e*\u00020\u0002H\u0002J\f\u0010\u0010\u001a\u00020\u0005*\u00020\u000fH\u0002J\f\u0010\u0011\u001a\u00020\n*\u00020\u0012H\u0002J\f\u0010\u0013\u001a\u00020\n*\u00020\u0012H\u0002J\u0012\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00120\u000e*\u00020\u000fH\u0002\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ConvertConcatenationToBuildStringIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingIntention;", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "()V", "applyTo", "", "element", "editor", "Lcom/intellij/openapi/editor/Editor;", "isApplicableTo", "", "caretOffset", "", "allExpressions", "", "Lorg/jetbrains/kotlin/psi/KtExpression;", "deleteTailComments", "isConcatenation", "Lcom/intellij/psi/PsiElement;", "isWhiteSpaceWithLineBreak", "tailComments", "kotlin.idea"})
public final class ConvertConcatenationToBuildStringIntention
extends SelfTargetingIntention<KtBinaryExpression> {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isApplicableTo(@NotNull KtBinaryExpression element3, int caretOffset) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        if (!this.isConcatenation((PsiElement)element3)) return false;
        PsiElement psiElement2 = element3.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"element.parent");
        if (this.isConcatenation(psiElement2)) return false;
        if (ConvertConcatenationToBuildStringIntentionKt.mustBeConstant((KtExpression)element3)) return false;
        return true;
    }

    @Override
    public void applyTo(@NotNull KtBinaryExpression element3, @Nullable Editor editor2) {
        PsiElement psiElement2;
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        KtExpression buildStringCall2 = CreateByPatternKt.buildExpression$default((KtPsiFactory)new KtPsiFactory((KtElement)element3, false, 2, null), (boolean)false, (Function1)((Function1)new Function1<BuilderByPattern<KtExpression>, Unit>(this, element3){
            final /* synthetic */ ConvertConcatenationToBuildStringIntention this$0;
            final /* synthetic */ KtBinaryExpression $element;

            public final void invoke(@NotNull BuilderByPattern<KtExpression> $this$buildExpression) {
                Intrinsics.checkNotNullParameter($this$buildExpression, (String)"$receiver");
                $this$buildExpression.appendFixedText("kotlin.text.buildString {\n");
                Iterable $this$forEach$iv = ConvertConcatenationToBuildStringIntention.access$allExpressions(this.this$0, this.$element);
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    KtExpression expression2 = (KtExpression)element$iv;
                    boolean bl = false;
                    $this$buildExpression.appendFixedText("append(");
                    if (expression2 instanceof KtStringTemplateExpression) {
                        Object[] objectArray = ((KtStringTemplateExpression)expression2).getEntries();
                        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"expression.entries");
                        KtStringTemplateEntry singleEntry = (KtStringTemplateEntry)ArraysKt.singleOrNull((Object[])objectArray);
                        if (singleEntry instanceof KtStringTemplateEntryWithExpression) {
                            $this$buildExpression.appendExpression(((KtStringTemplateEntryWithExpression)singleEntry).getExpression());
                        } else {
                            String string = ((KtStringTemplateExpression)expression2).getText();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"expression.text");
                            $this$buildExpression.appendNonFormattedText(string);
                        }
                    } else {
                        $this$buildExpression.appendExpression(expression2);
                    }
                    $this$buildExpression.appendFixedText(")");
                    List tailComments2 = ConvertConcatenationToBuildStringIntention.access$tailComments(this.this$0, expression2);
                    Collection collection = tailComments2;
                    if (!collection.isEmpty()) {
                        $this$buildExpression.appendFixedText(" ");
                        Iterable $this$forEach$iv2 = tailComments2;
                        boolean $i$f$forEach2 = false;
                        for (T element$iv2 : $this$forEach$iv2) {
                            PsiElement it = (PsiElement)element$iv2;
                            boolean bl2 = false;
                            String string = it.getText();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.text");
                            $this$buildExpression.appendNonFormattedText(string);
                        }
                    }
                    $this$buildExpression.appendFixedText("\n");
                }
                $this$buildExpression.appendFixedText("}");
            }
            {
                this.this$0 = convertConcatenationToBuildStringIntention;
                this.$element = ktBinaryExpression;
                super(1);
            }
        }), (int)1, null);
        this.deleteTailComments((KtExpression)element3);
        PsiElement $this$replaced$iv = (PsiElement)element3;
        boolean $i$f$replaced = false;
        if (Intrinsics.areEqual((Object)$this$replaced$iv, (Object)((PsiElement)buildStringCall2))) {
            psiElement2 = (PsiElement)buildStringCall2;
        } else {
            PsiElement result$iv = $this$replaced$iv.replace((PsiElement)buildStringCall2);
            PsiElement psiElement3 = result$iv;
            if (!(psiElement3 instanceof KtExpression)) {
                psiElement3 = null;
            }
            if ((psiElement2 = (PsiElement)((KtExpression)psiElement3)) == null) {
                PsiElement psiElement4 = result$iv;
                if (psiElement4 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                }
                KtExpression ktExpression = ((KtParenthesizedExpression)psiElement4).getExpression();
                if (ktExpression == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                }
                psiElement2 = (PsiElement)ktExpression;
            }
        }
        KtExpression replaced2 = (KtExpression)psiElement2;
        ShortenReferences.process$default(ShortenReferences.DEFAULT, (KtElement)replaced2, null, 2, null);
    }

    private final boolean isConcatenation(PsiElement $this$isConcatenation) {
        if (!($this$isConcatenation instanceof KtBinaryExpression)) {
            return false;
        }
        if (Intrinsics.areEqual((Object)((KtBinaryExpression)$this$isConcatenation).getOperationToken(), (Object)KtTokens.PLUS) ^ true) {
            return false;
        }
        KotlinType kotlinType = CallUtilKt.getType((KtExpression)((KtExpression)$this$isConcatenation), (BindingContext)ExtendedResolutionApiKt.safeAnalyzeNonSourceRootCode((KtElement)$this$isConcatenation, BodyResolveMode.PARTIAL));
        if (kotlinType == null) {
            return false;
        }
        KotlinType type2 = kotlinType;
        return KotlinBuiltIns.isString((KotlinType)type2);
    }

    private final List<KtExpression> allExpressions(KtBinaryExpression $this$allExpressions) {
        List expressions2 = new ArrayList();
        var $fun$collect$1 = new Function1<KtExpression, Unit>(expressions2){
            final /* synthetic */ List $expressions;

            public final void invoke(@Nullable KtExpression expression2) {
                block1: {
                    KtExpression ktExpression;
                    block0: {
                        ktExpression = expression2;
                        if (!(ktExpression instanceof KtBinaryExpression)) break block0;
                        this.invoke(((KtBinaryExpression)expression2).getLeft());
                        this.invoke(((KtBinaryExpression)expression2).getRight());
                        break block1;
                    }
                    if (!(ktExpression instanceof KtExpression)) break block1;
                    this.$expressions.add(expression2);
                }
            }
            {
                this.$expressions = list2;
                super(1);
            }
        };
        $fun$collect$1.invoke((KtExpression)$this$allExpressions);
        return expressions2;
    }

    private final List<PsiElement> tailComments(KtExpression $this$tailComments) {
        List list2;
        boolean bl;
        Sequence tailElements2;
        block6: {
            Sequence $this$any$iv = tailElements2 = SequencesKt.dropWhile((Sequence)SequencesKt.takeWhile((Sequence)PsiTreeUtilKt.getNextLeafs((PsiElement)((PsiElement)$this$tailComments)), (Function1)tailComments.tailElements.1.INSTANCE), (Function1)tailComments.tailElements.2.INSTANCE);
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                PsiElement it = (PsiElement)element$iv;
                boolean bl2 = false;
                if (!(it instanceof PsiComment)) continue;
                bl = true;
                break block6;
            }
            bl = false;
        }
        if (bl) {
            List $this$dropLastWhile$iv = SequencesKt.toList((Sequence)tailElements2);
            boolean $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    PsiElement it = (PsiElement)iterator$iv.previous();
                    boolean bl3 = false;
                    if (it instanceof PsiWhiteSpace) continue;
                    list2 = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list2 = CollectionsKt.emptyList();
            }
        } else {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    private final void deleteTailComments(KtExpression $this$deleteTailComments) {
        Sequence $this$forEach$iv = SequencesKt.filter((Sequence)SequencesKt.takeWhile((Sequence)PsiTreeUtilKt.siblings$default((PsiElement)((PsiElement)$this$deleteTailComments), (boolean)false, (boolean)false, (int)1, null), (Function1)((Function1)new Function1<PsiElement, Boolean>(this){
            final /* synthetic */ ConvertConcatenationToBuildStringIntention this$0;

            public final boolean invoke(@NotNull PsiElement it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return !ConvertConcatenationToBuildStringIntention.access$isWhiteSpaceWithLineBreak(this.this$0, it);
            }
            {
                this.this$0 = convertConcatenationToBuildStringIntention;
                super(1);
            }
        })), (Function1)deleteTailComments.2.INSTANCE);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PsiElement it = (PsiElement)element$iv;
            boolean bl = false;
            it.delete();
        }
    }

    private final boolean isWhiteSpaceWithLineBreak(PsiElement $this$isWhiteSpaceWithLineBreak) {
        return $this$isWhiteSpaceWithLineBreak instanceof PsiWhiteSpace && $this$isWhiteSpaceWithLineBreak.textContains('\n');
    }

    public ConvertConcatenationToBuildStringIntention() {
        super(KtBinaryExpression.class, KotlinBundle.lazyMessage("convert.concatenation.to.build.string", new Object[0]), null, 4, null);
    }

    public static final /* synthetic */ List access$allExpressions(ConvertConcatenationToBuildStringIntention $this, KtBinaryExpression $this$access_u24allExpressions) {
        return $this.allExpressions($this$access_u24allExpressions);
    }

    public static final /* synthetic */ List access$tailComments(ConvertConcatenationToBuildStringIntention $this, KtExpression $this$access_u24tailComments) {
        return $this.tailComments($this$access_u24tailComments);
    }

    public static final /* synthetic */ boolean access$isWhiteSpaceWithLineBreak(ConvertConcatenationToBuildStringIntention $this, PsiElement $this$access_u24isWhiteSpaceWithLineBreak) {
        return $this.isWhiteSpaceWithLineBreak($this$access_u24isWhiteSpaceWithLineBreak);
    }
}

