/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.inspections.AbstractApplicabilityBasedInspection;
import org.jetbrains.kotlin.idea.util.ExpressionExtKt;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIsExpression;
import org.jetbrains.kotlin.psi.KtOperationExpression;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTypeReference;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u00152\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0003J\"\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u0002H\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/SimplifyNegatedBinaryExpressionInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractApplicabilityBasedInspection;", "Lorg/jetbrains/kotlin/psi/KtPrefixExpression;", "()V", "defaultFixText", "", "getDefaultFixText", "()Ljava/lang/String;", "applyTo", "", "element", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "fixText", "inspectionHighlightRangeInElement", "Lcom/intellij/openapi/util/TextRange;", "inspectionText", "isApplicable", "", "Companion", "kotlin.idea"})
public final class SimplifyNegatedBinaryExpressionInspection
extends AbstractApplicabilityBasedInspection<KtPrefixExpression> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public TextRange inspectionHighlightRangeInElement(@NotNull KtPrefixExpression element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        KtSimpleNameExpression ktSimpleNameExpression = element3.getOperationReference();
        Intrinsics.checkNotNullExpressionValue((Object)ktSimpleNameExpression, (String)"element.operationReference");
        return ExpressionExtKt.textRangeIn((PsiElement)ktSimpleNameExpression, (PsiElement)element3);
    }

    @Override
    @NotNull
    public String inspectionText(@NotNull KtPrefixExpression element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        return KotlinBundle.message("negated.operation.should.be.simplified", new Object[0]);
    }

    @Override
    @NotNull
    public String getDefaultFixText() {
        return KotlinBundle.message("simplify.negated.operation", new Object[0]);
    }

    @Override
    @NotNull
    public String fixText(@NotNull KtPrefixExpression element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        KtExpression ktExpression = KtPsiUtil.deparenthesize((KtExpression)element3.getBaseExpression());
        if (!(ktExpression instanceof KtOperationExpression)) {
            ktExpression = null;
        }
        KtOperationExpression ktOperationExpression = (KtOperationExpression)ktExpression;
        if (ktOperationExpression == null) {
            return this.getDefaultFixText();
        }
        KtOperationExpression expression2 = ktOperationExpression;
        IElementType iElementType = expression2.getOperationReference().getReferencedNameElementType();
        if (!(iElementType instanceof KtSingleValueToken)) {
            iElementType = null;
        }
        KtSingleValueToken ktSingleValueToken = (KtSingleValueToken)iElementType;
        if (ktSingleValueToken == null) {
            return this.getDefaultFixText();
        }
        KtSingleValueToken operation2 = ktSingleValueToken;
        KtSingleValueToken ktSingleValueToken2 = SimplifyNegatedBinaryExpressionInspection.Companion.negate((IElementType)operation2);
        if (ktSingleValueToken2 == null) {
            return this.getDefaultFixText();
        }
        KtSingleValueToken negatedOperation = ktSingleValueToken2;
        Object[] objectArray = new Object[2];
        String string = operation2.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"operation.value");
        objectArray[0] = string;
        String string2 = negatedOperation.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"negatedOperation.value");
        objectArray[1] = string2;
        return KotlinBundle.message("replace.negated.0.operation.with.1", objectArray);
    }

    @Override
    public boolean isApplicable(@NotNull KtPrefixExpression element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        return SimplifyNegatedBinaryExpressionInspection.Companion.canBeSimplified(element3);
    }

    @Override
    public void applyTo(@NotNull KtPrefixExpression element3, @NotNull Project project2, @Nullable Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        SimplifyNegatedBinaryExpressionInspection.Companion.simplify(element3);
    }

    public SimplifyNegatedBinaryExpressionInspection() {
        super(KtPrefixExpression.class);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\f\u0010\u0007\u001a\u00020\b*\u00020\u0006H\u0002J\u000e\u0010\t\u001a\u0004\u0018\u00010\n*\u00020\u000bH\u0002J\f\u0010\f\u001a\u00020\u0004*\u00020\u0006H\u0002\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/SimplifyNegatedBinaryExpressionInspection$Companion;", "", "()V", "simplifyNegatedBinaryExpressionIfNeeded", "", "expression", "Lorg/jetbrains/kotlin/psi/KtPrefixExpression;", "canBeSimplified", "", "negate", "Lorg/jetbrains/kotlin/lexer/KtSingleValueToken;", "Lcom/intellij/psi/tree/IElementType;", "simplify", "kotlin.idea"})
    public static final class Companion {
        public final void simplifyNegatedBinaryExpressionIfNeeded(@NotNull KtPrefixExpression expression2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            if (this.canBeSimplified(expression2)) {
                this.simplify(expression2);
            }
        }

        private final boolean canBeSimplified(KtPrefixExpression $this$canBeSimplified) {
            IElementType iElementType;
            if (Intrinsics.areEqual((Object)$this$canBeSimplified.getOperationToken(), (Object)KtTokens.EXCL) ^ true) {
                return false;
            }
            KtExpression ktExpression = KtPsiUtil.deparenthesize((KtExpression)$this$canBeSimplified.getBaseExpression());
            if (!(ktExpression instanceof KtOperationExpression)) {
                ktExpression = null;
            }
            KtOperationExpression ktOperationExpression = (KtOperationExpression)ktExpression;
            if (ktOperationExpression == null) {
                return false;
            }
            KtOperationExpression expression2 = ktOperationExpression;
            KtOperationExpression ktOperationExpression2 = expression2;
            if (ktOperationExpression2 instanceof KtIsExpression) {
                if (((KtIsExpression)expression2).getTypeReference() == null) {
                    return false;
                }
            } else if (ktOperationExpression2 instanceof KtBinaryExpression) {
                if (((KtBinaryExpression)expression2).getLeft() == null || ((KtBinaryExpression)expression2).getRight() == null) {
                    return false;
                }
            } else {
                return false;
            }
            if (!((iElementType = expression2.getOperationReference().getReferencedNameElementType()) instanceof KtSingleValueToken)) {
                iElementType = null;
            }
            KtSingleValueToken ktSingleValueToken = (KtSingleValueToken)iElementType;
            return (ktSingleValueToken != null ? this.negate((IElementType)ktSingleValueToken) : null) != null;
        }

        private final void simplify(KtPrefixExpression $this$simplify) {
            KtExpression ktExpression;
            KtExpression expression2;
            KtExpression ktExpression2 = KtPsiUtil.deparenthesize((KtExpression)$this$simplify.getBaseExpression());
            if (ktExpression2 == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)ktExpression2, (String)"KtPsiUtil.deparenthesize(baseExpression) ?: return");
            KtExpression ktExpression3 = expression2 = ktExpression2;
            if (ktExpression3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtOperationExpression");
            }
            Object object = this.negate(((KtOperationExpression)ktExpression3).getOperationReference().getReferencedNameElementType());
            if (object == null || (object = object.getValue()) == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"(expression as KtOperati\u2026negate()?.value ?: return");
            Object operation2 = object;
            KtPsiFactory psiFactory = new KtPsiFactory((KtElement)expression2, false, 2, null);
            KtExpression ktExpression4 = expression2;
            if (ktExpression4 instanceof KtIsExpression) {
                Object[] objectArray = new Object[3];
                KtExpression ktExpression5 = ((KtIsExpression)expression2).getLeftHandSide();
                Intrinsics.checkNotNullExpressionValue((Object)ktExpression5, (String)"expression.leftHandSide");
                objectArray[0] = ktExpression5;
                objectArray[1] = operation2;
                KtTypeReference ktTypeReference = ((KtIsExpression)expression2).getTypeReference();
                Intrinsics.checkNotNull((Object)ktTypeReference);
                Intrinsics.checkNotNullExpressionValue((Object)ktTypeReference, (String)"expression.typeReference!!");
                objectArray[2] = ktTypeReference;
                ktExpression = CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)psiFactory, (String)"$0 $1 $2", (Object[])objectArray, (boolean)false, (int)4, null);
            } else if (ktExpression4 instanceof KtBinaryExpression) {
                Object[] objectArray = new Object[3];
                KtExpression ktExpression6 = ((KtBinaryExpression)expression2).getLeft();
                if (ktExpression6 == null) {
                    return;
                }
                Intrinsics.checkNotNullExpressionValue((Object)ktExpression6, (String)"expression.left ?: return");
                objectArray[0] = ktExpression6;
                objectArray[1] = operation2;
                KtExpression ktExpression7 = ((KtBinaryExpression)expression2).getRight();
                if (ktExpression7 == null) {
                    return;
                }
                Intrinsics.checkNotNullExpressionValue((Object)ktExpression7, (String)"expression.right ?: return");
                objectArray[2] = ktExpression7;
                ktExpression = CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)psiFactory, (String)"$0 $1 $2", (Object[])objectArray, (boolean)false, (int)4, null);
            } else {
                throw (Throwable)new IllegalArgumentException();
            }
            KtExpression newExpression2 = ktExpression;
            $this$simplify.replace((PsiElement)newExpression2);
        }

        private final KtSingleValueToken negate(IElementType $this$negate) {
            IElementType iElementType = $this$negate;
            return Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.IN_KEYWORD) ? (KtSingleValueToken)KtTokens.NOT_IN : (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.NOT_IN) ? (KtSingleValueToken)KtTokens.IN_KEYWORD : (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.IS_KEYWORD) ? (KtSingleValueToken)KtTokens.NOT_IS : (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.NOT_IS) ? (KtSingleValueToken)KtTokens.IS_KEYWORD : (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EQEQ) ? KtTokens.EXCLEQ : (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EXCLEQ) ? KtTokens.EQEQ : (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.LT) ? KtTokens.GTEQ : (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.GTEQ) ? KtTokens.LT : (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.GT) ? KtTokens.LTEQ : (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.LTEQ) ? KtTokens.GT : null)))))))));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

