/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.inspections.IntentionBasedInspectionKt;
import org.jetbrains.kotlin.idea.inspections.UnusedSymbolInspectionKt;
import org.jetbrains.kotlin.idea.quickfix.RemoveUnusedFunctionParameterFix;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0012\u0010\r\u001a\f0\u0006\u00a2\u0006\u0002\b\u000e\u00a2\u0006\u0002\b\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0006H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u0010\u0010\u0005\u001a\u00020\u00068\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/SafeDeleteFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "(Lorg/jetbrains/kotlin/psi/KtDeclaration;)V", "name", "", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "getName", "startInWriteAction", "", "kotlin.idea"})
public final class SafeDeleteFix
implements LocalQuickFix {
    @Nls
    private final String name;

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message((String)"safe.delete.family", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"QuickFixBundle.message(\"safe.delete.family\")");
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        PsiElement psiElement2 = descriptor2.getPsiElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"descriptor.psiElement");
        PsiElement $this$getStrictParentOfType$iv = psiElement2;
        boolean $i$f$getStrictParentOfType = false;
        KtDeclaration ktDeclaration = (KtDeclaration)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtDeclaration.class, (boolean)true);
        if (ktDeclaration == null) {
            return;
        }
        KtDeclaration declaration2 = ktDeclaration;
        if (!FileModificationService.getInstance().prepareFileForWrite(declaration2.getContainingFile())) {
            return;
        }
        if (declaration2 instanceof KtParameter && ((KtParameter)declaration2).getParent() instanceof KtParameterList) {
            PsiElement psiElement3 = ((KtParameter)declaration2).getParent();
            if ((psiElement3 != null ? psiElement3.getParent() : null) instanceof KtFunction) {
                RemoveUnusedFunctionParameterFix removeUnusedFunctionParameterFix = new RemoveUnusedFunctionParameterFix((KtParameter)declaration2, false, 2, null);
                Editor editor2 = IntentionBasedInspectionKt.findExistingEditor((PsiElement)declaration2);
                KtFile ktFile = ((KtParameter)declaration2).getContainingKtFile();
                Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"declaration.containingKtFile");
                removeUnusedFunctionParameterFix.invoke(project2, editor2, (PsiFile)ktFile);
                return;
            }
        }
        SmartPsiElementPointer declarationPointer = PsiUtilsKt.createSmartPointer((PsiElement)((PsiElement)declaration2));
        ModalityState modalityState$iv = null;
        boolean $i$f$invokeLater = false;
        Application application = ApplicationManager.getApplication();
        Runnable runnable = new Runnable(declarationPointer, project2){
            final /* synthetic */ SmartPsiElementPointer $declarationPointer$inlined;
            final /* synthetic */ Project $project$inlined;
            {
                this.$declarationPointer$inlined = smartPsiElementPointer;
                this.$project$inlined = project2;
            }

            public final void run() {
                block0: {
                    KtDeclaration ktDeclaration;
                    boolean bl = false;
                    KtDeclaration ktDeclaration2 = (KtDeclaration)this.$declarationPointer$inlined.getElement();
                    if (ktDeclaration2 == null) break block0;
                    KtDeclaration it = ktDeclaration = ktDeclaration2;
                    boolean bl2 = false;
                    KtDeclaration ktDeclaration3 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)ktDeclaration3, (String)"it");
                    UnusedSymbolInspectionKt.access$safeDelete(this.$project$inlined, (PsiElement)ktDeclaration3);
                }
            }
        };
        ModalityState modalityState = ModalityState.defaultModalityState();
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"ModalityState.defaultModalityState()");
        application.invokeLater(runnable, modalityState);
    }

    public SafeDeleteFix(@NotNull KtDeclaration declaration2) {
        String string;
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        if (declaration2 instanceof KtConstructor) {
            string = KotlinBundle.message("safe.delete.constructor", new Object[0]);
        } else {
            String string2 = QuickFixBundle.message((String)"safe.delete.text", (Object[])new Object[]{declaration2.getName()});
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"QuickFixBundle.message(\"\u2026.text\", declaration.name)");
        }
        this.name = string;
    }
}

