/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.inspections.RecursiveEqualsCallInspection;
import org.jetbrains.kotlin.idea.inspections.ReplaceWithReferentialEqualityFix;
import org.jetbrains.kotlin.idea.intentions.conventionNameCalls.ConventionUtilsKt;
import org.jetbrains.kotlin.idea.search.usagesSearch.SearchHelpersKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.resolve.scopes.receivers.ThisClassReceiver;
import org.jetbrains.kotlin.util.OperatorNameConventions;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/RecursiveEqualsCallInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "kotlin.idea"})
public final class RecursiveEqualsCallInspection
extends AbstractKotlinInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        return (PsiElementVisitor)new KtVisitorVoid(holder){
            final /* synthetic */ ProblemsHolder $holder;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private final boolean isRecursiveEquals(KtExpression $this$isRecursiveEquals, KtExpression argumentExpr) {
                FunctionDescriptor containingFunctionDescriptor;
                FunctionDescriptor calledFunctionDescriptor;
                ResolvedCall resolvedCall2;
                if (!(argumentExpr instanceof KtNameReferenceExpression)) {
                    return false;
                }
                BindingContext context2 = ResolutionUtils.analyze((KtElement)$this$isRecursiveEquals, BodyResolveMode.PARTIAL);
                ResolvedCall resolvedCall3 = resolvedCall2 = CallUtilKt.getResolvedCall((KtElement)((KtElement)$this$isRecursiveEquals), (BindingContext)context2);
                Object object = resolvedCall3 != null ? resolvedCall3.getDispatchReceiver() : null;
                if (!(object instanceof ThisClassReceiver)) {
                    object = null;
                }
                ThisClassReceiver thisClassReceiver = (ThisClassReceiver)object;
                if (thisClassReceiver == null) {
                    return false;
                }
                ThisClassReceiver dispatchReceiver = thisClassReceiver;
                DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)context2.get((ReadOnlySlice)BindingContext.REFERENCE_TARGET, (Object)argumentExpr);
                if (declarationDescriptor == null) {
                    return false;
                }
                Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"context[BindingContext.R\u2026mentExpr] ?: return false");
                DeclarationDescriptor argumentDescriptor = declarationDescriptor;
                ResolvedCall resolvedCall4 = resolvedCall2;
                Intrinsics.checkNotNullExpressionValue((Object)resolvedCall4, (String)"resolvedCall");
                CallableDescriptor callableDescriptor = resolvedCall4.getResultingDescriptor();
                if (!(callableDescriptor instanceof FunctionDescriptor)) {
                    callableDescriptor = null;
                }
                FunctionDescriptor functionDescriptor2 = calledFunctionDescriptor = (FunctionDescriptor)callableDescriptor;
                if (functionDescriptor2 == null) return false;
                if (!ConventionUtilsKt.isAnyEquals(functionDescriptor2)) {
                    return false;
                }
                PsiElement $this$getNonStrictParentOfType$iv = (PsiElement)$this$isRecursiveEquals;
                boolean $i$f$getNonStrictParentOfType = false;
                KtNamedFunction ktNamedFunction = (KtNamedFunction)PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv, KtNamedFunction.class, (boolean)false);
                Object object2 = ktNamedFunction != null ? SearchHelpersKt.getDescriptor((KtDeclaration)ktNamedFunction) : null;
                if (!(object2 instanceof FunctionDescriptor)) {
                    object2 = null;
                }
                if (!Intrinsics.areEqual((Object)calledFunctionDescriptor, (Object)(containingFunctionDescriptor = (FunctionDescriptor)object2))) return false;
                if (!Intrinsics.areEqual((Object)dispatchReceiver.getClassDescriptor(), (Object)containingFunctionDescriptor.getContainingDeclaration())) return false;
                List list2 = containingFunctionDescriptor.getValueParameters();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"containingFunctionDescriptor.valueParameters");
                if (!Intrinsics.areEqual((Object)argumentDescriptor, (Object)((ValueParameterDescriptor)CollectionsKt.singleOrNull((List)list2)))) return false;
                return true;
            }

            private final void reportRecursiveEquals(KtExpression $this$reportRecursiveEquals, boolean invert) {
                this.$holder.registerProblem((PsiElement)$this$reportRecursiveEquals, KotlinBundle.message("recursive.equals.call", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new ReplaceWithReferentialEqualityFix(invert)});
            }

            static /* synthetic */ void reportRecursiveEquals$default(buildVisitor.1 var0, KtExpression ktExpression, boolean bl, int n, Object object) {
                if ((n & 1) != 0) {
                    bl = false;
                }
                var0.reportRecursiveEquals(ktExpression, bl);
            }

            public void visitBinaryExpression(@NotNull KtBinaryExpression expr) {
                Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
                super.visitBinaryExpression(expr);
                if (Intrinsics.areEqual((Object)expr.getOperationToken(), (Object)KtTokens.EQEQ) ^ true && Intrinsics.areEqual((Object)expr.getOperationToken(), (Object)KtTokens.EXCLEQ) ^ true) {
                    return;
                }
                if (!this.isRecursiveEquals((KtExpression)expr, expr.getRight())) {
                    return;
                }
                this.reportRecursiveEquals((KtExpression)expr, Intrinsics.areEqual((Object)expr.getOperationToken(), (Object)KtTokens.EXCLEQ));
            }

            public void visitCallExpression(@NotNull KtCallExpression expr) {
                Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
                super.visitCallExpression(expr);
                KtExpression ktExpression = expr.getCalleeExpression();
                if (!(ktExpression instanceof KtSimpleNameExpression)) {
                    ktExpression = null;
                }
                KtSimpleNameExpression ktSimpleNameExpression = (KtSimpleNameExpression)ktExpression;
                if (ktSimpleNameExpression == null) {
                    return;
                }
                KtSimpleNameExpression calleeExpression2 = ktSimpleNameExpression;
                if (Intrinsics.areEqual((Object)calleeExpression2.getReferencedNameAsName(), (Object)OperatorNameConventions.EQUALS) ^ true) {
                    return;
                }
                KtExpression ktExpression2 = (KtExpression)expr;
                List list2 = expr.getValueArguments();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"expr.valueArguments");
                KtValueArgument ktValueArgument = (KtValueArgument)CollectionsKt.singleOrNull((List)list2);
                if (!this.isRecursiveEquals(ktExpression2, (KtExpression)(ktValueArgument != null ? ktValueArgument.getArgumentExpression() : null))) {
                    return;
                }
                buildVisitor.1.reportRecursiveEquals$default(this, (KtExpression)expr, false, 1, null);
            }
            {
                this.$holder = $captured_local_variable$0;
            }
        };
    }
}

