/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.util.containers.MultiMap;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactoryForDeprecation;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.inspections.KotlinInspectionSuppressor;
import org.jetbrains.kotlin.idea.inspections.KotlinRedundantDiagnosticSuppressInspectionKt;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u00000\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a/\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u001a\u0010\b\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\n0\t\"\u0006\u0012\u0002\b\u00030\nH\u0002\u00a2\u0006\u0002\u0010\u000b\u001a,\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u000e0\r*\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u000e0\rH\u0002\u001a \u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u000e0\r*\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\"!\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0014"}, d2={"availableDiagnostics", "", "", "getAvailableDiagnostics", "()Ljava/util/Set;", "availableDiagnostics$delegate", "Lkotlin/Lazy;", "extractDiagnosticNames", "classes", "", "Ljava/lang/Class;", "([Ljava/lang/Class;)Ljava/util/Set;", "findAllDiagnostics", "Lcom/intellij/util/containers/MultiMap;", "Lcom/intellij/psi/PsiElement;", "Lorg/jetbrains/kotlin/psi/KtFile;", "allSuppressedPlaces", "findAllSuppressedPlaces", "suppressor", "Lorg/jetbrains/kotlin/idea/inspections/KotlinInspectionSuppressor;", "kotlin.idea"})
public final class KotlinRedundantDiagnosticSuppressInspectionKt {
    private static final Lazy availableDiagnostics$delegate = LazyKt.lazy((Function0)availableDiagnostics.2.INSTANCE);

    private static final MultiMap<String, PsiElement> findAllDiagnostics(KtFile $this$findAllDiagnostics, MultiMap<String, PsiElement> allSuppressedPlaces) {
        MultiMap multiMap;
        boolean bl;
        KtAnnotated firstElement;
        block5: {
            Collection collection = allSuppressedPlaces.values();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"allSuppressedPlaces.values()");
            Collection places = collection;
            Object object = CollectionsKt.first((Iterable)places);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtAnnotated");
            }
            firstElement = (KtAnnotated)object;
            Iterable $this$all$iv = places;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    PsiElement it = (PsiElement)element$iv;
                    boolean bl2 = false;
                    if (it == firstElement) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
        }
        Diagnostics diagnostics2 = bl ? ResolutionUtils.analyzeWithContentAndGetResult((KtElement)firstElement).getBindingContext().getDiagnostics() : ResolutionUtils.analyzeWithAllCompilerChecks($this$findAllDiagnostics, new KtFile[0]).getBindingContext().getDiagnostics();
        Intrinsics.checkNotNullExpressionValue((Object)diagnostics2, (String)"if (places.all { it === \u2026Context.diagnostics\n    }");
        Diagnostics diagnostics3 = diagnostics2;
        MultiMap $this$apply = multiMap = MultiMap.create();
        boolean bl3 = false;
        for (Diagnostic diagnostic : diagnostics3.noSuppression()) {
            String string = diagnostic.getFactoryName();
            String string2 = string.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            $this$apply.putValue((Object)string2, (Object)diagnostic.getPsiElement());
        }
        MultiMap multiMap2 = multiMap;
        Intrinsics.checkNotNullExpressionValue((Object)multiMap2, (String)"MultiMap.create<String, \u2026iElement)\n        }\n    }");
        return multiMap2;
    }

    private static final MultiMap<String, PsiElement> findAllSuppressedPlaces(KtFile $this$findAllSuppressedPlaces, KotlinInspectionSuppressor suppressor) {
        MultiMap multiMap = MultiMap.createSet();
        Intrinsics.checkNotNullExpressionValue((Object)multiMap, (String)"MultiMap.createSet<String, PsiElement>()");
        MultiMap allSuppressedPlaces = multiMap;
        $this$findAllSuppressedPlaces.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(suppressor, allSuppressedPlaces){
            final /* synthetic */ KotlinInspectionSuppressor $suppressor;
            final /* synthetic */ MultiMap $allSuppressedPlaces;

            public void visitElement(@NotNull PsiElement element3) {
                Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
                Iterator<String> iterator = this.$suppressor.suppressionIds(element3).iterator();
                while (iterator.hasNext()) {
                    String idInLowercase;
                    String id;
                    String string = id = iterator.next();
                    Intrinsics.checkNotNullExpressionValue((Object)string.toLowerCase(Locale.ROOT), (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                    if (!KotlinRedundantDiagnosticSuppressInspectionKt.access$getAvailableDiagnostics$p().contains(idInLowercase)) continue;
                    this.$allSuppressedPlaces.putValue((Object)idInLowercase, (Object)element3);
                }
                super.visitElement(element3);
            }
            {
                this.$suppressor = $captured_local_variable$0;
                this.$allSuppressedPlaces = $captured_local_variable$1;
            }
        });
        return allSuppressedPlaces;
    }

    private static final Set<String> getAvailableDiagnostics() {
        Lazy lazy = availableDiagnostics$delegate;
        Object var1_1 = null;
        Object var2_2 = null;
        return (Set)lazy.getValue();
    }

    private static final Set<String> extractDiagnosticNames(Class<?> ... classes2) {
        Set set2 = new LinkedHashSet();
        for (Class<?> klass2 : classes2) {
            Field[] fieldArray = klass2.getDeclaredFields();
            int n = fieldArray.length;
            for (int i = 0; i < n; ++i) {
                Object object;
                String string;
                Field field2;
                Field field3 = field2 = fieldArray[i];
                Intrinsics.checkNotNullExpressionValue((Object)field3, (String)"field");
                if (!Modifier.isStatic(field3.getModifiers())) continue;
                Object value2 = field2.get(null);
                if (value2 instanceof DiagnosticFactoryForDeprecation) {
                    string = ((DiagnosticFactoryForDeprecation)value2).getWarningFactory().getName();
                } else if (value2 instanceof DiagnosticFactory) {
                    object = value2;
                    DiagnosticFactory it = (DiagnosticFactory)object;
                    boolean bl = false;
                    DiagnosticFactory diagnosticFactory = (DiagnosticFactory)(!(it.getSeverity() == Severity.ERROR) ? object : null);
                    string = diagnosticFactory != null ? diagnosticFactory.getName() : null;
                } else {
                    string = null;
                }
                if (string == null) continue;
                String name2 = string;
                Collection collection = set2;
                object = name2;
                String string2 = ((String)object).toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                object = string2;
                collection.add(object);
            }
        }
        return set2;
    }

    public static final /* synthetic */ MultiMap access$findAllSuppressedPlaces(KtFile $this$access_u24findAllSuppressedPlaces, KotlinInspectionSuppressor suppressor) {
        return KotlinRedundantDiagnosticSuppressInspectionKt.findAllSuppressedPlaces($this$access_u24findAllSuppressedPlaces, suppressor);
    }

    public static final /* synthetic */ MultiMap access$findAllDiagnostics(KtFile $this$access_u24findAllDiagnostics, MultiMap allSuppressedPlaces) {
        return KotlinRedundantDiagnosticSuppressInspectionKt.findAllDiagnostics($this$access_u24findAllDiagnostics, (MultiMap<String, PsiElement>)allSuppressedPlaces);
    }

    public static final /* synthetic */ Set access$getAvailableDiagnostics$p() {
        return KotlinRedundantDiagnosticSuppressInspectionKt.getAvailableDiagnostics();
    }

    public static final /* synthetic */ Set access$extractDiagnosticNames(Class ... classes2) {
        return KotlinRedundantDiagnosticSuppressInspectionKt.extractDiagnosticNames(classes2);
    }
}

