/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.hierarchy;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.ide.hierarchy.type.JavaTypeHierarchyProvider;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.builtins.jvm.JavaToKotlinClassMap;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.idea.search.SearchUtilKt;
import org.jetbrains.kotlin.idea.stubindex.KotlinClassShortNameIndex;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtil;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtilKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.jvm.JvmPlatformKt;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001a\u0010\f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J$\u0010\u0011\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/hierarchy/KotlinTypeHierarchyProvider;", "Lcom/intellij/ide/hierarchy/type/JavaTypeHierarchyProvider;", "()V", "getOriginalPsiClassOrCreateLightClass", "Lcom/intellij/psi/PsiClass;", "classOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "module", "Lcom/intellij/openapi/module/Module;", "getTarget", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "getTargetByContainingElement", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "getTargetByReference", "project", "Lcom/intellij/openapi/project/Project;", "kotlin.idea"})
public final class KotlinTypeHierarchyProvider
extends JavaTypeHierarchyProvider {
    private final PsiClass getOriginalPsiClassOrCreateLightClass(KtClassOrObject classOrObject, Module module2) {
        FqName fqName2 = classOrObject.getFqName();
        if (fqName2 != null) {
            Module module3 = module2;
            if (JvmPlatformKt.isJvm((TargetPlatform)(module3 != null ? PlatformKt.getPlatform(module3) : null))) {
                FqNameUnsafe fqNameUnsafe = fqName2.toUnsafe();
                Intrinsics.checkNotNullExpressionValue((Object)fqNameUnsafe, (String)"fqName.toUnsafe()");
                ClassId javaClassId = JavaToKotlinClassMap.INSTANCE.mapKotlinToJava(fqNameUnsafe);
                if (javaClassId != null) {
                    return JavaPsiFacade.getInstance((Project)classOrObject.getProject()).findClass(javaClassId.asSingleFqName().asString(), GlobalSearchScope.allScope((Project)classOrObject.getProject()));
                }
            }
        }
        KtLightClass ktLightClass = LightClassUtilsKt.toLightClass((KtClassOrObject)classOrObject);
        return ktLightClass != null ? (PsiClass)ktLightClass : (PsiClass)LightClassUtilsKt.toFakeLightClass((KtClassOrObject)classOrObject);
    }

    private final PsiClass getTargetByReference(Project project2, Editor editor2, Module module2) {
        PsiClass psiClass2;
        TargetElementUtil targetElementUtil = TargetElementUtil.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)targetElementUtil, (String)"TargetElementUtil.getInstance()");
        PsiElement target2 = TargetElementUtil.findTargetElement((Editor)editor2, (int)targetElementUtil.getAllAccepted());
        if (target2 instanceof PsiClass) {
            psiClass2 = (PsiClass)target2;
        } else if (target2 instanceof KtConstructor) {
            psiClass2 = this.getOriginalPsiClassOrCreateLightClass(((KtConstructor)target2).getContainingClassOrObject(), module2);
        } else if (target2 instanceof KtClassOrObject) {
            psiClass2 = this.getOriginalPsiClassOrCreateLightClass((KtClassOrObject)target2, module2);
        } else if (target2 instanceof KtNamedFunction) {
            String functionName = ((KtNamedFunction)target2).getName();
            FunctionDescriptor functionDescriptor2 = ResolutionUtils.resolveToDescriptorIfAny((KtNamedFunction)target2, BodyResolveMode.FULL);
            if (functionDescriptor2 == null) {
                return null;
            }
            FunctionDescriptor functionDescriptor3 = functionDescriptor2;
            KotlinType kotlinType = functionDescriptor3.getReturnType();
            if (kotlinType == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"functionDescriptor.returnType ?: return null");
            KotlinType type2 = kotlinType;
            String returnTypeText = DescriptorRenderer.FQ_NAMES_IN_TYPES.renderType(type2);
            if (Intrinsics.areEqual((Object)returnTypeText, (Object)functionName) ^ true) {
                return null;
            }
            KtClassOrObject ktClassOrObject = (KtClassOrObject)CollectionsKt.singleOrNull((Iterable)KotlinClassShortNameIndex.INSTANCE.get(functionName, project2, SearchUtilKt.allScope(project2)));
            if (ktClassOrObject == null) {
                return null;
            }
            KtClassOrObject classOrObject = ktClassOrObject;
            psiClass2 = this.getOriginalPsiClassOrCreateLightClass(classOrObject, module2);
        } else {
            psiClass2 = null;
        }
        return psiClass2;
    }

    private final PsiClass getTargetByContainingElement(Editor editor2, PsiFile file2) {
        PsiElement element3;
        CaretModel caretModel = editor2.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
        int offset2 = caretModel.getOffset();
        PsiElement psiElement2 = file2.findElementAt(offset2);
        if (psiElement2 == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"file.findElementAt(offset) ?: return null");
        PsiElement $this$getNonStrictParentOfType$iv = element3 = psiElement2;
        boolean $i$f$getNonStrictParentOfType = false;
        KtClassOrObject ktClassOrObject = (KtClassOrObject)PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv, KtClassOrObject.class, (boolean)false);
        if (ktClassOrObject == null) {
            return null;
        }
        KtClassOrObject classOrObject = ktClassOrObject;
        return this.getOriginalPsiClassOrCreateLightClass(classOrObject, ProjectRootsUtilKt.getModule((PsiElement)file2));
    }

    @Nullable
    public PsiClass getTarget(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        Project project2 = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
        if (project2 == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"PlatformDataKeys.PROJECT\u2026taContext) ?: return null");
        Project project3 = project2;
        Editor editor2 = (Editor)PlatformDataKeys.EDITOR.getData(dataContext);
        if (editor2 != null) {
            PsiClass psiElement2;
            PsiFile psiFile2 = PsiDocumentManager.getInstance((Project)project3).getPsiFile(editor2.getDocument());
            if (psiFile2 == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"PsiDocumentManager.getIn\u2026.document) ?: return null");
            PsiFile file2 = psiFile2;
            if (!ProjectRootsUtil.isInProjectOrLibSource$default((PsiElement)file2, false, 2, null)) {
                return null;
            }
            PsiClass psiClass2 = this.getTargetByReference(project3, editor2, ProjectRootsUtilKt.getModule((PsiElement)file2));
            if (psiClass2 == null) {
                psiClass2 = this.getTargetByContainingElement(editor2, file2);
            }
            if ((psiElement2 = psiClass2) instanceof PsiNamedElement && psiElement2.getName() == null) {
                return null;
            }
            return psiElement2;
        }
        PsiElement element3 = (PsiElement)LangDataKeys.PSI_ELEMENT.getData(dataContext);
        if (element3 instanceof KtClassOrObject) {
            return this.getOriginalPsiClassOrCreateLightClass((KtClassOrObject)element3, ProjectRootsUtilKt.getModule(element3));
        }
        return null;
    }
}

