/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.gradleJava.scripting.settings;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.JBTable;
import com.intellij.ui.table.TableView;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.TableModelListener;
import javax.swing.plaf.BorderUIResource;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.gradle.KotlinIdeaGradleBundle;
import org.jetbrains.kotlin.idea.gradle.scripting.settings.KotlinStandaloneScriptsModel;
import org.jetbrains.kotlin.idea.gradle.scripting.settings.StandaloneScriptsStorage;
import org.jetbrains.kotlin.idea.gradleJava.scripting.roots.GradleBuildRootsLocator;
import org.jetbrains.kotlin.idea.gradleJava.scripting.roots.GradleBuildRootsManager;
import org.jetbrains.kotlin.idea.gradleJava.scripting.roots.StandaloneScriptsUpdater;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u0015H\u0016J\n\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0015H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u0015H\u0002J\b\u0010\u001d\u001a\u00020\u0015H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/idea/gradleJava/scripting/settings/StandaloneScriptsUIComponent;", "Lcom/intellij/openapi/options/UnnamedConfigurable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "fileChooser", "Lcom/intellij/openapi/fileChooser/FileChooserDescriptor;", "model", "Lorg/jetbrains/kotlin/idea/gradle/scripting/settings/KotlinStandaloneScriptsModel;", "panel", "Ljavax/swing/JPanel;", "getProject", "()Lcom/intellij/openapi/project/Project;", "scriptsFromStorage", "", "", "scriptsInTable", "", "table", "Lcom/intellij/ui/table/JBTable;", "addScripts", "", "apply", "createComponent", "Ljavax/swing/JComponent;", "disposeUIResources", "isModified", "", "removeScripts", "reset", "kotlin.gradle.gradle-java"})
public final class StandaloneScriptsUIComponent
implements UnnamedConfigurable {
    @NotNull
    private final Project project;
    @NotNull
    private final FileChooserDescriptor fileChooser;
    @Nullable
    private JPanel panel;
    @NotNull
    private final List<String> scriptsFromStorage;
    @NotNull
    private final List<String> scriptsInTable;
    @NotNull
    private final JBTable table;
    @NotNull
    private final KotlinStandaloneScriptsModel model;

    public StandaloneScriptsUIComponent(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.fileChooser = new FileChooserDescriptor(this){
            final /* synthetic */ StandaloneScriptsUIComponent this$0;
            {
                this.this$0 = $receiver;
                super(true, false, false, false, false, true);
            }

            public boolean isFileSelectable(@Nullable VirtualFile file2) {
                GradleBuildRootsLocator.ScriptUnderRoot scriptUnderRoot;
                GradleBuildRootsManager rootsManager;
                if (file2 == null) {
                    return false;
                }
                GradleBuildRootsManager gradleBuildRootsManager = rootsManager = GradleBuildRootsManager.Companion.getInstance(this.this$0.getProject());
                GradleBuildRootsLocator.ScriptUnderRoot scriptUnderRoot2 = scriptUnderRoot = gradleBuildRootsManager != null ? gradleBuildRootsManager.findScriptBuildRoot(file2) : null;
                GradleBuildRootsLocator.NotificationKind notificationKind = scriptUnderRoot2 != null ? scriptUnderRoot2.getNotificationKind() : null;
                return notificationKind == GradleBuildRootsLocator.NotificationKind.legacyOutside || notificationKind == GradleBuildRootsLocator.NotificationKind.notEvaluatedInLastImport;
            }
        };
        Object object = StandaloneScriptsStorage.Companion.getInstance(this.project);
        if (object == null || (object = ((StandaloneScriptsStorage)object).getFiles()) == null || (object = CollectionsKt.toList((Iterable)((Iterable)object))) == null) {
            object = CollectionsKt.emptyList();
        }
        this.scriptsFromStorage = object;
        this.scriptsInTable = CollectionsKt.toMutableList((Collection)this.scriptsFromStorage);
        this.model = KotlinStandaloneScriptsModel.Companion.createModel((Collection<String>)this.scriptsInTable);
        this.table = (JBTable)new TableView((ListTableModel)this.model);
        ((TableView)this.table).setPreferredScrollableViewportSize((Dimension)JBUI.size((int)300, (int)-1));
        ((TableView)this.table).getSelectionModel().setSelectionMode(2);
        this.model.addTableModelListener((TableModelListener)this.table);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public void reset() {
        this.scriptsInTable.clear();
        this.scriptsInTable.addAll((Collection<String>)this.scriptsFromStorage);
        this.model.setItems(this.scriptsInTable);
    }

    public void apply() {
        block0: {
            GradleBuildRootsManager gradleBuildRootsManager = GradleBuildRootsManager.Companion.getInstance(this.project);
            if (gradleBuildRootsManager == null) break block0;
            gradleBuildRootsManager.updateStandaloneScripts((Function1<? super StandaloneScriptsUpdater, Unit>)((Function1)new Function1<StandaloneScriptsUpdater, Unit>(this){
                final /* synthetic */ StandaloneScriptsUIComponent this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull StandaloneScriptsUpdater $this$updateStandaloneScripts) {
                    void $this$filterNotTo$iv$iv;
                    Object element$iv2;
                    Iterator<T> $this$filterNotTo$iv$iv2;
                    Intrinsics.checkNotNullParameter((Object)$this$updateStandaloneScripts, (String)"$this$updateStandaloneScripts");
                    List previousScripts = StandaloneScriptsUIComponent.access$getScriptsFromStorage$p(this.this$0);
                    Iterable $this$filterNot$iv = StandaloneScriptsUIComponent.access$getScriptsInTable$p(this.this$0);
                    boolean $i$f$filterNot = false;
                    Iterable iterable = $this$filterNot$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterNotTo = false;
                    Iterator<T> iterator = $this$filterNotTo$iv$iv2.iterator();
                    while (iterator.hasNext()) {
                        T element$iv$iv = iterator.next();
                        String it = (String)element$iv$iv;
                        boolean bl = false;
                        if (previousScripts.contains(it)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    Iterable $this$forEach$iv = (List)destination$iv$iv;
                    boolean $i$f$forEach22 = false;
                    for (Object element$iv2 : $this$forEach$iv) {
                        String it = (String)element$iv2;
                        boolean bl = false;
                        $this$updateStandaloneScripts.addStandaloneScript(it);
                    }
                    $this$forEach$iv = previousScripts;
                    StandaloneScriptsUIComponent $i$f$forEach22 = this.this$0;
                    boolean $i$f$filterNot2 = false;
                    element$iv2 = $this$filterNot$iv;
                    Collection destination$iv$iv2 = new ArrayList<E>();
                    boolean $i$f$filterNotTo2 = false;
                    for (T element$iv$iv : $this$filterNotTo$iv$iv) {
                        String it = (String)element$iv$iv;
                        boolean bl = false;
                        if (StandaloneScriptsUIComponent.access$getScriptsInTable$p($i$f$forEach22).contains(it)) continue;
                        destination$iv$iv2.add(element$iv$iv);
                    }
                    $this$forEach$iv = (List)destination$iv$iv2;
                    boolean $i$f$forEach = false;
                    for (Object element$iv2 : $this$forEach$iv) {
                        String it = (String)element$iv2;
                        boolean bl = false;
                        $this$updateStandaloneScripts.removeStandaloneScript(it);
                    }
                }
            }));
        }
    }

    @Nullable
    public JComponent createComponent() {
        if (this.panel == null) {
            JPanel panel2 = new JPanel(new BorderLayout());
            panel2.setBorder(new BorderUIResource.TitledBorderUIResource(KotlinIdeaGradleBundle.message("standalone.scripts.settings.title", new Object[0])));
            panel2.add(ToolbarDecorator.createDecorator((JTable)((JTable)this.table)).setAddAction(arg_0 -> StandaloneScriptsUIComponent.createComponent$lambda-0(this, arg_0)).setRemoveAction(arg_0 -> StandaloneScriptsUIComponent.createComponent$lambda-1(this, arg_0)).setRemoveActionUpdater(arg_0 -> StandaloneScriptsUIComponent.createComponent$lambda-2(this, arg_0)).disableUpDownActions().createPanel());
            this.panel = panel2;
        }
        return this.panel;
    }

    public boolean isModified() {
        return !Intrinsics.areEqual(this.scriptsFromStorage, this.scriptsInTable);
    }

    public void disposeUIResources() {
        this.panel = null;
    }

    private final void addScripts() {
        VirtualFile[] chosen = FileChooser.chooseFiles((FileChooserDescriptor)this.fileChooser, (Project)this.project, null);
        Intrinsics.checkNotNullExpressionValue((Object)chosen, (String)"chosen");
        for (VirtualFile chosenFile : chosen) {
            String path2;
            Intrinsics.checkNotNullExpressionValue((Object)chosenFile.getPath(), (String)"chosenFile.path");
            if (this.scriptsInTable.contains(path2)) continue;
            this.scriptsInTable.add(path2);
            this.model.addRow(path2);
        }
    }

    private final void removeScripts() {
        int[] selected = this.table.getSelectedRows();
        if (selected == null || selected.length == 0) {
            return;
        }
        int[] nArray = selected;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int removedCount = i;
            int indexToRemove = nArray[i];
            int row = indexToRemove - removedCount;
            this.scriptsInTable.remove(row);
            this.model.removeRow(row);
        }
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> StandaloneScriptsUIComponent.removeScripts$lambda-3(this));
    }

    private static final void createComponent$lambda-0(StandaloneScriptsUIComponent this$0, AnActionButton it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.addScripts();
    }

    private static final void createComponent$lambda-1(StandaloneScriptsUIComponent this$0, AnActionButton it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.removeScripts();
    }

    private static final boolean createComponent$lambda-2(StandaloneScriptsUIComponent this$0, AnActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.table.getSelectedRow() >= 0;
    }

    private static final void removeScripts$lambda-3(StandaloneScriptsUIComponent this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        IdeFocusManager.getGlobalInstance().requestFocus((Component)this$0.table, true);
    }

    public static final /* synthetic */ List access$getScriptsFromStorage$p(StandaloneScriptsUIComponent $this) {
        return $this.scriptsFromStorage;
    }

    public static final /* synthetic */ List access$getScriptsInTable$p(StandaloneScriptsUIComponent $this) {
        return $this.scriptsInTable;
    }
}

