/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.gradleJava.scripting;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.importing.ImportSpecBuilder;
import com.intellij.openapi.externalSystem.importing.ProjectResolverPolicy;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.core.script.settings.KotlinScriptingSettings;
import org.jetbrains.kotlin.idea.gradle.KotlinIdeaGradleBundle;
import org.jetbrains.kotlin.idea.gradleJava.scripting.importing.KotlinDslScriptModelResolver;
import org.jetbrains.kotlin.idea.gradleJava.scripting.roots.GradleBuildRoot;
import org.jetbrains.kotlin.idea.gradleJava.scripting.roots.GradleBuildRootsLocator;
import org.jetbrains.kotlin.idea.gradleJava.scripting.roots.GradleBuildRootsManager;
import org.jetbrains.kotlin.idea.gradleJava.scripting.roots.GradleScriptInfo;
import org.jetbrains.kotlin.scripting.definitions.DefinitionsKt;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinition;
import org.jetbrains.plugins.gradle.service.GradleInstallationManager;
import org.jetbrains.plugins.gradle.service.project.GradlePartialResolverPolicy;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverExtension;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0016\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\b\u0010\t\u001a\u00020\nH\u0007\u001a\b\u0010\u000b\u001a\u00020\nH\u0007\u001a\b\u0010\f\u001a\u00020\nH\u0007\u001a\b\u0010\r\u001a\u00020\nH\u0007\u001a\u0016\u0010\u000e\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0014\u001a\u000e\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u000e\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0016\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\"\u0011\u0010\u0000\u001a\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0018"}, d2={"scriptConfigurationsNeedToBeUpdatedBalloon", "", "getScriptConfigurationsNeedToBeUpdatedBalloon", "()Z", "autoReloadScriptConfigurations", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "configurationsAreMissingAfterRequest", "", "configurationsAreMissingRequestNeeded", "configurationsAreMissingRequestNeededHelp", "getConfigurationsActionText", "getGradleVersion", "settings", "Lorg/jetbrains/plugins/gradle/settings/GradleProjectSettings;", "runPartialGradleImport", "", "root", "Lorg/jetbrains/kotlin/idea/gradleJava/scripting/roots/GradleBuildRoot;", "runPartialGradleImportForAllRoots", "scriptConfigurationsAreUpToDate", "scriptConfigurationsNeedToBeUpdated", "kotlin.gradle.gradle-java"})
public final class GradleImportHelperKt {
    public static final boolean getScriptConfigurationsNeedToBeUpdatedBalloon() {
        return Registry.is((String)"kotlin.gradle.scripts.scriptConfigurationsNeedToBeUpdatedFloatingNotification", (boolean)true);
    }

    public static final void runPartialGradleImportForAllRoots(@NotNull Project project2) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Object object = GradleBuildRootsManager.Companion.getInstance(project2);
            if (object == null || (object = ((GradleBuildRootsLocator)object).getAllRoots()) == null) break block1;
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                GradleBuildRoot root = (GradleBuildRoot)element$iv;
                boolean bl = false;
                GradleImportHelperKt.runPartialGradleImport(project2, root);
            }
        }
    }

    public static final void runPartialGradleImport(@NotNull Project project2, @NotNull GradleBuildRoot root) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        if (root.isImportingInProgress()) {
            return;
        }
        ExternalSystemUtil.refreshProject((String)root.getPathPrefix(), (ImportSpecBuilder)new ImportSpecBuilder(project2, GradleConstants.SYSTEM_ID).withVmOptions("-Dorg.gradle.kotlin.dsl.provider.mode=classpath").projectResolverPolicy((ProjectResolverPolicy)new GradlePartialResolverPolicy(GradleImportHelperKt::runPartialGradleImport$lambda-1)));
    }

    @Nls
    @NotNull
    public static final String configurationsAreMissingRequestNeeded() {
        return KotlinIdeaGradleBundle.message("notification.wasNotImportedAfterCreation.text", new Object[0]);
    }

    @Nls
    @NotNull
    public static final String getConfigurationsActionText() {
        return KotlinIdeaGradleBundle.message("action.text.load.script.configurations", new Object[0]);
    }

    @Nls
    @NotNull
    public static final String configurationsAreMissingRequestNeededHelp() {
        return KotlinIdeaGradleBundle.message("notification.wasNotImportedAfterCreation.help", new Object[0]);
    }

    @Nls
    @NotNull
    public static final String configurationsAreMissingAfterRequest() {
        return KotlinIdeaGradleBundle.message("notification.notEvaluatedInLastImport.text", new Object[0]);
    }

    public static final boolean autoReloadScriptConfigurations(@NotNull Project project2, @NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        ScriptDefinition scriptDefinition = DefinitionsKt.findScriptDefinition(file2, project2);
        if (scriptDefinition == null) {
            return false;
        }
        ScriptDefinition definition2 = scriptDefinition;
        return KotlinScriptingSettings.Companion.getInstance(project2).autoReloadConfigurations(definition2);
    }

    public static final void scriptConfigurationsNeedToBeUpdated(@NotNull Project project2, @NotNull VirtualFile file2) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            if (!GradleImportHelperKt.autoReloadScriptConfigurations(project2, file2)) break block1;
            Object object = GradleBuildRootsManager.Companion.getInstance(project2);
            if (object != null && (object = ((GradleBuildRootsLocator)object).getScriptInfo(file2)) != null && (object = ((GradleScriptInfo)object).getBuildRoot()) != null) {
                Object it = object;
                boolean bl = false;
                GradleImportHelperKt.runPartialGradleImport(project2, (GradleBuildRoot)it);
            }
        }
    }

    public static final boolean scriptConfigurationsAreUpToDate(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        return true;
    }

    @NotNull
    public static final String getGradleVersion(@NotNull Project project2, @NotNull GradleProjectSettings settings2) {
        String string;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)settings2, (String)"settings");
        boolean $i$f$service = false;
        Class<GradleInstallationManager> serviceClass$iv = GradleInstallationManager.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
        }
        File file2 = ((GradleInstallationManager)object).getGradleHome(project2, settings2.getExternalProjectPath());
        String string2 = GradleInstallationManager.getGradleVersion((String)(file2 != null ? file2.getPath() : null));
        if (string2 == null) {
            String string3 = GradleVersion.current().getVersion();
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"current().version");
        } else {
            string = string2;
        }
        return string;
    }

    private static final boolean runPartialGradleImport$lambda-1(GradleProjectResolverExtension it) {
        return it instanceof KotlinDslScriptModelResolver;
    }
}

