/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.gradleJava;

import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiFile;
import icons.GradleIcons;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.compiler.configuration.IdeKotlinVersion;
import org.jetbrains.kotlin.idea.extensions.gradle.GradleBuildScriptManipulator;
import org.jetbrains.kotlin.idea.extensions.gradle.GradleBuildScriptSupport;
import org.jetbrains.kotlin.idea.extensions.gradle.KotlinGradleFacade;
import org.jetbrains.kotlin.idea.gradle.configuration.GradleVersionProviderImpl;
import org.jetbrains.kotlin.idea.gradleJava.KotlinGradleFacadeImplKt;
import org.jetbrains.kotlin.idea.gradleJava.inspections.KotlinGradleModelFacadeKt;
import org.jetbrains.kotlin.idea.roots.NodeWithData;
import org.jetbrains.kotlin.idea.roots.ProjectRootUtilsKt;
import org.jetbrains.plugins.gradle.model.data.BuildScriptClasspathData;
import org.jetbrains.plugins.gradle.service.execution.GradleExternalTaskConfigurationType;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000b\u001a\u0004\u0018\u00010\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J\u0010\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0010\u001a\u00020\u0011J,\u0010\u0012\u001a\u0004\u0018\u00010\u00132\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u0014\u001a\u00020\u00132\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00130\u0016H\u0016J\u001e\u0010\u0017\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/idea/gradleJava/KotlinGradleFacadeImpl;", "Lorg/jetbrains/kotlin/idea/extensions/gradle/KotlinGradleFacade;", "()V", "gradleIcon", "Ljavax/swing/Icon;", "getGradleIcon", "()Ljavax/swing/Icon;", "runConfigurationFactory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "getRunConfigurationFactory", "()Lcom/intellij/execution/configurations/ConfigurationFactory;", "findKotlinPluginVersion", "Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion;", "node", "Lcom/intellij/openapi/externalSystem/model/DataNode;", "Lcom/intellij/openapi/externalSystem/model/project/ModuleData;", "classpathData", "Lorg/jetbrains/plugins/gradle/model/data/BuildScriptClasspathData;", "findLibraryVersionByModuleData", "", "groupId", "libraryIds", "", "findManipulator", "Lorg/jetbrains/kotlin/idea/extensions/gradle/GradleBuildScriptManipulator;", "file", "Lcom/intellij/psi/PsiFile;", "preferNewSyntax", "", "isDelegatedBuildEnabled", "module", "Lcom/intellij/openapi/module/Module;", "kotlin.gradle.gradle-java"})
public final class KotlinGradleFacadeImpl
implements KotlinGradleFacade {
    @NotNull
    public static final KotlinGradleFacadeImpl INSTANCE = new KotlinGradleFacadeImpl();

    private KotlinGradleFacadeImpl() {
    }

    @Override
    @NotNull
    public Icon getGradleIcon() {
        Icon icon2 = GradleIcons.Gradle;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Gradle");
        return icon2;
    }

    @Override
    @NotNull
    public ConfigurationFactory getRunConfigurationFactory() {
        ConfigurationFactory configurationFactory = GradleExternalTaskConfigurationType.getInstance().getConfigurationFactories()[0];
        Intrinsics.checkNotNullExpressionValue((Object)configurationFactory, (String)"GradleExternalTaskConfig\u2026configurationFactories[0]");
        return configurationFactory;
    }

    @Override
    public boolean isDelegatedBuildEnabled(@NotNull Module module2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        return GradleProjectSettings.isDelegatedBuildEnabled((Module)module2);
    }

    @Override
    @Nullable
    public IdeKotlinVersion findKotlinPluginVersion(@NotNull DataNode<ModuleData> node2) {
        Intrinsics.checkNotNullParameter(node2, (String)"node");
        Key key = BuildScriptClasspathData.KEY;
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"KEY");
        NodeWithData nodeWithData = (NodeWithData)CollectionsKt.firstOrNull(ProjectRootUtilsKt.findAll(node2, key));
        Object object = nodeWithData != null ? (BuildScriptClasspathData)nodeWithData.getData() : null;
        if (object == null) {
            return null;
        }
        BuildScriptClasspathData buildScriptClasspathData = object;
        return this.findKotlinPluginVersion(buildScriptClasspathData);
    }

    @Nullable
    public final IdeKotlinVersion findKotlinPluginVersion(@NotNull BuildScriptClasspathData classpathData) {
        Intrinsics.checkNotNullParameter((Object)classpathData, (String)"classpathData");
        List list2 = classpathData.getClasspathEntries();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"classpathData.classpathEntries");
        for (BuildScriptClasspathData.ClasspathEntry classPathEntry : CollectionsKt.asReversedMutable((List)list2)) {
            for (String path2 : classPathEntry.getClassesFile()) {
                String versionSubstring;
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"path");
                String uniformedPath = StringsKt.replace$default((String)path2, (char)'\\', (char)'/', (boolean)false, (int)4, null);
                if (!(StringsKt.contains$default((CharSequence)uniformedPath, (CharSequence)"org.jetbrains.kotlin/kotlin-gradle-plugin/", (boolean)false, (int)2, null) ? !Intrinsics.areEqual((Object)(versionSubstring = StringsKt.substringBefore((String)StringsKt.substringAfter$default((String)uniformedPath, (String)"org.jetbrains.kotlin/kotlin-gradle-plugin/", null, (int)2, null), (char)'/', (String)"<error>")), (Object)"<error>") : StringsKt.contains$default((CharSequence)uniformedPath, (CharSequence)KotlinGradleFacadeImplKt.access$getKOTLIN_PLUGIN_PATH_MARKER_FOR_MAVEN_LOCAL_REPO$p(), (boolean)false, (int)2, null) && !Intrinsics.areEqual((Object)(versionSubstring = StringsKt.substringBefore((String)StringsKt.substringAfter$default((String)uniformedPath, (String)KotlinGradleFacadeImplKt.access$getKOTLIN_PLUGIN_PATH_MARKER_FOR_MAVEN_LOCAL_REPO$p(), null, (int)2, null), (char)'/', (String)"<error>")), (Object)"<error>"))) continue;
                return IdeKotlinVersion.Companion.opt(versionSubstring);
            }
        }
        return null;
    }

    @Override
    @Nullable
    public String findLibraryVersionByModuleData(@NotNull DataNode<?> node2, @NotNull String groupId2, @NotNull List<String> libraryIds) {
        Intrinsics.checkNotNullParameter(node2, (String)"node");
        Intrinsics.checkNotNullParameter((Object)groupId2, (String)"groupId");
        Intrinsics.checkNotNullParameter(libraryIds, (String)"libraryIds");
        return KotlinGradleModelFacadeKt.getResolvedVersionByModuleData(node2, groupId2, libraryIds);
    }

    @Override
    @Nullable
    public GradleBuildScriptManipulator<?> findManipulator(@NotNull PsiFile file2, boolean preferNewSyntax) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        for (GradleBuildScriptSupport extension : GradleBuildScriptSupport.Companion.getEP_NAME().getExtensionList()) {
            GradleBuildScriptManipulator<?> gradleBuildScriptManipulator = extension.createManipulator(file2, preferNewSyntax, GradleVersionProviderImpl.INSTANCE);
            if (gradleBuildScriptManipulator == null) continue;
            return gradleBuildScriptManipulator;
        }
        return null;
    }
}

