/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.formatter;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.impl.source.codeStyle.PostFormatProcessorHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.formatter.CodeStyleUtilsKt;
import org.jetbrains.kotlin.idea.formatter.TrailingCommaPostFormatProcessorKt;
import org.jetbrains.kotlin.idea.formatter.TrailingCommaPostFormatVisitor;
import org.jetbrains.kotlin.idea.formatter.TrailingCommaVisitor;
import org.jetbrains.kotlin.idea.formatter.UtilsKt;
import org.jetbrains.kotlin.idea.formatter.trailingComma.TrailingCommaContext;
import org.jetbrains.kotlin.idea.formatter.trailingComma.TrailingCommaHelper;
import org.jetbrains.kotlin.idea.formatter.trailingComma.TrailingCommaState;
import org.jetbrains.kotlin.idea.formatter.trailingComma.UtilKt;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fJ\u0010\u0010\u000b\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J \u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\n2\u000e\b\u0002\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0015H\u0002J\u0016\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0017J\u001e\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\n2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\b0\u0015H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/idea/formatter/TrailingCommaPostFormatVisitor;", "Lorg/jetbrains/kotlin/idea/formatter/TrailingCommaVisitor;", "settings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "(Lcom/intellij/psi/codeStyle/CodeStyleSettings;)V", "myPostProcessor", "Lcom/intellij/psi/impl/source/codeStyle/PostFormatProcessorHelper;", "correctCommaPosition", "", "parent", "Lorg/jetbrains/kotlin/psi/KtElement;", "process", "Lcom/intellij/psi/PsiElement;", "formatted", "", "trailingCommaContext", "Lorg/jetbrains/kotlin/idea/formatter/trailingComma/TrailingCommaContext;", "processCommaOwner", "processIfInRange", "element", "block", "Lkotlin/Function0;", "processText", "Lcom/intellij/openapi/util/TextRange;", "source", "Lcom/intellij/psi/PsiFile;", "rangeToReformat", "updatePsi", "updater", "Companion", "kotlin.idea"})
final class TrailingCommaPostFormatVisitor
extends TrailingCommaVisitor {
    private final PostFormatProcessorHelper myPostProcessor;
    private final CodeStyleSettings settings;
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    @Override
    protected void process(@NotNull TrailingCommaContext trailingCommaContext) {
        Intrinsics.checkNotNullParameter((Object)trailingCommaContext, (String)"trailingCommaContext");
        this.processIfInRange(trailingCommaContext.getKtElement(), (Function0<Unit>)((Function0)new Function0<Unit>(this, trailingCommaContext){
            final /* synthetic */ TrailingCommaPostFormatVisitor this$0;
            final /* synthetic */ TrailingCommaContext $trailingCommaContext;

            public final void invoke() {
                TrailingCommaPostFormatVisitor.access$processCommaOwner(this.this$0, this.$trailingCommaContext);
            }
            {
                this.this$0 = trailingCommaPostFormatVisitor;
                this.$trailingCommaContext = trailingCommaContext;
                super(0);
            }
        }));
    }

    private final void processIfInRange(KtElement element3, Function0<Unit> block2) {
        if (this.myPostProcessor.isElementPartlyInRange((PsiElement)element3)) {
            block2.invoke();
        }
    }

    static /* synthetic */ void processIfInRange$default(TrailingCommaPostFormatVisitor trailingCommaPostFormatVisitor, KtElement ktElement, Function0 function0, int n, Object object) {
        if ((n & 2) != 0) {
            function0 = processIfInRange.1.INSTANCE;
        }
        trailingCommaPostFormatVisitor.processIfInRange(ktElement, (Function0<Unit>)function0);
    }

    private final void processCommaOwner(TrailingCommaContext trailingCommaContext) {
        KtElement ktElement = trailingCommaContext.getKtElement();
        PsiElement psiElement2 = TrailingCommaHelper.INSTANCE.trailingCommaOrLastElement(ktElement);
        if (psiElement2 == null) {
            return;
        }
        PsiElement lastElementOrComma = psiElement2;
        this.updatePsi(ktElement, (Function0<Boolean>)((Function0)new Function0<Boolean>(this, trailingCommaContext, ktElement, lastElementOrComma){
            final /* synthetic */ TrailingCommaPostFormatVisitor this$0;
            final /* synthetic */ TrailingCommaContext $trailingCommaContext;
            final /* synthetic */ KtElement $ktElement;
            final /* synthetic */ PsiElement $lastElementOrComma;

            public final boolean invoke() {
                boolean bl;
                TrailingCommaState state = this.$trailingCommaContext.getState();
                if (state == TrailingCommaState.MISSING && UtilKt.addTrailingCommaIsAllowedFor(CodeStyleUtilsKt.getKotlinCustomSettings(TrailingCommaPostFormatVisitor.access$getSettings$p(this.this$0)), (PsiElement)this.$ktElement)) {
                    boolean hasChange;
                    boolean bl2;
                    if (UtilsKt.trailingCommaAllowedInModule((PsiElement)this.$ktElement)) {
                        TrailingCommaPostFormatProcessorKt.access$addCommaAfter(this.$lastElementOrComma, new KtPsiFactory(this.$ktElement, false, 2, null));
                        bl2 = true;
                    } else {
                        bl2 = hasChange = false;
                    }
                    bl = TrailingCommaPostFormatVisitor.access$correctCommaPosition(this.this$0, this.$ktElement) || hasChange;
                } else if (state == TrailingCommaState.EXISTS) {
                    bl = TrailingCommaPostFormatVisitor.access$correctCommaPosition(this.this$0, this.$ktElement);
                } else if (state == TrailingCommaState.REDUNDANT) {
                    this.$lastElementOrComma.delete();
                    bl = true;
                } else {
                    bl = false;
                }
                return bl;
            }
            {
                this.this$0 = trailingCommaPostFormatVisitor;
                this.$trailingCommaContext = trailingCommaContext;
                this.$ktElement = ktElement;
                this.$lastElementOrComma = psiElement2;
                super(0);
            }
        }));
    }

    private final void updatePsi(KtElement element3, Function0<Boolean> updater2) {
        PsiElement psiElement2 = element3.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"element.parent");
        int oldLength = psiElement2.getTextLength();
        if (!((Boolean)updater2.invoke()).booleanValue()) {
            return;
        }
        PsiElement resultElement = org.jetbrains.kotlin.idea.util.PsiUtilsKt.reformatted((PsiElement)element3, true);
        PsiElement psiElement3 = resultElement.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"resultElement.parent");
        this.myPostProcessor.updateResultRange(oldLength, psiElement3.getTextLength());
    }

    /*
     * WARNING - void declaration
     */
    private final boolean correctCommaPosition(KtElement parent2) {
        void $this$mapTo$iv$iv;
        boolean hasChange = false;
        Iterable $this$map$iv = TrailingCommaHelper.INSTANCE.findInvalidCommas(parent2);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PsiElement psiElement2 = (PsiElement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            SmartPsiElementPointer smartPsiElementPointer = PsiUtilsKt.createSmartPointer((PsiElement)it);
            collection.add(smartPsiElementPointer);
        }
        for (SmartPsiElementPointer pointerToComma : (List)destination$iv$iv) {
            PsiElement psiElement3;
            if (pointerToComma.getElement() == null) continue;
            PsiElement it = psiElement3;
            boolean bl = false;
            PsiElement psiElement4 = it;
            Intrinsics.checkNotNullExpressionValue((Object)psiElement4, (String)"it");
            TrailingCommaPostFormatProcessorKt.access$correctComma(psiElement4);
            hasChange = true;
        }
        return hasChange || TrailingCommaHelper.INSTANCE.lineBreakIsMissing(parent2);
    }

    @NotNull
    public final PsiElement process(@NotNull PsiElement formatted) {
        Intrinsics.checkNotNullParameter((Object)formatted, (String)"formatted");
        LOG.assertTrue(formatted.isValid());
        formatted.accept((PsiElementVisitor)this);
        return formatted;
    }

    @NotNull
    public final TextRange processText(@NotNull PsiFile source, @NotNull TextRange rangeToReformat) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)rangeToReformat, (String)"rangeToReformat");
        this.myPostProcessor.setResultTextRange(rangeToReformat);
        source.accept((PsiElementVisitor)this);
        TextRange textRange = this.myPostProcessor.getResultTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"myPostProcessor.resultTextRange");
        return textRange;
    }

    public TrailingCommaPostFormatVisitor(@NotNull CodeStyleSettings settings2) {
        Intrinsics.checkNotNullParameter((Object)settings2, (String)"settings");
        this.settings = settings2;
        this.myPostProcessor = new PostFormatProcessorHelper((CommonCodeStyleSettings)CodeStyleUtilsKt.getKotlinCommonSettings(this.settings));
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(TrailingCommaVisitor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(Trail\u2026CommaVisitor::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ void access$processCommaOwner(TrailingCommaPostFormatVisitor $this, TrailingCommaContext trailingCommaContext) {
        $this.processCommaOwner(trailingCommaContext);
    }

    public static final /* synthetic */ CodeStyleSettings access$getSettings$p(TrailingCommaPostFormatVisitor $this) {
        return $this.settings;
    }

    public static final /* synthetic */ boolean access$correctCommaPosition(TrailingCommaPostFormatVisitor $this, KtElement parent2) {
        return $this.correctCommaPosition(parent2);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/formatter/TrailingCommaPostFormatVisitor$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "kotlin.idea"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

