/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.facet;

import com.intellij.facet.ui.FacetEditorContext;
import com.intellij.facet.ui.FacetEditorTab;
import com.intellij.facet.ui.FacetEditorValidator;
import com.intellij.facet.ui.FacetValidatorsManager;
import com.intellij.facet.ui.ValidationResult;
import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.RootsChangeRescanningInfo;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.ui.HoverHyperlinkLabel;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.ThreeStateCheckBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KAnnotatedElement;
import kotlin.reflect.KClass;
import kotlin.reflect.KProperty1;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.arguments.Argument;
import org.jetbrains.kotlin.cli.common.arguments.ArgumentParseErrors;
import org.jetbrains.kotlin.cli.common.arguments.ArgumentUtilsKt;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.CommonToolArguments;
import org.jetbrains.kotlin.cli.common.arguments.FreezableKt;
import org.jetbrains.kotlin.cli.common.arguments.K2JSCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.ParseCommandLineArgumentsKt;
import org.jetbrains.kotlin.config.CompilerSettings;
import org.jetbrains.kotlin.config.CompilerSettingsKt;
import org.jetbrains.kotlin.config.FacetSerializationKt;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.config.KotlinFacetSettings;
import org.jetbrains.kotlin.config.KotlinFacetSettingsKt;
import org.jetbrains.kotlin.config.KotlinMultiplatformVersion;
import org.jetbrains.kotlin.config.VersionView;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.compiler.configuration.Kotlin2JsCompilerArgumentsHolder;
import org.jetbrains.kotlin.idea.compiler.configuration.Kotlin2JvmCompilerArgumentsHolder;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinCommonCompilerArgumentsHolder;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinCompilerConfigurableTab;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinCompilerSettings;
import org.jetbrains.kotlin.idea.core.util.UiUtilsKt;
import org.jetbrains.kotlin.idea.facet.FacetUtilsKt;
import org.jetbrains.kotlin.idea.facet.KotlinFacetConfiguration;
import org.jetbrains.kotlin.idea.facet.KotlinFacetEditorGeneralTab;
import org.jetbrains.kotlin.idea.facet.KotlinFacetEditorGeneralTabKt;
import org.jetbrains.kotlin.idea.facet.KotlinFacetValidatorCreator;
import org.jetbrains.kotlin.idea.roots.RootUtilsKt;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.platform.CommonPlatforms;
import org.jetbrains.kotlin.platform.IdePlatformKind;
import org.jetbrains.kotlin.platform.IdePlatformKindUtil;
import org.jetbrains.kotlin.platform.PlatformUtilKt;
import org.jetbrains.kotlin.platform.SimplePlatform;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.TargetPlatformKt;
import org.jetbrains.kotlin.platform.js.JsPlatformKt;
import org.jetbrains.kotlin.platform.jvm.JdkPlatform;
import org.jetbrains.kotlin.platform.jvm.JvmPlatformKt;
import org.jetbrains.kotlin.platform.jvm.JvmPlatforms;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0003&'(B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0013H\u0016J\b\u0010\u0017\u001a\u00020\u0013H\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0006\u0010\u001a\u001a\u00020\u0013J\b\u0010\u001b\u001a\u00020\u0010H\u0016J\b\u0010\u001c\u001a\u00020\u0013H\u0002J\b\u0010\u001d\u001a\u00020\u0013H\u0016J\b\u0010\u001e\u001a\u00020\u0013H\u0016J\u0016\u0010\u001f\u001a\u00020\u00132\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00130!H\u0002J\f\u0010\"\u001a\u00020\u0013*\u00020#H\u0002J\u0010\u0010\"\u001a\u00020\u0013*\u0006\u0012\u0002\b\u00030$H\u0002J\f\u0010\"\u001a\u00020\u0013*\u00020%H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\t\u001a\u00020\n8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/idea/facet/KotlinFacetEditorGeneralTab;", "Lcom/intellij/facet/ui/FacetEditorTab;", "configuration", "Lorg/jetbrains/kotlin/idea/facet/KotlinFacetConfiguration;", "editorContext", "Lcom/intellij/facet/ui/FacetEditorContext;", "validatorsManager", "Lcom/intellij/facet/ui/FacetValidatorsManager;", "(Lorg/jetbrains/kotlin/idea/facet/KotlinFacetConfiguration;Lcom/intellij/facet/ui/FacetEditorContext;Lcom/intellij/facet/ui/FacetValidatorsManager;)V", "editor", "Lorg/jetbrains/kotlin/idea/facet/KotlinFacetEditorGeneralTab$EditorComponent;", "getEditor", "()Lorg/jetbrains/kotlin/idea/facet/KotlinFacetEditorGeneralTab$EditorComponent;", "editor$delegate", "Lkotlin/Lazy;", "enableValidation", "", "isInitialized", "apply", "", "createComponent", "Ljavax/swing/JComponent;", "disposeUIResources", "doValidate", "getDisplayName", "", "initializeIfNeeded", "isModified", "onLanguageLevelChanged", "onTabEntering", "reset", "validateOnce", "body", "Lkotlin/Function0;", "validateOnChange", "Ljavax/swing/AbstractButton;", "Ljavax/swing/JComboBox;", "Ljavax/swing/JTextField;", "ArgumentConsistencyValidator", "EditorComponent", "TargetPlatformWrapper", "kotlin.idea"})
public final class KotlinFacetEditorGeneralTab
extends FacetEditorTab {
    private boolean isInitialized;
    @NotNull
    private final Lazy editor$delegate;
    private boolean enableValidation;
    private final KotlinFacetConfiguration configuration;
    private final FacetEditorContext editorContext;
    private final FacetValidatorsManager validatorsManager;

    @NotNull
    public final EditorComponent getEditor() {
        Lazy lazy = this.editor$delegate;
        KotlinFacetEditorGeneralTab kotlinFacetEditorGeneralTab = this;
        Object var3_3 = null;
        return (EditorComponent)lazy.getValue();
    }

    private final void onLanguageLevelChanged() {
        KotlinCompilerConfigurableTab kotlinCompilerConfigurableTab;
        KotlinCompilerConfigurableTab $this$with = kotlinCompilerConfigurableTab = this.getEditor().getCompilerConfigurable();
        boolean bl = false;
        $this$with.onLanguageLevelChanged($this$with.getSelectedLanguageVersionView());
    }

    private final void validateOnChange(JTextField $this$validateOnChange) {
        UiUtilsKt.onTextChange($this$validateOnChange, (Function1<? super DocumentEvent, Unit>)((Function1)new Function1<DocumentEvent, Unit>(this){
            final /* synthetic */ KotlinFacetEditorGeneralTab this$0;

            public final void invoke(@NotNull DocumentEvent it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                KotlinFacetEditorGeneralTab.access$doValidate(this.this$0);
            }
            {
                this.this$0 = kotlinFacetEditorGeneralTab;
                super(1);
            }
        }));
    }

    private final void validateOnChange(AbstractButton $this$validateOnChange) {
        $this$validateOnChange.addChangeListener(new ChangeListener(this){
            final /* synthetic */ KotlinFacetEditorGeneralTab this$0;

            public final void stateChanged(ChangeEvent it) {
                KotlinFacetEditorGeneralTab.access$doValidate(this.this$0);
            }
            {
                this.this$0 = kotlinFacetEditorGeneralTab;
            }
        });
    }

    private final void validateOnChange(JComboBox<?> $this$validateOnChange) {
        $this$validateOnChange.addActionListener(new ActionListener(this){
            final /* synthetic */ KotlinFacetEditorGeneralTab this$0;

            public final void actionPerformed(ActionEvent it) {
                KotlinFacetEditorGeneralTab.access$doValidate(this.this$0);
            }
            {
                this.this$0 = kotlinFacetEditorGeneralTab;
            }
        });
    }

    private final void validateOnce(Function0<Unit> body2) {
        this.enableValidation = false;
        body2.invoke();
        this.enableValidation = true;
        this.doValidate();
    }

    private final void doValidate() {
        if (this.enableValidation) {
            this.validatorsManager.validate();
        }
    }

    public final void initializeIfNeeded() {
        KotlinCompilerConfigurableTab kotlinCompilerConfigurableTab;
        if (this.isInitialized) {
            return;
        }
        this.getEditor().initialize();
        for (KotlinFacetValidatorCreator creator : (KotlinFacetValidatorCreator[])KotlinFacetValidatorCreator.Companion.getEP_NAME().getExtensions()) {
            this.validatorsManager.registerValidator(creator.create(this.getEditor(), this.validatorsManager, this.editorContext), new JComponent[0]);
        }
        this.validatorsManager.registerValidator((FacetEditorValidator)new ArgumentConsistencyValidator(), new JComponent[0]);
        KotlinCompilerConfigurableTab $this$with = kotlinCompilerConfigurableTab = this.getEditor().getCompilerConfigurable();
        boolean bl = false;
        ThreeStateCheckBox threeStateCheckBox = $this$with.getReportWarningsCheckBox();
        Intrinsics.checkNotNullExpressionValue((Object)threeStateCheckBox, (String)"reportWarningsCheckBox");
        this.validateOnChange((AbstractButton)threeStateCheckBox);
        RawCommandLineEditor rawCommandLineEditor = $this$with.getAdditionalArgsOptionsField();
        Intrinsics.checkNotNullExpressionValue((Object)rawCommandLineEditor, (String)"additionalArgsOptionsField");
        JTextField jTextField = rawCommandLineEditor.getTextField();
        Intrinsics.checkNotNullExpressionValue((Object)jTextField, (String)"additionalArgsOptionsField.textField");
        this.validateOnChange(jTextField);
        ThreeStateCheckBox threeStateCheckBox2 = $this$with.getGenerateSourceMapsCheckBox();
        Intrinsics.checkNotNullExpressionValue((Object)threeStateCheckBox2, (String)"generateSourceMapsCheckBox");
        this.validateOnChange((AbstractButton)threeStateCheckBox2);
        TextFieldWithBrowseButton textFieldWithBrowseButton = $this$with.getOutputPrefixFile();
        Intrinsics.checkNotNullExpressionValue((Object)textFieldWithBrowseButton, (String)"outputPrefixFile");
        JTextField jTextField2 = textFieldWithBrowseButton.getTextField();
        Intrinsics.checkNotNullExpressionValue((Object)jTextField2, (String)"outputPrefixFile.textField");
        this.validateOnChange(jTextField2);
        TextFieldWithBrowseButton textFieldWithBrowseButton2 = $this$with.getOutputPostfixFile();
        Intrinsics.checkNotNullExpressionValue((Object)textFieldWithBrowseButton2, (String)"outputPostfixFile");
        JTextField jTextField3 = textFieldWithBrowseButton2.getTextField();
        Intrinsics.checkNotNullExpressionValue((Object)jTextField3, (String)"outputPostfixFile.textField");
        this.validateOnChange(jTextField3);
        TextFieldWithBrowseButton textFieldWithBrowseButton3 = $this$with.getOutputDirectory();
        Intrinsics.checkNotNullExpressionValue((Object)textFieldWithBrowseButton3, (String)"outputDirectory");
        JTextField jTextField4 = textFieldWithBrowseButton3.getTextField();
        Intrinsics.checkNotNullExpressionValue((Object)jTextField4, (String)"outputDirectory.textField");
        this.validateOnChange(jTextField4);
        ThreeStateCheckBox threeStateCheckBox3 = $this$with.getCopyRuntimeFilesCheckBox();
        Intrinsics.checkNotNullExpressionValue((Object)threeStateCheckBox3, (String)"copyRuntimeFilesCheckBox");
        this.validateOnChange((AbstractButton)threeStateCheckBox3);
        JComboBox<String> jComboBox = $this$with.getModuleKindComboBox();
        Intrinsics.checkNotNullExpressionValue(jComboBox, (String)"moduleKindComboBox");
        this.validateOnChange(jComboBox);
        $this$with.getLanguageVersionComboBox().addActionListener(new ActionListener(this){
            final /* synthetic */ KotlinFacetEditorGeneralTab this$0;
            {
                this.this$0 = kotlinFacetEditorGeneralTab;
            }

            public final void actionPerformed(ActionEvent it) {
                KotlinFacetEditorGeneralTab.access$onLanguageLevelChanged(this.this$0);
                KotlinFacetEditorGeneralTab.access$doValidate(this.this$0);
            }
        });
        JComboBox<VersionView> jComboBox2 = $this$with.getApiVersionComboBox();
        Intrinsics.checkNotNullExpressionValue(jComboBox2, (String)"apiVersionComboBox");
        this.validateOnChange(jComboBox2);
        this.validateOnChange((JComboBox)this.getEditor().getTargetPlatformSelectSingleCombobox());
        this.getEditor().updateCompilerConfigurable$kotlin_idea();
        this.isInitialized = true;
        this.reset();
    }

    public void onTabEntering() {
        this.initializeIfNeeded();
    }

    public boolean isModified() {
        SimplePlatform chosenSingle;
        Object object;
        if (!this.isInitialized) {
            return false;
        }
        if (this.getEditor().getUseProjectSettingsCheckBox().isSelected() != this.configuration.getSettings().getUseProjectSettings()) {
            return true;
        }
        TargetPlatform chosenPlatform = this.getEditor().getChosenPlatform();
        if (Intrinsics.areEqual((Object)chosenPlatform, (Object)this.configuration.getSettings().getTargetPlatform()) ^ true) {
            return true;
        }
        if (!KotlinFacetSettingsKt.isHmpp((KotlinMultiplatformVersion)this.configuration.getSettings().getMppVersion()) && !this.getEditor().getUseProjectSettingsCheckBox().isSelected()) {
            TargetPlatformWrapper targetPlatformWrapper;
            TargetPlatform targetPlatform = this.configuration.getSettings().getTargetPlatform();
            if (targetPlatform != null) {
                TargetPlatform targetPlatform2;
                TargetPlatform it = targetPlatform2 = targetPlatform;
                boolean bl = false;
                targetPlatformWrapper = new TargetPlatformWrapper(it);
            } else {
                targetPlatformWrapper = null;
            }
            if (Intrinsics.areEqual((Object)targetPlatformWrapper, (Object)KotlinFacetEditorGeneralTabKt.getSelectedItemTyped(this.getEditor().getTargetPlatformSelectSingleCombobox())) ^ true) {
                return true;
            }
        }
        SimplePlatform simplePlatform = (object = chosenPlatform) != null && (object = object.getComponentPlatforms()) != null ? (SimplePlatform)CollectionsKt.singleOrNull((Iterable)((Iterable)object)) : (chosenSingle = null);
        if (chosenSingle != null && Intrinsics.areEqual((Object)chosenSingle, (Object)JvmPlatforms.INSTANCE.getDefaultJvmPlatform()) && chosenSingle != this.configuration.getSettings().getTargetPlatform()) {
            return true;
        }
        return !this.getEditor().getUseProjectSettingsCheckBox().isSelected() && this.getEditor().getCompilerConfigurable().isModified();
    }

    public void reset() {
        if (!this.isInitialized) {
            return;
        }
        this.validateOnce((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ KotlinFacetEditorGeneralTab this$0;

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                Collection<String> collection;
                Collection<String> collection2;
                ComboBox<TargetPlatformWrapper> comboBox;
                Iterable iterable;
                Object object;
                ComboBox<TargetPlatformWrapper> comboBox2;
                block7: {
                    block6: {
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        this.this$0.getEditor().getUseProjectSettingsCheckBox().setSelected(KotlinFacetEditorGeneralTab.access$getConfiguration$p(this.this$0).getSettings().getUseProjectSettings());
                        this.this$0.getEditor().setTargetPlatformsCurrentlySelected(KotlinFacetEditorGeneralTab.access$getConfiguration$p(this.this$0).getSettings().getTargetPlatform());
                        comboBox2 = this.this$0.getEditor().getTargetPlatformLabel();
                        object = this.this$0.getEditor().getTargetPlatformsCurrentlySelected();
                        if (object == null || (object = object.getComponentPlatforms()) == null) break block6;
                        iterable = (Iterable)object;
                        comboBox = comboBox2;
                        boolean $i$f$map = false;
                        void var3_5 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            SimplePlatform simplePlatform = (SimplePlatform)item$iv$iv;
                            collection2 = destination$iv$iv;
                            boolean bl = false;
                            String string = it.getOldFashionedDescription();
                            String string2 = ((Object)StringsKt.trim((CharSequence)string)).toString();
                            collection2.add(string2);
                        }
                        collection2 = (List)destination$iv$iv;
                        comboBox2 = comboBox;
                        object = CollectionsKt.joinToString$default((Iterable)collection2, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
                        if (object != null) break block7;
                    }
                    object = "<none>";
                }
                comboBox2.setText((String)object);
                iterable = KotlinFacetEditorGeneralTab.access$getConfiguration$p(this.this$0).getSettings().getDependsOnModuleNames();
                this.this$0.getEditor().getDependsOnLabel().setVisible(!iterable.isEmpty());
                this.this$0.getEditor().getDependsOnLabel().setText(KotlinBundle.message("facets.editor.general.tab.label.depends.on.0", CollectionsKt.joinToString$default((Iterable)KotlinFacetEditorGeneralTab.access$getConfiguration$p(this.this$0).getSettings().getDependsOnModuleNames(), null, null, null, (int)0, null, null, (int)63, null)));
                ComboBox<TargetPlatformWrapper> comboBox3 = this.this$0.getEditor().getTargetPlatformSelectSingleCombobox();
                TargetPlatform targetPlatform = KotlinFacetEditorGeneralTab.access$getConfiguration$p(this.this$0).getSettings().getTargetPlatform();
                if (targetPlatform != null) {
                    void it;
                    Iterable $i$f$map = iterable = targetPlatform;
                    comboBox = comboBox3;
                    boolean bl = false;
                    int index2 = this.this$0.getEditor().getTargetPlatformWrappers().indexOf(new TargetPlatformWrapper((TargetPlatform)it));
                    collection2 = index2 >= 0 ? this.this$0.getEditor().getTargetPlatformWrappers().get(index2) : null;
                    comboBox3 = comboBox;
                    collection = collection2;
                } else {
                    collection = null;
                }
                comboBox3.setSelectedItem(collection);
                this.this$0.getEditor().getCompilerConfigurable().reset();
                this.this$0.getEditor().updateCompilerConfigurable$kotlin_idea();
            }
            {
                this.this$0 = kotlinFacetEditorGeneralTab;
                super(0);
            }
        }));
    }

    public void apply() {
        this.initializeIfNeeded();
        this.validateOnce((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ KotlinFacetEditorGeneralTab this$0;

            public final void invoke() {
                KotlinFacetSettings $this$with;
                block2: {
                    TargetPlatform it;
                    block3: {
                        TargetPlatform targetPlatform;
                        KotlinFacetSettings kotlinFacetSettings;
                        this.this$0.getEditor().getCompilerConfigurable().apply();
                        $this$with = kotlinFacetSettings = KotlinFacetEditorGeneralTab.access$getConfiguration$p(this.this$0).getSettings();
                        boolean bl = false;
                        $this$with.setUseProjectSettings(this.this$0.getEditor().getUseProjectSettingsCheckBox().isSelected());
                        TargetPlatform targetPlatform2 = this.this$0.getEditor().getChosenPlatform();
                        if (targetPlatform2 == null) break block2;
                        it = targetPlatform = targetPlatform2;
                        boolean bl2 = false;
                        if (Intrinsics.areEqual((Object)it, (Object)$this$with.getTargetPlatform()) ^ true) break block3;
                        if (!this.this$0.isModified()) break block2;
                    }
                    CommonCompilerArguments platformArguments = JvmPlatformKt.isJvm((TargetPlatform)it) ? (CommonCompilerArguments)this.this$0.getEditor().getCompilerConfigurable().getK2jvmCompilerArguments() : (JsPlatformKt.isJs((TargetPlatform)it) ? (CommonCompilerArguments)this.this$0.getEditor().getCompilerConfigurable().getK2jsCompilerArguments() : null);
                    $this$with.setCompilerArguments(FacetSerializationKt.createArguments((TargetPlatform)it, (Function1)((Function1)new Function1<CommonCompilerArguments, Unit>(platformArguments, $this$with, this){
                        final /* synthetic */ CommonCompilerArguments $platformArguments;
                        final /* synthetic */ KotlinFacetSettings $this_with$inlined;
                        final /* synthetic */ apply.1 this$0;
                        {
                            this.$platformArguments = commonCompilerArguments;
                            this.$this_with$inlined = kotlinFacetSettings;
                            this.this$0 = var3_3;
                            super(1);
                        }

                        public final void invoke(@NotNull CommonCompilerArguments $this$createArguments) {
                            Intrinsics.checkNotNullParameter((Object)$this$createArguments, (String)"$receiver");
                            if (this.$platformArguments != null) {
                                ArgumentUtilsKt.mergeBeans((Object)this.$platformArguments, (Object)$this$createArguments);
                            }
                            CommonCompilerArguments commonCompilerArguments = this.$this_with$inlined.getCompilerArguments();
                            Intrinsics.checkNotNull((Object)commonCompilerArguments);
                            ArgumentUtilsKt.copyInheritedFields((Object)commonCompilerArguments, (Object)$this$createArguments);
                        }
                    })));
                }
                KotlinFacetEditorGeneralTab.access$getConfiguration$p(this.this$0).getSettings().setTargetPlatform(this.this$0.getEditor().getChosenPlatform());
                $this$with.updateMergedArguments();
                ApplicationUtilsKt.runWriteAction((Function0)new Function0<Unit>(this){
                    final /* synthetic */ apply.1 this$0;
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }

                    public final void invoke() {
                        Project project2 = KotlinFacetEditorGeneralTab.access$getEditorContext$p(this.this$0.this$0).getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"editorContext.project");
                        RootsChangeRescanningInfo rootsChangeRescanningInfo = RootsChangeRescanningInfo.NO_RESCAN_NEEDED;
                        Intrinsics.checkNotNullExpressionValue((Object)rootsChangeRescanningInfo, (String)"RootsChangeRescanningInfo.NO_RESCAN_NEEDED");
                        RootUtilsKt.invalidateProjectRoots(project2, rootsChangeRescanningInfo);
                    }
                });
            }
            {
                this.this$0 = kotlinFacetEditorGeneralTab;
                super(0);
            }
        }));
    }

    @NotNull
    public String getDisplayName() {
        return KotlinBundle.message("facet.name.general", new Object[0]);
    }

    @NotNull
    public JComponent createComponent() {
        return this.getEditor();
    }

    public void disposeUIResources() {
        if (this.isInitialized) {
            this.getEditor().getCompilerConfigurable().disposeUIResources();
        }
    }

    public KotlinFacetEditorGeneralTab(@NotNull KotlinFacetConfiguration configuration2, @NotNull FacetEditorContext editorContext, @NotNull FacetValidatorsManager validatorsManager) {
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)editorContext, (String)"editorContext");
        Intrinsics.checkNotNullParameter((Object)validatorsManager, (String)"validatorsManager");
        this.configuration = configuration2;
        this.editorContext = editorContext;
        this.validatorsManager = validatorsManager;
        this.editor$delegate = LazyKt.lazy((Function0)((Function0)new Function0<EditorComponent>(this){
            final /* synthetic */ KotlinFacetEditorGeneralTab this$0;

            @NotNull
            public final EditorComponent invoke() {
                Project project2 = KotlinFacetEditorGeneralTab.access$getEditorContext$p(this.this$0).getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"editorContext.project");
                return new EditorComponent(project2, KotlinFacetEditorGeneralTab.access$getConfiguration$p(this.this$0));
            }
            {
                this.this$0 = kotlinFacetEditorGeneralTab;
                super(0);
            }
        }));
    }

    public static final /* synthetic */ void access$doValidate(KotlinFacetEditorGeneralTab $this) {
        $this.doValidate();
    }

    public static final /* synthetic */ void access$onLanguageLevelChanged(KotlinFacetEditorGeneralTab $this) {
        $this.onLanguageLevelChanged();
    }

    public static final /* synthetic */ KotlinFacetConfiguration access$getConfiguration$p(KotlinFacetEditorGeneralTab $this) {
        return $this.configuration;
    }

    public static final /* synthetic */ FacetEditorContext access$getEditorContext$p(KotlinFacetEditorGeneralTab $this) {
        return $this.editorContext;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u0001H\u0096\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/facet/KotlinFacetEditorGeneralTab$TargetPlatformWrapper;", "", "targetPlatform", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "(Lorg/jetbrains/kotlin/platform/TargetPlatform;)V", "getTargetPlatform", "()Lorg/jetbrains/kotlin/platform/TargetPlatform;", "equals", "", "other", "kotlin.idea"})
    public static final class TargetPlatformWrapper {
        @NotNull
        private final TargetPlatform targetPlatform;

        public boolean equals(@Nullable Object other) {
            if (other instanceof TargetPlatformWrapper && Intrinsics.areEqual((Object)this.targetPlatform, (Object)((TargetPlatformWrapper)other).targetPlatform)) {
                return this.targetPlatform.size() == 1 ? (SimplePlatform)CollectionsKt.singleOrNull((Iterable)this.targetPlatform.getComponentPlatforms()) == (SimplePlatform)CollectionsKt.singleOrNull((Iterable)((TargetPlatformWrapper)other).targetPlatform.getComponentPlatforms()) : true;
            }
            return false;
        }

        @NotNull
        public final TargetPlatform getTargetPlatform() {
            return this.targetPlatform;
        }

        public TargetPlatformWrapper(@NotNull TargetPlatform targetPlatform) {
            Intrinsics.checkNotNullParameter((Object)targetPlatform, (String)"targetPlatform");
            this.targetPlatform = targetPlatform;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010B\u001a\u0004\u0018\u000104J\u0006\u0010C\u001a\u00020DJ\u0010\u0010E\u001a\u00020D2\u0006\u0010F\u001a\u00020\u001bH\u0002J\u0010\u0010G\u001a\u00020H2\u0006\u0010I\u001a\u00020HH\u0002J\u0010\u0010J\u001a\u00020K2\u0006\u0010L\u001a\u00020KH\u0002J\r\u0010M\u001a\u00020DH\u0000\u00a2\u0006\u0002\bNJ\f\u0010O\u001a\u00020P*\u00020PH\u0002R\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\rX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\u00020\u001b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010 \u001a\u00020\rX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u000f\"\u0004\b\"\u0010\u0011R\u001a\u0010#\u001a\u00020\rX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\u000f\"\u0004\b%\u0010\u0011R \u0010&\u001a\b\u0012\u0004\u0012\u00020(0'X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R \u0010-\u001a\b\u0012\u0004\u0012\u00020(0.X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u00100\"\u0004\b1\u00102R\u001c\u00103\u001a\u0004\u0018\u000104X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u00106\"\u0004\b7\u00108R\u001a\u00109\u001a\u00020:X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u0010<\"\u0004\b=\u0010>R\u001a\u0010?\u001a\u00020\rX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b@\u0010\u000f\"\u0004\bA\u0010\u0011\u00a8\u0006Q"}, d2={"Lorg/jetbrains/kotlin/idea/facet/KotlinFacetEditorGeneralTab$EditorComponent;", "Ljavax/swing/JPanel;", "project", "Lcom/intellij/openapi/project/Project;", "configuration", "Lorg/jetbrains/kotlin/idea/facet/KotlinFacetConfiguration;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/kotlin/idea/facet/KotlinFacetConfiguration;)V", "<set-?>", "Lorg/jetbrains/kotlin/idea/compiler/configuration/KotlinCompilerConfigurableTab;", "compilerConfigurable", "getCompilerConfigurable", "()Lorg/jetbrains/kotlin/idea/compiler/configuration/KotlinCompilerConfigurableTab;", "dependsOnLabel", "Ljavax/swing/JLabel;", "getDependsOnLabel", "()Ljavax/swing/JLabel;", "setDependsOnLabel", "(Ljavax/swing/JLabel;)V", "editableCommonArguments", "Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;", "editableCompilerSettings", "Lorg/jetbrains/kotlin/config/CompilerSettings;", "editableJsArguments", "Lorg/jetbrains/kotlin/cli/common/arguments/K2JSCompilerArguments;", "editableJvmArguments", "Lorg/jetbrains/kotlin/cli/common/arguments/K2JVMCompilerArguments;", "isInTargetPlatformChangeAction", "", "isMultiEditor", "()Z", "projectSettingsLink", "Lcom/intellij/ui/HoverHyperlinkLabel;", "targetPlatformFacetLabel", "getTargetPlatformFacetLabel", "setTargetPlatformFacetLabel", "targetPlatformLabel", "getTargetPlatformLabel", "setTargetPlatformLabel", "targetPlatformSelectSingleCombobox", "Lcom/intellij/openapi/ui/ComboBox;", "Lorg/jetbrains/kotlin/idea/facet/KotlinFacetEditorGeneralTab$TargetPlatformWrapper;", "getTargetPlatformSelectSingleCombobox", "()Lcom/intellij/openapi/ui/ComboBox;", "setTargetPlatformSelectSingleCombobox", "(Lcom/intellij/openapi/ui/ComboBox;)V", "targetPlatformWrappers", "", "getTargetPlatformWrappers", "()Ljava/util/List;", "setTargetPlatformWrappers", "(Ljava/util/List;)V", "targetPlatformsCurrentlySelected", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "getTargetPlatformsCurrentlySelected", "()Lorg/jetbrains/kotlin/platform/TargetPlatform;", "setTargetPlatformsCurrentlySelected", "(Lorg/jetbrains/kotlin/platform/TargetPlatform;)V", "useProjectSettingsCheckBox", "Lcom/intellij/util/ui/ThreeStateCheckBox;", "getUseProjectSettingsCheckBox", "()Lcom/intellij/util/ui/ThreeStateCheckBox;", "setUseProjectSettingsCheckBox", "(Lcom/intellij/util/ui/ThreeStateCheckBox;)V", "useProjectSettingsWarningLabel", "getUseProjectSettingsWarningLabel", "setUseProjectSettingsWarningLabel", "getChosenPlatform", "initialize", "", "setupTargetPlatformCombobox", "useProjectSettings", "targetPlatformsComboboxRowsCount", "", "targetPlatforms", "unifyJvmVersion", "", "version", "updateCompilerConfigurable", "updateCompilerConfigurable$kotlin_idea", "addTargetPlatformComponents", "Lcom/intellij/util/ui/FormBuilder;", "kotlin.idea"})
    public static final class EditorComponent
    extends JPanel {
        private CommonCompilerArguments editableCommonArguments;
        private K2JVMCompilerArguments editableJvmArguments;
        private K2JSCompilerArguments editableJsArguments;
        private CompilerSettings editableCompilerSettings;
        private KotlinCompilerConfigurableTab compilerConfigurable;
        public ThreeStateCheckBox useProjectSettingsCheckBox;
        public ComboBox<TargetPlatformWrapper> targetPlatformSelectSingleCombobox;
        public JLabel dependsOnLabel;
        public List<TargetPlatformWrapper> targetPlatformWrappers;
        public JLabel targetPlatformLabel;
        @Nullable
        private TargetPlatform targetPlatformsCurrentlySelected;
        private HoverHyperlinkLabel projectSettingsLink;
        public JLabel targetPlatformFacetLabel;
        public JLabel useProjectSettingsWarningLabel;
        private volatile boolean isInTargetPlatformChangeAction;
        private final Project project;
        private final KotlinFacetConfiguration configuration;

        private final boolean isMultiEditor() {
            return this.configuration == null;
        }

        @NotNull
        public final KotlinCompilerConfigurableTab getCompilerConfigurable() {
            KotlinCompilerConfigurableTab kotlinCompilerConfigurableTab = this.compilerConfigurable;
            if (kotlinCompilerConfigurableTab == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"compilerConfigurable");
            }
            return kotlinCompilerConfigurableTab;
        }

        @NotNull
        public final ThreeStateCheckBox getUseProjectSettingsCheckBox() {
            ThreeStateCheckBox threeStateCheckBox = this.useProjectSettingsCheckBox;
            if (threeStateCheckBox == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"useProjectSettingsCheckBox");
            }
            return threeStateCheckBox;
        }

        public final void setUseProjectSettingsCheckBox(@NotNull ThreeStateCheckBox threeStateCheckBox) {
            Intrinsics.checkNotNullParameter((Object)threeStateCheckBox, (String)"<set-?>");
            this.useProjectSettingsCheckBox = threeStateCheckBox;
        }

        @NotNull
        public final ComboBox<TargetPlatformWrapper> getTargetPlatformSelectSingleCombobox() {
            ComboBox<TargetPlatformWrapper> comboBox = this.targetPlatformSelectSingleCombobox;
            if (comboBox == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"targetPlatformSelectSingleCombobox");
            }
            return comboBox;
        }

        public final void setTargetPlatformSelectSingleCombobox(@NotNull ComboBox<TargetPlatformWrapper> comboBox) {
            Intrinsics.checkNotNullParameter(comboBox, (String)"<set-?>");
            this.targetPlatformSelectSingleCombobox = comboBox;
        }

        @NotNull
        public final JLabel getDependsOnLabel() {
            JLabel jLabel = this.dependsOnLabel;
            if (jLabel == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"dependsOnLabel");
            }
            return jLabel;
        }

        public final void setDependsOnLabel(@NotNull JLabel jLabel) {
            Intrinsics.checkNotNullParameter((Object)jLabel, (String)"<set-?>");
            this.dependsOnLabel = jLabel;
        }

        @NotNull
        public final List<TargetPlatformWrapper> getTargetPlatformWrappers() {
            List<TargetPlatformWrapper> list2 = this.targetPlatformWrappers;
            if (list2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"targetPlatformWrappers");
            }
            return list2;
        }

        public final void setTargetPlatformWrappers(@NotNull List<TargetPlatformWrapper> list2) {
            Intrinsics.checkNotNullParameter(list2, (String)"<set-?>");
            this.targetPlatformWrappers = list2;
        }

        @NotNull
        public final JLabel getTargetPlatformLabel() {
            JLabel jLabel = this.targetPlatformLabel;
            if (jLabel == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"targetPlatformLabel");
            }
            return jLabel;
        }

        public final void setTargetPlatformLabel(@NotNull JLabel jLabel) {
            Intrinsics.checkNotNullParameter((Object)jLabel, (String)"<set-?>");
            this.targetPlatformLabel = jLabel;
        }

        @Nullable
        public final TargetPlatform getTargetPlatformsCurrentlySelected() {
            return this.targetPlatformsCurrentlySelected;
        }

        public final void setTargetPlatformsCurrentlySelected(@Nullable TargetPlatform targetPlatform) {
            this.targetPlatformsCurrentlySelected = targetPlatform;
        }

        @NotNull
        public final JLabel getTargetPlatformFacetLabel() {
            JLabel jLabel = this.targetPlatformFacetLabel;
            if (jLabel == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"targetPlatformFacetLabel");
            }
            return jLabel;
        }

        public final void setTargetPlatformFacetLabel(@NotNull JLabel jLabel) {
            Intrinsics.checkNotNullParameter((Object)jLabel, (String)"<set-?>");
            this.targetPlatformFacetLabel = jLabel;
        }

        @NotNull
        public final JLabel getUseProjectSettingsWarningLabel() {
            JLabel jLabel = this.useProjectSettingsWarningLabel;
            if (jLabel == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"useProjectSettingsWarningLabel");
            }
            return jLabel;
        }

        public final void setUseProjectSettingsWarningLabel(@NotNull JLabel jLabel) {
            Intrinsics.checkNotNullParameter((Object)jLabel, (String)"<set-?>");
            this.useProjectSettingsWarningLabel = jLabel;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final FormBuilder addTargetPlatformComponents(FormBuilder $this$addTargetPlatformComponents) {
            FormBuilder formBuilder;
            this.targetPlatformFacetLabel = new JLabel(KotlinBundle.message("facet.label.text.target.platform", new Object[0]));
            KotlinFacetConfiguration kotlinFacetConfiguration = this.configuration;
            if (kotlinFacetConfiguration != null && (kotlinFacetConfiguration = kotlinFacetConfiguration.getSettings()) != null && (kotlinFacetConfiguration = kotlinFacetConfiguration.getMppVersion()) != null) {
                if (KotlinFacetSettingsKt.isHmpp((KotlinMultiplatformVersion)kotlinFacetConfiguration)) {
                    JLabel jLabel = this.targetPlatformLabel;
                    if (jLabel == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"targetPlatformLabel");
                    }
                    jLabel.setToolTipText(KotlinBundle.message("facet.label.text.the.project.is.imported.from.external.build.system.and.could.not.be.edited", new Object[0]));
                    String string = KotlinBundle.message("facet.label.text.selected.target.platforms", new Object[0]);
                    JLabel jLabel2 = this.targetPlatformLabel;
                    if (jLabel2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"targetPlatformLabel");
                    }
                    FormBuilder formBuilder2 = $this$addTargetPlatformComponents.addLabeledComponent(string, (JComponent)jLabel2);
                    formBuilder = formBuilder2;
                    Intrinsics.checkNotNullExpressionValue((Object)formBuilder2, (String)"addLabeledComponent(\n   \u2026rmLabel\n                )");
                    return formBuilder;
                }
            }
            JLabel jLabel = this.targetPlatformFacetLabel;
            if (jLabel == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"targetPlatformFacetLabel");
            }
            JComponent jComponent = jLabel;
            ComboBox<TargetPlatformWrapper> comboBox = this.targetPlatformSelectSingleCombobox;
            if (comboBox == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"targetPlatformSelectSingleCombobox");
            }
            FormBuilder formBuilder3 = $this$addTargetPlatformComponents.addLabeledComponent(jComponent, (JComponent)comboBox);
            formBuilder = formBuilder3;
            Intrinsics.checkNotNullExpressionValue((Object)formBuilder3, (String)"addLabeledComponent(\n   \u2026ombobox\n                )");
            return formBuilder;
        }

        private final String unifyJvmVersion(String version2) {
            return version2.equals("JVM 9") ? "JVM 1.9" : version2;
        }

        private final int targetPlatformsComboboxRowsCount(int targetPlatforms) {
            return targetPlatforms <= 15 ? targetPlatforms : 10;
        }

        /*
         * WARNING - void declaration
         */
        public final void initialize() {
            JComponent $this$apply;
            TargetPlatformWrapper targetPlatformWrapper;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Object $this$apply2;
            if (this.isMultiEditor()) {
                this.editableCommonArguments = new CommonCompilerArguments(){};
                this.editableJvmArguments = new K2JVMCompilerArguments();
                this.editableJsArguments = new K2JSCompilerArguments();
                this.editableCompilerSettings = new CompilerSettings();
            } else {
                K2JSCompilerArguments k2JSCompilerArguments;
                K2JVMCompilerArguments k2JVMCompilerArguments;
                KotlinFacetConfiguration kotlinFacetConfiguration = this.configuration;
                Intrinsics.checkNotNull((Object)kotlinFacetConfiguration);
                CommonCompilerArguments commonCompilerArguments = kotlinFacetConfiguration.getSettings().getCompilerArguments();
                Intrinsics.checkNotNull((Object)commonCompilerArguments);
                CommonCompilerArguments commonCompilerArguments2 = this.editableCommonArguments = commonCompilerArguments;
                if (commonCompilerArguments2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"editableCommonArguments");
                }
                CommonCompilerArguments commonCompilerArguments3 = commonCompilerArguments2;
                if (!(commonCompilerArguments2 instanceof K2JVMCompilerArguments)) {
                    commonCompilerArguments3 = null;
                }
                if ((k2JVMCompilerArguments = (K2JVMCompilerArguments)commonCompilerArguments3) == null) {
                    k2JVMCompilerArguments = (K2JVMCompilerArguments)FreezableKt.unfrozen(Kotlin2JvmCompilerArgumentsHolder.Companion.getInstance(this.project).getSettings());
                }
                this.editableJvmArguments = k2JVMCompilerArguments;
                CommonCompilerArguments commonCompilerArguments4 = this.editableCommonArguments;
                if (commonCompilerArguments4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"editableCommonArguments");
                }
                CommonCompilerArguments commonCompilerArguments5 = commonCompilerArguments4;
                if (!(commonCompilerArguments4 instanceof K2JSCompilerArguments)) {
                    commonCompilerArguments5 = null;
                }
                if ((k2JSCompilerArguments = (K2JSCompilerArguments)commonCompilerArguments5) == null) {
                    k2JSCompilerArguments = (K2JSCompilerArguments)FreezableKt.unfrozen(Kotlin2JsCompilerArgumentsHolder.Companion.getInstance(this.project).getSettings());
                }
                this.editableJsArguments = k2JSCompilerArguments;
                CompilerSettings compilerSettings = this.configuration.getSettings().getCompilerSettings();
                Intrinsics.checkNotNull((Object)compilerSettings);
                this.editableCompilerSettings = compilerSettings;
            }
            CommonCompilerArguments commonCompilerArguments = this.editableCommonArguments;
            if (commonCompilerArguments == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"editableCommonArguments");
            }
            K2JSCompilerArguments k2JSCompilerArguments = this.editableJsArguments;
            if (k2JSCompilerArguments == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"editableJsArguments");
            }
            K2JVMCompilerArguments k2JVMCompilerArguments = this.editableJvmArguments;
            if (k2JVMCompilerArguments == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"editableJvmArguments");
            }
            CompilerSettings compilerSettings = this.editableCompilerSettings;
            if (compilerSettings == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"editableCompilerSettings");
            }
            this.compilerConfigurable = new KotlinCompilerConfigurableTab(this.project, commonCompilerArguments, k2JSCompilerArguments, k2JVMCompilerArguments, compilerSettings, null, false, this.isMultiEditor());
            Object object = new ThreeStateCheckBox(KotlinBundle.message("facet.checkbox.text.use.project.settings", new Object[0]));
            ThreeStateCheckBox threeStateCheckBox = object;
            EditorComponent editorComponent = this;
            boolean bl = false;
            $this$apply2.setThirdStateEnabled(this.isMultiEditor());
            Object object2 = Unit.INSTANCE;
            editorComponent.useProjectSettingsCheckBox = object;
            $this$apply2 = object = new JLabel();
            editorComponent = this;
            boolean $i$a$-apply-KotlinFacetEditorGeneralTab$EditorComponent$initialize$42 = false;
            ((JLabel)$this$apply2).setIcon(AllIcons.General.WarningDialog);
            ((JLabel)$this$apply2).setText(KotlinBundle.message("facet.label.text.project.settings.that.are.used.for.this.facet", new Object[0]));
            ((JLabel)$this$apply2).setIconTextGap(5);
            ((JComponent)$this$apply2).setVisible(false);
            object2 = Unit.INSTANCE;
            editorComponent.useProjectSettingsWarningLabel = object;
            this.dependsOnLabel = new JLabel();
            Iterable $this$sortedBy$iv = CommonPlatforms.INSTANCE.getAllDefaultTargetPlatforms();
            boolean $i$f$sortedBy = false;
            $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(this){
                final /* synthetic */ EditorComponent this$0;
                {
                    this.this$0 = editorComponent;
                }

                public final int compare(T a, T b) {
                    TargetPlatform it = (TargetPlatform)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)EditorComponent.access$unifyJvmVersion(this.this$0, PlatformUtilKt.getOldFashionedDescription((TargetPlatform)it)));
                    it = (TargetPlatform)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    String string = EditorComponent.access$unifyJvmVersion(this.this$0, PlatformUtilKt.getOldFashionedDescription((TargetPlatform)it));
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
                }
            });
            editorComponent = this;
            boolean $i$f$map = false;
            void $i$a$-apply-KotlinFacetEditorGeneralTab$EditorComponent$initialize$42 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                TargetPlatform targetPlatform = (TargetPlatform)item$iv$iv;
                object2 = destination$iv$iv;
                boolean bl2 = false;
                targetPlatformWrapper = new TargetPlatformWrapper((TargetPlatform)it);
                object2.add(targetPlatformWrapper);
            }
            object2 = (List)destination$iv$iv;
            editorComponent.targetPlatformWrappers = object2;
            this.targetPlatformLabel = new JLabel();
            List<TargetPlatformWrapper> list2 = this.targetPlatformWrappers;
            if (list2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"targetPlatformWrappers");
            }
            Collection $this$toTypedArray$iv = list2;
            boolean $i$f$toTypedArray22 = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Collection $i$f$toTypedArray22 = $this$toTypedArray$iv = new ComboBox((Object[])thisCollection$iv.toArray(new TargetPlatformWrapper[0]));
            editorComponent = this;
            boolean bl3 = false;
            $this$apply22.setRenderer(new DefaultListCellRenderer(){

                @NotNull
                public Component getListCellRendererComponent(@Nullable JList<?> list2, @Nullable Object value2, int index2, boolean isSelected, boolean cellHasFocus) {
                    Object object;
                    SimplePlatform specificPlatform;
                    Object object2;
                    Component component2;
                    Component $this$apply = component2 = super.getListCellRendererComponent(list2, value2, index2, isSelected, cellHasFocus);
                    boolean bl = false;
                    Object object3 = value2;
                    if (!(object3 instanceof TargetPlatformWrapper)) {
                        object3 = null;
                    }
                    if ((object2 = (specificPlatform = (object = (TargetPlatformWrapper)object3) != null && (object = ((TargetPlatformWrapper)object).getTargetPlatform()) != null && (object = object.getComponentPlatforms()) != null ? (SimplePlatform)CollectionsKt.singleOrNull((Iterable)((Iterable)object)) : null)) == null || (object2 = object2.getOldFashionedDescription()) == null) {
                        object2 = KotlinBundle.message("facet.text.multiplatform", new Object[0]);
                    }
                    this.setText((String)object2);
                    if (specificPlatform instanceof JdkPlatform && ((JdkPlatform)specificPlatform).getTargetVersion() == JvmTarget.JVM_1_6) {
                        initialize.6.1 v3 = this;
                        v3.setText(v3.getText() + " " + KotlinBundle.message("deprecated.jvm.version", new Object[0]));
                    }
                    Component component3 = component2;
                    Intrinsics.checkNotNullExpressionValue((Object)component3, (String)"super.getListCellRendere\u2026                        }");
                    return component3;
                }
            });
            object2 = Unit.INSTANCE;
            editorComponent.targetPlatformSelectSingleCombobox = $this$toTypedArray$iv;
            ComboBox<TargetPlatformWrapper> comboBox = this.targetPlatformSelectSingleCombobox;
            if (comboBox == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"targetPlatformSelectSingleCombobox");
            }
            List<TargetPlatformWrapper> list3 = this.targetPlatformWrappers;
            if (list3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"targetPlatformWrappers");
            }
            comboBox.setMaximumRowCount(this.targetPlatformsComboboxRowsCount(list3.size()));
            Collection $this$apply22 = $this$toTypedArray$iv = new HoverHyperlinkLabel(KotlinBundle.message("facet.link.text.edit.project.settings", new Object[0]));
            editorComponent = this;
            boolean $i$a$-apply-KotlinFacetEditorGeneralTab$EditorComponent$initialize$82 = false;
            $this$apply22.addHyperlinkListener(new HyperlinkListener(this){
                final /* synthetic */ EditorComponent this$0;
                {
                    this.this$0 = editorComponent;
                }

                public final void hyperlinkUpdate(HyperlinkEvent it) {
                    ShowSettingsUtilImpl.showSettingsDialog((Project)EditorComponent.access$getProject$p(this.this$0), (String)this.this$0.getCompilerConfigurable().getId(), (String)"");
                    if (this.this$0.getUseProjectSettingsCheckBox().isSelected()) {
                        this.this$0.updateCompilerConfigurable$kotlin_idea();
                    }
                }
            });
            object2 = Unit.INSTANCE;
            editorComponent.projectSettingsLink = $this$toTypedArray$iv;
            JComponent jComponent = new JPanel(new BorderLayout());
            JPanel $i$a$-apply-KotlinFacetEditorGeneralTab$EditorComponent$initialize$82 = jComponent;
            object2 = FormBuilder.createFormBuilder();
            editorComponent = this;
            boolean bl4 = false;
            ThreeStateCheckBox threeStateCheckBox2 = this.useProjectSettingsCheckBox;
            if (threeStateCheckBox2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"useProjectSettingsCheckBox");
            }
            $this$apply.add((Component)threeStateCheckBox2, "West");
            HoverHyperlinkLabel hoverHyperlinkLabel = this.projectSettingsLink;
            if (hoverHyperlinkLabel == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"projectSettingsLink");
            }
            $this$apply.add((Component)hoverHyperlinkLabel, "East");
            targetPlatformWrapper = Unit.INSTANCE;
            FormBuilder formBuilder = object2.addComponent(jComponent);
            JLabel jLabel = this.useProjectSettingsWarningLabel;
            if (jLabel == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"useProjectSettingsWarningLabel");
            }
            FormBuilder formBuilder2 = formBuilder.addComponent((JComponent)jLabel);
            Intrinsics.checkNotNullExpressionValue((Object)formBuilder2, (String)"FormBuilder\n            \u2026jectSettingsWarningLabel)");
            FormBuilder formBuilder3 = editorComponent.addTargetPlatformComponents(formBuilder2);
            JLabel jLabel2 = this.dependsOnLabel;
            if (jLabel2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"dependsOnLabel");
            }
            FormBuilder formBuilder4 = formBuilder3.addComponent((JComponent)jLabel2);
            KotlinCompilerConfigurableTab kotlinCompilerConfigurableTab = this.compilerConfigurable;
            if (kotlinCompilerConfigurableTab == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"compilerConfigurable");
            }
            JComponent jComponent2 = kotlinCompilerConfigurableTab.createComponent();
            Intrinsics.checkNotNull((Object)jComponent2);
            $this$apply = jComponent = jComponent2;
            editorComponent = formBuilder4;
            boolean bl5 = false;
            $this$apply.setBorder(null);
            object2 = Unit.INSTANCE;
            FormBuilder formBuilder5 = editorComponent.addComponent(jComponent);
            Intrinsics.checkNotNullExpressionValue((Object)formBuilder5, (String)"FormBuilder\n            \u2026= null\n                })");
            $this$apply = jComponent = formBuilder5.getPanel();
            boolean bl6 = false;
            $this$apply.setBorder(new EmptyBorder(10, 10, 10, 10));
            JComponent contentPanel = jComponent;
            this.add((Component)contentPanel, "North");
            ThreeStateCheckBox threeStateCheckBox3 = this.useProjectSettingsCheckBox;
            if (threeStateCheckBox3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"useProjectSettingsCheckBox");
            }
            threeStateCheckBox3.addActionListener(new ActionListener(this){
                final /* synthetic */ EditorComponent this$0;

                public final void actionPerformed(ActionEvent it) {
                    this.this$0.updateCompilerConfigurable$kotlin_idea();
                }
                {
                    this.this$0 = editorComponent;
                }
            });
            ComboBox<TargetPlatformWrapper> comboBox2 = this.targetPlatformSelectSingleCombobox;
            if (comboBox2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"targetPlatformSelectSingleCombobox");
            }
            comboBox2.addActionListener(new ActionListener(this){
                final /* synthetic */ EditorComponent this$0;

                public final void actionPerformed(ActionEvent it) {
                    EditorComponent.access$setInTargetPlatformChangeAction$p(this.this$0, true);
                    this.this$0.updateCompilerConfigurable$kotlin_idea();
                    EditorComponent.access$setInTargetPlatformChangeAction$p(this.this$0, false);
                }
                {
                    this.this$0 = editorComponent;
                }
            });
        }

        public final void updateCompilerConfigurable$kotlin_idea() {
            ThreeStateCheckBox threeStateCheckBox = this.useProjectSettingsCheckBox;
            if (threeStateCheckBox == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"useProjectSettingsCheckBox");
            }
            boolean useProjectSettings = threeStateCheckBox.isSelected();
            JLabel jLabel = this.useProjectSettingsWarningLabel;
            if (jLabel == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"useProjectSettingsWarningLabel");
            }
            jLabel.setVisible(useProjectSettings);
            KotlinCompilerConfigurableTab kotlinCompilerConfigurableTab = this.compilerConfigurable;
            if (kotlinCompilerConfigurableTab == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"compilerConfigurable");
            }
            TargetPlatform targetPlatform = this.getChosenPlatform();
            kotlinCompilerConfigurableTab.setTargetPlatform((IdePlatformKind)(targetPlatform != null ? IdePlatformKindUtil.getIdePlatformKind((TargetPlatform)targetPlatform) : null));
            KotlinCompilerConfigurableTab kotlinCompilerConfigurableTab2 = this.compilerConfigurable;
            if (kotlinCompilerConfigurableTab2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"compilerConfigurable");
            }
            kotlinCompilerConfigurableTab2.setEnabled(!useProjectSettings);
            if (useProjectSettings) {
                KotlinCompilerConfigurableTab kotlinCompilerConfigurableTab3 = this.compilerConfigurable;
                if (kotlinCompilerConfigurableTab3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"compilerConfigurable");
                }
                kotlinCompilerConfigurableTab3.setCommonCompilerArguments((CommonCompilerArguments)FreezableKt.unfrozen(KotlinCommonCompilerArgumentsHolder.Companion.getInstance(this.project).getSettings()));
                KotlinCompilerConfigurableTab kotlinCompilerConfigurableTab4 = this.compilerConfigurable;
                if (kotlinCompilerConfigurableTab4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"compilerConfigurable");
                }
                kotlinCompilerConfigurableTab4.setK2jvmCompilerArguments((K2JVMCompilerArguments)FreezableKt.unfrozen(Kotlin2JvmCompilerArgumentsHolder.Companion.getInstance(this.project).getSettings()));
                KotlinCompilerConfigurableTab kotlinCompilerConfigurableTab5 = this.compilerConfigurable;
                if (kotlinCompilerConfigurableTab5 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"compilerConfigurable");
                }
                kotlinCompilerConfigurableTab5.setK2jsCompilerArguments((K2JSCompilerArguments)FreezableKt.unfrozen(Kotlin2JsCompilerArgumentsHolder.Companion.getInstance(this.project).getSettings()));
                KotlinCompilerConfigurableTab kotlinCompilerConfigurableTab6 = this.compilerConfigurable;
                if (kotlinCompilerConfigurableTab6 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"compilerConfigurable");
                }
                kotlinCompilerConfigurableTab6.setCompilerSettings((CompilerSettings)FreezableKt.unfrozen(KotlinCompilerSettings.Companion.getInstance(this.project).getSettings()));
            } else {
                KotlinCompilerConfigurableTab kotlinCompilerConfigurableTab7 = this.compilerConfigurable;
                if (kotlinCompilerConfigurableTab7 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"compilerConfigurable");
                }
                CommonCompilerArguments commonCompilerArguments = this.editableCommonArguments;
                if (commonCompilerArguments == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"editableCommonArguments");
                }
                kotlinCompilerConfigurableTab7.setCommonCompilerArguments(commonCompilerArguments);
                KotlinCompilerConfigurableTab kotlinCompilerConfigurableTab8 = this.compilerConfigurable;
                if (kotlinCompilerConfigurableTab8 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"compilerConfigurable");
                }
                K2JVMCompilerArguments k2JVMCompilerArguments = this.editableJvmArguments;
                if (k2JVMCompilerArguments == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"editableJvmArguments");
                }
                kotlinCompilerConfigurableTab8.setK2jvmCompilerArguments(k2JVMCompilerArguments);
                KotlinCompilerConfigurableTab kotlinCompilerConfigurableTab9 = this.compilerConfigurable;
                if (kotlinCompilerConfigurableTab9 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"compilerConfigurable");
                }
                K2JSCompilerArguments k2JSCompilerArguments = this.editableJsArguments;
                if (k2JSCompilerArguments == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"editableJsArguments");
                }
                kotlinCompilerConfigurableTab9.setK2jsCompilerArguments(k2JSCompilerArguments);
                KotlinCompilerConfigurableTab kotlinCompilerConfigurableTab10 = this.compilerConfigurable;
                if (kotlinCompilerConfigurableTab10 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"compilerConfigurable");
                }
                CompilerSettings compilerSettings = this.editableCompilerSettings;
                if (compilerSettings == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"editableCompilerSettings");
                }
                kotlinCompilerConfigurableTab10.setCompilerSettings(compilerSettings);
            }
            KotlinCompilerConfigurableTab kotlinCompilerConfigurableTab11 = this.compilerConfigurable;
            if (kotlinCompilerConfigurableTab11 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"compilerConfigurable");
            }
            kotlinCompilerConfigurableTab11.reset();
            this.setupTargetPlatformCombobox(useProjectSettings);
        }

        /*
         * Unable to fully structure code
         */
        private final void setupTargetPlatformCombobox(boolean useProjectSettings) {
            block15: {
                block14: {
                    if (!useProjectSettings) break block14;
                    v0 = this.targetPlatformWrappers;
                    if (v0 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"targetPlatformWrappers");
                    }
                    $this$toTypedArray$iv = (TargetPlatformWrapper[])v0;
                    $i$f$toTypedArray = false;
                    thisCollection$iv = $this$toTypedArray$iv;
                    $this$mapNotNull$iv = thisCollection$iv.toArray(new TargetPlatformWrapper[0]);
                    $i$f$mapNotNull = false;
                    thisCollection$iv = $this$mapNotNull$iv;
                    destination$iv$iv = new ArrayList<E>();
                    $i$f$mapNotNullTo = false;
                    $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    $i$f$forEach = false;
                    var11_15 = ((void)$this$forEach$iv$iv$iv).length;
                    for (var10_13 = 0; var10_13 < var11_15; ++var10_13) {
                        element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[var10_13];
                        $i$a$-forEach-ArraysKt___ArraysKt$mapNotNullTo$1$iv$iv = false;
                        it = (TargetPlatformWrapper)element$iv$iv;
                        $i$a$-mapNotNull-KotlinFacetEditorGeneralTab$EditorComponent$setupTargetPlatformCombobox$target$1 = false;
                        if ((SimplePlatform)CollectionsKt.singleOrNull((Iterable)it.getTargetPlatform().getComponentPlatforms()) == null) continue;
                        it$iv$iv = var17_21;
                        $i$a$-let-ArraysKt___ArraysKt$mapNotNullTo$1$1$iv$iv = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    $this$filter$iv = (List)destination$iv$iv;
                    $i$f$filter = false;
                    $this$mapNotNullTo$iv$iv = $this$filter$iv;
                    destination$iv$iv = new ArrayList<E>();
                    $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        it = (SimplePlatform)element$iv$iv;
                        $i$a$-filter-KotlinFacetEditorGeneralTab$EditorComponent$setupTargetPlatformCombobox$target$2 = false;
                        if (!Intrinsics.areEqual((Object)it.getPlatformName(), (Object)"JVM")) ** GOTO lbl-1000
                        v1 = it.getTargetPlatformVersion().getDescription();
                        v2 = this.compilerConfigurable;
                        if (v2 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"compilerConfigurable");
                        }
                        if (Intrinsics.areEqual((Object)v1, (Object)v2.getSelectedJvmVersion())) {
                            v3 = true;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v3 = false;
                        }
                        if (!v3) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    v4 = (List)destination$iv$iv;
                    break block15;
                }
                v5 = this.configuration;
                v4 = target = (Collection)(v5 != null && (v5 = v5.getSettings()) != null ? v5.getTargetPlatform() : null);
            }
            if (useProjectSettings || !this.isInTargetPlatformChangeAction && !((var3_2 = target) == null || var3_2.isEmpty() != false)) {
                v6 = this.targetPlatformSelectSingleCombobox;
                if (v6 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"targetPlatformSelectSingleCombobox");
                }
                v7 = target;
                Intrinsics.checkNotNull((Object)v7);
                $i$f$filter = var3_2 = new TargetPlatform(CollectionsKt.toSet((Iterable)v7));
                var20_25 = v6;
                $i$a$-let-KotlinFacetEditorGeneralTab$EditorComponent$setupTargetPlatformCombobox$1 = false;
                v8 = this.targetPlatformWrappers;
                if (v8 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"targetPlatformWrappers");
                }
                if ((index = v8.indexOf(new TargetPlatformWrapper((TargetPlatform)it))) >= 0) {
                    v9 = this.targetPlatformWrappers;
                    if (v9 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"targetPlatformWrappers");
                    }
                    v10 = v9.get(index);
                } else {
                    v10 = null;
                }
                var21_26 = v10;
                var20_25.setSelectedItem(var21_26);
            }
            v11 = this.targetPlatformSelectSingleCombobox;
            if (v11 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"targetPlatformSelectSingleCombobox");
            }
            v11.setEnabled(useProjectSettings == false);
            v12 = this.targetPlatformFacetLabel;
            if (v12 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"targetPlatformFacetLabel");
            }
            v12.setEnabled(useProjectSettings == false);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Nullable
        public final TargetPlatform getChosenPlatform() {
            TargetPlatform targetPlatform;
            KotlinFacetConfiguration kotlinFacetConfiguration = this.configuration;
            if (kotlinFacetConfiguration != null && (kotlinFacetConfiguration = kotlinFacetConfiguration.getSettings()) != null && (kotlinFacetConfiguration = kotlinFacetConfiguration.getMppVersion()) != null) {
                if (KotlinFacetSettingsKt.isHmpp((KotlinMultiplatformVersion)kotlinFacetConfiguration)) {
                    targetPlatform = this.targetPlatformsCurrentlySelected;
                    return targetPlatform;
                }
            }
            ComboBox<TargetPlatformWrapper> comboBox = this.targetPlatformSelectSingleCombobox;
            if (comboBox == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"targetPlatformSelectSingleCombobox");
            }
            TargetPlatformWrapper targetPlatformWrapper = KotlinFacetEditorGeneralTabKt.getSelectedItemTyped(comboBox);
            if (targetPlatformWrapper == null) return null;
            targetPlatform = targetPlatformWrapper.getTargetPlatform();
            return targetPlatform;
        }

        public EditorComponent(@NotNull Project project2, @Nullable KotlinFacetConfiguration configuration2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            super(new BorderLayout());
            this.project = project2;
            this.configuration = configuration2;
        }

        public static final /* synthetic */ String access$unifyJvmVersion(EditorComponent $this, String version2) {
            return $this.unifyJvmVersion(version2);
        }

        public static final /* synthetic */ Project access$getProject$p(EditorComponent $this) {
            return $this.project;
        }

        public static final /* synthetic */ KotlinCompilerConfigurableTab access$getCompilerConfigurable$p(EditorComponent $this) {
            KotlinCompilerConfigurableTab kotlinCompilerConfigurableTab = $this.compilerConfigurable;
            if (kotlinCompilerConfigurableTab == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"compilerConfigurable");
            }
            return kotlinCompilerConfigurableTab;
        }

        public static final /* synthetic */ void access$setCompilerConfigurable$p(EditorComponent $this, KotlinCompilerConfigurableTab kotlinCompilerConfigurableTab) {
            $this.compilerConfigurable = kotlinCompilerConfigurableTab;
        }

        public static final /* synthetic */ boolean access$isInTargetPlatformChangeAction$p(EditorComponent $this) {
            return $this.isInTargetPlatformChangeAction;
        }

        public static final /* synthetic */ void access$setInTargetPlatformChangeAction$p(EditorComponent $this, boolean bl) {
            $this.isInTargetPlatformChangeAction = bl;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/idea/facet/KotlinFacetEditorGeneralTab$ArgumentConsistencyValidator;", "Lcom/intellij/facet/ui/FacetEditorValidator;", "(Lorg/jetbrains/kotlin/idea/facet/KotlinFacetEditorGeneralTab;)V", "check", "Lcom/intellij/facet/ui/ValidationResult;", "kotlin.idea"})
    public final class ArgumentConsistencyValidator
    extends FacetEditorValidator {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public ValidationResult check() {
            Collection property2;
            void $this$filterTo$iv$iv;
            TargetPlatform targetPlatform = KotlinFacetEditorGeneralTab.this.getEditor().getChosenPlatform();
            if (targetPlatform == null) {
                return new ValidationResult(KotlinBundle.message("facet.error.text.at.least.one.target.platform.should.be.selected", new Object[0]));
            }
            TargetPlatform platform2 = targetPlatform;
            CommonCompilerArguments primaryArguments2 = FacetSerializationKt.createArguments((TargetPlatform)platform2, (Function1)((Function1)new Function1<CommonCompilerArguments, Unit>(this){
                final /* synthetic */ ArgumentConsistencyValidator this$0;

                public final void invoke(@NotNull CommonCompilerArguments $this$createArguments) {
                    K2JSCompilerArguments k2JSCompilerArguments;
                    CommonCompilerArguments commonCompilerArguments;
                    K2JVMCompilerArguments k2JVMCompilerArguments;
                    Intrinsics.checkNotNullParameter((Object)$this$createArguments, (String)"$receiver");
                    KotlinCompilerConfigurableTab kotlinCompilerConfigurableTab = this.this$0.KotlinFacetEditorGeneralTab.this.getEditor().getCompilerConfigurable();
                    CommonCompilerArguments commonCompilerArguments2 = $this$createArguments;
                    if (!(commonCompilerArguments2 instanceof K2JVMCompilerArguments)) {
                        commonCompilerArguments2 = null;
                    }
                    if ((k2JVMCompilerArguments = (K2JVMCompilerArguments)commonCompilerArguments2) == null) {
                        k2JVMCompilerArguments = new K2JVMCompilerArguments();
                    }
                    if (!((commonCompilerArguments = $this$createArguments) instanceof K2JSCompilerArguments)) {
                        commonCompilerArguments = null;
                    }
                    if ((k2JSCompilerArguments = (K2JSCompilerArguments)commonCompilerArguments) == null) {
                        k2JSCompilerArguments = new K2JSCompilerArguments();
                    }
                    kotlinCompilerConfigurableTab.applyTo($this$createArguments, k2JVMCompilerArguments, k2JSCompilerArguments, new CompilerSettings());
                }
                {
                    this.this$0 = argumentConsistencyValidator;
                    super(1);
                }
            }));
            Class<?> argumentClass = primaryArguments2.getClass();
            Object obj = argumentClass.newInstance();
            CommonCompilerArguments $this$apply = (CommonCompilerArguments)obj;
            boolean bl = false;
            RawCommandLineEditor rawCommandLineEditor = KotlinFacetEditorGeneralTab.this.getEditor().getCompilerConfigurable().getAdditionalArgsOptionsField();
            Intrinsics.checkNotNullExpressionValue((Object)rawCommandLineEditor, (String)"editor.compilerConfigura\u2026dditionalArgsOptionsField");
            String string = rawCommandLineEditor.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"editor.compilerConfigura\u2026onalArgsOptionsField.text");
            ParseCommandLineArgumentsKt.parseCommandLineArguments$default((List)CompilerSettingsKt.splitArgumentString((String)string), (CommonToolArguments)((CommonToolArguments)$this$apply), (boolean)false, (int)4, null);
            String string2 = ParseCommandLineArgumentsKt.validateArguments((ArgumentParseErrors)$this$apply.getErrors());
            if (string2 != null) {
                String string3;
                String message2 = string3 = string2;
                boolean bl2 = false;
                return new ValidationResult(message2);
            }
            CommonCompilerArguments additionalArguments = (CommonCompilerArguments)obj;
            CommonCompilerArguments emptyArguments = (CommonCompilerArguments)argumentClass.newInstance();
            List<String> fieldNamesToCheck = JvmPlatformKt.isJvm((TargetPlatform)platform2) ? FacetUtilsKt.getJvmUIExposedFields() : (JsPlatformKt.isJs((TargetPlatform)platform2) ? FacetUtilsKt.getJsUIExposedFields() : (TargetPlatformKt.isCommon((TargetPlatform)platform2) ? FacetUtilsKt.getMetadataUIExposedFields() : FacetUtilsKt.getCommonUIExposedFields()));
            Iterable $this$filter$iv = ArgumentUtilsKt.collectProperties((KClass)JvmClassMappingKt.getKotlinClass(argumentClass), (boolean)false);
            boolean $i$f$filter = false;
            Iterable bl2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                KProperty1 it = (KProperty1)element$iv$iv;
                boolean bl3 = false;
                if (!fieldNamesToCheck.contains(it.getName())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List propertiesToCheck = (List)destination$iv$iv;
            ArrayList overridingArguments = new ArrayList();
            ArrayList redundantArguments = new ArrayList();
            Object object = propertiesToCheck.iterator();
            while (object.hasNext()) {
                Argument argumentInfo;
                Object v6;
                Object additionalValue;
                block9: {
                    property2 = (KProperty1)object.next();
                    CommonCompilerArguments commonCompilerArguments = additionalArguments;
                    Intrinsics.checkNotNullExpressionValue((Object)commonCompilerArguments, (String)"additionalArguments");
                    additionalValue = property2.get(commonCompilerArguments);
                    CommonCompilerArguments commonCompilerArguments2 = emptyArguments;
                    Intrinsics.checkNotNullExpressionValue((Object)commonCompilerArguments2, (String)"emptyArguments");
                    if (!(Intrinsics.areEqual((Object)additionalValue, (Object)property2.get(commonCompilerArguments2)) ^ true)) continue;
                    KAnnotatedElement $this$findAnnotation$iv = (KAnnotatedElement)property2;
                    boolean $i$f$findAnnotation = false;
                    Iterable $this$firstOrNull$iv$iv = $this$findAnnotation$iv.getAnnotations();
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv$iv : $this$firstOrNull$iv$iv) {
                        Annotation it$iv = (Annotation)element$iv$iv;
                        boolean bl4 = false;
                        if (!(it$iv instanceof Argument)) continue;
                        v6 = element$iv$iv;
                        break block9;
                    }
                    v6 = null;
                }
                if ((Argument)((Annotation)((Argument)v6)) == null) continue;
                ArrayList addTo = Intrinsics.areEqual((Object)additionalValue, (Object)property2.get(primaryArguments2)) ^ true ? overridingArguments : redundantArguments;
                Collection collection = addTo;
                String string4 = "<strong>" + StringsKt.first((CharSequence)argumentInfo.value()) + "</strong>";
                collection.add(string4);
            }
            property2 = overridingArguments;
            if (!property2.isEmpty() || !(property2 = (Collection)redundantArguments).isEmpty()) {
                Object $this$buildString = object = new StringBuilder();
                boolean bl5 = false;
                Object object2 = overridingArguments;
                if (!object2.isEmpty()) {
                    ((StringBuilder)$this$buildString).append(KotlinBundle.message("facet.text.following.arguments.override.facet.settings", CollectionsKt.joinToString$default((Iterable)overridingArguments, null, null, null, (int)0, null, null, (int)63, null)));
                }
                if (!(object2 = (Collection)redundantArguments).isEmpty()) {
                    object2 = (CharSequence)$this$buildString;
                    if (object2.length() > 0) {
                        ((StringBuilder)$this$buildString).append("<br/>");
                    }
                    ((StringBuilder)$this$buildString).append(KotlinBundle.message("facet.text.following.arguments.are.redundant", CollectionsKt.joinToString$default((Iterable)redundantArguments, null, null, null, (int)0, null, null, (int)63, null)));
                }
                String string5 = ((StringBuilder)object).toString();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"StringBuilder().apply(builderAction).toString()");
                String message3 = string5;
                return new ValidationResult(message3);
            }
            ValidationResult validationResult2 = ValidationResult.OK;
            Intrinsics.checkNotNullExpressionValue((Object)validationResult2, (String)"ValidationResult.OK");
            return validationResult2;
        }
    }
}

