/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.extensions.gradle;

import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.idea.extensions.gradle.GradleBuildScriptManipulator;
import org.jetbrains.kotlin.idea.extensions.gradle.GradleVersionInfo;
import org.jetbrains.kotlin.idea.extensions.gradle.GradleVersionProvider;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtilKt;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000:\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\n\u0010\u0007\u001a\u00020\b*\u00020\t\u001a\u0012\u0010\n\u001a\u00020\u000b*\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u001a\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u000b*\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a\u001a\u0010\u0010\u001a\u00020\u0001*\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\f\u001a&\u0010\u0013\u001a\u00020\u0014*\u0006\u0012\u0002\b\u00030\u00152\u0006\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\f\u001a\u000e\u0010\u0018\u001a\u00020\u0014*\u0006\u0012\u0002\b\u00030\u0015\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0019"}, d2={"MIN_GRADLE_VERSION_FOR_API_AND_IMPLEMENTATION_RAW", "", "MIN_GRADLE_VERSION_FOR_NEW_PLUGIN_SYNTAX_RAW", "SCRIPT_PRODUCTION_DEPENDENCY_STATEMENTS", "", "getSCRIPT_PRODUCTION_DEPENDENCY_STATEMENTS", "()Ljava/util/Set;", "assertApplicableInMultiplatform", "", "Lorg/jetbrains/kotlin/config/LanguageFeature$State;", "fetchGradleVersion", "Lorg/jetbrains/kotlin/idea/extensions/gradle/GradleVersionInfo;", "Lorg/jetbrains/kotlin/idea/extensions/gradle/GradleVersionProvider;", "psiFile", "Lcom/intellij/psi/PsiFile;", "gradleVersionFromFile", "scope", "directive", "versionProvider", "useNewSyntax", "", "Lorg/jetbrains/kotlin/idea/extensions/gradle/GradleBuildScriptManipulator;", "kotlinPluginName", "gradleVersion", "usesNewMultiplatform", "kotlin.idea"})
public final class GradleBuildScriptManipulatorKt {
    @NotNull
    private static final Set<String> SCRIPT_PRODUCTION_DEPENDENCY_STATEMENTS = SetsKt.setOf((Object[])new String[]{"classpath", "compile", "api", "implementation", "compileOnly", "runtimeOnly"});
    @NotNull
    public static final String MIN_GRADLE_VERSION_FOR_NEW_PLUGIN_SYNTAX_RAW = "4.4";
    private static final String MIN_GRADLE_VERSION_FOR_API_AND_IMPLEMENTATION_RAW = "3.4";

    @NotNull
    public static final Set<String> getSCRIPT_PRODUCTION_DEPENDENCY_STATEMENTS() {
        return SCRIPT_PRODUCTION_DEPENDENCY_STATEMENTS;
    }

    public static final boolean usesNewMultiplatform(@NotNull GradleBuildScriptManipulator<?> $this$usesNewMultiplatform) {
        String fileText2;
        Intrinsics.checkNotNullParameter($this$usesNewMultiplatform, (String)"$this$usesNewMultiplatform");
        String string = fileText2 = (String)ApplicationUtilsKt.runReadAction((Function0)new Function0<String>($this$usesNewMultiplatform){
            final /* synthetic */ GradleBuildScriptManipulator $this_usesNewMultiplatform;

            public final String invoke() {
                return this.$this_usesNewMultiplatform.getScriptFile().getText();
            }
            {
                this.$this_usesNewMultiplatform = gradleBuildScriptManipulator;
                super(0);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"fileText");
        return StringsKt.contains$default((CharSequence)string, (CharSequence)"multiplatform", (boolean)false, (int)2, null);
    }

    @NotNull
    public static final GradleVersionInfo fetchGradleVersion(@NotNull GradleVersionProvider $this$fetchGradleVersion, @NotNull PsiFile psiFile2) {
        Intrinsics.checkNotNullParameter((Object)$this$fetchGradleVersion, (String)"$this$fetchGradleVersion");
        Intrinsics.checkNotNullParameter((Object)psiFile2, (String)"psiFile");
        GradleVersionInfo gradleVersionInfo = GradleBuildScriptManipulatorKt.gradleVersionFromFile($this$fetchGradleVersion, psiFile2);
        if (gradleVersionInfo == null) {
            gradleVersionInfo = $this$fetchGradleVersion.getCurrentVersionGlobal();
        }
        return gradleVersionInfo;
    }

    private static final GradleVersionInfo gradleVersionFromFile(GradleVersionProvider $this$gradleVersionFromFile, PsiFile psiFile2) {
        Module module2 = ProjectRootsUtilKt.getModule((PsiElement)psiFile2);
        if (module2 == null) {
            return null;
        }
        Module module3 = module2;
        String string = ExternalSystemApiUtil.getExternalProjectPath((Module)module3);
        if (string == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ExternalSystemApiUtil.ge\u2026th(module) ?: return null");
        String path2 = string;
        Project project2 = module3.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"module.project");
        return $this$gradleVersionFromFile.getCurrentVersion(project2, path2);
    }

    public static final boolean useNewSyntax(@NotNull GradleBuildScriptManipulator<?> $this$useNewSyntax, @NotNull String kotlinPluginName, @NotNull GradleVersionInfo gradleVersion2, @NotNull GradleVersionProvider versionProvider) {
        String fileText2;
        Intrinsics.checkNotNullParameter($this$useNewSyntax, (String)"$this$useNewSyntax");
        Intrinsics.checkNotNullParameter((Object)kotlinPluginName, (String)"kotlinPluginName");
        Intrinsics.checkNotNullParameter((Object)gradleVersion2, (String)"gradleVersion");
        Intrinsics.checkNotNullParameter((Object)versionProvider, (String)"versionProvider");
        if (!$this$useNewSyntax.getPreferNewSyntax()) {
            return false;
        }
        if (gradleVersion2.compareTo(versionProvider.getVersion(MIN_GRADLE_VERSION_FOR_NEW_PLUGIN_SYNTAX_RAW)) < 0) {
            return false;
        }
        if ($this$useNewSyntax.isConfiguredWithOldSyntax(kotlinPluginName)) {
            return false;
        }
        String string = fileText2 = (String)ApplicationUtilsKt.runReadAction((Function0)new Function0<String>($this$useNewSyntax){
            final /* synthetic */ GradleBuildScriptManipulator $this_useNewSyntax;

            public final String invoke() {
                return this.$this_useNewSyntax.getScriptFile().getText();
            }
            {
                this.$this_useNewSyntax = gradleBuildScriptManipulator;
                super(0);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"fileText");
        boolean hasOldApply = StringsKt.contains$default((CharSequence)string, (CharSequence)"apply plugin:", (boolean)false, (int)2, null);
        return !hasOldApply;
    }

    public static final void assertApplicableInMultiplatform(@NotNull LanguageFeature.State $this$assertApplicableInMultiplatform) {
        Intrinsics.checkNotNullParameter((Object)$this$assertApplicableInMultiplatform, (String)"$this$assertApplicableInMultiplatform");
        if ($this$assertApplicableInMultiplatform == LanguageFeature.State.DISABLED) {
            throw (Throwable)new UnsupportedOperationException("Disabling the language feature is unsupported for multiplatform");
        }
    }

    @NotNull
    public static final String scope(@NotNull GradleVersionInfo $this$scope, @NotNull String directive, @NotNull GradleVersionProvider versionProvider) {
        Intrinsics.checkNotNullParameter((Object)$this$scope, (String)"$this$scope");
        Intrinsics.checkNotNullParameter((Object)directive, (String)"directive");
        Intrinsics.checkNotNullParameter((Object)versionProvider, (String)"versionProvider");
        if ($this$scope.compareTo(versionProvider.getVersion(MIN_GRADLE_VERSION_FOR_API_AND_IMPLEMENTATION_RAW)) < 0) {
            String string;
            switch (directive) {
                case "implementation": {
                    string = "compile";
                    break;
                }
                case "testImplementation": {
                    string = "testCompile";
                    break;
                }
                default: {
                    throw (Throwable)new IllegalArgumentException("Unknown directive `" + directive + "`");
                }
            }
            return string;
        }
        return directive;
    }
}

