/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.stepping;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.MethodFilter;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.openapi.project.Project;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.stepping.KotlinStepActionFactory;
import org.jetbrains.kotlin.idea.debugger.stepping.filter.KotlinStepOverFilter;
import org.jetbrains.kotlin.idea.debugger.stepping.filter.LocationToken;
import org.jetbrains.kotlin.idea.debugger.stepping.filter.StepOverCallerInfo;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0005\u000b\f\r\u000e\u000fB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00060\u0004R\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH&\u0082\u0001\u0005\u0010\u0011\u0012\u0013\u0014\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/stepping/KotlinStepAction;", "", "()V", "createCommand", "Lcom/intellij/debugger/engine/DebugProcessImpl$StepCommand;", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "debugProcess", "suspendContext", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "ignoreBreakpoints", "", "JvmStepOver", "KotlinStepInto", "KotlinStepOver", "StepInto", "StepOut", "Lorg/jetbrains/kotlin/idea/debugger/stepping/KotlinStepAction$JvmStepOver;", "Lorg/jetbrains/kotlin/idea/debugger/stepping/KotlinStepAction$KotlinStepInto;", "Lorg/jetbrains/kotlin/idea/debugger/stepping/KotlinStepAction$KotlinStepOver;", "Lorg/jetbrains/kotlin/idea/debugger/stepping/KotlinStepAction$StepInto;", "Lorg/jetbrains/kotlin/idea/debugger/stepping/KotlinStepAction$StepOut;", "kotlin.jvm-debugger.core"})
public abstract class KotlinStepAction {
    @NotNull
    public abstract DebugProcessImpl.StepCommand createCommand(@NotNull DebugProcessImpl var1, @NotNull SuspendContextImpl var2, boolean var3);

    private KotlinStepAction() {
    }

    public /* synthetic */ KotlinStepAction(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00060\u0004R\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/stepping/KotlinStepAction$JvmStepOver;", "Lorg/jetbrains/kotlin/idea/debugger/stepping/KotlinStepAction;", "()V", "createCommand", "Lcom/intellij/debugger/engine/DebugProcessImpl$StepCommand;", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "debugProcess", "suspendContext", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "ignoreBreakpoints", "", "kotlin.jvm-debugger.core"})
    public static final class JvmStepOver
    extends KotlinStepAction {
        @NotNull
        public static final JvmStepOver INSTANCE;

        @Override
        @NotNull
        public DebugProcessImpl.StepCommand createCommand(@NotNull DebugProcessImpl debugProcess, @NotNull SuspendContextImpl suspendContext, boolean ignoreBreakpoints) {
            DebugProcessImpl debugProcessImpl;
            Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
            Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
            DebugProcessImpl $this$run = debugProcessImpl = debugProcess;
            boolean bl = false;
            return (DebugProcessImpl.StepCommand)new DebugProcessImpl.StepOverCommand($this$run, suspendContext, ignoreBreakpoints, null, -2);
        }

        private JvmStepOver() {
            super(null);
        }

        static {
            JvmStepOver jvmStepOver;
            INSTANCE = jvmStepOver = new JvmStepOver();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0005\u001a\u00060\u0006R\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/stepping/KotlinStepAction$StepInto;", "Lorg/jetbrains/kotlin/idea/debugger/stepping/KotlinStepAction;", "filter", "Lcom/intellij/debugger/engine/MethodFilter;", "(Lcom/intellij/debugger/engine/MethodFilter;)V", "createCommand", "Lcom/intellij/debugger/engine/DebugProcessImpl$StepCommand;", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "debugProcess", "suspendContext", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "ignoreBreakpoints", "", "kotlin.jvm-debugger.core"})
    public static final class StepInto
    extends KotlinStepAction {
        private final MethodFilter filter;

        @Override
        @NotNull
        public DebugProcessImpl.StepCommand createCommand(@NotNull DebugProcessImpl debugProcess, @NotNull SuspendContextImpl suspendContext, boolean ignoreBreakpoints) {
            Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
            Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
            DebugProcessImpl.StepIntoCommand stepIntoCommand = KotlinStepActionFactory.createStepIntoCommand(debugProcess, suspendContext, ignoreBreakpoints, this.filter, -2);
            Intrinsics.checkNotNullExpressionValue((Object)stepIntoCommand, (String)"KotlinStepActionFactory.\u2026r, StepRequest.STEP_LINE)");
            return (DebugProcessImpl.StepCommand)stepIntoCommand;
        }

        public StepInto(@Nullable MethodFilter filter2) {
            super(null);
            this.filter = filter2;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00060\u0004R\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/stepping/KotlinStepAction$StepOut;", "Lorg/jetbrains/kotlin/idea/debugger/stepping/KotlinStepAction;", "()V", "createCommand", "Lcom/intellij/debugger/engine/DebugProcessImpl$StepCommand;", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "debugProcess", "suspendContext", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "ignoreBreakpoints", "", "kotlin.jvm-debugger.core"})
    public static final class StepOut
    extends KotlinStepAction {
        @NotNull
        public static final StepOut INSTANCE;

        @Override
        @NotNull
        public DebugProcessImpl.StepCommand createCommand(@NotNull DebugProcessImpl debugProcess, @NotNull SuspendContextImpl suspendContext, boolean ignoreBreakpoints) {
            Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
            Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
            DebugProcessImpl.StepOutCommand stepOutCommand = KotlinStepActionFactory.createStepOutCommand(debugProcess, suspendContext);
            Intrinsics.checkNotNullExpressionValue((Object)stepOutCommand, (String)"KotlinStepActionFactory.\u2026gProcess, suspendContext)");
            return (DebugProcessImpl.StepCommand)stepOutCommand;
        }

        private StepOut() {
            super(null);
        }

        static {
            StepOut stepOut;
            INSTANCE = stepOut = new StepOut();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J$\u0010\b\u001a\u00060\tR\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/stepping/KotlinStepAction$KotlinStepOver;", "Lorg/jetbrains/kotlin/idea/debugger/stepping/KotlinStepAction;", "tokensToSkip", "", "Lorg/jetbrains/kotlin/idea/debugger/stepping/filter/LocationToken;", "callerInfo", "Lorg/jetbrains/kotlin/idea/debugger/stepping/filter/StepOverCallerInfo;", "(Ljava/util/Set;Lorg/jetbrains/kotlin/idea/debugger/stepping/filter/StepOverCallerInfo;)V", "createCommand", "Lcom/intellij/debugger/engine/DebugProcessImpl$StepCommand;", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "debugProcess", "suspendContext", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "ignoreBreakpoints", "", "kotlin.jvm-debugger.core"})
    public static final class KotlinStepOver
    extends KotlinStepAction {
        private final Set<LocationToken> tokensToSkip;
        private final StepOverCallerInfo callerInfo;

        @Override
        @NotNull
        public DebugProcessImpl.StepCommand createCommand(@NotNull DebugProcessImpl debugProcess, @NotNull SuspendContextImpl suspendContext, boolean ignoreBreakpoints) {
            Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
            Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
            Project project2 = debugProcess.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"debugProcess.project");
            KotlinStepOverFilter filter2 = new KotlinStepOverFilter(project2, this.tokensToSkip, this.callerInfo);
            DebugProcessImpl.StepOverCommand stepOverCommand = KotlinStepActionFactory.createKotlinStepOverCommand(debugProcess, suspendContext, ignoreBreakpoints, filter2);
            Intrinsics.checkNotNullExpressionValue((Object)stepOverCommand, (String)"KotlinStepActionFactory.\u2026gnoreBreakpoints, filter)");
            return (DebugProcessImpl.StepCommand)stepOverCommand;
        }

        public KotlinStepOver(@NotNull Set<LocationToken> tokensToSkip, @NotNull StepOverCallerInfo callerInfo) {
            Intrinsics.checkNotNullParameter(tokensToSkip, (String)"tokensToSkip");
            Intrinsics.checkNotNullParameter((Object)callerInfo, (String)"callerInfo");
            super(null);
            this.tokensToSkip = tokensToSkip;
            this.callerInfo = callerInfo;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0005\u001a\u00060\u0006R\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/stepping/KotlinStepAction$KotlinStepInto;", "Lorg/jetbrains/kotlin/idea/debugger/stepping/KotlinStepAction;", "filter", "Lcom/intellij/debugger/engine/MethodFilter;", "(Lcom/intellij/debugger/engine/MethodFilter;)V", "createCommand", "Lcom/intellij/debugger/engine/DebugProcessImpl$StepCommand;", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "debugProcess", "suspendContext", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "ignoreBreakpoints", "", "kotlin.jvm-debugger.core"})
    public static final class KotlinStepInto
    extends KotlinStepAction {
        private final MethodFilter filter;

        @Override
        @NotNull
        public DebugProcessImpl.StepCommand createCommand(@NotNull DebugProcessImpl debugProcess, @NotNull SuspendContextImpl suspendContext, boolean ignoreBreakpoints) {
            Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
            Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
            DebugProcessImpl.StepIntoCommand stepIntoCommand = KotlinStepActionFactory.createKotlinStepIntoCommand(debugProcess, suspendContext, ignoreBreakpoints, this.filter);
            Intrinsics.checkNotNullExpressionValue((Object)stepIntoCommand, (String)"KotlinStepActionFactory.\u2026gnoreBreakpoints, filter)");
            return (DebugProcessImpl.StepCommand)stepIntoCommand;
        }

        public KotlinStepInto(@Nullable MethodFilter filter2) {
            super(null);
            this.filter = filter2;
        }
    }
}

