/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.dfaassist;

import com.intellij.codeInspection.dataFlow.TypeConstraint;
import com.intellij.codeInspection.dataFlow.TypeConstraints;
import com.intellij.codeInspection.dataFlow.lang.DfaAnchor;
import com.intellij.codeInspection.dataFlow.lang.UnsatisfiedConditionProblem;
import com.intellij.codeInspection.dataFlow.memory.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.codeInspection.dataFlow.value.VariableDescriptor;
import com.intellij.debugger.engine.dfaassist.DebuggerDfaListener;
import com.intellij.debugger.engine.dfaassist.DfaAssistProvider;
import com.intellij.debugger.engine.dfaassist.DfaHint;
import com.intellij.debugger.engine.jdi.LocalVariableProxy;
import com.intellij.debugger.jdi.StackFrameProxyEx;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ThreeState;
import com.sun.jdi.Field;
import com.sun.jdi.Location;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ExtendedResolutionApiKt;
import org.jetbrains.kotlin.idea.debugger.ClassNameCalculator;
import org.jetbrains.kotlin.idea.debugger.dfaassist.KotlinDfaAssistProvider;
import org.jetbrains.kotlin.idea.debugger.evaluate.variables.EvaluatorValueConverter;
import org.jetbrains.kotlin.idea.inspections.dfa.KotlinAnchor;
import org.jetbrains.kotlin.idea.inspections.dfa.KotlinConstantConditionsInspection;
import org.jetbrains.kotlin.idea.inspections.dfa.KotlinProblem;
import org.jetbrains.kotlin.idea.inspections.dfa.KtClassDef;
import org.jetbrains.kotlin.idea.inspections.dfa.KtThisDescriptor;
import org.jetbrains.kotlin.idea.inspections.dfa.KtVariableDescriptor;
import org.jetbrains.kotlin.idea.util.PsiUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPostfixExpression;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u0006H\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\"\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0012\u0010\u0019\u001a\u00020\u00102\b\u0010\u001a\u001a\u0004\u0018\u00010\u0010H\u0002\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/dfaassist/KotlinDfaAssistProvider;", "Lcom/intellij/debugger/engine/dfaassist/DfaAssistProvider;", "()V", "constraintFromJvmClassName", "Lcom/intellij/codeInspection/dataFlow/TypeConstraint;", "anchor", "Lcom/intellij/psi/PsiElement;", "jvmClassName", "", "createListener", "Lcom/intellij/debugger/engine/dfaassist/DebuggerDfaListener;", "getAnchor", "Lorg/jetbrains/kotlin/psi/KtExpression;", "element", "getCodeBlock", "getJdiValueForDfaVariable", "Lcom/sun/jdi/Value;", "proxy", "Lcom/intellij/debugger/jdi/StackFrameProxyEx;", "dfaVar", "Lcom/intellij/codeInspection/dataFlow/value/DfaVariableValue;", "locationMatches", "", "location", "Lcom/sun/jdi/Location;", "postprocess", "value", "kotlin.jvm-debugger.evaluation"})
public final class KotlinDfaAssistProvider
implements DfaAssistProvider {
    public boolean locationMatches(@NotNull PsiElement element3, @NotNull Location location2) {
        String string;
        String jdiClassName;
        block2: {
            Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
            Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
            jdiClassName = location2.method().declaringType().name();
            PsiFile file2 = element3.getContainingFile();
            if (!(file2 instanceof KtFile)) {
                return false;
            }
            Map<KtElement, String> classNames = ClassNameCalculator.INSTANCE.getClassNames((KtFile)file2);
            Sequence sequence2 = org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt.getParentsWithSelf((PsiElement)element3);
            for (Object e : sequence2) {
                PsiElement e2 = (PsiElement)e;
                boolean bl = false;
                Map<KtElement, String> map2 = classNames;
                String string2 = map2.get(e2);
                if (string2 == null) continue;
                string = string2;
                break block2;
            }
            string = null;
        }
        String psiClassName = string;
        return Intrinsics.areEqual(psiClassName, (Object)jdiClassName);
    }

    @Nullable
    public KtExpression getAnchor(@NotNull PsiElement element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        PsiElement cur = element3;
        while (cur instanceof PsiWhiteSpace || cur instanceof PsiComment) {
            Intrinsics.checkNotNullExpressionValue((Object)cur.getNextSibling(), (String)"cur.nextSibling");
        }
        while (true) {
            PsiElement parent2;
            if ((parent2 = cur.getParent()) instanceof KtBlockExpression || parent2 instanceof KtFunction) {
                PsiElement psiElement2 = cur;
                if (!(psiElement2 instanceof KtExpression)) {
                    psiElement2 = null;
                }
                return (KtExpression)psiElement2;
            }
            if (parent2 == null || cur.getStartOffsetInParent() > 0) {
                return null;
            }
            cur = parent2;
        }
    }

    @Nullable
    public KtExpression getCodeBlock(@NotNull PsiElement anchor) {
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        if (!(anchor instanceof KtExpression)) {
            return null;
        }
        PsiElement parent2 = ((KtExpression)anchor).getParent();
        if (parent2 instanceof KtBlockExpression) {
            return (KtExpression)parent2;
        }
        if (parent2 instanceof KtFunction) {
            return (KtExpression)anchor;
        }
        return null;
    }

    @Nullable
    public Value getJdiValueForDfaVariable(@NotNull StackFrameProxyEx proxy, @NotNull DfaVariableValue dfaVar, @NotNull PsiElement anchor) {
        Intrinsics.checkNotNullParameter((Object)proxy, (String)"proxy");
        Intrinsics.checkNotNullParameter((Object)dfaVar, (String)"dfaVar");
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        DfaVariableValue qualifier2 = dfaVar.getQualifier();
        PsiElement psiVariable = dfaVar.getPsiVariable();
        if (qualifier2 == null) {
            LocalVariableProxy variable2;
            VariableDescriptor variableDescriptor = dfaVar.getDescriptor();
            Intrinsics.checkNotNullExpressionValue((Object)variableDescriptor, (String)"dfaVar.descriptor");
            VariableDescriptor descriptor2 = variableDescriptor;
            if (descriptor2 instanceof KtThisDescriptor) {
                DeclarationDescriptor declarationDescriptor = ((KtThisDescriptor)descriptor2).getDescriptor();
                if (declarationDescriptor instanceof FunctionDescriptor) {
                    String thisName = "$this$" + ((FunctionDescriptor)declarationDescriptor).getName();
                    LocalVariableProxy thisVar = proxy.visibleVariableByName(thisName);
                    if (thisVar != null) {
                        return this.postprocess(proxy.getVariableValue(thisVar));
                    }
                    return null;
                }
                ObjectReference thisObject = proxy.thisObject();
                if (thisObject != null) {
                    Type type2 = Type.getType((String)thisObject.referenceType().signature());
                    Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"AsmType.getType(thisObje\u2026erenceType().signature())");
                    String signature = type2.getClassName();
                    String jvmName = PsiUtilsKt.getToJvmFqName(DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)declarationDescriptor));
                    if (Intrinsics.areEqual((Object)signature, (Object)jvmName)) {
                        return thisObject;
                    }
                }
                return null;
            }
            if (descriptor2 instanceof KtVariableDescriptor && psiVariable instanceof KtCallableDeclaration && (variable2 = proxy.visibleVariableByName(((KtNamedDeclaration)psiVariable).getName())) != null) {
                return this.postprocess(proxy.getVariableValue(variable2));
            }
        } else {
            ReferenceType type3;
            Field field2;
            Value jdiQualifier = this.getJdiValueForDfaVariable(proxy, qualifier2, anchor);
            if (jdiQualifier instanceof ObjectReference && psiVariable instanceof KtCallableDeclaration && (field2 = (type3 = ((ObjectReference)jdiQualifier).referenceType()).fieldByName(((KtCallableDeclaration)psiVariable).getName())) != null) {
                return this.postprocess(((ObjectReference)jdiQualifier).getValue(field2));
            }
        }
        return null;
    }

    private final Value postprocess(Value value2) {
        Value value3 = DfaAssistProvider.wrap((Value)EvaluatorValueConverter.Companion.unref(value2));
        Intrinsics.checkNotNullExpressionValue((Object)value3, (String)"DfaAssistProvider.wrap(E\u2026ueConverter.unref(value))");
        return value3;
    }

    @NotNull
    public DebuggerDfaListener createListener() {
        return new DebuggerDfaListener(){
            @NotNull
            private final HashMap<PsiElement, DfaHint> hints;

            @NotNull
            public final HashMap<PsiElement, DfaHint> getHints() {
                return this.hints;
            }

            public void beforePush(@NotNull DfaValue[] args, @NotNull DfaValue value2, @NotNull DfaAnchor anchor, @NotNull DfaMemoryState state) {
                Object object;
                KtElement ktElement;
                Intrinsics.checkNotNullParameter((Object)args, (String)"args");
                Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
                Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
                Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                DfType dfType = state.getDfType(value2);
                Intrinsics.checkNotNullExpressionValue((Object)dfType, (String)"state.getDfType(value)");
                DfType dfType2 = dfType;
                DfaAnchor dfaAnchor = anchor;
                if (dfaAnchor instanceof KotlinAnchor.KotlinExpressionAnchor) {
                    if (!this.shouldTrackExpressionValue(((KotlinAnchor.KotlinExpressionAnchor)anchor).getExpression()) || KotlinConstantConditionsInspection.Companion.shouldSuppress(dfType2, ((KotlinAnchor.KotlinExpressionAnchor)anchor).getExpression())) {
                        return;
                    }
                    ktElement = (KtElement)((KotlinAnchor.KotlinExpressionAnchor)anchor).getExpression();
                } else if (dfaAnchor instanceof KotlinAnchor.KotlinWhenConditionAnchor) {
                    ktElement = (KtElement)((KotlinAnchor.KotlinWhenConditionAnchor)anchor).getCondition();
                } else {
                    return;
                }
                KtElement psi2 = ktElement;
                DfaHint hint = DfaHint.ANY_VALUE;
                if (dfType2 == DfTypes.TRUE) {
                    hint = DfaHint.TRUE;
                } else if (dfType2 == DfTypes.FALSE) {
                    hint = DfaHint.FALSE;
                } else if (dfType2 == DfTypes.NULL) {
                    PsiElement parent2 = psi2.getParent();
                    if (parent2 instanceof KtPostfixExpression && Intrinsics.areEqual((Object)((KtPostfixExpression)parent2).getOperationToken(), (Object)KtTokens.EXCLEXCL)) {
                        hint = DfaHint.NPE;
                    } else if (parent2 instanceof KtBinaryExpressionWithTypeRHS && ((KtBinaryExpressionWithTypeRHS)parent2).getOperationReference().textMatches((CharSequence)"as")) {
                        KotlinType type2;
                        KtTypeReference typeReference2;
                        KtTypeReference ktTypeReference = typeReference2 = ((KtBinaryExpressionWithTypeRHS)parent2).getRight();
                        KotlinType kotlinType = type2 = ktTypeReference != null ? BindingContextUtilsKt.getAbbreviatedTypeOrType((KtTypeReference)ktTypeReference, (BindingContext)ExtendedResolutionApiKt.safeAnalyzeNonSourceRootCode((KtElement)typeReference2, BodyResolveMode.FULL)) : null;
                        if (type2 != null && !type2.isMarkedNullable()) {
                            hint = DfaHint.NPE;
                            KtSimpleNameExpression ktSimpleNameExpression = ((KtBinaryExpressionWithTypeRHS)parent2).getOperationReference();
                            Intrinsics.checkNotNullExpressionValue((Object)ktSimpleNameExpression, (String)"parent.operationReference");
                            psi2 = (KtElement)ktSimpleNameExpression;
                        }
                    } else if (parent2 instanceof KtBinaryExpression && Intrinsics.areEqual((Object)((KtBinaryExpression)parent2).getOperationToken(), (Object)KtTokens.ELVIS)) {
                        hint = DfaHint.NULL;
                    } else if (psi2 instanceof KtBinaryExpressionWithTypeRHS && ((KtBinaryExpressionWithTypeRHS)psi2).getOperationReference().textMatches((CharSequence)"as?")) {
                        hint = DfaHint.NULL;
                    }
                }
                if ((object = (Function2)createListener.beforePush.1.INSTANCE) != null) {
                    Function2 function2 = object;
                    object = new BiFunction(function2){
                        private final /* synthetic */ Function2 function;
                        {
                            this.function = function2;
                        }

                        public final /* synthetic */ Object apply(Object p0, Object p1) {
                            return this.function.invoke(p0, p1);
                        }
                    };
                }
                this.hints.merge((PsiElement)psi2, hint, (BiFunction)object);
            }

            public void onCondition(@NotNull UnsatisfiedConditionProblem problem, @NotNull DfaValue value2, @NotNull ThreeState failed, @NotNull DfaMemoryState state) {
                Intrinsics.checkNotNullParameter((Object)problem, (String)"problem");
                Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
                Intrinsics.checkNotNullParameter((Object)failed, (String)"failed");
                Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                if (problem instanceof KotlinProblem.KotlinCastProblem) {
                    KtSimpleNameExpression ktSimpleNameExpression = ((KotlinProblem.KotlinCastProblem)problem).getCast().getOperationReference();
                    DfaHint dfaHint = failed == ThreeState.YES ? DfaHint.CCE : DfaHint.NONE;
                    Object object = createListener.onCondition.1.INSTANCE;
                    if (object != null) {
                        Function2 function2 = object;
                        object = new /* invalid duplicate definition of identical inner class */;
                    }
                    this.hints.merge((PsiElement)ktSimpleNameExpression, dfaHint, (BiFunction)object);
                }
            }

            private final boolean shouldTrackExpressionValue(KtExpression expr) {
                if (expr instanceof KtBinaryExpression) {
                    IElementType iElementType = ((KtBinaryExpression)expr).getOperationToken();
                    Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"expr.operationToken");
                    IElementType token = iElementType;
                    if (Intrinsics.areEqual((Object)token, (Object)KtTokens.EQ)) {
                        return false;
                    }
                    if (Intrinsics.areEqual((Object)token, (Object)KtTokens.ANDAND) || Intrinsics.areEqual((Object)token, (Object)KtTokens.OROR)) {
                        return false;
                    }
                }
                PsiElement parent2 = expr.getParent();
                while (parent2 instanceof KtParenthesizedExpression) {
                    parent2 = ((KtParenthesizedExpression)parent2).getParent();
                }
                PsiElement psiElement2 = parent2;
                if (!(psiElement2 instanceof KtPrefixExpression)) {
                    psiElement2 = null;
                }
                KtPrefixExpression ktPrefixExpression = (KtPrefixExpression)psiElement2;
                return !Intrinsics.areEqual((Object)(ktPrefixExpression != null ? ktPrefixExpression.getOperationToken() : null), (Object)KtTokens.EXCL);
            }

            @NotNull
            public Map<PsiElement, DfaHint> computeHints() {
                this.hints.values().removeIf(createListener.computeHints.1.INSTANCE);
                return this.hints;
            }
            {
                this.hints = new HashMap<K, V>();
            }
        };
    }

    @NotNull
    public TypeConstraint constraintFromJvmClassName(@NotNull PsiElement anchor, @NotNull String jvmClassName) {
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        Intrinsics.checkNotNullParameter((Object)jvmClassName, (String)"jvmClassName");
        TypeConstraints.ClassDef classDef2 = KtClassDef.Companion.fromJvmClassName((KtElement)anchor, jvmClassName);
        if (classDef2 == null) {
            TypeConstraint typeConstraint = TypeConstraints.TOP;
            Intrinsics.checkNotNullExpressionValue((Object)typeConstraint, (String)"TypeConstraints.TOP");
            return typeConstraint;
        }
        TypeConstraints.ClassDef classDef3 = classDef2;
        TypeConstraint.Exact exact = TypeConstraints.exactClass((TypeConstraints.ClassDef)classDef3);
        Intrinsics.checkNotNullExpressionValue((Object)exact, (String)"TypeConstraints.exactClass(classDef)");
        return (TypeConstraint)exact;
    }
}

