/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.coroutine;

import com.intellij.debugger.engine.AsyncStackTraceProvider;
import com.intellij.debugger.engine.JavaStackFrame;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.memory.utils.StackFrameItem;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.HopelessExceptionUtilKt;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CoroutinePreflightFrame;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CoroutineStackFrameItem;
import org.jetbrains.kotlin.idea.debugger.coroutine.util.CoroutineFrameBuilder;
import org.jetbrains.kotlin.idea.debugger.coroutine.util.CoroutineUtilsKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J \u0010\n\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/CoroutineAsyncStackTraceProvider;", "Lcom/intellij/debugger/engine/AsyncStackTraceProvider;", "()V", "getAsyncStackTrace", "", "Lcom/intellij/debugger/memory/utils/StackFrameItem;", "stackFrame", "Lcom/intellij/debugger/engine/JavaStackFrame;", "suspendContext", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "processPreflight", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineStackFrameItem;", "preflightFrame", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutinePreflightFrame;", "kotlin.jvm-debugger.coroutines"})
public final class CoroutineAsyncStackTraceProvider
implements AsyncStackTraceProvider {
    @Nullable
    public List<StackFrameItem> getAsyncStackTrace(@NotNull JavaStackFrame stackFrame, @NotNull SuspendContextImpl suspendContext) {
        List<StackFrameItem> list2;
        Intrinsics.checkNotNullParameter((Object)stackFrame, (String)"stackFrame");
        Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
        boolean $i$f$hopelessAware = false;
        try {
            boolean bl = false;
            list2 = stackFrame instanceof CoroutinePreflightFrame ? this.processPreflight((CoroutinePreflightFrame)stackFrame, suspendContext) : null;
        }
        catch (Exception e$iv) {
            HopelessExceptionUtilKt.handleHopelessException(e$iv);
            list2 = null;
        }
        List<StackFrameItem> stackFrameList = list2;
        Collection collection = stackFrameList;
        return collection == null || collection.isEmpty() ? null : stackFrameList;
    }

    private final List<CoroutineStackFrameItem> processPreflight(CoroutinePreflightFrame preflightFrame, SuspendContextImpl suspendContext) {
        StackFrameProxyImpl resumeWithFrame = (StackFrameProxyImpl)CollectionsKt.firstOrNull(preflightFrame.getThreadPreCoroutineFrames());
        if (CoroutineUtilsKt.threadAndContextSupportsEvaluation(suspendContext, resumeWithFrame)) {
            CoroutineFrameBuilder.Companion.CoroutineFrameItemLists doubleFrameList = CoroutineFrameBuilder.Companion.build(preflightFrame, suspendContext);
            return doubleFrameList.allFrames();
        }
        return null;
    }
}

