/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.breakpoints;

import com.intellij.debugger.ui.breakpoints.JavaLineBreakpointType;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.debugger.SourceInfo;
import org.jetbrains.kotlin.idea.debugger.breakpoints.KotlinBreakpointType;
import org.jetbrains.kotlin.idea.debugger.breakpoints.KotlinFieldBreakpointType;
import org.jetbrains.kotlin.idea.debugger.breakpoints.KotlinFunctionBreakpointType;
import org.jetbrains.kotlin.idea.debugger.breakpoints.KotlinLineBreakpointType;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \u000e2\u00020\u0001:\u0002\r\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u0018\u0010\u0003\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/breakpoints/BreakpointChecker;", "", "()V", "breakpointTypes", "", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpointType;", "check", "Ljava/util/EnumSet;", "Lorg/jetbrains/kotlin/idea/debugger/breakpoints/BreakpointChecker$BreakpointType;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "line", "", "BreakpointType", "Companion", "kotlin.jvm-debugger.core"})
public final class BreakpointChecker {
    private final List<XLineBreakpointType<?>> breakpointTypes;
    @Deprecated
    private static final Map<Class<? extends Object>, BreakpointType> BREAKPOINT_TYPES;
    @NotNull
    private static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final EnumSet<BreakpointType> check(@NotNull KtFile file2, int line) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        EnumSet<BreakpointType> actualBreakpointTypes = EnumSet.noneOf(BreakpointType.class);
        for (XLineBreakpointType<?> breakpointType : this.breakpointTypes) {
            BreakpointType sign;
            if (BREAKPOINT_TYPES.get(breakpointType.getClass()) == null) continue;
            boolean isApplicable2 = breakpointType.canPutAt(file2.getVirtualFile(), line, file2.getProject());
            if (breakpointType instanceof KotlinLineBreakpointType) {
                List<JavaLineBreakpointType.JavaBreakpointVariant> variants2;
                if (!isApplicable2) continue;
                KotlinLineBreakpointType kotlinLineBreakpointType = (KotlinLineBreakpointType)breakpointType;
                Project project2 = file2.getProject();
                VirtualFile virtualFile2 = file2.getVirtualFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"file.virtualFile");
                Intrinsics.checkNotNullExpressionValue(kotlinLineBreakpointType.computeVariants(project2, (XSourcePosition)new SourceInfo(virtualFile2, line, 0, 0, null, null, 60, null)), (String)"breakpointType.computeVa\u2026(file.virtualFile, line))");
                Collection collection = variants2;
                if (!collection.isEmpty()) {
                    void $this$mapNotNullTo$iv$iv;
                    collection = actualBreakpointTypes;
                    Iterable $this$mapNotNull$iv = variants2;
                    boolean $i$f$mapNotNull = false;
                    Iterable iterable = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        BreakpointType breakpointType2;
                        Object element$iv$iv$iv;
                        Object element$iv$iv = element$iv$iv$iv = iterator.next();
                        boolean bl = false;
                        JavaLineBreakpointType.JavaBreakpointVariant it = (JavaLineBreakpointType.JavaBreakpointVariant)element$iv$iv;
                        boolean bl2 = false;
                        if (BREAKPOINT_TYPES.get(it.getClass()) == null) continue;
                        BreakpointType it$iv$iv = breakpointType2;
                        boolean bl3 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    Iterable iterable2 = (List)destination$iv$iv;
                    CollectionsKt.addAll((Collection)collection, (Iterable)iterable2);
                    continue;
                }
                collection = actualBreakpointTypes;
                collection.add(sign);
                continue;
            }
            if (!isApplicable2) continue;
            Collection collection = actualBreakpointTypes;
            collection.add(sign);
        }
        EnumSet<BreakpointType> enumSet = actualBreakpointTypes;
        Intrinsics.checkNotNullExpressionValue(enumSet, (String)"actualBreakpointTypes");
        return enumSet;
    }

    /*
     * WARNING - void declaration
     */
    public BreakpointChecker() {
        List list2;
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv;
        BreakpointChecker breakpointChecker;
        BreakpointChecker breakpointChecker2 = breakpointChecker = this;
        BreakpointChecker breakpointChecker3 = this;
        boolean bl = false;
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        ExtensionsArea extensionsArea = application.getExtensionArea();
        ExtensionPointName extensionPointName = XBreakpointType.EXTENSION_POINT_NAME;
        Intrinsics.checkNotNullExpressionValue((Object)extensionPointName, (String)"XBreakpointType.EXTENSION_POINT_NAME");
        ExtensionPoint extensionPoint = extensionsArea.getExtensionPoint(extensionPointName.getName());
        Intrinsics.checkNotNullExpressionValue((Object)extensionPoint, (String)"ApplicationManager.getAp\u2026XTENSION_POINT_NAME.name)");
        ExtensionPoint extensionPoint2 = extensionPoint;
        Object[] objectArray = extensionPoint2.getExtensions();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"extensionPoint.extensions");
        Object[] objectArray2 = objectArray;
        boolean $i$f$filterIsInstance = false;
        void var7_8 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof XLineBreakpointType)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            XLineBreakpointType it = (XLineBreakpointType)element$iv$iv;
            boolean bl2 = false;
            if (!(it instanceof KotlinBreakpointType)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        breakpointChecker3.breakpointTypes = list2 = (List)destination$iv$iv;
    }

    static {
        Companion = new Companion(null);
        BREAKPOINT_TYPES = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to(KotlinLineBreakpointType.class, (Object)((Object)BreakpointType.Line)), TuplesKt.to(KotlinFieldBreakpointType.class, (Object)((Object)BreakpointType.Field)), TuplesKt.to(KotlinFunctionBreakpointType.class, (Object)((Object)BreakpointType.Function)), TuplesKt.to(JavaLineBreakpointType.LambdaJavaBreakpointVariant.class, (Object)((Object)BreakpointType.Lambda)), TuplesKt.to(KotlinLineBreakpointType.LineKotlinBreakpointVariant.class, (Object)((Object)BreakpointType.Line)), TuplesKt.to(KotlinLineBreakpointType.KotlinBreakpointVariant.class, (Object)((Object)BreakpointType.All))});
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/breakpoints/BreakpointChecker$BreakpointType;", "", "prefix", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getPrefix", "()Ljava/lang/String;", "Line", "Field", "Function", "Lambda", "All", "kotlin.jvm-debugger.core"})
    public static final class BreakpointType
    extends Enum<BreakpointType> {
        public static final /* enum */ BreakpointType Line;
        public static final /* enum */ BreakpointType Field;
        public static final /* enum */ BreakpointType Function;
        public static final /* enum */ BreakpointType Lambda;
        public static final /* enum */ BreakpointType All;
        private static final /* synthetic */ BreakpointType[] $VALUES;
        @NotNull
        private final String prefix;

        static {
            BreakpointType[] breakpointTypeArray = new BreakpointType[5];
            BreakpointType[] breakpointTypeArray2 = breakpointTypeArray;
            breakpointTypeArray[0] = Line = new BreakpointType("L");
            breakpointTypeArray[1] = Field = new BreakpointType("F");
            breakpointTypeArray[2] = Function = new BreakpointType("M");
            breakpointTypeArray[3] = Lambda = new BreakpointType("\u03bb");
            breakpointTypeArray[4] = All = new BreakpointType("*");
            $VALUES = breakpointTypeArray;
        }

        @NotNull
        public final String getPrefix() {
            return this.prefix;
        }

        private BreakpointType(String prefix2) {
            this.prefix = prefix2;
        }

        public static BreakpointType[] values() {
            return (BreakpointType[])$VALUES.clone();
        }

        public static BreakpointType valueOf(String string) {
            return Enum.valueOf(BreakpointType.class, string);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\"\u0010\u0003\u001a\u0016\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/breakpoints/BreakpointChecker$Companion;", "", "()V", "BREAKPOINT_TYPES", "", "Ljava/lang/Class;", "Lorg/jetbrains/kotlin/idea/debugger/breakpoints/BreakpointChecker$BreakpointType;", "kotlin.jvm-debugger.core"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

