/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.jdi.VirtualMachineProxy;
import com.intellij.debugger.impl.DebuggerUtilsAsync;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Function;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VirtualMachine;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.inline.FileMapping;
import org.jetbrains.kotlin.codegen.inline.RangeMapping;
import org.jetbrains.kotlin.codegen.inline.SMAP;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.util.PhysicalFileSystemUtilsKt;
import org.jetbrains.kotlin.idea.core.util.PsiLinesUtilsKt;
import org.jetbrains.kotlin.idea.debugger.BinaryCacheKey;
import org.jetbrains.kotlin.idea.debugger.DebuggerUtils;
import org.jetbrains.kotlin.idea.debugger.NoStrataPositionManagerHelperKt;
import org.jetbrains.kotlin.idea.debugger.NoStrataPositionManagerHelperKt$isInCrossinlineArgument$argumentFunctions$1$$special$;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinDebuggerCaches;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtil;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000l\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\t0\u0007\u001a$\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012\u001a>\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u000b2\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u001a\u000e\u0010\u001d\u001a\u00020\u00012\u0006\u0010\u001e\u001a\u00020\u001f\u001a\u001e\u0010 \u001a\u00020\u00012\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u001c\u001a\n\u0010$\u001a\u00020\u0001*\u00020%\u001a\f\u0010$\u001a\u00020\u0001*\u0004\u0018\u00010&\"\u001a\u0010\u0000\u001a\u00020\u0001X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0004\b\u0004\u0010\u0005\u00a8\u0006'"}, d2={"emulateDexDebugInTests", "", "getEmulateDexDebugInTests", "()Z", "setEmulateDexDebugInTests", "(Z)V", "createWeakBytecodeDebugInfoStorage", "Ljava/util/concurrent/ConcurrentMap;", "Lorg/jetbrains/kotlin/idea/debugger/BinaryCacheKey;", "Lorg/jetbrains/kotlin/codegen/inline/SMAP;", "getLocationsOfInlinedLine", "", "Lcom/sun/jdi/Location;", "type", "Lcom/sun/jdi/ReferenceType;", "position", "Lcom/intellij/debugger/SourcePosition;", "sourceSearchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "inlinedLinesNumbers", "", "inlineLineNumber", "inlineFileName", "", "destinationTypeFqName", "Lorg/jetbrains/kotlin/name/FqName;", "destinationFileName", "project", "Lcom/intellij/openapi/project/Project;", "isInCrossinlineArgument", "ktElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "isInlineFunctionLineNumber", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "lineNumber", "isDexDebug", "Lcom/intellij/debugger/engine/DebugProcess;", "Lcom/sun/jdi/VirtualMachine;", "kotlin.jvm-debugger.util"})
public final class NoStrataPositionManagerHelperKt {
    private static volatile boolean emulateDexDebugInTests;

    public static final boolean isInlineFunctionLineNumber(@NotNull VirtualFile file2, int lineNumber2, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        if (ProjectRootsUtil.isProjectSourceFile$default(project2, file2, false, 4, null)) {
            PsiFile psiFile2 = PhysicalFileSystemUtilsKt.toPsiFile(file2, project2);
            if (psiFile2 == null) {
                return false;
            }
            int linesInFile = PsiLinesUtilsKt.getLineCount((PsiElement)psiFile2);
            return lineNumber2 > linesInFile;
        }
        return true;
    }

    @NotNull
    public static final ConcurrentMap<BinaryCacheKey, SMAP> createWeakBytecodeDebugInfoStorage() {
        ConcurrentMap concurrentMap = ConcurrentFactoryMap.createWeakMap((Function)createWeakBytecodeDebugInfoStorage.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"ConcurrentFactoryMap.cre\u2026eadDebugInfo(bytes)\n    }");
        return concurrentMap;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Location> getLocationsOfInlinedLine(@NotNull ReferenceType type2, @NotNull SourcePosition position, @NotNull GlobalSearchScope sourceSearchScope) {
        void $this$flatMapTo$iv$iv;
        boolean isInCrossinlineArgument2;
        Object v5;
        PsiElement element3;
        Project project2;
        int line;
        block6: {
            Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
            Intrinsics.checkNotNullParameter((Object)position, (String)"position");
            Intrinsics.checkNotNullParameter((Object)sourceSearchScope, (String)"sourceSearchScope");
            line = position.getLine();
            PsiFile psiFile2 = position.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"position.file");
            PsiFile file2 = psiFile2;
            PsiFile psiFile3 = position.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile3, (String)"position.file");
            Project project3 = psiFile3.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"position.file.project");
            project2 = project3;
            Integer n = PsiLinesUtilsKt.getLineStartOffset(file2, line);
            if (n == null) {
                return CollectionsKt.emptyList();
            }
            int lineStartOffset = n;
            PsiElement psiElement2 = file2.findElementAt(lineStartOffset);
            if (psiElement2 == null) {
                return CollectionsKt.emptyList();
            }
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"file.findElementAt(lineS\u2026ffset) ?: return listOf()");
            element3 = psiElement2;
            Sequence $this$firstIsInstanceOrNull$iv = PsiUtilsKt.getParents((PsiElement)element3);
            boolean $i$f$firstIsInstanceOrNull = false;
            for (Object element$iv : $this$firstIsInstanceOrNull$iv) {
                if (!(element$iv instanceof KtElement)) continue;
                v5 = element$iv;
                break block6;
            }
            v5 = null;
        }
        KtElement ktElement = v5;
        if (ktElement == null) {
            return CollectionsKt.emptyList();
        }
        KtElement ktElement2 = ktElement;
        boolean isInInline2 = (Boolean)ApplicationUtilsKt.runReadAction((Function0)new Function0<Boolean>(element3){
            final /* synthetic */ PsiElement $element;

            public final boolean invoke() {
                boolean bl;
                block1: {
                    Sequence $this$any$iv = PsiUtilsKt.getParents((PsiElement)this.$element);
                    boolean $i$f$any = false;
                    for (E element$iv : $this$any$iv) {
                        PsiElement it = (PsiElement)element$iv;
                        boolean bl2 = false;
                        if (!(it instanceof KtFunction && ((KtFunction)it).hasModifier(KtTokens.INLINE_KEYWORD))) continue;
                        bl = true;
                        break block1;
                    }
                    bl = false;
                }
                return bl;
            }
            {
                this.$element = psiElement2;
                super(0);
            }
        });
        if (!isInInline2 && !(isInCrossinlineArgument2 = NoStrataPositionManagerHelperKt.isInCrossinlineArgument(ktElement2))) {
            return CollectionsKt.emptyList();
        }
        PsiFile psiFile4 = position.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile4, (String)"position.file");
        String string = psiFile4.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"position.file.name");
        FqName fqName2 = new FqName(type2.name());
        String string2 = type2.sourceName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"type.sourceName()");
        List<Integer> lines = NoStrataPositionManagerHelperKt.inlinedLinesNumbers(line + 1, string, fqName2, string2, project2, sourceSearchScope);
        Iterable $this$flatMap$iv = lines;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            int it = ((Number)element$iv$iv).intValue();
            boolean bl = false;
            Iterable list$iv$iv = DebuggerUtilsAsync.locationsOfLineSync((ReferenceType)type2, (int)it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static final boolean isInCrossinlineArgument(@NotNull KtElement ktElement) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter((Object)ktElement, (String)"ktElement");
            Sequence argumentFunctions2 = (Sequence)ApplicationUtilsKt.runReadAction((Function0)new Function0<Sequence<? extends KtFunction>>(ktElement){
                final /* synthetic */ KtElement $ktElement;

                @NotNull
                public final Sequence<KtFunction> invoke() {
                    Sequence $this$filterIsInstance$iv = SequencesKt.filter((Sequence)PsiUtilsKt.getParents((PsiElement)((PsiElement)this.$ktElement)), (Function1)isInCrossinlineArgument.argumentFunctions.1.INSTANCE);
                    boolean $i$f$filterIsInstance = false;
                    Sequence sequence2 = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)isInCrossinlineArgument$argumentFunctions$1$$special$$inlined$filterIsInstance$1.INSTANCE);
                    Intrinsics.checkNotNull((Object)sequence2, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
                    return sequence2;
                }
                {
                    this.$ktElement = ktElement;
                    super(0);
                }
            });
            BindingContext bindingContext2 = ResolutionUtils.analyze(ktElement, BodyResolveMode.PARTIAL);
            Sequence $this$any$iv = argumentFunctions2;
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                ValueParameterDescriptor argumentDescriptor;
                KtFunction it = (KtFunction)element$iv;
                boolean bl2 = false;
                ValueParameterDescriptor valueParameterDescriptor = argumentDescriptor = InlineUtil.getInlineArgumentDescriptor((KtFunction)it, (BindingContext)bindingContext2);
                if (!(valueParameterDescriptor != null ? valueParameterDescriptor.isCrossinline() : false)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<Integer> inlinedLinesNumbers(int inlineLineNumber, String inlineFileName, FqName destinationTypeFqName, String destinationFileName, Project project2, GlobalSearchScope sourceSearchScope) {
        void $this$flatMapTo$iv$iv;
        void $this$filterTo$iv$iv;
        String string = destinationTypeFqName.asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"destinationTypeFqName.asString()");
        String internalName = StringsKt.replace$default((String)string, (char)'.', (char)'/', (boolean)false, (int)4, null);
        JvmClassName jvmClassName = JvmClassName.byInternalName((String)internalName);
        Intrinsics.checkNotNullExpressionValue((Object)jvmClassName, (String)"JvmClassName.byInternalName(internalName)");
        JvmClassName jvmClassName2 = jvmClassName;
        KtFile ktFile = DebuggerUtils.findSourceFileForClassIncludeLibrarySources$default(DebuggerUtils.INSTANCE, project2, sourceSearchScope, jvmClassName2, destinationFileName, null, 16, null);
        if (ktFile == null) {
            return CollectionsKt.emptyList();
        }
        KtFile file2 = ktFile;
        VirtualFile virtualFile2 = file2.getVirtualFile();
        if (virtualFile2 == null) {
            return CollectionsKt.emptyList();
        }
        VirtualFile virtualFile3 = virtualFile2;
        SMAP sMAP = KotlinDebuggerCaches.Companion.getSmapCached(project2, jvmClassName2, virtualFile3);
        if (sMAP == null) {
            return CollectionsKt.emptyList();
        }
        SMAP smapData = sMAP;
        Iterable $this$filter$iv = smapData.getFileMappings();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FileMapping it = (FileMapping)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getName(), (Object)inlineFileName)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List mappingsToInlinedFile = (List)destination$iv$iv;
        Iterable $this$flatMap$iv = mappingsToInlinedFile;
        boolean $i$f$flatMap = false;
        destination$iv$iv = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            FileMapping it = (FileMapping)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getLineMappings();
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        List mappingIntervals = (List)destination$iv$iv2;
        return SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)mappingIntervals), (Function1)((Function1)new Function1<RangeMapping, Boolean>(inlineLineNumber){
            final /* synthetic */ int $inlineLineNumber;

            public final boolean invoke(@NotNull RangeMapping rangeMapping) {
                Intrinsics.checkNotNullParameter((Object)rangeMapping, (String)"rangeMapping");
                return rangeMapping.hasMappingForSource(this.$inlineLineNumber);
            }
            {
                this.$inlineLineNumber = n;
                super(1);
            }
        })), (Function1)((Function1)new Function1<RangeMapping, Integer>(inlineLineNumber){
            final /* synthetic */ int $inlineLineNumber;

            public final int invoke(@NotNull RangeMapping rangeMapping) {
                Intrinsics.checkNotNullParameter((Object)rangeMapping, (String)"rangeMapping");
                return rangeMapping.mapSourceToDest(this.$inlineLineNumber);
            }
            {
                this.$inlineLineNumber = n;
                super(1);
            }
        })), (Function1)inlinedLinesNumbers.3.INSTANCE));
    }

    public static final boolean getEmulateDexDebugInTests() {
        return emulateDexDebugInTests;
    }

    public static final void setEmulateDexDebugInTests(boolean bl) {
        emulateDexDebugInTests = bl;
    }

    public static final boolean isDexDebug(@NotNull DebugProcess $this$isDexDebug) {
        Intrinsics.checkNotNullParameter((Object)$this$isDexDebug, (String)"$this$isDexDebug");
        VirtualMachineProxy virtualMachineProxy = $this$isDexDebug.getVirtualMachineProxy();
        if (!(virtualMachineProxy instanceof VirtualMachineProxyImpl)) {
            virtualMachineProxy = null;
        }
        VirtualMachineProxyImpl virtualMachineProxyImpl = (VirtualMachineProxyImpl)virtualMachineProxy;
        VirtualMachine virtualMachine = virtualMachineProxyImpl != null ? virtualMachineProxyImpl.getVirtualMachine() : null;
        return NoStrataPositionManagerHelperKt.isDexDebug(virtualMachine);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isDexDebug(@Nullable VirtualMachine $this$isDexDebug) {
        if (emulateDexDebugInTests) {
            boolean $i$f$isUnitTestMode = false;
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
            if (application.isUnitTestMode()) return true;
        }
        VirtualMachine virtualMachine = $this$isDexDebug;
        if (!Intrinsics.areEqual((Object)(virtualMachine != null ? virtualMachine.name() : null), (Object)"Dalvik")) return false;
        return true;
    }
}

