/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core;

import com.intellij.ide.util.DirectoryChooserUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.externalSystem.model.project.ExternalSystemSourceType;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemContentRootContributor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.RootsChangeRescanningInfo;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModulePackageIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.Query;
import java.io.File;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;
import org.jetbrains.jps.model.java.JavaSourceRootProperties;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.jetbrains.kotlin.config.KotlinSourceRootType;
import org.jetbrains.kotlin.config.SourceKotlinRootType;
import org.jetbrains.kotlin.config.TestSourceKotlinRootType;
import org.jetbrains.kotlin.idea.caches.PerModulePackageCacheService;
import org.jetbrains.kotlin.idea.caches.project.MultiplatformUtilKt;
import org.jetbrains.kotlin.idea.caches.project.SourceType;
import org.jetbrains.kotlin.idea.core.ExternalContentRootChooser;
import org.jetbrains.kotlin.idea.core.ModuleUtilsKt;
import org.jetbrains.kotlin.idea.core.PackageUtilsKt;
import org.jetbrains.kotlin.idea.core.PackageUtilsKt$WhenMappings;
import org.jetbrains.kotlin.idea.core.PureKotlinSourceFoldersHolder;
import org.jetbrains.kotlin.idea.core.util.PhysicalFileSystemUtilsKt;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.idea.roots.RootUtilsKt;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtilKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.jvm.JvmPlatformKt;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.utils.KotlinExceptionWithAttachments;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000\u0092\u0001\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a*\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u0018\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007\u001a(\u0010\u0013\u001a\u0004\u0018\u00010\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u001a:\u0010\u0019\u001a\u0004\u0018\u00010\u0005*\u00020\u000b2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00050\u001b2\u000e\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u001b2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00050\u001bH\u0002\u001a\u001a\u0010\u001e\u001a\u00020\u0005*\u00020\u000b2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00050\u001bH\u0002\u001a\u001c\u0010 \u001a\u0004\u0018\u00010\u0016*\u00020\u000b2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u001bH\u0002\u001a\u0014\u0010#\u001a\n\u0012\u0004\u0012\u00020%\u0018\u00010$*\u00020\u000bH\u0002\u001a\u0010\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00160\u001b*\u00020\u000b\u001a\u001a\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00160\u001b*\u00020\u000b2\u0006\u0010'\u001a\u00020\u000eH\u0002\u001a\u0012\u0010(\u001a\b\u0012\u0004\u0012\u00020\"0)*\u00020\u000bH\u0002\u001a\u001a\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00160\u001b*\u00020\u000b2\u0006\u0010'\u001a\u00020\u000eH\u0002\u001a\"\u0010+\u001a\n\u0012\u0004\u0012\u00020%\u0018\u00010\u001b*\u00020\u000b2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00050\u001bH\u0002\u001a\n\u0010,\u001a\u00020-*\u00020.\u001a\f\u0010/\u001a\u0004\u0018\u00010-*\u00020\u0012\u001a\n\u00100\u001a\u00020-*\u00020\u0012\u001a\u000e\u00101\u001a\u0004\u0018\u00010-*\u00020\u0012H\u0002\u001a\f\u00102\u001a\u0004\u0018\u00010\t*\u00020\u0012\u001a\u0014\u00103\u001a\u000204*\u00020\u00162\u0006\u00105\u001a\u000206H\u0002\u001a\n\u00107\u001a\u000204*\u000208\u001a\n\u00109\u001a\u000204*\u000208\u001a\u000e\u0010:\u001a\u0004\u0018\u00010\u0005*\u00020\u0016H\u0002\u001a(\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00160\u001b*\b\u0012\u0004\u0012\u00020\"0)2\u0006\u00105\u001a\u0002062\u0006\u0010'\u001a\u00020\u000eH\u0002\"\u001a\u0010\u0000\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"kotlinSourceRootTypes", "", "Lorg/jetbrains/jps/model/module/JpsModuleSourceRootType;", "Lorg/jetbrains/jps/model/java/JavaSourceRootProperties;", "convertUrlToPath", "Ljava/nio/file/Path;", "url", "", "findLongestExistingPackage", "Lcom/intellij/psi/PsiPackage;", "module", "Lcom/intellij/openapi/module/Module;", "packageName", "pureKotlinSourceFolders", "Lorg/jetbrains/kotlin/idea/core/PureKotlinSourceFoldersHolder;", "allowedScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "findOrCreateDirectoryForPackage", "Lcom/intellij/psi/PsiDirectory;", "getWritableModuleDirectory", "vFiles", "Lcom/intellij/util/Query;", "Lcom/intellij/openapi/vfs/VirtualFile;", "manager", "Lcom/intellij/psi/PsiManager;", "chooseSourceRootPath", "allowedPaths", "", "sourceFolderPaths", "contentEntryPaths", "chooseSourceRootPathHeuristically", "contentEntries", "createSourceRootDirectory", "nonGeneratedSourceFolders", "Lcom/intellij/openapi/roots/SourceFolder;", "findContentRootsByExternalProject", "", "Lcom/intellij/openapi/externalSystem/util/ExternalSystemContentRootContributor$ExternalContentRoot;", "findExistingNonGeneratedKotlinSourceRootFiles", "pureKotlinSourceFoldersHolder", "findNonGeneratedKotlinSourceFolders", "Lkotlin/sequences/Sequence;", "findOrConfigureKotlinSourceRoots", "findSourceRootPathByExternalProject", "getFqNameByDirectory", "Lorg/jetbrains/kotlin/name/FqName;", "Lcom/intellij/psi/PsiFile;", "getFqNameWithImplicitPrefix", "getFqNameWithImplicitPrefixOrRoot", "getNonRootFqNameOrNull", "getPackage", "hasExplicitPackagePrefix", "", "project", "Lcom/intellij/openapi/project/Project;", "packageMatchesDirectory", "Lorg/jetbrains/kotlin/psi/KtFile;", "packageMatchesDirectoryOrImplicit", "pathOrNull", "toExistingFiles", "kotlin.core"})
public final class PackageUtilsKt {
    private static final Set<JpsModuleSourceRootType<JavaSourceRootProperties>> kotlinSourceRootTypes;

    @Nullable
    public static final PsiPackage getPackage(@NotNull PsiDirectory $this$getPackage) {
        Intrinsics.checkNotNullParameter((Object)$this$getPackage, (String)"$this$getPackage");
        JavaDirectoryService javaDirectoryService = JavaDirectoryService.getInstance();
        Intrinsics.checkNotNull((Object)javaDirectoryService);
        return javaDirectoryService.getPackage($this$getPackage);
    }

    private static final FqName getNonRootFqNameOrNull(PsiDirectory $this$getNonRootFqNameOrNull) {
        FqName fqName2;
        Object object = PackageUtilsKt.getPackage($this$getNonRootFqNameOrNull);
        if (object != null && (object = object.getQualifiedName()) != null) {
            Object object2;
            Object p1 = object2 = object;
            boolean bl = false;
            fqName2 = new FqName((String)p1);
        } else {
            fqName2 = null;
        }
        return fqName2;
    }

    @NotNull
    public static final FqName getFqNameByDirectory(@NotNull PsiFile $this$getFqNameByDirectory) {
        Intrinsics.checkNotNullParameter((Object)$this$getFqNameByDirectory, (String)"$this$getFqNameByDirectory");
        PsiDirectory psiDirectory = $this$getFqNameByDirectory.getParent();
        if (psiDirectory == null || (psiDirectory = PackageUtilsKt.getNonRootFqNameOrNull(psiDirectory)) == null) {
            FqName fqName2 = FqName.ROOT;
            psiDirectory = fqName2;
            Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"FqName.ROOT");
        }
        return psiDirectory;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final FqName getFqNameWithImplicitPrefix(@NotNull PsiDirectory $this$getFqNameWithImplicitPrefix) {
        Intrinsics.checkNotNullParameter((Object)$this$getFqNameWithImplicitPrefix, (String)"$this$getFqNameWithImplicitPrefix");
        FqName fqName2 = PackageUtilsKt.getNonRootFqNameOrNull($this$getFqNameWithImplicitPrefix);
        if (fqName2 == null) {
            return null;
        }
        FqName packageFqName = fqName2;
        Object object = ProjectRootsUtilKt.getSourceRoot((PsiFileSystemItem)$this$getFqNameWithImplicitPrefix);
        if (object != null) {
            VirtualFile virtualFile2;
            VirtualFile it = virtualFile2 = object;
            boolean bl = false;
            Project project2 = $this$getFqNameWithImplicitPrefix.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
            object = !PackageUtilsKt.hasExplicitPackagePrefix(it, project2) ? virtualFile2 : null;
            if (object != null) {
                void $this$mapTo$iv$iv;
                VirtualFile sourceRoot = virtualFile2 = object;
                boolean bl2 = false;
                Project project3 = $this$getFqNameWithImplicitPrefix.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"project");
                FqName implicitPrefix = PerModulePackageCacheService.Companion.getInstance(project3).getImplicitPackagePrefix(sourceRoot);
                List list2 = implicitPrefix.pathSegments();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"implicitPrefix.pathSegments()");
                Collection collection = list2;
                List list3 = packageFqName.pathSegments();
                Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"packageFqName.pathSegments()");
                Iterable $this$map$iv = CollectionsKt.plus((Collection)collection, (Iterable)list3);
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it2;
                    Name name2 = (Name)item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    boolean bl3 = false;
                    String string = it2.asString();
                    collection2.add(string);
                }
                return FqName.fromSegments((List)((List)destination$iv$iv));
            }
        }
        return packageFqName;
    }

    @NotNull
    public static final FqName getFqNameWithImplicitPrefixOrRoot(@NotNull PsiDirectory $this$getFqNameWithImplicitPrefixOrRoot) {
        Intrinsics.checkNotNullParameter((Object)$this$getFqNameWithImplicitPrefixOrRoot, (String)"$this$getFqNameWithImplicitPrefixOrRoot");
        FqName fqName2 = PackageUtilsKt.getFqNameWithImplicitPrefix($this$getFqNameWithImplicitPrefixOrRoot);
        if (fqName2 == null) {
            FqName fqName3 = FqName.ROOT;
            fqName2 = fqName3;
            Intrinsics.checkNotNullExpressionValue((Object)fqName3, (String)"FqName.ROOT");
        }
        return fqName2;
    }

    private static final boolean hasExplicitPackagePrefix(VirtualFile $this$hasExplicitPackagePrefix, Project project2) {
        CharSequence charSequence;
        Object object = PhysicalFileSystemUtilsKt.toPsiDirectory($this$hasExplicitPackagePrefix, project2);
        return object != null && (object = PackageUtilsKt.getPackage(object)) != null && (object = object.getQualifiedName()) != null && (charSequence = (CharSequence)object).length() > 0;
    }

    public static final boolean packageMatchesDirectory(@NotNull KtFile $this$packageMatchesDirectory) {
        Intrinsics.checkNotNullParameter((Object)$this$packageMatchesDirectory, (String)"$this$packageMatchesDirectory");
        return Intrinsics.areEqual((Object)$this$packageMatchesDirectory.getPackageFqName(), (Object)PackageUtilsKt.getFqNameByDirectory((PsiFile)$this$packageMatchesDirectory));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean packageMatchesDirectoryOrImplicit(@NotNull KtFile $this$packageMatchesDirectoryOrImplicit) {
        Intrinsics.checkNotNullParameter((Object)$this$packageMatchesDirectoryOrImplicit, (String)"$this$packageMatchesDirectoryOrImplicit");
        if (Intrinsics.areEqual((Object)$this$packageMatchesDirectoryOrImplicit.getPackageFqName(), (Object)PackageUtilsKt.getFqNameByDirectory((PsiFile)$this$packageMatchesDirectoryOrImplicit))) return true;
        PsiDirectory psiDirectory = $this$packageMatchesDirectoryOrImplicit.getParent();
        if (!Intrinsics.areEqual((Object)$this$packageMatchesDirectoryOrImplicit.getPackageFqName(), (Object)(psiDirectory != null ? PackageUtilsKt.getFqNameWithImplicitPrefix(psiDirectory) : null))) return false;
        return true;
    }

    private static final PsiDirectory getWritableModuleDirectory(Query<VirtualFile> vFiles2, Module module2, PsiManager manager) {
        for (VirtualFile vFile : vFiles2) {
            PsiDirectory directory;
            if (ModuleUtil.findModuleForFile((VirtualFile)vFile, (Project)module2.getProject()) != module2 || (directory = manager.findDirectory(vFile)) == null || !directory.isValid() || !directory.isWritable()) continue;
            return directory;
        }
        return null;
    }

    private static final PsiPackage findLongestExistingPackage(Module module2, String packageName2, PureKotlinSourceFoldersHolder pureKotlinSourceFolders, GlobalSearchScope allowedScope) {
        PsiManager psiManager2 = PsiManager.getInstance((Project)module2.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)psiManager2, (String)"PsiManager.getInstance(module.project)");
        PsiManager manager = psiManager2;
        String nameToMatch = packageName2;
        while (true) {
            int lastDotIndex;
            Query vFiles2;
            Function1 function1 = (Function1)new Function1<VirtualFile, Boolean>(allowedScope){

                public final boolean invoke(@NotNull VirtualFile p1) {
                    Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                    return ((GlobalSearchScope)this.receiver).contains(p1);
                }
            };
            Intrinsics.checkNotNullExpressionValue((Object)ModulePackageIndex.getInstance((Module)module2).getDirsByPackageName(nameToMatch, false).filtering(new Predicate(function1){
                private final /* synthetic */ Function1 function;
                {
                    this.function = function1;
                }

                public final /* synthetic */ boolean test(Object p0) {
                    Object object = this.function.invoke(p0);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"invoke(...)");
                    return (Boolean)object;
                }
            }), (String)"ModulePackageIndex.getIn\u2026g(allowedScope::contains)");
            PsiDirectory directory = PackageUtilsKt.getWritableModuleDirectory((Query<VirtualFile>)vFiles2, module2, manager);
            if (directory != null) {
                VirtualFile virtualFile2 = directory.getVirtualFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"directory.virtualFile");
                String string = virtualFile2.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"directory.virtualFile.path");
                if (pureKotlinSourceFolders.hasPurePrefixInPath(module2, string)) {
                    return PackageUtilsKt.getPackage(directory);
                }
            }
            if ((lastDotIndex = StringsKt.lastIndexOf$default((CharSequence)nameToMatch, (char)'.', (int)0, (boolean)false, (int)6, null)) < 0) {
                return null;
            }
            String string = nameToMatch;
            int n = 0;
            Intrinsics.checkNotNullExpressionValue((Object)string.substring(n, lastDotIndex), (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        }
    }

    private static final Sequence<SourceFolder> findNonGeneratedKotlinSourceFolders(Module $this$findNonGeneratedKotlinSourceFolders) {
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)$this$findNonGeneratedKotlinSourceFolders);
        Intrinsics.checkNotNullExpressionValue((Object)moduleRootManager, (String)"ModuleRootManager.getInstance(this)");
        Object[] objectArray = moduleRootManager.getContentEntries();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"ModuleRootManager.getIns\u2026this)\n    .contentEntries");
        return SequencesKt.filter((Sequence)SequencesKt.flatMap((Sequence)ArraysKt.asSequence((Object[])objectArray), (Function1)findNonGeneratedKotlinSourceFolders.1.INSTANCE), (Function1)findNonGeneratedKotlinSourceFolders.2.INSTANCE);
    }

    private static final List<VirtualFile> findExistingNonGeneratedKotlinSourceRootFiles(Module $this$findExistingNonGeneratedKotlinSourceRootFiles, PureKotlinSourceFoldersHolder pureKotlinSourceFoldersHolder) {
        Sequence<SourceFolder> sequence2 = PackageUtilsKt.findNonGeneratedKotlinSourceFolders($this$findExistingNonGeneratedKotlinSourceRootFiles);
        Project project2 = $this$findExistingNonGeneratedKotlinSourceRootFiles.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        return PackageUtilsKt.toExistingFiles(sequence2, project2, pureKotlinSourceFoldersHolder);
    }

    @NotNull
    public static final List<VirtualFile> findExistingNonGeneratedKotlinSourceRootFiles(@NotNull Module $this$findExistingNonGeneratedKotlinSourceRootFiles) {
        Intrinsics.checkNotNullParameter((Object)$this$findExistingNonGeneratedKotlinSourceRootFiles, (String)"$this$findExistingNonGeneratedKotlinSourceRootFiles");
        return PackageUtilsKt.findExistingNonGeneratedKotlinSourceRootFiles($this$findExistingNonGeneratedKotlinSourceRootFiles, new PureKotlinSourceFoldersHolder());
    }

    private static final List<VirtualFile> toExistingFiles(Sequence<? extends SourceFolder> $this$toExistingFiles, Project project2, PureKotlinSourceFoldersHolder pureKotlinSourceFoldersHolder) {
        return SequencesKt.toList((Sequence)SequencesKt.mapNotNull($this$toExistingFiles, (Function1)((Function1)new Function1<SourceFolder, VirtualFile>(pureKotlinSourceFoldersHolder, project2){
            final /* synthetic */ PureKotlinSourceFoldersHolder $pureKotlinSourceFoldersHolder;
            final /* synthetic */ Project $project;

            @Nullable
            public final VirtualFile invoke(@NotNull SourceFolder sourceFolder) {
                Object object;
                Intrinsics.checkNotNullParameter((Object)sourceFolder, (String)"sourceFolder");
                VirtualFile virtualFile2 = sourceFolder.getFile();
                if (virtualFile2 != null) {
                    VirtualFile virtualFile3;
                    VirtualFile it = virtualFile3 = virtualFile2;
                    boolean bl = false;
                    VirtualFile virtualFile4 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile4, (String)"it");
                    object = this.$pureKotlinSourceFoldersHolder.hasPurePrefixInVirtualFile(this.$project, virtualFile4) ? virtualFile3 : null;
                } else {
                    object = null;
                }
                return object;
            }
            {
                this.$pureKotlinSourceFoldersHolder = pureKotlinSourceFoldersHolder;
                this.$project = project2;
                super(1);
            }
        })));
    }

    private static final List<VirtualFile> findOrConfigureKotlinSourceRoots(Module $this$findOrConfigureKotlinSourceRoots, PureKotlinSourceFoldersHolder pureKotlinSourceFoldersHolder) {
        List nonGeneratedSourceFolders = SequencesKt.toList(PackageUtilsKt.findNonGeneratedKotlinSourceFolders($this$findOrConfigureKotlinSourceRoots));
        Sequence sequence2 = CollectionsKt.asSequence((Iterable)nonGeneratedSourceFolders);
        Project project2 = $this$findOrConfigureKotlinSourceRoots.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        Collection $this$ifNotEmpty$iv = PackageUtilsKt.toExistingFiles((Sequence<? extends SourceFolder>)sequence2, project2, pureKotlinSourceFoldersHolder);
        boolean $i$f$ifNotEmpty = false;
        if (!$this$ifNotEmpty$iv.isEmpty()) {
            List $this$ifNotEmpty = (List)$this$ifNotEmpty$iv;
            boolean bl = false;
            return $this$ifNotEmpty;
        }
        return CollectionsKt.listOfNotNull((Object)PackageUtilsKt.createSourceRootDirectory($this$findOrConfigureKotlinSourceRoots, nonGeneratedSourceFolders));
    }

    private static final Path convertUrlToPath(String url) {
        Path path2;
        Object object = VfsUtilCore.convertToURL((String)url);
        if (object != null && (object = ((URL)object).getPath()) != null) {
            Object object2;
            Object p1 = object2 = object;
            boolean bl = false;
            Path path3 = Paths.get((String)p1, new String[0]);
            path2 = path3;
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"get(path)");
        } else {
            path2 = null;
        }
        return path2;
    }

    private static final Path pathOrNull(VirtualFile $this$pathOrNull) {
        return $this$pathOrNull.getFileSystem().getNioPath($this$pathOrNull);
    }

    /*
     * WARNING - void declaration
     */
    private static final VirtualFile createSourceRootDirectory(Module $this$createSourceRootDirectory, List<? extends SourceFolder> nonGeneratedSourceFolders) {
        Iterable iterable;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = nonGeneratedSourceFolders;
        boolean $i$f$mapNotNull = false;
        Iterable iterable2 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo2 = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Path path2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            SourceFolder it = (SourceFolder)element$iv$iv;
            boolean bl2 = false;
            String string = it.getUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.url");
            if (PackageUtilsKt.convertUrlToPath(string) == null) continue;
            Path it$iv$iv = path2;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        if ($this$mapNotNull$iv.isEmpty()) {
            boolean bl = false;
            iterable = null;
        } else {
            iterable = $this$mapNotNull$iv;
        }
        List sourceFolderPaths = (List)iterable;
        Object var4_4 = null;
        Lazy contentEntryPaths2 = LazyKt.lazy((Function0)((Function0)new Function0<List<? extends Path>>($this$createSourceRootDirectory){
            final /* synthetic */ Module $this_createSourceRootDirectory;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<Path> invoke() {
                void $this$mapNotNullTo$iv$iv;
                ContentEntry[] contentEntryArray = ProjectRootsUtilKt.getRootManager(this.$this_createSourceRootDirectory).getContentEntries();
                Intrinsics.checkNotNullExpressionValue((Object)contentEntryArray, (String)"rootManager.contentEntries");
                ContentEntry[] $this$mapNotNull$iv = contentEntryArray;
                boolean $i$f$mapNotNull = false;
                ContentEntry[] contentEntryArray2 = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                int n = ((void)$this$forEach$iv$iv$iv).length;
                for (int i = 0; i < n; ++i) {
                    Object object;
                    void element$iv$iv$iv;
                    void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
                    boolean bl = false;
                    void it = element$iv$iv;
                    boolean bl2 = false;
                    void v1 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"it");
                    Object object2 = v1.getFile();
                    if (object2 == null || (object2 = PackageUtilsKt.access$pathOrNull(object2)) == null) {
                        String string = it.getUrl();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.url");
                        object2 = PackageUtilsKt.access$convertUrlToPath(string);
                    }
                    if (object2 == null) continue;
                    Object it$iv$iv = object = object2;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                return (List)destination$iv$iv;
            }
            {
                this.$this_createSourceRootDirectory = module2;
                super(0);
            }
        }));
        List list2 = sourceFolderPaths;
        if (list2 == null) {
            destination$iv$iv = contentEntryPaths2;
            Object $i$f$mapNotNullTo2 = null;
            list2 = (List)destination$iv$iv.getValue();
        }
        List allowedPaths = list2;
        Lazy $i$f$mapNotNullTo2 = contentEntryPaths2;
        Object var8_11 = null;
        Path path3 = PackageUtilsKt.chooseSourceRootPath($this$createSourceRootDirectory, allowedPaths, sourceFolderPaths, (List)$i$f$mapNotNullTo2.getValue());
        if (path3 == null) {
            return null;
        }
        Path srcFolderPath = path3;
        boolean $i$f$runWriteAction = false;
        ApplicationManager.getApplication().runWriteAction(new Computable($this$createSourceRootDirectory, srcFolderPath){
            final /* synthetic */ Module $this_createSourceRootDirectory$inlined;
            final /* synthetic */ Path $srcFolderPath$inlined;
            {
                this.$this_createSourceRootDirectory$inlined = module2;
                this.$srcFolderPath$inlined = path2;
            }

            public final T compute() {
                boolean bl = false;
                Path path2 = this.$srcFolderPath$inlined;
                VfsUtil.createDirectoryIfMissing((String)((Object)path2.toAbsolutePath()).toString());
                Project project2 = this.$this_createSourceRootDirectory$inlined.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
                RootsChangeRescanningInfo rootsChangeRescanningInfo = RootsChangeRescanningInfo.NO_RESCAN_NEEDED;
                Intrinsics.checkNotNullExpressionValue((Object)rootsChangeRescanningInfo, (String)"RootsChangeRescanningInfo.NO_RESCAN_NEEDED");
                RootUtilsKt.invalidateProjectRoots(project2, rootsChangeRescanningInfo);
                return (T)Unit.INSTANCE;
            }
        });
        return VfsUtil.findFile((Path)srcFolderPath, (boolean)true);
    }

    private static final Path chooseSourceRootPath(Module $this$chooseSourceRootPath, List<? extends Path> allowedPaths, List<? extends Path> sourceFolderPaths, List<? extends Path> contentEntryPaths2) {
        List<ExternalSystemContentRootContributor.ExternalContentRoot> externalContentRoots = PackageUtilsKt.findSourceRootPathByExternalProject($this$chooseSourceRootPath, allowedPaths);
        Iterable iterable = externalContentRoots;
        if (!(iterable == null || iterable.isEmpty())) {
            ExternalSystemContentRootContributor.ExternalContentRoot externalContentRoot = (ExternalSystemContentRootContributor.ExternalContentRoot)CollectionsKt.singleOrNull(externalContentRoots);
            if (externalContentRoot != null) {
                iterable = externalContentRoot;
                Collection it = iterable;
                boolean bl = false;
                return it.getPath();
            }
            if (externalContentRoots.size() == 2) {
                ExternalSystemContentRootContributor.ExternalContentRoot it;
                boolean bl;
                block12: {
                    Iterable $this$any$iv = externalContentRoots;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            it = (ExternalSystemContentRootContributor.ExternalContentRoot)element$iv;
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual((Object)PathsKt.getName((Path)it.getPath()), (Object)"java")) continue;
                            bl = true;
                            break block12;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    TargetPlatform targetPlatform = PlatformKt.getPlatform($this$chooseSourceRootPath);
                    if (targetPlatform != null) {
                        if (JvmPlatformKt.isJvm((TargetPlatform)targetPlatform)) {
                            Object object;
                            block13: {
                                Iterable $i$f$any = iterable = (Iterable)externalContentRoots;
                                for (Object object2 : $i$f$any) {
                                    it = (ExternalSystemContentRootContributor.ExternalContentRoot)object2;
                                    boolean bl3 = false;
                                    if (!Intrinsics.areEqual((Object)PathsKt.getName((Path)it.getPath()), (Object)"kotlin")) continue;
                                    object = object2;
                                    break block13;
                                }
                                object = null;
                            }
                            ExternalSystemContentRootContributor.ExternalContentRoot externalContentRoot2 = (ExternalSystemContentRootContributor.ExternalContentRoot)object;
                            if (externalContentRoot2 != null) {
                                Iterable it2 = iterable = externalContentRoot2;
                                boolean bl4 = false;
                                return it2.getPath();
                            }
                        }
                    }
                }
            }
            Project project2 = $this$chooseSourceRootPath.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
            ExternalSystemContentRootContributor.ExternalContentRoot externalContentRoot3 = ExternalContentRootChooser.Companion.choose(project2, (Collection<ExternalSystemContentRootContributor.ExternalContentRoot>)externalContentRoots);
            return externalContentRoot3 != null ? externalContentRoot3.getPath() : null;
        }
        Iterable<Path> iterable2 = sourceFolderPaths;
        if (iterable2 == null || (iterable2 = (Path)CollectionsKt.singleOrNull(iterable2)) == null) {
            iterable2 = PackageUtilsKt.chooseSourceRootPathHeuristically($this$chooseSourceRootPath, contentEntryPaths2);
        }
        return iterable2;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<ExternalSystemContentRootContributor.ExternalContentRoot> findSourceRootPathByExternalProject(Module $this$findSourceRootPathByExternalProject, List<? extends Path> allowedPaths) {
        List list2;
        Collection<ExternalSystemContentRootContributor.ExternalContentRoot> collection = PackageUtilsKt.findContentRootsByExternalProject($this$findSourceRootPathByExternalProject);
        if (collection != null) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = collection;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                boolean bl;
                block6: {
                    ExternalSystemContentRootContributor.ExternalContentRoot externalContentRoot = (ExternalSystemContentRootContributor.ExternalContentRoot)element$iv$iv;
                    boolean bl2 = false;
                    Iterable $this$any$iv = allowedPaths;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            Path it = (Path)element$iv;
                            boolean bl3 = false;
                            if (!externalContentRoot.getPath().startsWith(it)) continue;
                            bl = true;
                            break block6;
                        }
                        bl = false;
                    }
                }
                if (!bl) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = null;
        }
        return list2;
    }

    /*
     * WARNING - void declaration
     */
    private static final Collection<ExternalSystemContentRootContributor.ExternalContentRoot> findContentRootsByExternalProject(Module $this$findContentRootsByExternalProject) {
        void $this$filterTo$iv$iv;
        Collection excludedPaths;
        List list2;
        Enum enum_;
        SourceType sourceType = MultiplatformUtilKt.getSourceType($this$findContentRootsByExternalProject);
        if (sourceType != null) {
            SourceType sourceType2;
            SourceType it = sourceType2 = sourceType;
            boolean bl = false;
            enum_ = !ModuleUtilsKt.isAndroidModule$default($this$findContentRootsByExternalProject, null, 1, null) ? sourceType2 : null;
        } else {
            enum_ = null;
        }
        if (enum_ == null) {
            list2 = CollectionsKt.listOf((Object[])new ExternalSystemSourceType[]{ExternalSystemSourceType.SOURCE, ExternalSystemSourceType.TEST});
        } else {
            switch (PackageUtilsKt$WhenMappings.$EnumSwitchMapping$0[enum_.ordinal()]) {
                case 1: {
                    list2 = CollectionsKt.listOf((Object)ExternalSystemSourceType.SOURCE);
                    break;
                }
                case 2: {
                    list2 = CollectionsKt.listOf((Object)ExternalSystemSourceType.TEST);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        List sourceRootTypes = list2;
        Collection collection = ExternalSystemApiUtil.getExternalProjectContentRoots((Module)$this$findContentRootsByExternalProject, (Collection)sourceRootTypes);
        if (collection == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"ExternalSystemApiUtil.ge\u2026RootTypes) ?: return null");
        Collection externalContentRoots = collection;
        Collection bl = excludedPaths = ExternalSystemApiUtil.getExternalProjectContentRoots((Module)$this$findContentRootsByExternalProject, (ExternalSystemSourceType)ExternalSystemSourceType.EXCLUDED);
        if (bl == null || bl.isEmpty()) {
            return externalContentRoots;
        }
        Iterable $this$filter$iv = externalContentRoots;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl2;
            block14: {
                ExternalSystemContentRootContributor.ExternalContentRoot contentRoot = (ExternalSystemContentRootContributor.ExternalContentRoot)element$iv$iv;
                boolean bl3 = false;
                Iterable $this$none$iv = excludedPaths;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl2 = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        ExternalSystemContentRootContributor.ExternalContentRoot it = (ExternalSystemContentRootContributor.ExternalContentRoot)element$iv;
                        boolean bl4 = false;
                        if (!contentRoot.getPath().startsWith(it.getPath())) continue;
                        bl2 = false;
                        break block14;
                    }
                    bl2 = true;
                }
            }
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final Path chooseSourceRootPathHeuristically(Module $this$chooseSourceRootPathHeuristically, List<? extends Path> contentEntries) {
        Path path2;
        Object v3;
        block5: {
            Iterable iterable;
            String string;
            block4: {
                String string2 = $this$chooseSourceRootPathHeuristically.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name");
                String $this$takeLastWhile$iv = string2;
                boolean $i$f$takeLastWhile = false;
                for (int index$iv = StringsKt.getLastIndex((CharSequence)$this$takeLastWhile$iv); -1 < index$iv; --index$iv) {
                    char it = $this$takeLastWhile$iv.charAt(index$iv);
                    boolean bl = false;
                    if (it != '.') continue;
                    String string3 = $this$takeLastWhile$iv;
                    int n = index$iv + 1;
                    String string4 = string3.substring(n);
                    string = string4;
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).substring(startIndex)");
                    break block4;
                }
                string = $this$takeLastWhile$iv;
            }
            String moduleName2 = string;
            Iterable iterable2 = iterable = (Iterable)contentEntries;
            for (Object t : iterable2) {
                Path it = (Path)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)PathsKt.getName((Path)it), (Object)moduleName2)) continue;
                v3 = t;
                break block5;
            }
            v3 = null;
        }
        if ((path2 = (Path)v3) == null) {
            path2 = (Path)CollectionsKt.firstOrNull(contentEntries);
        }
        if (path2 == null) {
            throw (Throwable)new KotlinExceptionWithAttachments("Content entry path is not found").withAttachment("module", (Object)$this$chooseSourceRootPathHeuristically.getName());
        }
        Path sourceRootPath = path2;
        Path path3 = sourceRootPath.resolve("kotlin");
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"sourceRootPath.resolve(\"kotlin\")");
        return path3;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final PsiDirectory findOrCreateDirectoryForPackage(@NotNull Module module2, @NotNull String packageName2) {
        void psiDirectory;
        CharSequence $this$toTypedArray$iv222;
        PsiDirectory psiDirectory2;
        Collection result2;
        List<VirtualFile> sourcePaths;
        Collection collection;
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter((Object)packageName2, (String)"packageName");
        Project project2 = module2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"module.project");
        Project project3 = project2;
        PureKotlinSourceFoldersHolder pureKotlinSourceFoldersHolder = new PureKotlinSourceFoldersHolder();
        PsiDirectory existingDirectoryByPackage = null;
        Object restOfName = packageName2;
        CharSequence charSequence = packageName2;
        if (charSequence.length() > 0 && !(collection = (Collection)(sourcePaths = PackageUtilsKt.findExistingNonGeneratedKotlinSourceRootFiles(module2, pureKotlinSourceFoldersHolder))).isEmpty()) {
            void $this$reduce$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = sourcePaths;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                VirtualFile virtualFile2 = (VirtualFile)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                GlobalSearchScopesCore.DirectoryScope directoryScope = new GlobalSearchScopesCore.DirectoryScope(project3, (VirtualFile)it, true);
                collection2.add(directoryScope);
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$reduce = false;
            Iterator iterator$iv = $this$reduce$iv.iterator();
            if (!iterator$iv.hasNext()) {
                throw new UnsupportedOperationException("Empty collection can't be reduced.");
            }
            Object accumulator$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void p22;
                SearchScope $i$f$mapTo2 = (SearchScope)iterator$iv.next();
                GlobalSearchScope p1 = (GlobalSearchScope)accumulator$iv;
                boolean bl = false;
                accumulator$iv = p1.union((SearchScope)p22);
            }
            Object t = accumulator$iv;
            Intrinsics.checkNotNullExpressionValue(t, (String)"sourcePaths.map { Global\u2026GlobalSearchScope::union)");
            GlobalSearchScope allowedScope = (GlobalSearchScope)t;
            PsiPackage rootPackage = PackageUtilsKt.findLongestExistingPackage(module2, packageName2, pureKotlinSourceFoldersHolder, allowedScope);
            if (rootPackage != null) {
                String string;
                int beginIndex = rootPackage.getQualifiedName().length() + 1;
                if (beginIndex < packageName2.length()) {
                    accumulator$iv = packageName2;
                    String string2 = ((String)accumulator$iv).substring(beginIndex);
                    string = string2;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
                } else {
                    string = "";
                }
                String subPackageName = string;
                String postfixToShow = StringsKt.replace$default((String)subPackageName, (char)'.', (char)File.separatorChar, (boolean)false, (int)4, null);
                CharSequence p22 = subPackageName;
                if (p22.length() > 0) {
                    char p22 = File.separatorChar;
                    postfixToShow = p22 + postfixToShow;
                }
                PsiDirectory[] moduleDirectories = rootPackage.getDirectories(allowedScope);
                result2 = new ArrayList();
                PsiDirectory[] bl = moduleDirectories;
                int n = bl.length;
                for (int it = 0; it < n; ++it) {
                    PsiDirectory directory;
                    PsiDirectory psiDirectory3 = directory = bl[it];
                    Intrinsics.checkNotNullExpressionValue((Object)psiDirectory3, (String)"directory");
                    VirtualFile virtualFile3 = psiDirectory3.getVirtualFile();
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile3, (String)"directory.virtualFile");
                    if (!pureKotlinSourceFoldersHolder.hasPurePrefixInVirtualFile(project3, virtualFile3)) continue;
                    Collection collection3 = result2;
                    collection3.add(directory);
                }
                Collection $this$toTypedArray$iv = result2;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                PsiDirectory psiDirectory4 = DirectoryChooserUtil.selectDirectory((Project)project3, (PsiDirectory[])thisCollection$iv.toArray(new PsiDirectory[0]), null, (String)postfixToShow);
                if (psiDirectory4 == null) {
                    return null;
                }
                existingDirectoryByPackage = psiDirectory4;
                restOfName = subPackageName;
            }
        }
        if ((psiDirectory2 = existingDirectoryByPackage) == null) {
            void $this$toTypedArray$iv222;
            boolean bl = false;
            List<VirtualFile> sourceRoots = PackageUtilsKt.findOrConfigureKotlinSourceRoots(module2, pureKotlinSourceFoldersHolder);
            if (sourceRoots.isEmpty()) {
                return null;
            }
            List directoryList = new ArrayList();
            for (VirtualFile sourceRoot : sourceRoots) {
                PsiDirectory directory;
                if (PsiManager.getInstance((Project)project3).findDirectory(sourceRoot) == null) continue;
                Intrinsics.checkNotNullExpressionValue((Object)directory, (String)"PsiManager.getInstance(p\u2026y(sourceRoot) ?: continue");
                result2 = directoryList;
                result2.add(directory);
            }
            Iterable $this$sortedBy$iv = directoryList;
            boolean $i$f$sortedBy = false;
            $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    PsiDirectory it = (PsiDirectory)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.getName());
                    it = (PsiDirectory)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    String string = it.getName();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
                }
            });
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv222;
            PsiDirectory[] sourceDirectories = thisCollection$iv.toArray(new PsiDirectory[0]);
            char $this$toTypedArray$iv222 = File.separatorChar;
            String string = StringsKt.replace$default((String)packageName2, (char)'.', (char)File.separatorChar, (boolean)false, (int)4, null);
            PsiDirectory psiDirectory5 = DirectoryChooserUtil.selectDirectory((Project)project3, (PsiDirectory[])sourceDirectories, null, (String)($this$toTypedArray$iv222 + string));
            if (psiDirectory5 == null) {
                return null;
            }
            psiDirectory2 = psiDirectory5;
            Intrinsics.checkNotNullExpressionValue((Object)psiDirectory5, (String)"DirectoryChooserUtil.sel\u2026\n        ) ?: return null");
        }
        PsiDirectory existingDirectory = psiDirectory2;
        var $fun$getLeftPart$1 = findOrCreateDirectoryForPackage.1.INSTANCE;
        var $fun$cutLeftPart$2 = findOrCreateDirectoryForPackage.2.INSTANCE;
        Ref.ObjectRef directoryList = new Ref.ObjectRef();
        directoryList.element = existingDirectory;
        while (($this$toTypedArray$iv222 = (CharSequence)restOfName).length() > 0) {
            String name2 = $fun$getLeftPart$1.invoke((String)restOfName);
            PsiDirectory foundExistingDirectory = ((PsiDirectory)psiDirectory.element).findSubdirectory(name2);
            PsiDirectory psiDirectory6 = foundExistingDirectory;
            if (psiDirectory6 == null) {
                Object object = WriteAction.compute((ThrowableComputable)new ThrowableComputable((Ref.ObjectRef)psiDirectory, name2){
                    final /* synthetic */ Ref.ObjectRef $psiDirectory;
                    final /* synthetic */ String $name;

                    public final PsiDirectory compute() {
                        return ((PsiDirectory)this.$psiDirectory.element).createSubdirectory(this.$name);
                    }
                    {
                        this.$psiDirectory = objectRef;
                        this.$name = string;
                    }
                });
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"WriteAction.compute<PsiD\u2026reateSubdirectory(name) }");
                psiDirectory6 = (PsiDirectory)object;
            }
            psiDirectory.element = psiDirectory6;
            restOfName = $fun$cutLeftPart$2.invoke((String)restOfName);
        }
        return (PsiDirectory)psiDirectory.element;
    }

    static {
        Set set2 = SetsKt.setOf((Object[])new KotlinSourceRootType[]{(KotlinSourceRootType)SourceKotlinRootType.INSTANCE, (KotlinSourceRootType)TestSourceKotlinRootType.INSTANCE});
        Set set3 = JavaModuleSourceRootTypes.SOURCES;
        Intrinsics.checkNotNullExpressionValue((Object)set3, (String)"JavaModuleSourceRootTypes.SOURCES");
        kotlinSourceRootTypes = SetsKt.plus((Set)set2, (Iterable)set3);
    }

    public static final /* synthetic */ Set access$getKotlinSourceRootTypes$p() {
        return kotlinSourceRootTypes;
    }

    public static final /* synthetic */ Path access$pathOrNull(VirtualFile $this$access_u24pathOrNull) {
        return PackageUtilsKt.pathOrNull($this$access_u24pathOrNull);
    }

    public static final /* synthetic */ Path access$convertUrlToPath(String url) {
        return PackageUtilsKt.convertUrlToPath(url);
    }
}

