/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration.ui;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinJvmBundle;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinJpsPluginSettings;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtilsKt;
import org.jetbrains.kotlin.idea.configuration.ui.KotlinConfigurationCheckerService;
import org.jetbrains.kotlin.idea.facet.KotlinFacet;
import org.jetbrains.kotlin.idea.facet.KotlinFacetConfiguration;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.idea.util.projectStructure.ProjectStructureUtilKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000e\u001a\u00020\rJ\u0006\u0010\u000f\u001a\u00020\rR\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/ui/KotlinConfigurationCheckerService;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "isSyncing", "", "()Z", "getProject", "()Lcom/intellij/openapi/project/Project;", "syncDepth", "Ljava/util/concurrent/atomic/AtomicInteger;", "performProjectPostOpenActions", "", "syncDone", "syncStarted", "Companion", "kotlin.jvm"})
public final class KotlinConfigurationCheckerService {
    private final AtomicInteger syncDepth;
    @NotNull
    private final Project project;
    @NotNull
    public static final String CONFIGURE_NOTIFICATION_GROUP_ID = "Configure Kotlin in Project";
    @NotNull
    public static final Companion Companion = new Companion(null);

    public final void performProjectPostOpenActions() {
        Task.Backgroundable task2 = new Task.Backgroundable(this, this.project, KotlinJvmBundle.message("configure.kotlin.language.settings", new Object[0]), false){
            final /* synthetic */ KotlinConfigurationCheckerService this$0;

            /*
             * WARNING - void declaration
             */
            public void run(@NotNull ProgressIndicator indicator) {
                Collection<Module> ktModules;
                Collection<Module> collection;
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                boolean $i$f$runReadAction = false;
                boolean kotlinLanguageVersionConfigured = (Boolean)ApplicationManager.getApplication().runReadAction(new Computable(this){
                    final /* synthetic */ performProjectPostOpenActions.task.1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public final T compute() {
                        boolean bl = false;
                        Project project2 = this.this$0.getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
                        return (T)Boolean.valueOf(PlatformKt.isKotlinLanguageVersionConfigured(project2));
                    }
                });
                if (kotlinLanguageVersionConfigured) {
                    void $this$filterTo$iv$iv;
                    void $this$filter$iv;
                    Project project2 = this.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
                    KotlinJpsPluginSettings.Companion.validateSettings(project2);
                    boolean $i$f$runReadAction22 = false;
                    Iterable $i$f$runReadAction22 = (Iterable)ApplicationManager.getApplication().runReadAction(new Computable(this){
                        final /* synthetic */ performProjectPostOpenActions.task.1 this$0;
                        {
                            this.this$0 = var1_1;
                        }

                        public final T compute() {
                            boolean bl = false;
                            Project project2 = this.this$0.getProject();
                            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
                            return (T)ProjectStructureUtilKt.allModules(project2);
                        }
                    });
                    boolean $i$f$filter = false;
                    void var7_9 = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        Object facetSettings;
                        Module it = (Module)element$iv$iv;
                        boolean bl = false;
                        Module module2 = it;
                        Intrinsics.checkNotNullExpressionValue((Object)module2, (String)"it");
                        Object object = KotlinFacet.Companion.get(module2);
                        if (!(object == null || (object = (KotlinFacetConfiguration)object.getConfiguration()) == null || (object = object.getSettings()) == null ? false : !(facetSettings = object).getUseProjectSettings() && (facetSettings.getLanguageLevel() == null || facetSettings.getApiLevel() == null))) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    List modulesWithKotlinFacets = (List)destination$iv$iv;
                    if (modulesWithKotlinFacets.isEmpty()) {
                        return;
                    }
                    Project project3 = this.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"project");
                    collection = ConfigureKotlinInProjectUtilsKt.getModulesWithKotlinFiles(project3, modulesWithKotlinFacets);
                } else {
                    Project project4 = this.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project4, (String)"project");
                    collection = ktModules = ConfigureKotlinInProjectUtilsKt.getModulesWithKotlinFiles$default(project4, null, 2, null);
                }
                if (ktModules.isEmpty()) {
                    return;
                }
                if (!kotlinLanguageVersionConfigured) {
                    Project project5 = this.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project5, (String)"project");
                    KotlinJpsPluginSettings.Companion.validateSettings(project5);
                }
                indicator.setIndeterminate(false);
                boolean modulesWithKotlinFacets = false;
                for (Module module3 : (Iterable)ktModules) {
                    void idx;
                    indicator.checkCanceled();
                    Project project6 = this.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project6, (String)"project");
                    if (project6.isDisposed()) {
                        return;
                    }
                    indicator.setFraction(1.0 * (double)idx / (double)ktModules.size());
                    boolean $i$f$runReadAction2 = false;
                    ApplicationManager.getApplication().runReadAction(new Computable(module3, indicator){
                        final /* synthetic */ Module $module$inlined;
                        final /* synthetic */ ProgressIndicator $indicator$inlined;
                        {
                            this.$module$inlined = module2;
                            this.$indicator$inlined = progressIndicator;
                        }

                        public final T compute() {
                            boolean bl = false;
                            if (!this.$module$inlined.isDisposed()) {
                                Object[] objectArray = new Object[1];
                                String string = this.$module$inlined.getName();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"module.name");
                                objectArray[0] = string;
                                this.$indicator$inlined.setText2(KotlinJvmBundle.message("configure.kotlin.language.settings.0.module", objectArray));
                                PlatformKt.getAndCacheLanguageLevelByDependencies(this.$module$inlined);
                            }
                            return (T)Unit.INSTANCE;
                        }
                    });
                    ++idx;
                }
            }
            {
                this.this$0 = this$0;
                super($super_call_param$1, $super_call_param$2, $super_call_param$3);
            }
        };
        ProgressManager.getInstance().run((Task)task2);
    }

    public final boolean isSyncing() {
        return this.syncDepth.get() > 0;
    }

    public final void syncStarted() {
        this.syncDepth.incrementAndGet();
    }

    public final void syncDone() {
        this.syncDepth.decrementAndGet();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public KotlinConfigurationCheckerService(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.syncDepth = new AtomicInteger();
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/ui/KotlinConfigurationCheckerService$Companion;", "", "()V", "CONFIGURE_NOTIFICATION_GROUP_ID", "", "getInstance", "Lorg/jetbrains/kotlin/idea/configuration/ui/KotlinConfigurationCheckerService;", "project", "Lcom/intellij/openapi/project/Project;", "kotlin.jvm"})
    public static final class Companion {
        @NotNull
        public final KotlinConfigurationCheckerService getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Project $this$service$iv = project2;
            boolean $i$f$service = false;
            Object object = $this$service$iv.getService(KotlinConfigurationCheckerService.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
            return (KotlinConfigurationCheckerService)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

