/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.DummyLibraryProperties;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryType;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinJvmBundle;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtilsKt;
import org.jetbrains.kotlin.idea.configuration.KotlinJsModuleConfigurator;
import org.jetbrains.kotlin.idea.configuration.KotlinWithLibraryConfigurator;
import org.jetbrains.kotlin.idea.configuration.NotificationMessageCollector;
import org.jetbrains.kotlin.idea.framework.JSLibraryKind;
import org.jetbrains.kotlin.idea.framework.JSLibraryStdDescription;
import org.jetbrains.kotlin.idea.framework.JSLibraryType;
import org.jetbrains.kotlin.idea.framework.JsLibraryStdDetectionUtil;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.idea.versions.LibraryJarDescriptor;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.js.JsPlatforms;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 ,2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001,B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010&\u001a\u0004\u0018\u00010\u000e2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0014J\u0010\u0010+\u001a\u00020\u00102\u0006\u0010'\u001a\u00020(H\u0016R\u0014\u0010\u0004\u001a\u00020\u00058TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR&\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\rX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00058TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0007R\u0014\u0010\u0015\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u00058TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0007R\u0014\u0010\u001e\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0007R\u0014\u0010 \u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0007R\u0014\u0010\"\u001a\u00020#8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%\u00a8\u0006-"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/KotlinJsModuleConfigurator;", "Lorg/jetbrains/kotlin/idea/configuration/KotlinWithLibraryConfigurator;", "Lcom/intellij/openapi/roots/libraries/DummyLibraryProperties;", "()V", "dialogTitle", "", "getDialogTitle", "()Ljava/lang/String;", "libraryJarDescriptor", "Lorg/jetbrains/kotlin/idea/versions/LibraryJarDescriptor;", "getLibraryJarDescriptor", "()Lorg/jetbrains/kotlin/idea/versions/LibraryJarDescriptor;", "libraryMatcher", "Lkotlin/Function2;", "Lcom/intellij/openapi/roots/libraries/Library;", "Lcom/intellij/openapi/project/Project;", "", "getLibraryMatcher", "()Lkotlin/jvm/functions/Function2;", "libraryName", "getLibraryName", "libraryProperties", "getLibraryProperties", "()Lcom/intellij/openapi/roots/libraries/DummyLibraryProperties;", "libraryType", "Lcom/intellij/openapi/roots/libraries/LibraryType;", "getLibraryType", "()Lcom/intellij/openapi/roots/libraries/LibraryType;", "messageForOverrideDialog", "getMessageForOverrideDialog", "name", "getName", "presentableText", "getPresentableText", "targetPlatform", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "getTargetPlatform", "()Lorg/jetbrains/kotlin/platform/TargetPlatform;", "findAndFixBrokenKotlinLibrary", "module", "Lcom/intellij/openapi/module/Module;", "collector", "Lorg/jetbrains/kotlin/idea/configuration/NotificationMessageCollector;", "isConfigured", "Companion", "kotlin.jvm"})
public class KotlinJsModuleConfigurator
extends KotlinWithLibraryConfigurator<DummyLibraryProperties> {
    @NotNull
    private final Function2<Library, Project, Boolean> libraryMatcher = libraryMatcher.1.INSTANCE;
    @NotNull
    public static final String NAME = "js";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public String getName() {
        return NAME;
    }

    @Override
    @NotNull
    public TargetPlatform getTargetPlatform() {
        return JsPlatforms.INSTANCE.getDefaultJsPlatform();
    }

    @Override
    @NotNull
    public String getPresentableText() {
        return KotlinJvmBundle.message("language.name.javascript", new Object[0]);
    }

    @Override
    public boolean isConfigured(@NotNull Module module2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        return ConfigureKotlinInProjectUtilsKt.hasKotlinJsRuntimeInScope(module2);
    }

    @Override
    @NotNull
    protected String getLibraryName() {
        return "KotlinJavaScript";
    }

    @Override
    @NotNull
    protected String getDialogTitle() {
        return JSLibraryStdDescription.Companion.getDIALOG_TITLE();
    }

    @Override
    @NotNull
    protected String getMessageForOverrideDialog() {
        return JSLibraryStdDescription.Companion.getJAVA_SCRIPT_LIBRARY_CREATION();
    }

    @Override
    @NotNull
    public LibraryJarDescriptor getLibraryJarDescriptor() {
        return LibraryJarDescriptor.JS_STDLIB_JAR;
    }

    @Override
    @NotNull
    protected Function2<Library, Project, Boolean> getLibraryMatcher() {
        return this.libraryMatcher;
    }

    @Override
    @NotNull
    public LibraryType<DummyLibraryProperties> getLibraryType() {
        return JSLibraryType.Companion.getInstance();
    }

    @Override
    @NotNull
    public DummyLibraryProperties getLibraryProperties() {
        DummyLibraryProperties dummyLibraryProperties = DummyLibraryProperties.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)dummyLibraryProperties, (String)"DummyLibraryProperties.INSTANCE");
        return dummyLibraryProperties;
    }

    @Override
    @Nullable
    protected Library findAndFixBrokenKotlinLibrary(@NotNull Module module2, @NotNull NotificationMessageCollector collector2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter((Object)collector2, (String)"collector");
        List allLibraries = new ArrayList();
        Library brokenStdlib = null;
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module2);
        Intrinsics.checkNotNullExpressionValue((Object)moduleRootManager, (String)"ModuleRootManager.getInstance(module)");
        for (OrderEntry orderEntry : moduleRootManager.getOrderEntries()) {
            LibraryEx library2;
            OrderEntry orderEntry2 = orderEntry;
            if (!(orderEntry2 instanceof LibraryOrderEntry)) {
                orderEntry2 = null;
            }
            LibraryOrderEntry libraryOrderEntry = (LibraryOrderEntry)orderEntry2;
            Object object = libraryOrderEntry != null ? libraryOrderEntry.getLibrary() : null;
            if (!(object instanceof LibraryEx)) {
                object = null;
            }
            if ((LibraryEx)object == null) continue;
            allLibraries.add(library2);
            Library library3 = (Library)library2;
            Project project2 = module2.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"module.project");
            if (!JsLibraryStdDetectionUtil.INSTANCE.hasJsStdlibJar(library3, project2, true) || library2.getKind() != null) continue;
            brokenStdlib = (Library)library2;
        }
        if (brokenStdlib != null) {
            ApplicationUtilsKt.runWriteAction((Function0)new Function0<Unit>(allLibraries){
                final /* synthetic */ List $allLibraries;

                /*
                 * WARNING - void declaration
                 */
                public final void invoke() {
                    void $this$filterTo$iv$iv;
                    Iterable $this$filter$iv = this.$allLibraries;
                    boolean $i$f$filter = false;
                    Iterable iterable = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        LibraryEx it = (LibraryEx)element$iv$iv;
                        boolean bl = false;
                        if (!(it.getKind() == null)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    for (LibraryEx library2 : (List)destination$iv$iv) {
                        LibraryEx.ModifiableModelEx modifiableModelEx;
                        LibraryEx.ModifiableModelEx $this$apply = modifiableModelEx = library2.getModifiableModel();
                        boolean bl = false;
                        $this$apply.setKind((PersistentLibraryKind)JSLibraryKind.INSTANCE);
                        $this$apply.commit();
                    }
                }
                {
                    this.$allLibraries = list2;
                    super(0);
                }
            });
            Object[] objectArray = new Object[1];
            String string = module2.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"module.name");
            objectArray[0] = string;
            collector2.addMessage(KotlinJvmBundle.message("updated.javascript.libraries.in.module.0", objectArray));
        }
        return brokenStdlib;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/KotlinJsModuleConfigurator$Companion;", "", "()V", "NAME", "", "kotlin.jvm"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

