/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.compiler.configuration;

import com.intellij.jarRepository.JarRepositoryManager;
import com.intellij.jarRepository.RemoteRepositoriesConfiguration;
import com.intellij.jarRepository.RemoteRepositoryDescription;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.ui.OrderRoot;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.io.PathKt;
import com.intellij.workspaceModel.ide.VirtualFileUrlManagerUtil;
import com.intellij.workspaceModel.ide.impl.UtilsKt;
import com.intellij.workspaceModel.storage.url.VirtualFileUrlManager;
import java.awt.EventQueue;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.aether.ArtifactKind;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryProperties;
import org.jetbrains.jps.model.library.JpsMavenRepositoryLibraryDescriptor;
import org.jetbrains.kotlin.idea.artifacts.KotlinArtifacts;
import org.jetbrains.kotlin.idea.artifacts.LazyZipUnpacker;
import org.jetbrains.kotlin.idea.base.plugin.KotlinBasePluginBundle;
import org.jetbrains.kotlin.idea.compiler.configuration.FailedToDownloadJpsMavenArtifactSuggestedSolutionsContributor;
import org.jetbrains.kotlin.idea.compiler.configuration.IdeKotlinVersion;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinArtifactsDownloader;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinArtifactsDownloaderKt;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinJpsPluginSettings;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinMavenUtils;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinPluginLayout;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinPluginLayoutKt;
import org.jetbrains.kotlin.idea.compiler.configuration.LazyKotlinJpsPluginClasspathDownloader;
import org.jetbrains.kotlin.idea.compiler.configuration.LazyKotlinMavenArtifactDownloader;
import org.jetbrains.kotlin.idea.compiler.configuration.LazyKotlincDistDownloaderAndUnpacker;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\u0006H\u0007JF\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u00102\u000e\b\u0002\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\nJ \u0010\u0013\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0007J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0007\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0007\u001a\u00020\u0006H\u0002J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00120\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u000e\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006J\u0010\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\u0017H\u0002J\u000e\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\u0006J \u0010\u001e\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eJ2\u0010\u001f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010 \u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020#0\"J,\u0010$\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010%\u001a\u00020\u0006H\u0002\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/idea/compiler/configuration/KotlinArtifactsDownloader;", "", "()V", "downloadArtifactForIdeFromSources", "Ljava/io/File;", "artifactId", "", "version", "suffix", "downloadMavenArtifacts", "", "project", "Lcom/intellij/openapi/project/Project;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "artifactIsPom", "", "additionalMavenRepos", "Lcom/intellij/jarRepository/RemoteRepositoryDescription;", "failedToDownloadUnbundledJpsMavenArtifact", "findAllInOneOldFormatPackedDist", "getAllIneOneOldFormatLazyDistUnpacker", "Lorg/jetbrains/kotlin/idea/artifacts/LazyZipUnpacker;", "Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion;", "getLazyDistDownloaderAndUnpacker", "Lorg/jetbrains/kotlin/idea/compiler/configuration/LazyKotlincDistDownloaderAndUnpacker;", "getMavenRepos", "getUnpackedKotlinDistPath", "isAllInOneOldFormatDistFormatAvailable", "isKotlinDistInitialized", "lazyDownloadAndUnpackKotlincDist", "lazyDownloadMissingJpsPluginDependencies", "jpsVersion", "onError", "Lkotlin/Function1;", "", "lazyDownloadOldKotlinDistMavenArtifact", "indicatorDownloadText", "kotlin.base.plugin"})
public final class KotlinArtifactsDownloader {
    @NotNull
    public static final KotlinArtifactsDownloader INSTANCE;

    @NotNull
    public final File getUnpackedKotlinDistPath(@NotNull String version2) {
        Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
        return Intrinsics.areEqual((Object)IdeKotlinVersion.Companion.get(version2), (Object)KotlinPluginLayout.Companion.getInstance().getStandaloneCompilerVersion()) ? KotlinPluginLayout.Companion.getInstance().getKotlinc() : FilesKt.resolve((File)KotlinArtifacts.Companion.getKOTLIN_DIST_LOCATION_PREFIX(), (String)version2);
    }

    @NotNull
    public final File getUnpackedKotlinDistPath(@NotNull Project project2) {
        Object object;
        block3: {
            block2: {
                String string;
                Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                object = KotlinJpsPluginSettings.Companion.jpsVersion(project2);
                if (object == null) break block2;
                String it = string = object;
                boolean bl = false;
                object = INSTANCE.getUnpackedKotlinDistPath(it);
                if (object != null) break block3;
            }
            object = KotlinPluginLayout.Companion.getInstance().getKotlinc();
        }
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isKotlinDistInitialized(@NotNull String version2) {
        File file2;
        LazyZipUnpacker lazyZipUnpacker;
        Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
        IdeKotlinVersion parsedVersion = IdeKotlinVersion.Companion.get(version2);
        if (Intrinsics.areEqual((Object)parsedVersion, (Object)KotlinPluginLayout.Companion.getInstance().getStandaloneCompilerVersion())) {
            return true;
        }
        if (this.getLazyDistDownloaderAndUnpacker(version2).isUpToDate()) return true;
        LazyZipUnpacker lazyZipUnpacker2 = this.getAllIneOneOldFormatLazyDistUnpacker(parsedVersion);
        LazyZipUnpacker lazyZipUnpacker3 = lazyZipUnpacker2;
        if (lazyZipUnpacker2 == null) return false;
        LazyZipUnpacker unpacker = lazyZipUnpacker = lazyZipUnpacker3;
        boolean bl = false;
        File file3 = INSTANCE.findAllInOneOldFormatPackedDist(parsedVersion.getRawVersion());
        if (file3 == null) return false;
        File jar = file2 = file3;
        boolean bl2 = false;
        Boolean bl3 = unpacker.isUpToDate(jar);
        lazyZipUnpacker3 = bl3;
        if (bl3 == null) return false;
        boolean bl4 = (Boolean)((Object)lazyZipUnpacker3);
        if (!bl4) return false;
        return true;
    }

    public final synchronized boolean lazyDownloadMissingJpsPluginDependencies(@NotNull Project project2, @NotNull String jpsVersion2, @NotNull ProgressIndicator indicator, @NotNull Function1<? super String, Unit> onError) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)jpsVersion2, (String)"jpsVersion");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Intrinsics.checkNotNullParameter(onError, (String)"onError");
        LazyKotlinJpsPluginClasspathDownloader.Context context2 = new LazyKotlinJpsPluginClasspathDownloader.Context(project2, indicator);
        List<File> jpsPluginClasspath2 = new LazyKotlinJpsPluginClasspathDownloader(jpsVersion2).lazyDownload(context2);
        if (jpsPluginClasspath2.isEmpty()) {
            onError.invoke((Object)this.failedToDownloadUnbundledJpsMavenArtifact(project2, "kotlin-jps-plugin", jpsVersion2));
            return false;
        }
        File unpackedDist = this.lazyDownloadAndUnpackKotlincDist(project2, jpsVersion2, indicator);
        if (unpackedDist == null) {
            onError.invoke((Object)this.failedToDownloadUnbundledJpsMavenArtifact(project2, "kotlin-dist-for-jps-meta", jpsVersion2));
            return false;
        }
        return true;
    }

    @Nullable
    public final synchronized File lazyDownloadAndUnpackKotlincDist(@NotNull Project project2, @NotNull String version2, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        IdeKotlinVersion parsedVersion = IdeKotlinVersion.Companion.get(version2);
        if (Intrinsics.areEqual((Object)parsedVersion, (Object)KotlinPluginLayout.Companion.getInstance().getStandaloneCompilerVersion())) {
            return KotlinPluginLayout.Companion.getInstance().getKotlinc();
        }
        LazyZipUnpacker lazyZipUnpacker = this.getAllIneOneOldFormatLazyDistUnpacker(parsedVersion);
        if (lazyZipUnpacker != null) {
            LazyZipUnpacker lazyZipUnpacker2;
            LazyZipUnpacker unpacker = lazyZipUnpacker2 = lazyZipUnpacker;
            boolean bl = false;
            File file2 = INSTANCE.findAllInOneOldFormatPackedDist(version2);
            if (file2 != null) {
                File file3;
                File packedDist = file3 = file2;
                boolean bl2 = false;
                File file4 = unpacker.getUnpackedIfUpToDateOrNull(packedDist);
                if (file4 != null) {
                    File file5;
                    File it = file5 = file4;
                    boolean bl3 = false;
                    return it;
                }
            }
        }
        String indicatorDownloadText = KotlinBasePluginBundle.message("progress.text.downloading.kotlinc.dist", new Object[0]);
        File file6 = this.getLazyDistDownloaderAndUnpacker(version2).lazyProduceDist(new LazyKotlinMavenArtifactDownloader.DownloadContext(project2, indicator, indicatorDownloadText));
        if (file6 == null) {
            LazyZipUnpacker lazyZipUnpacker3 = this.getAllIneOneOldFormatLazyDistUnpacker(parsedVersion);
            if (lazyZipUnpacker3 != null) {
                LazyZipUnpacker lazyZipUnpacker4;
                LazyZipUnpacker unpacker = lazyZipUnpacker4 = lazyZipUnpacker3;
                boolean bl = false;
                File file7 = INSTANCE.lazyDownloadOldKotlinDistMavenArtifact(project2, version2, indicator, indicatorDownloadText);
                if (file7 != null) {
                    File file8;
                    File it = file8 = file7;
                    boolean bl4 = false;
                    file6 = unpacker.lazyUnpack(it);
                } else {
                    file6 = null;
                }
            } else {
                file6 = null;
            }
        }
        return file6;
    }

    private final synchronized File lazyDownloadOldKotlinDistMavenArtifact(Project project2, String version2, ProgressIndicator indicator, @Nls String indicatorDownloadText) {
        var $fun$getExpectedMavenArtifactPath$1 = new Function0<File>(version2){
            final /* synthetic */ String $version;

            @Nullable
            public final File invoke() {
                Path path2 = KotlinMavenUtils.findArtifact$default(KotlinMavenUtils.INSTANCE, "org.jetbrains.kotlin", "kotlin-dist-for-ide", this.$version, null, 8, null);
                return path2 != null ? path2.toFile() : null;
            }
            {
                this.$version = string;
                super(0);
            }
        };
        Object object = $fun$getExpectedMavenArtifactPath$1.invoke();
        if (object != null) {
            Object object2;
            Object it = object2 = object;
            boolean bl = false;
            object = ((File)it).exists() ? object2 : null;
            if (object != null) {
                it = object2 = object;
                boolean bl2 = false;
                return it;
            }
        }
        indicator.setText(indicatorDownloadText);
        List artifacts = KotlinArtifactsDownloader.downloadMavenArtifacts$default(this, "kotlin-dist-for-ide", version2, project2, indicator, false, null, 48, null);
        if (artifacts.isEmpty()) {
            return null;
        }
        Object object3 = CollectionsKt.singleOrNull((List)artifacts);
        Object it = (File)object3;
        boolean bl = false;
        File file2 = it;
        if (file2 == null) {
            String string = "Expected to download only single artifact";
            throw new IllegalStateException(string.toString());
        }
        it = object3 = file2;
        boolean bl3 = false;
        Object expectedMavenArtifactPath = $fun$getExpectedMavenArtifactPath$1.invoke();
        boolean bl4 = Intrinsics.areEqual((Object)it, (Object)expectedMavenArtifactPath);
        if (!bl4) {
            boolean bl5 = false;
            String string = "Expected maven artifact path (" + (File)expectedMavenArtifactPath + ") doesn't match actual artifact path (" + (File)it + ")";
            throw new IllegalStateException(string.toString());
        }
        return object3;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<File> downloadMavenArtifacts(@NotNull String artifactId2, @NotNull String version2, @NotNull Project project2, @NotNull ProgressIndicator indicator, boolean artifactIsPom, @NotNull List<RemoteRepositoryDescription> additionalMavenRepos) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)artifactId2, (String)"artifactId");
        Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Intrinsics.checkNotNullParameter(additionalMavenRepos, (String)"additionalMavenRepos");
        boolean $i$f$isUnitTestMode = false;
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        boolean bl = $i$f$isUnitTestMode = application.isUnitTestMode() || !EventQueue.isDispatchThread();
        if (!$i$f$isUnitTestMode) {
            boolean $i$a$-check-KotlinArtifactsDownloader$downloadMavenArtifacts$22 = false;
            String $i$a$-check-KotlinArtifactsDownloader$downloadMavenArtifacts$22 = "Don't call downloadMavenArtifact on UI thread";
            throw new IllegalStateException($i$a$-check-KotlinArtifactsDownloader$downloadMavenArtifacts$22.toString());
        }
        List excludedDeps = Intrinsics.areEqual((Object)artifactId2, (Object)"kotlin-dist-for-jps-meta") && IdeKotlinVersion.Companion.get(version2).compareTo(IdeKotlinVersion.Companion.get("1.7.20")) < 0 ? CollectionsKt.listOf((Object[])new String[]{"org.jetbrains.kotlin:util", "org.jetbrains.kotlin:cli", "org.jetbrains.kotlin:backend", "org.jetbrains.kotlin:frontend", "org.jetbrains.kotlin:frontend.java", "org.jetbrains.kotlin:plugin-api", "org.jetbrains.kotlin:backend.jvm.entrypoint"}) : CollectionsKt.emptyList();
        RepositoryLibraryProperties prop = new RepositoryLibraryProperties(new JpsMavenRepositoryLibraryDescriptor("org.jetbrains.kotlin", artifactId2, version2, artifactIsPom ? ArtifactKind.POM.getExtension() : ArtifactKind.ARTIFACT.getExtension(), true, excludedDeps));
        List repos = CollectionsKt.plus((Collection)this.getMavenRepos(project2), (Iterable)additionalMavenRepos);
        Collection collection = JarRepositoryManager.loadDependenciesSync((Project)project2, (RepositoryLibraryProperties)prop, (boolean)false, (boolean)false, null, (Collection)repos, (ProgressIndicator)indicator);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"JarRepositoryManager.loa\u2026, null, repos, indicator)");
        Iterable iterable = collection;
        boolean $i$f$map = false;
        void var12_15 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            OrderRoot orderRoot = (OrderRoot)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl2 = false;
            void v3 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"it");
            VirtualFile virtualFile2 = v3.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"it.file");
            File file2 = new File(UtilsKt.toVirtualFileUrl((VirtualFile)virtualFile2, (VirtualFileUrlManager)VirtualFileUrlManagerUtil.getInstance((VirtualFileUrlManager.Companion)VirtualFileUrlManager.Companion, (Project)project2)).getPresentableUrl()).getCanonicalFile();
            collection2.add(file2);
        }
        return CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
    }

    public static /* synthetic */ List downloadMavenArtifacts$default(KotlinArtifactsDownloader kotlinArtifactsDownloader, String string, String string2, Project project2, ProgressIndicator progressIndicator, boolean bl, List list2, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl = false;
        }
        if ((n & 0x20) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        return kotlinArtifactsDownloader.downloadMavenArtifacts(string, string2, project2, progressIndicator, bl, list2);
    }

    @JvmOverloads
    @NotNull
    public final File downloadArtifactForIdeFromSources(@NotNull String artifactId2, @NotNull String version2, @NotNull String suffix2) {
        Path artifact;
        Path path22;
        Intrinsics.checkNotNullParameter((Object)artifactId2, (String)"artifactId");
        Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
        Intrinsics.checkNotNullParameter((Object)suffix2, (String)"suffix");
        boolean bl = KotlinPluginLayoutKt.isRunningFromSources();
        if (!bl) {
            boolean $i$a$-check-KotlinArtifactsDownloader$downloadArtifactForIdeFromSources$22 = false;
            String $i$a$-check-KotlinArtifactsDownloader$downloadArtifactForIdeFromSources$22 = "downloadArtifactForIdeFromSources" + " must be called only for IDE running from sources or tests. Use " + "downloadMavenArtifacts" + " when run in production";
            throw new IllegalStateException($i$a$-check-KotlinArtifactsDownloader$downloadArtifactForIdeFromSources$22.toString());
        }
        Path path3 = KotlinMavenUtils.INSTANCE.findArtifact("org.jetbrains.kotlin", artifactId2, version2, suffix2);
        if (path3 != null) {
            Path path4;
            Path it = path4 = path3;
            boolean path22 = false;
            File file2 = it.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"it.toFile()");
            return file2;
        }
        String fileName = artifactId2 + "-" + version2 + suffix2;
        Path it = path22 = Paths.get(PathManager.getCommunityHomePath(), new String[0]).resolve("out").resolve("kotlin-from-sources-deps").resolve(fileName);
        boolean bl2 = false;
        Path path5 = it;
        Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"it");
        Files.createDirectories(path5.getParent(), new FileAttribute[0]);
        Path path6 = artifact = path22;
        Intrinsics.checkNotNullExpressionValue((Object)path6, (String)"artifact");
        if (!PathKt.exists((Path)path6)) {
            String idePluginDeps = "https://cache-redirector.jetbrains.com/maven.pkg.jetbrains.space/kotlin/p/kotlin/kotlin-ide-plugin-dependencies/org/jetbrains/kotlin/" + artifactId2 + "/" + version2 + "/" + fileName;
            String mavenCentral = "https://repo1.maven.org/maven2/org/jetbrains/kotlin/" + artifactId2 + "/" + version2 + "/" + fileName;
            InputStream inputStream = KotlinArtifactsDownloaderKt.access$openStreamOrNull(new URL(idePluginDeps));
            if (inputStream == null) {
                inputStream = new URL(mavenCentral).openStream();
            }
            InputStream stream = inputStream;
            Files.copy(stream, artifact, new CopyOption[0]);
            boolean bl3 = PathKt.exists((Path)artifact);
            if (!bl3) {
                boolean bl4 = false;
                String string = artifact + " should be downloaded";
                throw new IllegalStateException(string.toString());
            }
        }
        File file3 = artifact.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"artifact.toFile()");
        return file3;
    }

    public static /* synthetic */ File downloadArtifactForIdeFromSources$default(KotlinArtifactsDownloader kotlinArtifactsDownloader, String string, String string2, String string3, int n, Object object) {
        if ((n & 4) != 0) {
            string3 = ".jar";
        }
        return kotlinArtifactsDownloader.downloadArtifactForIdeFromSources(string, string2, string3);
    }

    @JvmOverloads
    @NotNull
    public final File downloadArtifactForIdeFromSources(@NotNull String artifactId2, @NotNull String version2) {
        return KotlinArtifactsDownloader.downloadArtifactForIdeFromSources$default(this, artifactId2, version2, null, 4, null);
    }

    private final LazyZipUnpacker getAllIneOneOldFormatLazyDistUnpacker(IdeKotlinVersion version2) {
        return this.isAllInOneOldFormatDistFormatAvailable(version2) ? new LazyZipUnpacker(this.getUnpackedKotlinDistPath(version2.getRawVersion())) : null;
    }

    private final LazyKotlincDistDownloaderAndUnpacker getLazyDistDownloaderAndUnpacker(String version2) {
        return new LazyKotlincDistDownloaderAndUnpacker(version2);
    }

    private final boolean isAllInOneOldFormatDistFormatAvailable(IdeKotlinVersion version2) {
        return version2.compareTo(IdeKotlinVersion.Companion.get("1.7.20")) < 0;
    }

    private final File findAllInOneOldFormatPackedDist(String version2) {
        Path path2 = KotlinMavenUtils.findArtifact$default(KotlinMavenUtils.INSTANCE, "org.jetbrains.kotlin", "kotlin-dist-for-ide", version2, null, 8, null);
        return path2 != null ? path2.toFile() : null;
    }

    private final List<RemoteRepositoryDescription> getMavenRepos(Project project2) {
        RemoteRepositoriesConfiguration remoteRepositoriesConfiguration = RemoteRepositoriesConfiguration.getInstance((Project)project2);
        Intrinsics.checkNotNullExpressionValue((Object)remoteRepositoriesConfiguration, (String)"RemoteRepositoriesConfig\u2026tion.getInstance(project)");
        List list2 = remoteRepositoriesConfiguration.getRepositories();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"RemoteRepositoriesConfig\u2026nce(project).repositories");
        return list2;
    }

    /*
     * WARNING - void declaration
     */
    @Nls
    @NotNull
    public final String failedToDownloadUnbundledJpsMavenArtifact(@NotNull Project project2, @NotNull String artifactId2, @NotNull String version2) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)artifactId2, (String)"artifactId");
        Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
        boolean bl2 = bl = Intrinsics.areEqual((Object)artifactId2, (Object)"kotlin-jps-plugin") || Intrinsics.areEqual((Object)artifactId2, (Object)"kotlin-dist-for-jps-meta");
        if (!bl) {
            boolean $i$a$-require-KotlinArtifactsDownloader$failedToDownloadUnbundledJpsMavenArtifact$22 = false;
            String $i$a$-require-KotlinArtifactsDownloader$failedToDownloadUnbundledJpsMavenArtifact$22 = artifactId2 + " should be either kotlin-jps-plugin or kotlin-dist-for-jps-meta";
            throw new IllegalArgumentException($i$a$-require-KotlinArtifactsDownloader$failedToDownloadUnbundledJpsMavenArtifact$22.toString());
        }
        Iterable $i$a$-require-KotlinArtifactsDownloader$failedToDownloadUnbundledJpsMavenArtifact$22 = FailedToDownloadJpsMavenArtifactSuggestedSolutionsContributor.Companion.getAllContributors(project2);
        Collection collection = CollectionsKt.listOf((Object)KotlinBasePluginBundle.message("you.can.use.kotlin.compiler.which.is.bundled.into.your.ide", new Object[0]));
        boolean $i$f$mapNotNull = false;
        void var7_11 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String string;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl3 = false;
            FailedToDownloadJpsMavenArtifactSuggestedSolutionsContributor it = (FailedToDownloadJpsMavenArtifactSuggestedSolutionsContributor)element$iv$iv;
            boolean bl4 = false;
            if (it.getSuggestion() == null) continue;
            String it$iv$iv = string;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        List suggestions2 = CollectionsKt.plus((Collection)collection, (Iterable)list2);
        String suggestion2 = suggestions2.size() == 1 ? (String)CollectionsKt.single((List)suggestions2) : KotlinBasePluginBundle.message("suggested.solutions", CollectionsKt.joinToString$default((Iterable)suggestions2, (CharSequence)"\n", null, null, (int)0, null, (Function1)failedToDownloadUnbundledJpsMavenArtifact.suggestion.1.INSTANCE, (int)30, null));
        return KotlinBasePluginBundle.message("failed.to.download.unbundled.jps.maven.artifact", "org.jetbrains.kotlin:" + artifactId2 + ":" + version2, StringsKt.prependIndent$default((String)CollectionsKt.joinToString$default((Iterable)this.getMavenRepos(project2), (CharSequence)"\n", null, null, (int)0, null, (Function1)failedToDownloadUnbundledJpsMavenArtifact.2.INSTANCE, (int)30, null), null, (int)1, null)) + "\n\n" + suggestion2;
    }

    private KotlinArtifactsDownloader() {
    }

    static {
        KotlinArtifactsDownloader kotlinArtifactsDownloader;
        INSTANCE = kotlinArtifactsDownloader = new KotlinArtifactsDownloader();
    }
}

