/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.caches.project;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.jetbrains.kotlin.idea.UserDataModuleInfoKt;
import org.jetbrains.kotlin.idea.caches.project.IdeaModuleInfo;
import org.jetbrains.kotlin.idea.caches.project.IdeaModuleInfosKt;
import org.jetbrains.kotlin.idea.caches.project.ModuleSourceInfo;
import org.jetbrains.kotlin.idea.caches.project.SdkInfo;
import org.jetbrains.kotlin.idea.caches.project.SourceType;
import org.jetbrains.kotlin.idea.caches.project.UserDataModuleContainer;
import org.jetbrains.kotlin.idea.caches.project.UserDataModuleInfoUtilKt$WhenMappings;
import org.jetbrains.kotlin.idea.core.FileIndexUtilsKt;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000$\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001c\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u001e\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"collectModuleInfoByUserData", "", "Lorg/jetbrains/kotlin/idea/caches/project/IdeaModuleInfo;", "project", "Lcom/intellij/openapi/project/Project;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "container", "Lorg/jetbrains/kotlin/idea/caches/project/UserDataModuleContainer;", "psiElement", "Lcom/intellij/psi/PsiElement;", "kotlin.core"})
public final class UserDataModuleInfoUtilKt {
    private static final List<IdeaModuleInfo> collectModuleInfoByUserData(Project project2, UserDataModuleContainer container) {
        Sdk sdk2;
        var $fun$forModule$1 = new Function0<ModuleSourceInfo>(container){
            final /* synthetic */ UserDataModuleContainer $container;

            @Nullable
            public final ModuleSourceInfo invoke() {
                ModuleSourceInfo moduleSourceInfo;
                JpsModuleSourceRootType<?> jpsModuleSourceRootType = this.$container.getUserData(UserDataModuleInfoKt.MODULE_ROOT_TYPE_KEY);
                if (jpsModuleSourceRootType == null) {
                    return null;
                }
                JpsModuleSourceRootType<?> rootType = jpsModuleSourceRootType;
                Module module2 = this.$container.getModule();
                if (module2 == null) {
                    return null;
                }
                Module module3 = module2;
                SourceType sourceType = FileIndexUtilsKt.getSourceType(rootType);
                if (sourceType == null) {
                    moduleSourceInfo = null;
                } else {
                    switch (UserDataModuleInfoUtilKt$WhenMappings.$EnumSwitchMapping$0[sourceType.ordinal()]) {
                        case 1: {
                            moduleSourceInfo = IdeaModuleInfosKt.productionSourceInfo(module3);
                            break;
                        }
                        case 2: {
                            moduleSourceInfo = IdeaModuleInfosKt.testSourceInfo(module3);
                            break;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                }
                return moduleSourceInfo;
            }
            {
                this.$container = userDataModuleContainer;
                super(0);
            }
        };
        List result2 = new ArrayList();
        CollectionsKt.addIfNotNull((Collection)result2, (Object)$fun$forModule$1.invoke());
        Library library2 = container.getUserData(UserDataModuleInfoKt.LIBRARY_KEY);
        if (library2 != null) {
            result2.addAll((Collection)IdeaModuleInfosKt.createLibraryInfo(project2, library2));
        }
        if ((sdk2 = container.getUserData(UserDataModuleInfoKt.SDK_KEY)) != null) {
            result2.add(new SdkInfo(project2, sdk2));
        }
        return result2;
    }

    @NotNull
    public static final List<IdeaModuleInfo> collectModuleInfoByUserData(@NotNull Project project2, @NotNull VirtualFile virtualFile2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
        return UserDataModuleInfoUtilKt.collectModuleInfoByUserData(project2, new UserDataModuleContainer.ForVirtualFile(virtualFile2, project2));
    }

    @NotNull
    public static final List<IdeaModuleInfo> collectModuleInfoByUserData(@NotNull PsiElement psiElement2) {
        Intrinsics.checkNotNullParameter((Object)psiElement2, (String)"psiElement");
        Project project2 = psiElement2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"psiElement.project");
        return UserDataModuleInfoUtilKt.collectModuleInfoByUserData(project2, new UserDataModuleContainer.ForPsiElement(psiElement2));
    }
}

