/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.caches.project;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinIdeaAnalysisBundle;
import org.jetbrains.kotlin.idea.caches.project.IdeaModuleInfo;
import org.jetbrains.kotlin.idea.caches.project.IdeaModuleInfosKt;
import org.jetbrains.kotlin.idea.caches.project.ModuleOrigin;
import org.jetbrains.kotlin.idea.caches.project.ScriptDependenciesInfo;
import org.jetbrains.kotlin.idea.caches.project.SdkInfo;
import org.jetbrains.kotlin.idea.core.script.dependencies.ScriptAdditionalIdeaDependenciesProvider;
import org.jetbrains.kotlin.idea.project.TargetPlatformDetector;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.resolve.PlatformDependentAnalyzerServices;
import org.jetbrains.kotlin.resolve.jvm.platform.JvmPlatformAnalyzerServices;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinition;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010#\u001a\u00020\u0003H\u00c6\u0003J\t\u0010$\u001a\u00020\u0005H\u00c6\u0003J\t\u0010%\u001a\u00020\u0007H\u00c6\u0003J\r\u0010&\u001a\u00070'\u00a2\u0006\u0002\b(H\u0016J'\u0010)\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u000e\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00010+H\u0016J\u0013\u0010,\u001a\u00020-2\b\u0010.\u001a\u0004\u0018\u00010/H\u00d6\u0003J\t\u00100\u001a\u000201H\u00d6\u0001J\t\u00102\u001a\u00020\u000eH\u00d6\u0001R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"\u00a8\u00063"}, d2={"Lorg/jetbrains/kotlin/idea/caches/project/ScriptModuleInfo;", "Lorg/jetbrains/kotlin/idea/caches/project/IdeaModuleInfo;", "project", "Lcom/intellij/openapi/project/Project;", "scriptFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "scriptDefinition", "Lorg/jetbrains/kotlin/scripting/definitions/ScriptDefinition;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Lorg/jetbrains/kotlin/scripting/definitions/ScriptDefinition;)V", "analyzerServices", "Lorg/jetbrains/kotlin/resolve/PlatformDependentAnalyzerServices;", "getAnalyzerServices", "()Lorg/jetbrains/kotlin/resolve/PlatformDependentAnalyzerServices;", "displayedName", "", "getDisplayedName", "()Ljava/lang/String;", "moduleOrigin", "Lorg/jetbrains/kotlin/idea/caches/project/ModuleOrigin;", "getModuleOrigin", "()Lorg/jetbrains/kotlin/idea/caches/project/ModuleOrigin;", "name", "Lorg/jetbrains/kotlin/name/Name;", "getName", "()Lorg/jetbrains/kotlin/name/Name;", "platform", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "getPlatform", "()Lorg/jetbrains/kotlin/platform/TargetPlatform;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getScriptDefinition", "()Lorg/jetbrains/kotlin/scripting/definitions/ScriptDefinition;", "getScriptFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "component1", "component2", "component3", "contentScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "Lorg/jetbrains/annotations/NotNull;", "copy", "dependencies", "", "equals", "", "other", "", "hashCode", "", "toString", "kotlin.core"})
public final class ScriptModuleInfo
implements IdeaModuleInfo {
    @NotNull
    private final Name name;
    @NotNull
    private final Project project;
    @NotNull
    private final VirtualFile scriptFile;
    @NotNull
    private final ScriptDefinition scriptDefinition;

    @Override
    @NotNull
    public ModuleOrigin getModuleOrigin() {
        return ModuleOrigin.OTHER;
    }

    @NotNull
    public Name getName() {
        return this.name;
    }

    @NotNull
    public String getDisplayedName() {
        Object[] objectArray = new Object[2];
        String string = this.scriptFile.getPresentableName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"scriptFile.presentableName");
        objectArray[0] = string;
        objectArray[1] = this.scriptDefinition.getName();
        return KotlinIdeaAnalysisBundle.message("script.0.1", objectArray);
    }

    @Override
    @NotNull
    public GlobalSearchScope contentScope() {
        GlobalSearchScope globalSearchScope = GlobalSearchScope.fileScope((Project)this.getProject(), (VirtualFile)this.scriptFile);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"GlobalSearchScope.fileScope(project, scriptFile)");
        return globalSearchScope;
    }

    @Override
    @NotNull
    public List<IdeaModuleInfo> dependencies() {
        ArrayList arrayList;
        block2: {
            Sdk sdk2;
            ArrayList $this$apply = arrayList = CollectionsKt.arrayListOf((Object[])new IdeaModuleInfo[]{this});
            boolean bl = false;
            List<Module> scriptDependentModules = ScriptAdditionalIdeaDependenciesProvider.Companion.getRelatedModules(this.scriptFile, this.getProject());
            Iterable $this$forEach$iv = scriptDependentModules;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Module it = (Module)element$iv;
                boolean bl2 = false;
                $this$apply.addAll((Collection)IdeaModuleInfosKt.correspondingModuleInfos(it));
            }
            List<Library> scriptDependentLibraries = ScriptAdditionalIdeaDependenciesProvider.Companion.getRelatedLibraries(this.scriptFile, this.getProject());
            Iterable $this$forEach$iv2 = scriptDependentLibraries;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                Library it = (Library)element$iv;
                boolean bl3 = false;
                $this$apply.addAll((Collection)IdeaModuleInfosKt.createLibraryInfo(this.getProject(), it));
            }
            ScriptDependenciesInfo.ForFile dependenciesInfo = new ScriptDependenciesInfo.ForFile(this.getProject(), this.scriptFile, this.scriptDefinition);
            $this$apply.add(dependenciesInfo);
            Sdk sdk3 = dependenciesInfo.getSdk();
            if (sdk3 == null) break block2;
            Sdk it = sdk2 = sdk3;
            boolean bl4 = false;
            $this$apply.add(new SdkInfo(this.getProject(), it));
        }
        return arrayList;
    }

    @NotNull
    public TargetPlatform getPlatform() {
        TargetPlatform targetPlatform = TargetPlatformDetector.getPlatform4Script(this.getProject(), this.scriptFile, this.scriptDefinition);
        Intrinsics.checkNotNullExpressionValue((Object)targetPlatform, (String)"TargetPlatformDetector.g\u2026ptFile, scriptDefinition)");
        return targetPlatform;
    }

    @NotNull
    public PlatformDependentAnalyzerServices getAnalyzerServices() {
        return (PlatformDependentAnalyzerServices)JvmPlatformAnalyzerServices.INSTANCE;
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.project;
    }

    @NotNull
    public final VirtualFile getScriptFile() {
        return this.scriptFile;
    }

    @NotNull
    public final ScriptDefinition getScriptDefinition() {
        return this.scriptDefinition;
    }

    public ScriptModuleInfo(@NotNull Project project2, @NotNull VirtualFile scriptFile, @NotNull ScriptDefinition scriptDefinition) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)scriptFile, (String)"scriptFile");
        Intrinsics.checkNotNullParameter((Object)((Object)scriptDefinition), (String)"scriptDefinition");
        this.project = project2;
        this.scriptFile = scriptFile;
        this.scriptDefinition = scriptDefinition;
        Name name2 = Name.special((String)("<script " + this.scriptFile.getName() + " " + this.scriptDefinition.getName() + ">"));
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"Name.special(\"<script ${\u2026scriptDefinition.name}>\")");
        this.name = name2;
    }

    @NotNull
    public final Project component1() {
        return this.getProject();
    }

    @NotNull
    public final VirtualFile component2() {
        return this.scriptFile;
    }

    @NotNull
    public final ScriptDefinition component3() {
        return this.scriptDefinition;
    }

    @NotNull
    public final ScriptModuleInfo copy(@NotNull Project project2, @NotNull VirtualFile scriptFile, @NotNull ScriptDefinition scriptDefinition) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)scriptFile, (String)"scriptFile");
        Intrinsics.checkNotNullParameter((Object)((Object)scriptDefinition), (String)"scriptDefinition");
        return new ScriptModuleInfo(project2, scriptFile, scriptDefinition);
    }

    public static /* synthetic */ ScriptModuleInfo copy$default(ScriptModuleInfo scriptModuleInfo, Project project2, VirtualFile virtualFile2, ScriptDefinition scriptDefinition, int n, Object object) {
        if ((n & 1) != 0) {
            project2 = scriptModuleInfo.getProject();
        }
        if ((n & 2) != 0) {
            virtualFile2 = scriptModuleInfo.scriptFile;
        }
        if ((n & 4) != 0) {
            scriptDefinition = scriptModuleInfo.scriptDefinition;
        }
        return scriptModuleInfo.copy(project2, virtualFile2, scriptDefinition);
    }

    @NotNull
    public String toString() {
        return "ScriptModuleInfo(project=" + this.getProject() + ", scriptFile=" + this.scriptFile + ", scriptDefinition=" + this.scriptDefinition + ")";
    }

    public int hashCode() {
        Project project2 = this.getProject();
        VirtualFile virtualFile2 = this.scriptFile;
        ScriptDefinition scriptDefinition = this.scriptDefinition;
        return ((project2 != null ? project2.hashCode() : 0) * 31 + (virtualFile2 != null ? virtualFile2.hashCode() : 0)) * 31 + (scriptDefinition != null ? ((Object)((Object)scriptDefinition)).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof ScriptModuleInfo)) break block3;
                ScriptModuleInfo scriptModuleInfo = (ScriptModuleInfo)object;
                if (!Intrinsics.areEqual((Object)this.getProject(), (Object)scriptModuleInfo.getProject()) || !Intrinsics.areEqual((Object)this.scriptFile, (Object)scriptModuleInfo.scriptFile) || !Intrinsics.areEqual((Object)((Object)this.scriptDefinition), (Object)((Object)scriptModuleInfo.scriptDefinition))) break block3;
            }
            return true;
        }
        return false;
    }
}

