/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea;

import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginManagerUISettings;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.RepositoryHelper;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PermanentInstallationID;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.Alarm;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.text.VersionComparatorUtil;
import java.io.IOException;
import java.net.URLEncoder;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.KotlinIcons;
import org.jetbrains.kotlin.idea.KotlinPluginUpdater;
import org.jetbrains.kotlin.idea.PluginUpdateStatus;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinIdePlugin;
import org.jetbrains.kotlin.idea.update.VerifyKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u0000 .2\u00020\u0001:\u0001.B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\bH\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0012H\u0002J>\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001b2\u000e\b\u0002\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00150\u001d2\u000e\b\u0002\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00150\u001d2\u000e\b\u0002\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00150\u001dJ\u0006\u0010 \u001a\u00020\u0015J\u0012\u0010!\u001a\u00020\u00152\b\u0010\"\u001a\u0004\u0018\u00010\u0012H\u0002J\u0010\u0010#\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u001c\u0010$\u001a\u00020\u00152\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020'0&H\u0002J\b\u0010(\u001a\u00020\u0015H\u0002J\u001a\u0010)\u001a\u00020\u00152\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020'0&J\u001a\u0010*\u001a\u00020\u00152\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020'0&J\u001c\u0010+\u001a\u00020\u00152\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020'0&H\u0002J\u001a\u0010,\u001a\u00020\b2\u0006\u0010-\u001a\u00020\u00172\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lorg/jetbrains/kotlin/idea/KotlinPluginUpdater;", "Lcom/intellij/openapi/Disposable;", "()V", "alarm", "Lcom/intellij/util/Alarm;", "checkQueued", "Ljava/util/concurrent/atomic/AtomicBoolean;", "lastUpdateStatus", "Lorg/jetbrains/kotlin/idea/PluginUpdateStatus;", "notificationGroup", "Lcom/intellij/notification/NotificationGroup;", "kotlin.jvm.PlatformType", "getNotificationGroup", "()Lcom/intellij/notification/NotificationGroup;", "updateDelay", "", "checkUpdatesInCustomRepository", "host", "", "checkUpdatesInMainRepository", "dispose", "", "initPluginDescriptor", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "newVersion", "installPluginUpdate", "update", "Lorg/jetbrains/kotlin/idea/PluginUpdateStatus$Update;", "successCallback", "Lkotlin/Function0;", "cancelCallback", "errorCallback", "kotlinFileEdited", "notifyNotInstalled", "message", "notifyPluginUpdateAvailable", "queueUpdateCheck", "callback", "Lkotlin/Function1;", "", "recordSuccessfulUpdateCheck", "runCachedUpdate", "runUpdateCheck", "updateCheck", "updateIfNotLatest", "kotlinPlugin", "Companion", "kotlin.idea"})
public final class KotlinPluginUpdater
implements Disposable {
    private volatile long updateDelay = 2000L;
    private final Alarm alarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
    private final AtomicBoolean checkQueued = new AtomicBoolean(false);
    private volatile PluginUpdateStatus lastUpdateStatus;
    private static final long INITIAL_UPDATE_DELAY = 2000L;
    private static final long CACHED_REQUEST_DELAY;
    private static final String PROPERTY_NAME = "kotlin.lastUpdateCheck";
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    private final NotificationGroup getNotificationGroup() {
        return NotificationGroupManager.getInstance().getNotificationGroup("Kotlin plugin updates");
    }

    public final void kotlinFileEdited() {
        UpdateSettings updateSettings = UpdateSettings.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)updateSettings, (String)"UpdateSettings.getInstance()");
        if (!updateSettings.isCheckNeeded()) {
            return;
        }
        long lastUpdateTime = PropertiesComponent.getInstance().getLong(PROPERTY_NAME, 0L);
        if (lastUpdateTime == 0L || System.currentTimeMillis() - lastUpdateTime > CACHED_REQUEST_DELAY) {
            this.queueUpdateCheck((Function1<? super PluginUpdateStatus, Boolean>)((Function1)new Function1<PluginUpdateStatus, Boolean>(this){
                final /* synthetic */ KotlinPluginUpdater this$0;

                public final boolean invoke(@NotNull PluginUpdateStatus updateStatus) {
                    block1: {
                        PluginUpdateStatus pluginUpdateStatus;
                        block0: {
                            Intrinsics.checkNotNullParameter((Object)updateStatus, (String)"updateStatus");
                            pluginUpdateStatus = updateStatus;
                            if (!(pluginUpdateStatus instanceof PluginUpdateStatus.Update)) break block0;
                            KotlinPluginUpdater.access$notifyPluginUpdateAvailable(this.this$0, (PluginUpdateStatus.Update)updateStatus);
                            break block1;
                        }
                        if (!(pluginUpdateStatus instanceof PluginUpdateStatus.CheckFailed)) break block1;
                        KotlinPluginUpdater.access$getLOG$cp().info("Plugin update check failed: " + ((PluginUpdateStatus.CheckFailed)updateStatus).getMessage() + ", details: " + ((PluginUpdateStatus.CheckFailed)updateStatus).getDetail());
                    }
                    return true;
                }
                {
                    this.this$0 = kotlinPluginUpdater;
                    super(1);
                }
            }));
        }
    }

    private final void queueUpdateCheck(Function1<? super PluginUpdateStatus, Boolean> callback2) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.checkQueued.compareAndSet(false, true)) {
            this.alarm.addRequest(new Runnable(this, callback2){
                final /* synthetic */ KotlinPluginUpdater this$0;
                final /* synthetic */ Function1 $callback;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void run() {
                    try {
                        KotlinPluginUpdater.access$updateCheck(this.this$0, this.$callback);
                    }
                    finally {
                        KotlinPluginUpdater.access$getCheckQueued$p(this.this$0).set(false);
                    }
                }
                {
                    this.this$0 = kotlinPluginUpdater;
                    this.$callback = function1;
                }
            }, this.updateDelay);
            this.updateDelay *= (long)2;
        }
    }

    public final void runUpdateCheck(@NotNull Function1<? super PluginUpdateStatus, Boolean> callback2) {
        Intrinsics.checkNotNullParameter(callback2, (String)"callback");
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(this, callback2){
            final /* synthetic */ KotlinPluginUpdater this$0;
            final /* synthetic */ Function1 $callback;

            public final void run() {
                KotlinPluginUpdater.access$updateCheck(this.this$0, this.$callback);
            }
            {
                this.this$0 = kotlinPluginUpdater;
                this.$callback = function1;
            }
        });
    }

    public final void runCachedUpdate(@NotNull Function1<? super PluginUpdateStatus, Boolean> callback2) {
        Intrinsics.checkNotNullParameter(callback2, (String)"callback");
        ApplicationManager.getApplication().assertIsDispatchThread();
        PluginUpdateStatus cachedStatus = this.lastUpdateStatus;
        if (cachedStatus != null && System.currentTimeMillis() - cachedStatus.getTimestamp() < CACHED_REQUEST_DELAY && !(cachedStatus instanceof PluginUpdateStatus.CheckFailed)) {
            callback2.invoke((Object)cachedStatus);
            return;
        }
        this.queueUpdateCheck(callback2);
    }

    private final void updateCheck(Function1<? super PluginUpdateStatus, Boolean> callback2) {
        Ref.ObjectRef updateStatus = new Ref.ObjectRef();
        if (KotlinIdePlugin.INSTANCE.isSnapshot() || KotlinIdePlugin.INSTANCE.getHasPatchedVersion()) {
            updateStatus.element = PluginUpdateStatus.LatestVersionInstalled.INSTANCE;
        } else {
            try {
                updateStatus.element = this.checkUpdatesInMainRepository();
                List list2 = RepositoryHelper.getPluginHosts();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"RepositoryHelper.getPluginHosts()");
                for (String host : CollectionsKt.filterNotNull((Iterable)list2)) {
                    PluginUpdateStatus customUpdateStatus = this.checkUpdatesInCustomRepository(host);
                    updateStatus.element = ((PluginUpdateStatus)updateStatus.element).mergeWith(customUpdateStatus);
                }
            }
            catch (Exception e) {
                updateStatus.element = PluginUpdateStatus.Companion.fromException(KotlinBundle.message("plugin.updater.error.check.failed", new Object[0]), e);
            }
        }
        this.lastUpdateStatus = (PluginUpdateStatus)updateStatus.element;
        if ((PluginUpdateStatus)updateStatus.element instanceof PluginUpdateStatus.Update) {
            updateStatus.element = VerifyKt.verify((PluginUpdateStatus.Update)((PluginUpdateStatus)updateStatus.element));
        }
        if (!((PluginUpdateStatus)updateStatus.element instanceof PluginUpdateStatus.CheckFailed)) {
            this.recordSuccessfulUpdateCheck();
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(callback2, updateStatus){
            final /* synthetic */ Function1 $callback;
            final /* synthetic */ Ref.ObjectRef $updateStatus;

            public final void run() {
                this.$callback.invoke((Object)((PluginUpdateStatus)this.$updateStatus.element));
            }
            {
                this.$callback = function1;
                this.$updateStatus = objectRef;
            }
        }, ModalityState.any());
    }

    private final IdeaPluginDescriptor initPluginDescriptor(String newVersion) {
        PluginNode pluginNode;
        IdeaPluginDescriptor originalPlugin = KotlinIdePlugin.INSTANCE.getPluginDescriptor();
        PluginNode $this$apply = pluginNode = new PluginNode(KotlinIdePlugin.INSTANCE.getId());
        boolean bl = false;
        $this$apply.setVersion(newVersion);
        $this$apply.setName(originalPlugin.getName());
        $this$apply.setDescription(originalPlugin.getDescription());
        return (IdeaPluginDescriptor)pluginNode;
    }

    private final PluginUpdateStatus checkUpdatesInMainRepository() {
        Element responseDoc2;
        ApplicationInfo applicationInfo = ApplicationInfo.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)applicationInfo, (String)"ApplicationInfo.getInstance()");
        String string = applicationInfo.getApiVersion();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ApplicationInfo.getInstance().apiVersion");
        String buildNumber = string;
        String currentVersion = KotlinIdePlugin.INSTANCE.getVersion();
        String os = URLEncoder.encode(SystemInfo.OS_NAME + " " + SystemInfo.OS_VERSION, "UTF-8");
        String string2 = PermanentInstallationID.get();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"PermanentInstallationID.get()");
        String uid = string2;
        String string3 = KotlinIdePlugin.INSTANCE.getId().getIdString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"KotlinIdePlugin.id.idString");
        String pluginId = string3;
        String url = "https://plugins.jetbrains.com/plugins/list?pluginId=" + pluginId + "&build=" + buildNumber + "&pluginVersion=" + currentVersion + "&os=" + os + "&uuid=" + uid;
        Element element3 = responseDoc2 = (Element)HttpRequests.request((String)url).connect((HttpRequests.RequestProcessor)checkUpdatesInMainRepository.responseDoc.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)element3, (String)"responseDoc");
        if (Intrinsics.areEqual((Object)element3.getName(), (Object)"plugin-repository") ^ true) {
            return new PluginUpdateStatus.CheckFailed(KotlinBundle.message("plugin.updater.error.unexpected.repository.response", new Object[0]), JDOMUtil.writeElement((Element)responseDoc2, (String)"\n"));
        }
        if (responseDoc2.getChildren().isEmpty()) {
            return PluginUpdateStatus.LatestVersionInstalled.INSTANCE;
        }
        Object object = responseDoc2.getChild("category");
        if (object == null || (object = object.getChild("idea-plugin")) == null || (object = object.getChild("version")) == null || (object = object.getText()) == null) {
            return new PluginUpdateStatus.CheckFailed(KotlinBundle.message("plugin.updater.error.cant.find.plugin.version", new Object[0]), JDOMUtil.writeElement((Element)responseDoc2, (String)"\n"));
        }
        Object newVersion = object;
        IdeaPluginDescriptor pluginDescriptor = this.initPluginDescriptor((String)newVersion);
        return this.updateIfNotLatest(pluginDescriptor, null);
    }

    private final PluginUpdateStatus checkUpdatesInCustomRepository(String host) {
        Object v2;
        block4: {
            Iterable iterable;
            List list2;
            try {
                list2 = RepositoryHelper.loadPlugins((String)host, null, null);
            }
            catch (Exception e) {
                return PluginUpdateStatus.Companion.fromException(KotlinBundle.message("plugin.updater.error.custom.repository", host), e);
            }
            List list3 = list2;
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"try {\n            Reposi\u2026ory\", host), e)\n        }");
            List plugins = list3;
            Iterable iterable2 = iterable = (Iterable)plugins;
            for (Object t : iterable2) {
                PluginNode pluginDescriptor = (PluginNode)t;
                boolean bl = false;
                PluginNode pluginNode = pluginDescriptor;
                Intrinsics.checkNotNullExpressionValue((Object)pluginNode, (String)"pluginDescriptor");
                if (!(Intrinsics.areEqual((Object)pluginNode.getPluginId(), (Object)KotlinIdePlugin.INSTANCE.getId()) && PluginManagerCore.isCompatible((IdeaPluginDescriptor)((IdeaPluginDescriptor)pluginDescriptor)))) continue;
                v2 = t;
                break block4;
            }
            v2 = null;
        }
        PluginNode pluginNode = v2;
        if (pluginNode == null) {
            return PluginUpdateStatus.LatestVersionInstalled.INSTANCE;
        }
        PluginNode kotlinPlugin = pluginNode;
        return this.updateIfNotLatest((IdeaPluginDescriptor)kotlinPlugin, host);
    }

    private final PluginUpdateStatus updateIfNotLatest(IdeaPluginDescriptor kotlinPlugin, String host) {
        if (VersionComparatorUtil.compare((String)kotlinPlugin.getVersion(), (String)KotlinIdePlugin.INSTANCE.getVersion()) <= 0) {
            return PluginUpdateStatus.LatestVersionInstalled.INSTANCE;
        }
        return new PluginUpdateStatus.Update(kotlinPlugin, host);
    }

    private final void recordSuccessfulUpdateCheck() {
        PropertiesComponent.getInstance().setValue(PROPERTY_NAME, String.valueOf(System.currentTimeMillis()));
        this.updateDelay = 2000L;
    }

    private final void notifyPluginUpdateAvailable(PluginUpdateStatus.Update update2) {
        NotificationGroup notificationGroup = this.getNotificationGroup();
        String string = KotlinBundle.message("plugin.updater.notification.title", new Object[0]);
        Object[] objectArray = new Object[1];
        String string2 = update2.getPluginDescriptor().getVersion();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"update.pluginDescriptor.version");
        objectArray[0] = string2;
        notificationGroup.createNotification(string, KotlinBundle.message("plugin.updater.notification.message", objectArray), NotificationType.INFORMATION).setSuggestionType(true).addAction((AnAction)NotificationAction.createSimpleExpiring((String)KotlinBundle.message("action.text.install", new Object[0]), (Runnable)new Runnable(this, update2){
            final /* synthetic */ KotlinPluginUpdater this$0;
            final /* synthetic */ PluginUpdateStatus.Update $update;

            public final void run() {
                KotlinPluginUpdater.installPluginUpdate$default(this.this$0, this.$update, null, null, (Function0)new Function0<Unit>(this){
                    final /* synthetic */ notifyPluginUpdateAvailable.1 this$0;

                    public final void invoke() {
                        KotlinPluginUpdater.access$notifyPluginUpdateAvailable(this.this$0.this$0, this.this$0.$update);
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                }, 6, null);
            }
            {
                this.this$0 = kotlinPluginUpdater;
                this.$update = update2;
            }
        })).setIcon(KotlinIcons.SMALL_LOGO).notify(null);
    }

    public final void installPluginUpdate(@NotNull PluginUpdateStatus.Update update2, @NotNull Function0<Unit> successCallback, @NotNull Function0<Unit> cancelCallback, @NotNull Function0<Unit> errorCallback) {
        Intrinsics.checkNotNullParameter((Object)update2, (String)"update");
        Intrinsics.checkNotNullParameter(successCallback, (String)"successCallback");
        Intrinsics.checkNotNullParameter(cancelCallback, (String)"cancelCallback");
        Intrinsics.checkNotNullParameter(errorCallback, (String)"errorCallback");
        IdeaPluginDescriptor descriptor2 = update2.getPluginDescriptor();
        PluginDownloader pluginDownloader = PluginDownloader.createDownloader((IdeaPluginDescriptor)descriptor2, (String)update2.getHostToInstallFrom(), null);
        Intrinsics.checkNotNullExpressionValue((Object)pluginDownloader, (String)"PluginDownloader.createD\u2026.hostToInstallFrom, null)");
        PluginDownloader pluginDownloader2 = pluginDownloader;
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this, pluginDownloader2, errorCallback, successCallback, cancelCallback, null, KotlinBundle.message("plugin.updater.downloading", new Object[0]), true, (PerformInBackgroundOption)PluginManagerUISettings.getInstance()){
            final /* synthetic */ KotlinPluginUpdater this$0;
            final /* synthetic */ PluginDownloader $pluginDownloader;
            final /* synthetic */ Function0 $errorCallback;
            final /* synthetic */ Function0 $successCallback;
            final /* synthetic */ Function0 $cancelCallback;

            /*
             * WARNING - void declaration
             */
            public void run(@NotNull ProgressIndicator indicator) {
                void message2;
                void installed;
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                Ref.BooleanRef booleanRef = new Ref.BooleanRef();
                booleanRef.element = false;
                Ref.ObjectRef objectRef = new Ref.ObjectRef();
                objectRef.element = null;
                try {
                    bl = this.$pluginDownloader.prepareToInstall(indicator);
                }
                catch (IOException e) {
                    KotlinPluginUpdater.access$getLOG$cp().info((Throwable)e);
                    message2.element = e.getMessage();
                    bl = false;
                }
                boolean prepareResult2 = bl;
                if (prepareResult2) {
                    installed.element = true;
                    this.$pluginDownloader.install();
                    ApplicationManager.getApplication().invokeLater((Runnable)installPluginUpdate.run.1.INSTANCE);
                }
                ApplicationManager.getApplication().invokeLater(new Runnable(this, (Ref.BooleanRef)installed, (Ref.ObjectRef)message2){
                    final /* synthetic */ installPluginUpdate.4 this$0;
                    final /* synthetic */ Ref.BooleanRef $installed;
                    final /* synthetic */ Ref.ObjectRef $message;

                    public final void run() {
                        if (!this.$installed.element) {
                            this.this$0.$errorCallback.invoke();
                            KotlinPluginUpdater.access$notifyNotInstalled(this.this$0.this$0, (String)this.$message.element);
                        } else {
                            this.this$0.$successCallback.invoke();
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        this.$installed = booleanRef;
                        this.$message = objectRef;
                    }
                });
            }

            public void onCancel() {
                this.$cancelCallback.invoke();
            }
            {
                this.this$0 = this$0;
                this.$pluginDownloader = $captured_local_variable$1;
                this.$errorCallback = $captured_local_variable$2;
                this.$successCallback = $captured_local_variable$3;
                this.$cancelCallback = $captured_local_variable$4;
                super($super_call_param$5, $super_call_param$6, $super_call_param$7, $super_call_param$8);
            }
        });
    }

    public static /* synthetic */ void installPluginUpdate$default(KotlinPluginUpdater kotlinPluginUpdater, PluginUpdateStatus.Update update2, Function0 function0, Function0 function02, Function0 function03, int n, Object object) {
        if ((n & 2) != 0) {
            function0 = installPluginUpdate.1.INSTANCE;
        }
        if ((n & 4) != 0) {
            function02 = installPluginUpdate.2.INSTANCE;
        }
        if ((n & 8) != 0) {
            function03 = installPluginUpdate.3.INSTANCE;
        }
        kotlinPluginUpdater.installPluginUpdate(update2, (Function0<Unit>)function0, (Function0<Unit>)function02, (Function0<Unit>)function03);
    }

    private final void notifyNotInstalled(String message2) {
        String string = message2;
        String content2 = string == null ? KotlinBundle.message("plugin.updater.not.installed", new Object[0]) : KotlinBundle.message("plugin.updater.not.installed.misc", message2);
        this.getNotificationGroup().createNotification(KotlinBundle.message("plugin.updater.notification.title", new Object[0]), content2, NotificationType.INFORMATION).addAction((AnAction)NotificationAction.createSimpleExpiring((String)KotlinBundle.message("plugin.updater.not.installed.see.log.action", new Object[0]), (Runnable)notifyNotInstalled.1.INSTANCE)).notify(null);
    }

    public void dispose() {
    }

    static {
        Companion = new Companion(null);
        CACHED_REQUEST_DELAY = TimeUnit.DAYS.toMillis(1L);
        Logger logger = Logger.getInstance(KotlinPluginUpdater.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(Kotli\u2026luginUpdater::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ void access$notifyPluginUpdateAvailable(KotlinPluginUpdater $this, PluginUpdateStatus.Update update2) {
        $this.notifyPluginUpdateAvailable(update2);
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    public static final /* synthetic */ void access$updateCheck(KotlinPluginUpdater $this, Function1 callback2) {
        $this.updateCheck((Function1<? super PluginUpdateStatus, Boolean>)callback2);
    }

    public static final /* synthetic */ AtomicBoolean access$getCheckQueued$p(KotlinPluginUpdater $this) {
        return $this.checkQueued;
    }

    public static final /* synthetic */ void access$notifyNotInstalled(KotlinPluginUpdater $this, String message2) {
        $this.notifyNotInstalled(message2);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0002\u0013\u0014B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\n2\b\u0010\u0010\u001a\u0004\u0018\u00010\nJ\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/KotlinPluginUpdater$Companion;", "", "()V", "CACHED_REQUEST_DELAY", "", "INITIAL_UPDATE_DELAY", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "PROPERTY_NAME", "", "fetchPluginReleaseDate", "Ljava/time/LocalDate;", "pluginId", "Lcom/intellij/openapi/extensions/PluginId;", "version", "channel", "getInstance", "Lorg/jetbrains/kotlin/idea/KotlinPluginUpdater;", "PluginDTO", "ResponseParseException", "kotlin.idea"})
    public static final class Companion {
        @NotNull
        public final KotlinPluginUpdater getInstance() {
            boolean $i$f$service = false;
            Class<KotlinPluginUpdater> serviceClass$iv = KotlinPluginUpdater.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
            }
            return (KotlinPluginUpdater)object;
        }

        @Nullable
        public final LocalDate fetchPluginReleaseDate(@NotNull PluginId pluginId, @NotNull String version2, @Nullable String channel) throws IOException, ResponseParseException {
            LocalDate localDate;
            PluginDTO pluginDTO;
            block9: {
                PluginDTO[] pluginDTOs2;
                PluginDTO[] pluginDTOArray;
                Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
                Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
                String url = "https://plugins.jetbrains.com/api/plugins/" + pluginId.getIdString() + "/updates?version=" + version2;
                try {
                    Object object = HttpRequests.request((String)url).connect((HttpRequests.RequestProcessor)fetchPluginReleaseDate.pluginDTOs.1.INSTANCE);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"HttpRequests.request(url\u2026s.java)\n                }");
                    pluginDTOArray = (PluginDTO[])object;
                }
                catch (JsonIOException ioException) {
                    throw (Throwable)new IOException(ioException);
                }
                catch (JsonSyntaxException syntaxException) {
                    throw (Throwable)new ResponseParseException("Can't parse json response", (Exception)((Object)syntaxException));
                }
                PluginDTO[] $this$firstOrNull$iv = pluginDTOs2 = pluginDTOArray;
                boolean $i$f$firstOrNull = false;
                int n = $this$firstOrNull$iv.length;
                for (int i = 0; i < n; ++i) {
                    PluginDTO element$iv;
                    PluginDTO it = element$iv = $this$firstOrNull$iv[i];
                    boolean bl = false;
                    if (!(it.getListed() && it.getApprove() && (Intrinsics.areEqual((Object)it.getChannel(), (Object)channel) || Intrinsics.areEqual((Object)it.getChannel(), (Object)"") && channel == null))) continue;
                    pluginDTO = element$iv;
                    break block9;
                }
                pluginDTO = null;
            }
            if (pluginDTO == null) {
                return null;
            }
            PluginDTO selectedPluginDTO = pluginDTO;
            String string = selectedPluginDTO.getCdate();
            if (string == null) {
                throw (Throwable)new ResponseParseException("Empty cdate", null, 2, null);
            }
            String dateString = string;
            try {
                String string2 = dateString;
                long dateLong = Long.parseLong(string2);
                localDate = Instant.ofEpochMilli(dateLong).atZone(ZoneOffset.UTC).toLocalDate();
            }
            catch (NumberFormatException e) {
                throw (Throwable)new ResponseParseException("Can't parse long date", e);
            }
            catch (DateTimeException e) {
                throw (Throwable)new ResponseParseException("Can't convert to date", e);
            }
            return localDate;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0010\b\u0002\u0010\u0005\u001a\n\u0018\u00010\u0006j\u0004\u0018\u0001`\u0007\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/KotlinPluginUpdater$Companion$ResponseParseException;", "Ljava/lang/IllegalStateException;", "Lkotlin/IllegalStateException;", "message", "", "cause", "Ljava/lang/Exception;", "Lkotlin/Exception;", "(Ljava/lang/String;Ljava/lang/Exception;)V", "kotlin.idea"})
        public static final class ResponseParseException
        extends IllegalStateException {
            public ResponseParseException(@NotNull String message2, @Nullable Exception cause) {
                Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
                super(message2, cause);
            }

            public /* synthetic */ ResponseParseException(String string, Exception exception, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 2) != 0) {
                    exception = null;
                }
                this(string, exception);
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000eR\u001a\u0010\u0012\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0006\"\u0004\b\u0014\u0010\b\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/KotlinPluginUpdater$Companion$PluginDTO;", "", "()V", "approve", "", "getApprove", "()Z", "setApprove", "(Z)V", "cdate", "", "getCdate", "()Ljava/lang/String;", "setCdate", "(Ljava/lang/String;)V", "channel", "getChannel", "setChannel", "listed", "getListed", "setListed", "kotlin.idea"})
        private static final class PluginDTO {
            @Nullable
            private String cdate;
            @Nullable
            private String channel;
            private boolean listed = true;
            private boolean approve = true;

            @Nullable
            public final String getCdate() {
                return this.cdate;
            }

            public final void setCdate(@Nullable String string) {
                this.cdate = string;
            }

            @Nullable
            public final String getChannel() {
                return this.channel;
            }

            public final void setChannel(@Nullable String string) {
                this.channel = string;
            }

            public final boolean getListed() {
                return this.listed;
            }

            public final void setListed(boolean bl) {
                this.listed = bl;
            }

            public final boolean getApprove() {
                return this.approve;
            }

            public final void setApprove(boolean bl) {
                this.approve = bl;
            }
        }
    }
}

