/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling.internal;

import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.gradle.StartParameter;
import org.gradle.api.Project;
import org.gradle.api.internal.project.DefaultProject;
import org.gradle.api.invocation.Gradle;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.com.google.gson.GsonBuilder;
import org.gradle.internal.logging.progress.ProgressLogger;
import org.gradle.internal.logging.progress.ProgressLoggerFactory;
import org.gradle.tooling.provider.model.ParameterizedToolingModelBuilder;
import org.gradle.tooling.provider.model.ToolingModelBuilder;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.plugins.gradle.model.internal.DummyModel;
import org.jetbrains.plugins.gradle.model.internal.TurnOffDefaultTasks;
import org.jetbrains.plugins.gradle.tooling.Message;
import org.jetbrains.plugins.gradle.tooling.MessageReporter;
import org.jetbrains.plugins.gradle.tooling.ModelBuilderContext;
import org.jetbrains.plugins.gradle.tooling.ModelBuilderService;
import org.jetbrains.plugins.gradle.tooling.builder.ExternalProjectBuilderImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtraModelBuilder
implements ToolingModelBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(ExtraModelBuilder.class);
    @ApiStatus.Internal
    public static final String MODEL_BUILDER_SERVICE_MESSAGE_PREFIX = "ModelBuilderService message: ";
    private final List<ModelBuilderService> modelBuilderServices;
    @NotNull
    private final GradleVersion myCurrentGradleVersion;
    private MyModelBuilderContext myModelBuilderContext;

    public ExtraModelBuilder() {
        this(GradleVersion.current());
    }

    @TestOnly
    public ExtraModelBuilder(@NotNull GradleVersion gradleVersion) {
        this.myCurrentGradleVersion = gradleVersion;
        this.modelBuilderServices = Lists.newArrayList(ServiceLoader.load(ModelBuilderService.class, ExtraModelBuilder.class.getClassLoader()));
    }

    public boolean canBuild(String modelName) {
        if (DummyModel.class.getName().equals(modelName)) {
            return true;
        }
        if (TurnOffDefaultTasks.class.getName().equals(modelName)) {
            return true;
        }
        for (ModelBuilderService service : this.modelBuilderServices) {
            if (!service.canBuild(modelName)) continue;
            return true;
        }
        return false;
    }

    public Object buildAll(String modelName, Project project) {
        return this.buildAll(modelName, null, project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object buildAll(String modelName, ModelBuilderService.Parameter parameter, Project project) {
        if (DummyModel.class.getName().equals(modelName)) {
            return new DummyModel(){};
        }
        if (TurnOffDefaultTasks.class.getName().equals(modelName)) {
            StartParameter startParameter = project.getGradle().getStartParameter();
            List taskNames = startParameter.getTaskNames();
            if (taskNames.isEmpty()) {
                startParameter.setTaskNames(null);
                List<String> helpTask = Collections.singletonList("help");
                project.setDefaultTasks(helpTask);
                startParameter.setExcludedTaskNames(helpTask);
            }
            return null;
        }
        if (this.myModelBuilderContext == null) {
            Gradle rootGradle = ExtraModelBuilder.getRootGradle(project.getGradle());
            this.myModelBuilderContext = new MyModelBuilderContext(rootGradle);
        }
        this.myModelBuilderContext.setParameter(parameter);
        for (ModelBuilderService service : this.modelBuilderServices) {
            if (!service.canBuild(modelName)) continue;
            long startTime = System.currentTimeMillis();
            try {
                if (service instanceof ModelBuilderService.Ex) {
                    Object object = ((ModelBuilderService.Ex)service).buildAll(modelName, project, (ModelBuilderContext)this.myModelBuilderContext);
                    return object;
                }
                Object object = service.buildAll(modelName, project);
                return object;
            }
            catch (Exception e) {
                if (service instanceof ExternalProjectBuilderImpl) {
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new ExternalSystemException((Throwable)e);
                }
                ExtraModelBuilder.reportModelBuilderFailure(project, service, this.myModelBuilderContext, e);
            }
            finally {
                if (Boolean.getBoolean("idea.gradle.custom.tooling.perf")) {
                    long timeInMs = System.currentTimeMillis() - startTime;
                    ExtraModelBuilder.reportPerformanceStatistic(project, service, modelName, timeInMs);
                }
            }
            return null;
        }
        throw new IllegalArgumentException("Unsupported model: " + modelName);
    }

    private static void reportPerformanceStatistic(Project project, ModelBuilderService service, String modelName, long timeInMs) {
        String msg = String.format("%s: service %s imported '%s' in %d ms", project.getDisplayName(), service.getClass().getSimpleName(), modelName, timeInMs);
        project.getLogger().error(msg);
    }

    public static void reportModelBuilderFailure(@NotNull Project project, @NotNull ModelBuilderService service, @NotNull ModelBuilderContext modelBuilderContext, @NotNull Exception modelBuilderError) {
        try {
            Message message = service.getErrorMessageBuilder(project, modelBuilderError).buildMessage();
            modelBuilderContext.report(project, message);
        }
        catch (Throwable e) {
            LOG.warn("Failed to report model builder error", e);
        }
    }

    @NotNull
    private static Gradle getRootGradle(@NotNull Gradle gradle) {
        Gradle root = gradle;
        while (root.getParent() != null) {
            root = root.getParent();
        }
        return root;
    }

    private static final class MyModelBuilderContext
    implements ModelBuilderContext {
        private final Map<ModelBuilderContext.DataProvider, Object> myMap = new IdentityHashMap<ModelBuilderContext.DataProvider, Object>();
        private final Gradle myGradle;
        @Nullable
        private ModelBuilderService.Parameter myParameter = null;

        private MyModelBuilderContext(Gradle gradle) {
            this.myGradle = gradle;
        }

        @NotNull
        public Gradle getRootGradle() {
            return this.myGradle;
        }

        @Nullable
        public String getParameter() {
            return this.myParameter != null ? this.myParameter.getValue() : null;
        }

        private void setParameter(@Nullable ModelBuilderService.Parameter parameter) {
            this.myParameter = parameter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public <T> T getData(@NotNull ModelBuilderContext.DataProvider<T> provider) {
            Object data = this.myMap.get(provider);
            if (data == null) {
                Map<ModelBuilderContext.DataProvider, Object> map = this.myMap;
                synchronized (map) {
                    Object secondAttempt = this.myMap.get(provider);
                    if (secondAttempt != null) {
                        return (T)secondAttempt;
                    }
                    Object value = provider.create(this.myGradle, (MessageReporter)this);
                    this.myMap.put(provider, value);
                    return (T)value;
                }
            }
            return (T)data;
        }

        @ApiStatus.Experimental
        public void report(@NotNull Project project, @NotNull Message message) {
            if (GradleVersion.current().getBaseVersion().compareTo(GradleVersion.version((String)"2.14.1")) < 0) {
                return;
            }
            try {
                ProgressLoggerFactory progressLoggerFactory = (ProgressLoggerFactory)((DefaultProject)project).getServices().get(ProgressLoggerFactory.class);
                ProgressLogger operation = progressLoggerFactory.newOperation(ModelBuilderService.class);
                String jsonMessage = new GsonBuilder().create().toJson((Object)message);
                operation.setDescription(ExtraModelBuilder.MODEL_BUILDER_SERVICE_MESSAGE_PREFIX + jsonMessage);
                operation.started();
                operation.completed();
            }
            catch (Throwable e) {
                LOG.warn("Failed to report model builder message", e);
            }
        }
    }

    public static class ForGradle44
    extends ExtraModelBuilder
    implements ParameterizedToolingModelBuilder<ModelBuilderService.Parameter> {
        @NotNull
        public Class<ModelBuilderService.Parameter> getParameterType() {
            return ModelBuilderService.Parameter.class;
        }
    }
}

