/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling.builder;

import org.gradle.api.Project;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.model.RepositoriesModel;
import org.jetbrains.plugins.gradle.tooling.ErrorMessageBuilder;
import org.jetbrains.plugins.gradle.tooling.ModelBuilderService;
import org.jetbrains.plugins.gradle.tooling.internal.MavenRepositoryModelImpl;
import org.jetbrains.plugins.gradle.tooling.internal.RepositoriesModelImpl;

public class MavenRepositoriesModelBuilder
implements ModelBuilderService {
    public boolean canBuild(String modelName) {
        return RepositoriesModel.class.getName().equals(modelName);
    }

    public Object buildAll(String modelName, Project project) {
        RepositoriesModelImpl repoModel = new RepositoriesModelImpl();
        for (MavenArtifactRepository artifactRepository : project.getRepositories().withType(MavenArtifactRepository.class)) {
            MavenRepositoryModelImpl model = new MavenRepositoryModelImpl(artifactRepository.getName(), artifactRepository.getUrl().toString());
            repoModel.add(model);
        }
        return repoModel;
    }

    @NotNull
    public ErrorMessageBuilder getErrorMessageBuilder(@NotNull Project project, @NotNull Exception e) {
        return ErrorMessageBuilder.create((Project)project, (Exception)e, (String)"Project maven repositories import errors").withDescription("Unable to obtain information about configured Maven repositories");
    }
}

