/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling.builder;

import com.intellij.openapi.externalSystem.model.project.dependencies.ComponentDependencies;
import com.intellij.openapi.externalSystem.model.project.dependencies.ComponentDependenciesImpl;
import com.intellij.openapi.externalSystem.model.project.dependencies.DependencyScopeNode;
import com.intellij.openapi.externalSystem.model.project.dependencies.ProjectDependencies;
import com.intellij.openapi.externalSystem.model.project.dependencies.ProjectDependenciesImpl;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import java.util.Iterator;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.tooling.ErrorMessageBuilder;
import org.jetbrains.plugins.gradle.tooling.ModelBuilderService;
import org.jetbrains.plugins.gradle.tooling.tasks.DependenciesReport;
import org.jetbrains.plugins.gradle.tooling.util.JavaPluginUtil;
import org.jetbrains.plugins.gradle.tooling.util.resolve.DependencyResolverImpl;

public class DependencyGraphModelBuilderImpl
implements ModelBuilderService,
GroovyObject {
    private DependenciesReport.ReportGenerator reportGenerator;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public DependencyGraphModelBuilderImpl() {
        MetaClass metaClass;
        DependenciesReport.ReportGenerator reportGenerator;
        this.reportGenerator = reportGenerator = new DependenciesReport.ReportGenerator();
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public boolean canBuild(String modelName) {
        return ScriptBytecodeAdapter.compareEqual((Object)ProjectDependencies.class.getName(), (Object)modelName);
    }

    public Object buildAll(String modelName, Project project) {
        boolean resolveSourceSetDependencies = DefaultTypeTransformation.booleanUnbox((Object)ScriptBytecodeAdapter.asType(System.getProperties().get("idea.resolveSourceSetDependencies"), Boolean.TYPE));
        if (!resolveSourceSetDependencies || !DependencyResolverImpl.isIsNewDependencyResolutionApplicable()) {
            return null;
        }
        SourceSetContainer sourceSetContainer = JavaPluginUtil.getSourceSetContainer(project);
        if (sourceSetContainer == null) {
            return null;
        }
        ProjectDependenciesImpl dependencies = new ProjectDependenciesImpl();
        SourceSet sourceSet = null;
        Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethod0(DependencyGraphModelBuilderImpl.class, (Object)sourceSetContainer, (String)"iterator"), Iterator.class);
        while (iterator.hasNext()) {
            sourceSet = (SourceSet)ScriptBytecodeAdapter.castToType(iterator.next(), SourceSet.class);
            String compileConfigurationName = sourceSet.getCompileClasspathConfigurationName();
            Configuration compileConfiguration = (Configuration)ScriptBytecodeAdapter.castToType((Object)project.getConfigurations().findByName(compileConfigurationName), Configuration.class);
            if (compileConfiguration == null) continue;
            String runtimeConfigurationName = sourceSet.getRuntimeClasspathConfigurationName();
            Configuration runtimeConfiguration = (Configuration)ScriptBytecodeAdapter.castToType((Object)project.getConfigurations().findByName(runtimeConfigurationName), Configuration.class);
            if (runtimeConfiguration == null) continue;
            DependencyScopeNode compileScopeNode = this.reportGenerator.buildDependenciesGraph(compileConfiguration, project);
            DependencyScopeNode runtimeScopeNode = this.reportGenerator.buildDependenciesGraph(runtimeConfiguration, project);
            if (!(!compileScopeNode.getDependencies().isEmpty() || !runtimeScopeNode.getDependencies().isEmpty())) continue;
            dependencies.add((ComponentDependencies)new ComponentDependenciesImpl(sourceSet.getName(), compileScopeNode, runtimeScopeNode));
        }
        return dependencies.getComponentsDependencies().isEmpty() ? null : dependencies;
    }

    @NotNull
    public ErrorMessageBuilder getErrorMessageBuilder(@NotNull Project project, @NotNull Exception e) {
        return ErrorMessageBuilder.create((Project)project, (Exception)e, (String)"Dependency graph model errors");
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != DependencyGraphModelBuilderImpl.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    public DependenciesReport.ReportGenerator getReportGenerator() {
        return this.reportGenerator;
    }

    public void setReportGenerator(DependenciesReport.ReportGenerator reportGenerator) {
        this.reportGenerator = reportGenerator;
    }
}

