/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.model;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.model.DefaultExternalFilter;
import org.jetbrains.plugins.gradle.model.ExternalFilter;
import org.jetbrains.plugins.gradle.model.ExternalSourceDirectorySet;
import org.jetbrains.plugins.gradle.model.FilePatternSet;
import org.jetbrains.plugins.gradle.model.FilePatternSetImpl;

public final class DefaultExternalSourceDirectorySet
implements ExternalSourceDirectorySet {
    private static final long serialVersionUID = 1L;
    @NotNull
    private String name;
    @NotNull
    private Set<File> srcDirs;
    private File outputDir;
    private final List<File> gradleOutputDirs;
    private final FilePatternSetImpl patterns;
    @NotNull
    private List<DefaultExternalFilter> filters;
    private boolean inheritedCompilerOutput;

    public DefaultExternalSourceDirectorySet() {
        this.srcDirs = new HashSet<File>(0);
        this.filters = new ArrayList<DefaultExternalFilter>(0);
        this.gradleOutputDirs = new ArrayList<File>(0);
        this.patterns = new FilePatternSetImpl();
    }

    public DefaultExternalSourceDirectorySet(ExternalSourceDirectorySet sourceDirectorySet) {
        this.name = sourceDirectorySet.getName();
        this.srcDirs = new HashSet<File>(sourceDirectorySet.getSrcDirs());
        this.outputDir = sourceDirectorySet.getOutputDir();
        this.gradleOutputDirs = new ArrayList<File>(sourceDirectorySet.getGradleOutputDirs());
        this.patterns = new FilePatternSetImpl(sourceDirectorySet.getIncludes(), sourceDirectorySet.getExcludes());
        this.filters = new ArrayList<DefaultExternalFilter>(sourceDirectorySet.getFilters().size());
        for (ExternalFilter filter : sourceDirectorySet.getFilters()) {
            this.filters.add(new DefaultExternalFilter(filter));
        }
        this.inheritedCompilerOutput = sourceDirectorySet.isCompilerOutputPathInherited();
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(@NotNull String name) {
        this.name = name;
    }

    @NotNull
    public Set<File> getSrcDirs() {
        return this.srcDirs;
    }

    public void setSrcDirs(@NotNull Set<File> srcDirs) {
        this.srcDirs = srcDirs;
    }

    @NotNull
    public File getOutputDir() {
        return this.outputDir;
    }

    public void setOutputDir(@NotNull File outputDir) {
        this.outputDir = outputDir;
    }

    @NotNull
    public Collection<File> getGradleOutputDirs() {
        return this.gradleOutputDirs;
    }

    public void addGradleOutputDir(@NotNull File outputDir) {
        this.gradleOutputDirs.add(outputDir);
    }

    public boolean isCompilerOutputPathInherited() {
        return this.inheritedCompilerOutput;
    }

    @NotNull
    public Set<String> getExcludes() {
        return this.patterns.getExcludes();
    }

    public void setExcludes(Set<String> excludes) {
        this.patterns.setExcludes(excludes);
    }

    @NotNull
    public Set<String> getIncludes() {
        return this.patterns.getIncludes();
    }

    public void setIncludes(Set<String> includes) {
        this.patterns.setIncludes(includes);
    }

    @NotNull
    public FilePatternSet getPatterns() {
        return this.patterns;
    }

    public void setInheritedCompilerOutput(boolean inheritedCompilerOutput) {
        this.inheritedCompilerOutput = inheritedCompilerOutput;
    }

    @NotNull
    public List<? extends ExternalFilter> getFilters() {
        return this.filters;
    }

    public void setFilters(@NotNull List<DefaultExternalFilter> filters) {
        this.filters = filters;
    }
}

