/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.model;

import java.io.File;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.gradle.internal.impldep.com.google.common.base.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.model.AbstractExternalDependency;
import org.jetbrains.plugins.gradle.model.ExternalDependency;
import org.jetbrains.plugins.gradle.model.ExternalMultiLibraryDependency;
import org.jetbrains.plugins.gradle.tooling.util.BooleanBiFunction;
import org.jetbrains.plugins.gradle.tooling.util.GradleContainerUtil;

public final class DefaultExternalMultiLibraryDependency
extends AbstractExternalDependency
implements ExternalMultiLibraryDependency {
    private static final long serialVersionUID = 1L;
    private final Collection<File> files;
    private final Collection<File> sources;
    private final Collection<File> javadocs;

    public DefaultExternalMultiLibraryDependency() {
        this.files = new LinkedHashSet<File>(0);
        this.sources = new LinkedHashSet<File>(0);
        this.javadocs = new LinkedHashSet<File>(0);
    }

    public DefaultExternalMultiLibraryDependency(ExternalMultiLibraryDependency dependency) {
        super((ExternalDependency)dependency);
        this.files = dependency.getFiles();
        this.sources = dependency.getSources();
        this.javadocs = dependency.getJavadoc();
    }

    @NotNull
    public Collection<File> getFiles() {
        return this.files;
    }

    @NotNull
    public Collection<File> getSources() {
        return this.sources;
    }

    @NotNull
    public Collection<File> getJavadoc() {
        return this.javadocs;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultExternalMultiLibraryDependency)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DefaultExternalMultiLibraryDependency that = (DefaultExternalMultiLibraryDependency)o;
        return GradleContainerUtil.match(this.files.iterator(), that.files.iterator(), (BooleanBiFunction)new BooleanBiFunction<File, File>(){

            public Boolean fun(File o1, File o2) {
                return Objects.equal((Object)o1.getPath(), (Object)o2.getPath());
            }
        });
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), DefaultExternalMultiLibraryDependency.calcFilesPathsHashCode(this.files)});
    }

    public String toString() {
        return "library '" + this.files + '\'' + super.toString();
    }
}

