/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.model;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.tooling.BuildController;
import org.gradle.tooling.model.BuildModel;
import org.gradle.tooling.model.Model;
import org.gradle.tooling.model.gradle.GradleBuild;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.ProjectImportModelProvider;

public final class ClassSetBuildImportModelProvider
implements ProjectImportModelProvider {
    @NotNull
    private final Set<Class<?>> classSet;

    public ClassSetBuildImportModelProvider(@NotNull Collection<Class<?>> classes) {
        this.classSet = new LinkedHashSet(classes);
    }

    public void populateBuildModels(@NotNull BuildController controller, @NotNull GradleBuild buildModel, @NotNull ProjectImportModelProvider.BuildModelConsumer consumer) {
        for (Class<?> aClass : this.classSet) {
            Object instance = controller.findModel((Model)buildModel, aClass);
            if (instance == null) continue;
            consumer.consume((BuildModel)buildModel, instance, aClass);
        }
    }

    public void populateProjectModels(@NotNull BuildController controller, @Nullable Model module, @NotNull ProjectImportModelProvider.ProjectModelConsumer modelConsumer) {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassSetBuildImportModelProvider provider = (ClassSetBuildImportModelProvider)o;
        return this.classSet.equals(provider.classSet);
    }

    public int hashCode() {
        return this.classSet.hashCode();
    }
}

