/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.android.parcel.quickfixes;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.android.parcel.ParcelableDeclarationCheckerKt;
import org.jetbrains.kotlin.android.parcel.quickfixes.AbstractParcelableQuickFix;
import org.jetbrains.kotlin.android.parcel.quickfixes.ParcelMigrateToParcelizeQuickFix;
import org.jetbrains.kotlin.android.parcel.quickfixes.ParcelMigrateToParcelizeQuickFix$Companion$findCreatorClass$;
import org.jetbrains.kotlin.android.parcel.quickfixes.ParcelMigrateToParcelizeQuickFix$Companion$findFunction$;
import org.jetbrains.kotlin.android.parcel.quickfixes.ParcelMigrateToParcelizeQuickFix$invoke$;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.PsiModificationUtilsKt;
import org.jetbrains.kotlin.idea.intentions.branchedTransformations.IfThenUtilsKt;
import org.jetbrains.kotlin.idea.util.ModifierListModifactorKt;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtClassOrObjectKt;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.addRemoveModifier.AddRemoveModifierKt;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.typeRefHelpers.TypeRefHelpersKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElement;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \f2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003\f\r\u000eB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/android/parcel/quickfixes/ParcelMigrateToParcelizeQuickFix;", "Lorg/jetbrains/kotlin/android/parcel/quickfixes/AbstractParcelableQuickFix;", "Lorg/jetbrains/kotlin/psi/KtClass;", "function", "(Lorg/jetbrains/kotlin/psi/KtClass;)V", "getText", "", "invoke", "", "ktPsiFactory", "Lorg/jetbrains/kotlin/psi/KtPsiFactory;", "parcelableClass", "Companion", "FactoryForCREATOR", "FactoryForWrite", "intellij.android.kotlin.extensions.common"})
public final class ParcelMigrateToParcelizeQuickFix
extends AbstractParcelableQuickFix<KtClass> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final FqName PARCELER_FQNAME = new FqName("kotlinx.parcelize.Parceler");
    @NotNull
    private static final Name PARCELER_WRITE_FUNCTION_NAME;
    @NotNull
    private static final Name PARCELER_CREATE_FUNCTION_NAME;
    @NotNull
    private static final Logger LOG;

    public ParcelMigrateToParcelizeQuickFix(@NotNull KtClass function) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        super((KtElement)function);
    }

    @NotNull
    public String getText() {
        return "Migrate to ''Parceler'' companion object";
    }

    @Override
    public void invoke(@NotNull KtPsiFactory ktPsiFactory, @NotNull KtClass parcelableClass) {
        Class[] classArray;
        KtClassBody body$iv3;
        Object anchor$iv;
        KtClassOrObject this_$iv;
        Object parcelParameterName;
        KtFunction newFunction;
        KotlinType superClass;
        KtNamedFunction ktNamedFunction;
        boolean bl;
        ClassifierDescriptor it;
        String parcelerTypeArg;
        BindingContext bindingContext;
        Pair parcelerObject;
        block51: {
            Intrinsics.checkNotNullParameter((Object)ktPsiFactory, (String)"ktPsiFactory");
            Intrinsics.checkNotNullParameter((Object)parcelableClass, (String)"parcelableClass");
            Pair pair = ParcelMigrateToParcelizeQuickFix.Companion.findParcelerCompanionObject(parcelableClass);
            if (pair == null || (pair = (KtObjectDeclaration)pair.getFirst()) == null) {
                pair = PsiModificationUtilsKt.getOrCreateCompanionObject((KtClass)parcelableClass);
            }
            parcelerObject = pair;
            bindingContext = ResolutionUtils.analyze((KtElement)((KtElement)parcelerObject), (BodyResolveMode)BodyResolveMode.PARTIAL);
            String string = parcelableClass.getName();
            if (string == null) {
                ParcelMigrateToParcelizeQuickFix $this$invoke_u24lambda_u2d0 = this;
                boolean bl2 = false;
                LOG.error("Parceler class should not be an anonymous class");
                return;
            }
            parcelerTypeArg = string;
            ClassDescriptor classDescriptor = (ClassDescriptor)bindingContext.get((ReadOnlySlice)BindingContext.CLASS, (Object)parcelerObject);
            if (classDescriptor == null) {
                ParcelMigrateToParcelizeQuickFix $this$invoke_u24lambda_u2d1 = this;
                boolean bl3 = false;
                StringBuilder stringBuilder = new StringBuilder().append("Unable to resolve parceler object for ");
                String string2 = parcelableClass.getName();
                if (string2 == null) {
                    string2 = "<unnamed Parcelable class>";
                }
                LOG.error(stringBuilder.append(string2).toString());
                return;
            }
            ClassDescriptor parcelerObjectDescriptor = classDescriptor;
            Sequence $this$any$iv = DescriptorUtilsKt.getAllSuperClassifiers((ClassifierDescriptor)((ClassifierDescriptor)parcelerObjectDescriptor));
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                it = (ClassifierDescriptor)element$iv;
                boolean bl4 = false;
                if (!Intrinsics.areEqual((Object)DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)((DeclarationDescriptor)it)), (Object)PARCELER_FQNAME)) continue;
                bl = true;
                break block51;
            }
            bl = false;
        }
        if (!bl) {
            String entryText = PARCELER_FQNAME.asString() + '<' + parcelerTypeArg + '>';
            AbstractParcelableQuickFix.Companion.shortenReferences((KtElement)parcelerObject.addSuperTypeListEntry((KtSuperTypeListEntry)ktPsiFactory.createSuperTypeEntry(entryText)));
        }
        KtNamedFunction oldWriteToParcelFunction = ParcelMigrateToParcelizeQuickFix.Companion.findWriteToParcelOverride(parcelableClass);
        KtClassOrObject ktClassOrObject = ParcelMigrateToParcelizeQuickFix.Companion.findCreatorClass(parcelableClass);
        if (ktClassOrObject != null) {
            it = ktClassOrObject;
            boolean bl5 = false;
            ktNamedFunction = ParcelMigrateToParcelizeQuickFix.Companion.findCreateFromParcel((KtClassOrObject)it);
        } else {
            ktNamedFunction = null;
        }
        KtNamedFunction oldCreateFromParcelFunction = ktNamedFunction;
        for (KtSuperTypeListEntry superTypeEntry : parcelerObject.getSuperTypeListEntries()) {
            boolean bl6;
            block52: {
                KotlinType kotlinType = (KotlinType)bindingContext.get((ReadOnlySlice)BindingContext.TYPE, (Object)superTypeEntry.getTypeReference());
                if (kotlinType == null || (kotlinType = kotlinType.getConstructor()) == null || (kotlinType = kotlinType.getDeclarationDescriptor()) == null) continue;
                superClass = kotlinType;
                Sequence $this$any$iv = DescriptorUtilsKt.getAllSuperClassifiers((ClassifierDescriptor)superClass);
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    ClassifierDescriptor it2 = (ClassifierDescriptor)element$iv;
                    boolean bl7 = false;
                    if (!Intrinsics.areEqual((Object)DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)((DeclarationDescriptor)it2)), (Object)ParcelableDeclarationCheckerKt.getANDROID_PARCELABLE_CREATOR_CLASS_FQNAME())) continue;
                    bl6 = true;
                    break block52;
                }
                bl6 = false;
            }
            if (!bl6) continue;
            parcelerObject.removeSuperTypeListEntry(superTypeEntry);
        }
        if (Intrinsics.areEqual((Object)parcelerObject.getName(), (Object)"CREATOR")) {
            PsiElement psiElement = parcelerObject.getNameIdentifier();
            if (psiElement != null) {
                psiElement.delete();
            }
        }
        if (oldWriteToParcelFunction != null) {
            KtNamedFunction ktNamedFunction2 = ParcelMigrateToParcelizeQuickFix.Companion.findWriteImplementation((KtObjectDeclaration)parcelerObject);
            if (ktNamedFunction2 != null) {
                ktNamedFunction2.delete();
            }
            PsiElement psiElement = oldWriteToParcelFunction.copy();
            Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFunction");
            newFunction = (KtFunction)psiElement;
            oldWriteToParcelFunction.delete();
            newFunction.setName(PARCELER_WRITE_FUNCTION_NAME.asString());
            KtModifierListOwner ktModifierListOwner = (KtModifierListOwner)newFunction;
            KtModifierKeywordToken ktModifierKeywordToken = KtTokens.OVERRIDE_KEYWORD;
            Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken, (String)"OVERRIDE_KEYWORD");
            AddRemoveModifierKt.setModifierList((KtModifierListOwner)ktModifierListOwner, (KtModifierList)ktPsiFactory.createModifierList(ktModifierKeywordToken));
            TypeRefHelpersKt.setReceiverTypeReference((KtCallableDeclaration)((KtCallableDeclaration)newFunction), (KtTypeReference)ktPsiFactory.createType(parcelerTypeArg));
            KtParameterList ktParameterList = newFunction.getValueParameterList();
            if (ktParameterList != null) {
                boolean bl8;
                KotlinType $this$invoke_u24lambda_u2d6 = superClass = ktParameterList;
                boolean bl9 = false;
                boolean bl10 = bl8 = $this$invoke_u24lambda_u2d6.getParameters().size() == 2;
                if (_Assertions.ENABLED && !bl8) {
                    Object element$iv;
                    element$iv = "Assertion failed";
                    throw new AssertionError(element$iv);
                }
                String string = ((KtParameter)$this$invoke_u24lambda_u2d6.getParameters().get(0)).getName();
                if (string == null) {
                    string = "parcel";
                }
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"parameters[0].name ?: \"parcel\"");
                parcelParameterName = string;
                String string3 = ((KtParameter)$this$invoke_u24lambda_u2d6.getParameters().get(1)).getName();
                if (string3 == null) {
                    string3 = "flags";
                }
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"parameters[1].name ?: \"flags\"");
                String flagsParameterName = string3;
                int it2 = $this$invoke_u24lambda_u2d6.getParameters().size();
                int n = 0;
                while (n < it2) {
                    int it3 = n++;
                    boolean bl11 = false;
                    $this$invoke_u24lambda_u2d6.removeParameter(0);
                }
                $this$invoke_u24lambda_u2d6.addParameter(ktPsiFactory.createParameter((String)parcelParameterName + " : " + ParcelableDeclarationCheckerKt.getANDROID_PARCEL_CLASS_FQNAME().asString()));
                $this$invoke_u24lambda_u2d6.addParameter(ktPsiFactory.createParameter(flagsParameterName + " : Int"));
            }
            this_$iv = (KtClassOrObject)parcelerObject;
            boolean $i$f$addDeclaration = false;
            KtClassBody body$iv2 = KtClassOrObjectKt.getOrCreateBody((KtClassOrObject)this_$iv);
            PsiElement psiElement2 = body$iv2.getRBrace();
            if (psiElement2 == null) {
                PsiElement psiElement3 = body$iv2.getLastChild();
                psiElement2 = psiElement3;
                Intrinsics.checkNotNull((Object)psiElement3);
            }
            parcelParameterName = new Class[]{PsiWhiteSpace.class};
            PsiElement psiElement4 = anchor$iv = PsiTreeUtil.skipSiblingsBackward((PsiElement)psiElement2, (Class[])parcelParameterName);
            PsiElement psiElement5 = (psiElement4 != null ? psiElement4.getNextSibling() : null) instanceof PsiErrorElement ? body$iv2.addBefore((PsiElement)((KtDeclaration)newFunction), anchor$iv) : body$iv2.addAfter((PsiElement)((KtDeclaration)newFunction), anchor$iv);
            if (psiElement5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFunction");
            }
            KtParameterList ktParameterList2 = ((KtFunction)((KtDeclaration)((KtFunction)psiElement5))).getValueParameterList();
            if (ktParameterList2 != null) {
                AbstractParcelableQuickFix.Companion.shortenReferences((KtElement)ktParameterList2);
            }
        } else if (ParcelMigrateToParcelizeQuickFix.Companion.findWriteImplementation((KtObjectDeclaration)parcelerObject) == null) {
            PsiElement anchor$iv2;
            String writeFunction = "fun " + parcelerTypeArg + ".write(parcel: " + ParcelableDeclarationCheckerKt.getANDROID_PARCEL_CLASS_FQNAME().asString() + ", flags: Int) = TODO()";
            this_$iv = (KtClassOrObject)parcelerObject;
            KtDeclaration declaration$iv = (KtDeclaration)ktPsiFactory.createFunction(writeFunction);
            boolean $i$f$addDeclaration = false;
            body$iv3 = KtClassOrObjectKt.getOrCreateBody((KtClassOrObject)this_$iv);
            PsiElement psiElement = body$iv3.getRBrace();
            if (psiElement == null) {
                PsiElement psiElement6 = body$iv3.getLastChild();
                psiElement = psiElement6;
                Intrinsics.checkNotNull((Object)psiElement6);
            }
            anchor$iv = new Class[]{PsiWhiteSpace.class};
            PsiElement psiElement7 = anchor$iv2 = PsiTreeUtil.skipSiblingsBackward((PsiElement)psiElement, (Class[])anchor$iv);
            PsiElement psiElement8 = (psiElement7 != null ? psiElement7.getNextSibling() : null) instanceof PsiErrorElement ? body$iv3.addBefore((PsiElement)declaration$iv, anchor$iv2) : body$iv3.addAfter((PsiElement)declaration$iv, anchor$iv2);
            if (psiElement8 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtNamedFunction");
            }
            KtParameterList ktParameterList = ((KtNamedFunction)((KtDeclaration)((KtNamedFunction)psiElement8))).getValueParameterList();
            if (ktParameterList != null) {
                AbstractParcelableQuickFix.Companion.shortenReferences((KtElement)ktParameterList);
            }
        }
        if (oldCreateFromParcelFunction != null) {
            KtNamedFunction ktNamedFunction3 = ParcelMigrateToParcelizeQuickFix.Companion.findCreateImplementation((KtObjectDeclaration)parcelerObject);
            if (ktNamedFunction3 != null) {
                ktNamedFunction3.delete();
            }
            PsiElement psiElement = oldCreateFromParcelFunction.copy();
            Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFunction");
            newFunction = (KtFunction)psiElement;
            if (Intrinsics.areEqual((Object)KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)oldCreateFromParcelFunction)), (Object)parcelerObject)) {
                oldCreateFromParcelFunction.delete();
            }
            newFunction.setName(PARCELER_CREATE_FUNCTION_NAME.asString());
            KtModifierListOwner ktModifierListOwner = (KtModifierListOwner)newFunction;
            KtModifierKeywordToken ktModifierKeywordToken = KtTokens.OVERRIDE_KEYWORD;
            Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken, (String)"OVERRIDE_KEYWORD");
            AddRemoveModifierKt.setModifierList((KtModifierListOwner)ktModifierListOwner, (KtModifierList)ktPsiFactory.createModifierList(ktModifierKeywordToken));
            TypeRefHelpersKt.setReceiverTypeReference((KtCallableDeclaration)((KtCallableDeclaration)newFunction), null);
            KtParameterList ktParameterList = newFunction.getValueParameterList();
            if (ktParameterList != null) {
                boolean body$iv3;
                KtClassOrObject $this$invoke_u24lambda_u2d7 = this_$iv = ktParameterList;
                boolean bl12 = false;
                boolean bl13 = body$iv3 = $this$invoke_u24lambda_u2d7.getParameters().size() == 1;
                if (_Assertions.ENABLED && !body$iv3) {
                    anchor$iv = "Assertion failed";
                    throw new AssertionError(anchor$iv);
                }
                String string = ((KtParameter)$this$invoke_u24lambda_u2d7.getParameters().get(0)).getName();
                if (string == null) {
                    string = "parcel";
                }
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"parameters[0].name ?: \"parcel\"");
                parcelParameterName = string;
                $this$invoke_u24lambda_u2d7.removeParameter(0);
                $this$invoke_u24lambda_u2d7.addParameter(ktPsiFactory.createParameter((String)parcelParameterName + " : " + ParcelableDeclarationCheckerKt.getANDROID_PARCEL_CLASS_FQNAME().asString()));
            }
            this_$iv = (KtClassOrObject)parcelerObject;
            boolean $i$f$addDeclaration = false;
            KtClassBody body$iv4 = KtClassOrObjectKt.getOrCreateBody((KtClassOrObject)this_$iv);
            PsiElement psiElement9 = body$iv4.getRBrace();
            if (psiElement9 == null) {
                PsiElement psiElement10 = body$iv4.getLastChild();
                psiElement9 = psiElement10;
                Intrinsics.checkNotNull((Object)psiElement10);
            }
            parcelParameterName = new Class[]{PsiWhiteSpace.class};
            Object object = anchor$iv = PsiTreeUtil.skipSiblingsBackward((PsiElement)psiElement9, (Class[])parcelParameterName);
            PsiElement psiElement11 = (object != null ? object.getNextSibling() : null) instanceof PsiErrorElement ? body$iv4.addBefore((PsiElement)((KtDeclaration)newFunction), anchor$iv) : body$iv4.addAfter((PsiElement)((KtDeclaration)newFunction), anchor$iv);
            if (psiElement11 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFunction");
            }
            KtParameterList ktParameterList3 = ((KtFunction)((KtDeclaration)((KtFunction)psiElement11))).getValueParameterList();
            if (ktParameterList3 != null) {
                AbstractParcelableQuickFix.Companion.shortenReferences((KtElement)ktParameterList3);
            }
        } else if (ParcelMigrateToParcelizeQuickFix.Companion.findCreateImplementation((KtObjectDeclaration)parcelerObject) == null) {
            PsiElement anchor$iv3;
            String createFunction = "override fun create(parcel: " + ParcelableDeclarationCheckerKt.getANDROID_PARCEL_CLASS_FQNAME().asString() + "): " + parcelerTypeArg + " = TODO()";
            this_$iv = (KtClassOrObject)parcelerObject;
            KtDeclaration declaration$iv = (KtDeclaration)ktPsiFactory.createFunction(createFunction);
            boolean $i$f$addDeclaration = false;
            body$iv3 = KtClassOrObjectKt.getOrCreateBody((KtClassOrObject)this_$iv);
            PsiElement psiElement = body$iv3.getRBrace();
            if (psiElement == null) {
                PsiElement psiElement12 = body$iv3.getLastChild();
                psiElement = psiElement12;
                Intrinsics.checkNotNull((Object)psiElement12);
            }
            classArray = new Class[]{PsiWhiteSpace.class};
            PsiElement psiElement13 = anchor$iv3 = PsiTreeUtil.skipSiblingsBackward((PsiElement)psiElement, (Class[])classArray);
            PsiElement psiElement14 = (psiElement13 != null ? psiElement13.getNextSibling() : null) instanceof PsiErrorElement ? body$iv3.addBefore((PsiElement)declaration$iv, anchor$iv3) : body$iv3.addAfter((PsiElement)declaration$iv, anchor$iv3);
            if (psiElement14 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtNamedFunction");
            }
            KtParameterList ktParameterList = ((KtNamedFunction)((KtDeclaration)((KtNamedFunction)psiElement14))).getValueParameterList();
            if (ktParameterList != null) {
                AbstractParcelableQuickFix.Companion.shortenReferences((KtElement)ktParameterList);
            }
        }
        KtNamedFunction ktNamedFunction4 = ParcelMigrateToParcelizeQuickFix.Companion.findNewArrayOverride((KtObjectDeclaration)parcelerObject);
        if (ktNamedFunction4 != null) {
            ktNamedFunction4.delete();
        }
        KtNamedFunction ktNamedFunction5 = ParcelMigrateToParcelizeQuickFix.Companion.findDescribeContentsOverride(parcelableClass);
        if (ktNamedFunction5 != null) {
            KtExpression returnExpr;
            KtExpression ktExpression;
            KtExpression $i$f$addDeclaration;
            KtNamedFunction describeContentsFunction = ktNamedFunction5;
            boolean bl14 = false;
            KtExpression ktExpression2 = $i$f$addDeclaration = describeContentsFunction.getBodyExpression();
            if (ktExpression2 != null) {
                Intrinsics.checkNotNullExpressionValue((Object)ktExpression2, (String)"bodyExpression");
                ktExpression = IfThenUtilsKt.unwrapBlockOrParenthesis((KtExpression)$i$f$addDeclaration);
            } else {
                ktExpression = returnExpr = null;
            }
            if (returnExpr instanceof KtReturnExpression && ((KtReturnExpression)returnExpr).getTargetLabel() == null) {
                Object returnValue;
                Object object;
                classArray = (Class[])ResolutionUtils.analyze$default((KtElement)((KtElement)returnExpr), null, (int)1, null).get((ReadOnlySlice)BindingContext.COMPILE_TIME_VALUE, (Object)((KtReturnExpression)returnExpr).getReturnedExpression());
                if (classArray != null) {
                    SimpleType simpleType = TypeUtils.NO_EXPECTED_TYPE;
                    Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"NO_EXPECTED_TYPE");
                    object = classArray.getValue((KotlinType)simpleType);
                } else {
                    object = returnValue = null;
                }
                if (Intrinsics.areEqual(returnValue, (Object)0)) {
                    Object object2 = (SimpleFunctionDescriptor)bindingContext.get((ReadOnlySlice)BindingContext.FUNCTION, (Object)describeContentsFunction);
                    boolean bl15 = object2 != null && (object2 = object2.getOverriddenDescriptors()) != null ? object2.size() == 1 : false;
                    if (bl15) {
                        describeContentsFunction.delete();
                    }
                }
            }
        }
        Sequence $this$filterIsInstance$iv = CollectionsKt.asSequence((Iterable)parcelerObject.getDeclarations());
        boolean $i$f$filterIsInstance = false;
        for (KtProperty property : SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)invoke$$inlined$filterIsInstance$1.INSTANCE), (Function1)invoke.6.INSTANCE)) {
            if (ModifierListModifactorKt.findAnnotation((KtAnnotated)((KtAnnotated)property), (FqName)JvmAbi.JVM_FIELD_ANNOTATION_FQ_NAME) == null) continue;
            property.delete();
        }
    }

    static {
        Name name = Name.identifier((String)"write");
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(\"write\")");
        PARCELER_WRITE_FUNCTION_NAME = name;
        Name name2 = Name.identifier((String)"create");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(\"create\")");
        PARCELER_CREATE_FUNCTION_NAME = name2;
        Logger logger = Logger.getInstance(ParcelMigrateToParcelizeQuickFix.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(ParcelMigrat\u2026lizeQuickFix::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\f\u0010\u000f\u001a\u00020\u0010*\u00020\fH\u0002J\f\u0010\u0011\u001a\u00020\u0010*\u00020\fH\u0002J\f\u0010\u0012\u001a\u00020\u0010*\u00020\fH\u0002J\f\u0010\u0013\u001a\u00020\u0010*\u00020\fH\u0002J\f\u0010\u0014\u001a\u00020\u0010*\u00020\fH\u0002J\f\u0010\u0015\u001a\u00020\u0010*\u00020\fH\u0002J\u000e\u0010\u0016\u001a\u0004\u0018\u00010\f*\u00020\u0017H\u0002J\u000e\u0010\u0018\u001a\u0004\u0018\u00010\u000e*\u00020\u0019H\u0002J\u000e\u0010\u001a\u001a\u0004\u0018\u00010\f*\u00020\u0019H\u0002J'\u0010\u001b\u001a\u0004\u0018\u00010\f*\u00020\u000e2\u0017\u0010\u001c\u001a\u0013\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00100\u001d\u00a2\u0006\u0002\b\u001eH\u0002J\u000e\u0010\u001f\u001a\u0004\u0018\u00010\f*\u00020\u0017H\u0002J\u001a\u0010 \u001a\u0010\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\"\u0018\u00010!*\u00020\u0019H\u0002J\u000e\u0010#\u001a\u0004\u0018\u00010\f*\u00020\u0017H\u0002J\u000e\u0010$\u001a\u0004\u0018\u00010\f*\u00020\u0019H\u0002J\u000e\u0010%\u001a\u0004\u0018\u00010&*\u00020'H\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/android/parcel/quickfixes/ParcelMigrateToParcelizeQuickFix$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "PARCELER_CREATE_FUNCTION_NAME", "Lorg/jetbrains/kotlin/name/Name;", "PARCELER_FQNAME", "Lorg/jetbrains/kotlin/name/FqName;", "PARCELER_WRITE_FUNCTION_NAME", "findCreateFromParcel", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "creator", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "doesLookLikeCreateFromParcelOverride", "", "doesLookLikeCreateImplementation", "doesLookLikeDescribeContentsOverride", "doesLookLikeNewArrayOverride", "doesLookLikeWriteImplementation", "doesLookLikeWriteToParcelOverride", "findCreateImplementation", "Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;", "findCreatorClass", "Lorg/jetbrains/kotlin/psi/KtClass;", "findDescribeContentsOverride", "findFunction", "f", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "findNewArrayOverride", "findParcelerCompanionObject", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "findWriteImplementation", "findWriteToParcelOverride", "getFqName", "", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "intellij.android.kotlin.extensions.common"})
    public static final class Companion {
        private Companion() {
        }

        private final Pair<KtObjectDeclaration, ClassDescriptor> findParcelerCompanionObject(KtClass $this$findParcelerCompanionObject) {
            for (KtObjectDeclaration obj : $this$findParcelerCompanionObject.getCompanionObjects()) {
                ClassDescriptor objDescriptor;
                if (ResolutionUtils.resolveToDescriptorIfAny$default((KtClassOrObject)((KtClassOrObject)obj), null, (int)1, null) == null) continue;
                for (ClassifierDescriptor superClassifier : DescriptorUtilsKt.getAllSuperClassifiers((ClassifierDescriptor)((ClassifierDescriptor)objDescriptor))) {
                    ClassDescriptor superClass;
                    ClassDescriptor classDescriptor = superClassifier instanceof ClassDescriptor ? (ClassDescriptor)superClassifier : null;
                    if (classDescriptor == null || !Intrinsics.areEqual((Object)DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)((DeclarationDescriptor)(superClass = classDescriptor))), (Object)PARCELER_FQNAME)) continue;
                    return new Pair((Object)obj, (Object)objDescriptor);
                }
            }
            return null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean doesLookLikeWriteToParcelOverride(KtNamedFunction $this$doesLookLikeWriteToParcelOverride) {
            if (!Intrinsics.areEqual((Object)$this$doesLookLikeWriteToParcelOverride.getName(), (Object)"writeToParcel")) return false;
            if (!$this$doesLookLikeWriteToParcelOverride.hasModifier(KtTokens.OVERRIDE_KEYWORD)) return false;
            if ($this$doesLookLikeWriteToParcelOverride.getReceiverTypeReference() != null) return false;
            if ($this$doesLookLikeWriteToParcelOverride.getValueParameters().size() != 2) return false;
            if ($this$doesLookLikeWriteToParcelOverride.getTypeParameters().size() != 0) return false;
            KtTypeReference ktTypeReference = ((KtParameter)$this$doesLookLikeWriteToParcelOverride.getValueParameters().get(0)).getTypeReference();
            if (!Intrinsics.areEqual((Object)(ktTypeReference != null ? this.getFqName(ktTypeReference) : null), (Object)ParcelableDeclarationCheckerKt.getANDROID_PARCEL_CLASS_FQNAME().asString())) return false;
            KtTypeReference ktTypeReference2 = ((KtParameter)$this$doesLookLikeWriteToParcelOverride.getValueParameters().get(1)).getTypeReference();
            if (!Intrinsics.areEqual((Object)(ktTypeReference2 != null ? this.getFqName(ktTypeReference2) : null), (Object)StandardNames.FqNames._int.asString())) return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean doesLookLikeNewArrayOverride(KtNamedFunction $this$doesLookLikeNewArrayOverride) {
            if (!Intrinsics.areEqual((Object)$this$doesLookLikeNewArrayOverride.getName(), (Object)"newArray")) return false;
            if (!$this$doesLookLikeNewArrayOverride.hasModifier(KtTokens.OVERRIDE_KEYWORD)) return false;
            if ($this$doesLookLikeNewArrayOverride.getReceiverTypeReference() != null) return false;
            if ($this$doesLookLikeNewArrayOverride.getValueParameters().size() != 1) return false;
            if ($this$doesLookLikeNewArrayOverride.getTypeParameters().size() != 0) return false;
            KtTypeReference ktTypeReference = ((KtParameter)$this$doesLookLikeNewArrayOverride.getValueParameters().get(0)).getTypeReference();
            if (!Intrinsics.areEqual((Object)(ktTypeReference != null ? this.getFqName(ktTypeReference) : null), (Object)StandardNames.FqNames._int.asString())) return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean doesLookLikeDescribeContentsOverride(KtNamedFunction $this$doesLookLikeDescribeContentsOverride) {
            if (!Intrinsics.areEqual((Object)$this$doesLookLikeDescribeContentsOverride.getName(), (Object)"describeContents")) return false;
            if (!$this$doesLookLikeDescribeContentsOverride.hasModifier(KtTokens.OVERRIDE_KEYWORD)) return false;
            if ($this$doesLookLikeDescribeContentsOverride.getReceiverTypeReference() != null) return false;
            if ($this$doesLookLikeDescribeContentsOverride.getValueParameters().size() != 0) return false;
            if ($this$doesLookLikeDescribeContentsOverride.getTypeParameters().size() != 0) return false;
            KtTypeReference ktTypeReference = $this$doesLookLikeDescribeContentsOverride.getTypeReference();
            if (!Intrinsics.areEqual((Object)(ktTypeReference != null ? this.getFqName(ktTypeReference) : null), (Object)StandardNames.FqNames._int.asString())) return false;
            return true;
        }

        private final KtNamedFunction findWriteToParcelOverride(KtClass $this$findWriteToParcelOverride) {
            return this.findFunction((KtClassOrObject)$this$findWriteToParcelOverride, (Function1<? super KtNamedFunction, Boolean>)((Function1)findWriteToParcelOverride.1.INSTANCE));
        }

        private final KtNamedFunction findDescribeContentsOverride(KtClass $this$findDescribeContentsOverride) {
            return this.findFunction((KtClassOrObject)$this$findDescribeContentsOverride, (Function1<? super KtNamedFunction, Boolean>)((Function1)findDescribeContentsOverride.1.INSTANCE));
        }

        private final KtNamedFunction findNewArrayOverride(KtObjectDeclaration $this$findNewArrayOverride) {
            return this.findFunction((KtClassOrObject)$this$findNewArrayOverride, (Function1<? super KtNamedFunction, Boolean>)((Function1)findNewArrayOverride.1.INSTANCE));
        }

        /*
         * WARNING - void declaration
         */
        private final KtClassOrObject findCreatorClass(KtClass $this$findCreatorClass) {
            for (KtObjectDeclaration companion : $this$findCreatorClass.getCompanionObjects()) {
                KotlinSourceElement sourceElement;
                Object object;
                CallableDescriptor callableDescriptor;
                ClassDescriptor constructedClass;
                KtExpression initializer;
                KtProperty creatorProperty;
                Object v0;
                Iterator iterator;
                Sequence sequence;
                block4: {
                    void $this$firstOrNull$iv;
                    Sequence $this$filterIsInstance$iv;
                    if (Intrinsics.areEqual((Object)companion.getName(), (Object)"CREATOR")) {
                        return (KtClassOrObject)companion;
                    }
                    sequence = CollectionsKt.asSequence((Iterable)companion.getDeclarations());
                    boolean $i$f$filterIsInstance = false;
                    $this$filterIsInstance$iv = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)Companion$findCreatorClass$$inlined$filterIsInstance$1.INSTANCE);
                    boolean $i$f$firstOrNull = false;
                    iterator = $this$firstOrNull$iv.iterator();
                    while (iterator.hasNext()) {
                        Object element$iv = iterator.next();
                        KtProperty it = (KtProperty)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)"CREATOR")) continue;
                        v0 = element$iv;
                        break block4;
                    }
                    v0 = null;
                }
                if ((KtProperty)v0 == null || ModifierListModifactorKt.findAnnotation((KtAnnotated)((KtAnnotated)creatorProperty), (FqName)JvmAbi.JVM_FIELD_ANNOTATION_FQ_NAME) == null || creatorProperty.getInitializer() == null) continue;
                sequence = initializer;
                if (sequence instanceof KtObjectLiteralExpression) {
                    return (KtClassOrObject)((KtObjectLiteralExpression)initializer).getObjectDeclaration();
                }
                if (!(sequence instanceof KtCallExpression) || (constructedClass = (iterator = (callableDescriptor = (object = ResolutionUtils.resolveToCall$default((KtElement)((KtElement)initializer), null, (int)1, null)) != null ? object.getResultingDescriptor() : null) instanceof ConstructorDescriptor ? (ConstructorDescriptor)callableDescriptor : null) != null ? iterator.getConstructedClass() : null) == null) continue;
                callableDescriptor = constructedClass.getSource();
                KotlinSourceElement kotlinSourceElement = sourceElement = callableDescriptor instanceof KotlinSourceElement ? (KotlinSourceElement)callableDescriptor : null;
                object = kotlinSourceElement != null ? kotlinSourceElement.getPsi() : null;
                callableDescriptor = object instanceof KtClassOrObject ? (KtClassOrObject)object : null;
                if (callableDescriptor == null) continue;
                CallableDescriptor it = callableDescriptor;
                boolean bl = false;
                return it;
            }
            return null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean doesLookLikeCreateFromParcelOverride(KtNamedFunction $this$doesLookLikeCreateFromParcelOverride) {
            if (!Intrinsics.areEqual((Object)$this$doesLookLikeCreateFromParcelOverride.getName(), (Object)"createFromParcel")) return false;
            if (!$this$doesLookLikeCreateFromParcelOverride.hasModifier(KtTokens.OVERRIDE_KEYWORD)) return false;
            if ($this$doesLookLikeCreateFromParcelOverride.getReceiverTypeReference() != null) return false;
            if ($this$doesLookLikeCreateFromParcelOverride.getValueParameters().size() != 1) return false;
            if ($this$doesLookLikeCreateFromParcelOverride.getTypeParameters().size() != 0) return false;
            KtTypeReference ktTypeReference = ((KtParameter)$this$doesLookLikeCreateFromParcelOverride.getValueParameters().get(0)).getTypeReference();
            if (!Intrinsics.areEqual((Object)(ktTypeReference != null ? this.getFqName(ktTypeReference) : null), (Object)ParcelableDeclarationCheckerKt.getANDROID_PARCEL_CLASS_FQNAME().asString())) return false;
            return true;
        }

        private final KtNamedFunction findCreateFromParcel(KtClassOrObject creator) {
            return this.findFunction(creator, (Function1<? super KtNamedFunction, Boolean>)((Function1)findCreateFromParcel.1.INSTANCE));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean doesLookLikeWriteImplementation(KtNamedFunction $this$doesLookLikeWriteImplementation) {
            KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)$this$doesLookLikeWriteImplementation));
            String containingParcelableClassFqName = ktClassOrObject != null && (ktClassOrObject = KtPsiUtilKt.containingClass((KtElement)((KtElement)ktClassOrObject))) != null && (ktClassOrObject = ktClassOrObject.getFqName()) != null ? ktClassOrObject.asString() : null;
            if (!Intrinsics.areEqual((Object)$this$doesLookLikeWriteImplementation.getName(), (Object)PARCELER_WRITE_FUNCTION_NAME.asString())) return false;
            if (!$this$doesLookLikeWriteImplementation.hasModifier(KtTokens.OVERRIDE_KEYWORD)) return false;
            KtTypeReference ktTypeReference = $this$doesLookLikeWriteImplementation.getReceiverTypeReference();
            if (!Intrinsics.areEqual((Object)(ktTypeReference != null ? this.getFqName(ktTypeReference) : null), (Object)containingParcelableClassFqName)) return false;
            if ($this$doesLookLikeWriteImplementation.getValueParameters().size() != 2) return false;
            if ($this$doesLookLikeWriteImplementation.getTypeParameters().size() != 0) return false;
            KtTypeReference ktTypeReference2 = ((KtParameter)$this$doesLookLikeWriteImplementation.getValueParameters().get(0)).getTypeReference();
            if (!Intrinsics.areEqual((Object)(ktTypeReference2 != null ? this.getFqName(ktTypeReference2) : null), (Object)ParcelableDeclarationCheckerKt.getANDROID_PARCEL_CLASS_FQNAME().asString())) return false;
            KtTypeReference ktTypeReference3 = ((KtParameter)$this$doesLookLikeWriteImplementation.getValueParameters().get(1)).getTypeReference();
            if (!Intrinsics.areEqual((Object)(ktTypeReference3 != null ? this.getFqName(ktTypeReference3) : null), (Object)StandardNames.FqNames._int.asString())) return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean doesLookLikeCreateImplementation(KtNamedFunction $this$doesLookLikeCreateImplementation) {
            if (!Intrinsics.areEqual((Object)$this$doesLookLikeCreateImplementation.getName(), (Object)PARCELER_CREATE_FUNCTION_NAME.asString())) return false;
            if (!$this$doesLookLikeCreateImplementation.hasModifier(KtTokens.OVERRIDE_KEYWORD)) return false;
            if ($this$doesLookLikeCreateImplementation.getReceiverTypeReference() != null) return false;
            if ($this$doesLookLikeCreateImplementation.getValueParameters().size() != 1) return false;
            if ($this$doesLookLikeCreateImplementation.getTypeParameters().size() != 0) return false;
            KtTypeReference ktTypeReference = ((KtParameter)$this$doesLookLikeCreateImplementation.getValueParameters().get(0)).getTypeReference();
            if (!Intrinsics.areEqual((Object)(ktTypeReference != null ? this.getFqName(ktTypeReference) : null), (Object)ParcelableDeclarationCheckerKt.getANDROID_PARCEL_CLASS_FQNAME().asString())) return false;
            return true;
        }

        private final KtNamedFunction findCreateImplementation(KtObjectDeclaration $this$findCreateImplementation) {
            return this.findFunction((KtClassOrObject)$this$findCreateImplementation, (Function1<? super KtNamedFunction, Boolean>)((Function1)findCreateImplementation.1.INSTANCE));
        }

        private final KtNamedFunction findWriteImplementation(KtObjectDeclaration $this$findWriteImplementation) {
            return this.findFunction((KtClassOrObject)$this$findWriteImplementation, (Function1<? super KtNamedFunction, Boolean>)((Function1)findWriteImplementation.1.INSTANCE));
        }

        private final KtNamedFunction findFunction(KtClassOrObject $this$findFunction, Function1<? super KtNamedFunction, Boolean> f) {
            Object v0;
            block1: {
                Sequence $this$filterIsInstance$iv = CollectionsKt.asSequence((Iterable)$this$findFunction.getDeclarations());
                boolean $i$f$filterIsInstance = false;
                Sequence $this$firstOrNull$iv = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)Companion$findFunction$$inlined$filterIsInstance$1.INSTANCE);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    if (!((Boolean)f.invoke(element$iv)).booleanValue()) continue;
                    v0 = element$iv;
                    break block1;
                }
                v0 = null;
            }
            return v0;
        }

        private final String getFqName(KtTypeReference $this$getFqName) {
            FqName fqName;
            ClassifierDescriptor classifierDescriptor;
            TypeConstructor typeConstructor;
            KotlinType kotlinType = (KotlinType)ResolutionUtils.analyze((KtElement)((KtElement)$this$getFqName), (BodyResolveMode)BodyResolveMode.PARTIAL).get((ReadOnlySlice)BindingContext.TYPE, (Object)$this$getFqName);
            return kotlinType != null && (typeConstructor = kotlinType.getConstructor()) != null && (classifierDescriptor = typeConstructor.getDeclarationDescriptor()) != null && (fqName = DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)((DeclarationDescriptor)classifierDescriptor))) != null ? fqName.asString() : null;
        }

        public static final /* synthetic */ boolean access$doesLookLikeWriteToParcelOverride(Companion $this, KtNamedFunction $receiver) {
            return $this.doesLookLikeWriteToParcelOverride($receiver);
        }

        public static final /* synthetic */ boolean access$doesLookLikeDescribeContentsOverride(Companion $this, KtNamedFunction $receiver) {
            return $this.doesLookLikeDescribeContentsOverride($receiver);
        }

        public static final /* synthetic */ boolean access$doesLookLikeNewArrayOverride(Companion $this, KtNamedFunction $receiver) {
            return $this.doesLookLikeNewArrayOverride($receiver);
        }

        public static final /* synthetic */ boolean access$doesLookLikeCreateFromParcelOverride(Companion $this, KtNamedFunction $receiver) {
            return $this.doesLookLikeCreateFromParcelOverride($receiver);
        }

        public static final /* synthetic */ boolean access$doesLookLikeCreateImplementation(Companion $this, KtNamedFunction $receiver) {
            return $this.doesLookLikeCreateImplementation($receiver);
        }

        public static final /* synthetic */ boolean access$doesLookLikeWriteImplementation(Companion $this, KtNamedFunction $receiver) {
            return $this.doesLookLikeWriteImplementation($receiver);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/android/parcel/quickfixes/ParcelMigrateToParcelizeQuickFix$FactoryForWrite;", "Lorg/jetbrains/kotlin/android/parcel/quickfixes/AbstractParcelableQuickFix$AbstractFactory;", "()V", "intellij.android.kotlin.extensions.common"})
    public static final class FactoryForWrite
    extends AbstractParcelableQuickFix.AbstractFactory {
        @NotNull
        public static final FactoryForWrite INSTANCE = new FactoryForWrite();

        private FactoryForWrite() {
            super((Function1<? super Diagnostic, ? extends IntentionAction>)((Function1)1.INSTANCE));
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/android/parcel/quickfixes/ParcelMigrateToParcelizeQuickFix$FactoryForCREATOR;", "Lorg/jetbrains/kotlin/android/parcel/quickfixes/AbstractParcelableQuickFix$AbstractFactory;", "()V", "intellij.android.kotlin.extensions.common"})
    public static final class FactoryForCREATOR
    extends AbstractParcelableQuickFix.AbstractFactory {
        @NotNull
        public static final FactoryForCREATOR INSTANCE = new FactoryForCREATOR();

        private FactoryForCREATOR() {
            super((Function1<? super Diagnostic, ? extends IntentionAction>)((Function1)1.INSTANCE));
        }
    }
}

